/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hr.hdm.business.domain.transfer.handler.AbstractHandler;
import kd.hr.hdm.business.domain.transfer.handler.submit.operation.FirstSubmitOpHandler;
import kd.hr.hdm.business.domain.transfer.handler.submit.operation.SecondSubmitOpHandler;
import kd.hr.hdm.business.domain.transfer.handler.submit.validate.FirstValidateHandler;
import kd.hr.hdm.business.domain.transfer.handler.submit.validate.SecondValidateHandler;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class OperationHandler {
    private static final OperationHandler OPERATION_HANDLER = new OperationHandler();
    public Map<String, List<AbstractHandler>> hanlderCache = new HashMap<String, List<AbstractHandler>>();

    private OperationHandler() {
    }

    public static OperationHandler getInstance() {
        return OPERATION_HANDLER;
    }

    public void registerHandler(String opSign, AbstractHandler handler) {
        List<AbstractHandler> abstractSubmitHandlers = this.hanlderCache.get(opSign);
        if (ObjectUtils.isEmpty(abstractSubmitHandlers)) {
            abstractSubmitHandlers = new ArrayList<AbstractHandler>();
        }
        abstractSubmitHandlers.add(handler);
        this.hanlderCache.put(opSign, abstractSubmitHandlers);
    }

    private static void init() {
        FirstSubmitOpHandler firstSubmitOpHandler = new FirstSubmitOpHandler();
        SecondSubmitOpHandler secondSubmitOpHandler = new SecondSubmitOpHandler();
        FirstValidateHandler firstValidateHandler = new FirstValidateHandler();
        SecondValidateHandler secondValidateHandler = new SecondValidateHandler();
    }

    static {
        OperationHandler.init();
    }
}

