/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.repository;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;

public class TransferBillRepository {
    private static volatile TransferBillRepository instance = null;
    private static final Log LOGGER = LogFactory.getLog(TransferBillRepository.class);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hdm_transferbasebill");

    private TransferBillRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransferBillRepository getInstance() {
        if (instance != null) return instance;
        Class<TransferBillRepository> clazz = TransferBillRepository.class;
        synchronized (TransferBillRepository.class) {
            if (instance != null) return instance;
            instance = new TransferBillRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DynamicObject queryOne(String fields, Object id) {
        return SERVICE_HELPER.queryOne(fields, id);
    }

    public void update(DynamicObject dy) {
        SERVICE_HELPER.updateOne(dy);
    }

    public void batchUpdate(List<DynamicObject> dynamicObjects) {
        DynamicObject[] temp = new DynamicObject[dynamicObjects.size()];
        SERVICE_HELPER.update(dynamicObjects.toArray(temp));
    }

    public void save(DynamicObject dy) {
        SERVICE_HELPER.saveOne(dy);
    }

    public void batchSave(DynamicObject[] dys) {
        SERVICE_HELPER.save(dys);
    }

    public DynamicObject queryEmpposorgrel(long depempId, String pageSign) {
        String param = "postype,company,adminorg,position";
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageSign);
        QFilter qFilter = new QFilter("depemp", "=", (Object)depempId);
        return hrBaseServiceHelper.queryOne("postype,company,adminorg,position", qFilter);
    }

    public DynamicObjectCollection getSubmitTransferBillById(List<Long> bdepempIds, List<Long> billIds) {
        QFilter qFilter = new QFilter("bdepemp", "in", bdepempIds);
        QFilter qFilter1 = new QFilter("transferstatus", "in", (Object)new String[]{"1", "4"});
        QFilter qFilter3 = new QFilter("transferstatus", "=", (Object)"0").and(new QFilter("originator", "!=", (Object)TransferOriginatorEnum.MY.getOriginator()));
        QFilter qFilter2 = new QFilter("id", "not in", billIds);
        DynamicObjectCollection dynamicObjects = SERVICE_HELPER.queryOriginalCollection("id,bdepemp,billno,transferstatus,auditstatus,transfertype,mid.billno", new QFilter[]{qFilter, qFilter1.or(qFilter3), qFilter2});
        return dynamicObjects;
    }

    public DynamicObjectCollection getSubmitTransferBillById(List<Long> bdepempIds) {
        LOGGER.info("start getSubmitTransferBillById");
        QFilter qFilter = new QFilter("bdepemp", "in", bdepempIds);
        QFilter qFilter1 = new QFilter("transferstatus", "in", (Object)new String[]{"0", "1", "4"});
        DynamicObjectCollection dynamicObjects = SERVICE_HELPER.queryOriginalCollection("id,bdepemp,billno,transferstatus,auditstatus,transfertype,person,mid.billno", new QFilter[]{qFilter, qFilter1});
        LOGGER.info("getSubmitTransferBillById result :{}", (Object)dynamicObjects.toString());
        LOGGER.info("end getSubmitTransferBillById");
        return dynamicObjects;
    }

    public DynamicObject[] query(String fields, QFilter[] qFilters) {
        return SERVICE_HELPER.query(fields, qFilters);
    }

    public DynamicObject[] query(String fields, List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        return this.query(fields, idFilterArray);
    }

    public DynamicObject[] queryTransferBillInfoByBdepempIds(List<Long> bdepempIds, String[] filters) {
        LOGGER.info("start queryTransferBillInfoByBdepempIds");
        QFilter qFilter = new QFilter("bdepemp", "in", bdepempIds);
        QFilter qFilter1 = new QFilter("transferstatus", "in", (Object)filters);
        Object[] dynamicObjects = SERVICE_HELPER.query("id,bdepemp.id,billno,transferstatus,arealityorg,arealitycompany,realitydate,affaction,terminationreason,terminationdesc,createtime", new QFilter[]{qFilter, qFilter1});
        LOGGER.info("queryTransferBillInfoByBdepempIds result :{}", (Object)Arrays.toString(dynamicObjects));
        LOGGER.info("end queryTransferBillInfoByBdepempIds");
        return dynamicObjects;
    }
}

