/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.external.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.exception.TCCTryException;
import kd.bos.kdtx.common.exception.invoke.BranchBizException;
import kd.bos.kdtx.sdk.session.tcc.TCCGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.domain.transfer.service.invoke.InvokeHandler;
import kd.hr.hdm.business.domain.transfer.service.invoke.InvokeParam;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;
import kd.sdk.hr.hdm.business.transfer.IStaffTransferExtendService;
import kd.sdk.hr.hpfs.business.config.repository.DevParamConfigRepository;

public class TransferStaffServiceImpl
implements TransferStaffService {
    private static final Log LOGGER = LogFactory.getLog(TransferStaffServiceImpl.class);
    private static final String ISOCCUPYSTAFF = "isOccupyStaff";

    @Override
    public StaffResponse<StaffQueryOutParamMap> getStaffUseInfoDetail(String condition, List<DynamicObject> transferbills) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IStaffTransferExtendService.class, (String)"kd.sdk.hr.hdm.business.transfer.IStaffTransferExtendService", null);
        List objects = hrPluginProxy.callReplace(hrPlugin -> hrPlugin.occupyStaffOrNot(transferbills));
        LOGGER.info("TransferStaffServiceImpl.occupyStaff={}", (Object)objects);
        Map<Object, Object> otherMap = new HashMap(0);
        if (objects.size() > 0) {
            Map map = (Map)objects.get(0);
            LOGGER.info("TransferStaffServiceImpl.map={}", (Object)map);
            otherMap = transferbills.stream().filter(dy -> map.containsKey(dy.getLong("id")) && (Boolean)map.get(dy.getLong("id")) == false).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        }
        List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
        ArrayList<StaffQueryInParam> staffQueryInParams = new ArrayList<StaffQueryInParam>(transferbills.size());
        for (DynamicObject temp : transferbills) {
            StaffQueryInParam staffQueryInParam = new TransferStaffVO(temp).genStaffQueryInParam(condition, temp, dimension);
            if (otherMap.containsKey(temp.getLong("id"))) {
                Map other = staffQueryInParam.getOther();
                other.put(ISOCCUPYSTAFF, false);
            }
            staffQueryInParams.add(staffQueryInParam);
        }
        LOGGER.info("getStaffUseInfoDetail staffQueryInParams|{}", staffQueryInParams);
        StaffResponse staffQueryOutParam = (StaffResponse)InvokeHandler.getInstance().invokeService(new InvokeParam("hrmp", "haos", "IHAOSStaffService", "getStaffUseInfoDetail"), staffQueryInParams);
        return staffQueryOutParam;
    }

    @Override
    public void occupyStaff(List<DynamicObject> transferBills, boolean isUpdate) throws KDBizException {
        if (CollectionUtils.isEmpty(transferBills)) {
            return;
        }
        try {
            List<Object> occupyTransferBills;
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IStaffTransferExtendService.class, (String)"kd.sdk.hr.hdm.business.transfer.IStaffTransferExtendService", null);
            List objects = hrPluginProxy.callReplace(hrPlugin -> hrPlugin.occupyStaffOrNot(transferBills));
            LOGGER.info("TransferStaffServiceImpl.occupyStaff={}", (Object)objects);
            if (objects.size() > 0) {
                Map map = (Map)objects.get(0);
                LOGGER.info("TransferStaffServiceImpl.map={}", (Object)map);
                occupyTransferBills = transferBills.stream().filter(dy -> !map.containsKey(dy.getLong("id")) || (Boolean)map.get(dy.getLong("id")) != false).collect(Collectors.toList());
            } else {
                occupyTransferBills = transferBills;
            }
            StaffUseParam staffUseParam = new StaffUseParam();
            ArrayList staffUseInParams = new ArrayList(occupyTransferBills.size());
            staffUseParam.setStaffUseInParamList(staffUseInParams);
            List transferBillIds = occupyTransferBills.stream().map(temp -> temp.getLong("id")).collect(Collectors.toList());
            DynamicObject[] oldTransferBills = ITransferBillService.getInstance().query(this.getSelectProperties(), new QFilter("id", "in", transferBillIds).toArray());
            HashMap oldTransferBillMap = new HashMap();
            if (oldTransferBills != null && oldTransferBills.length > 0) {
                Arrays.stream(oldTransferBills).forEach(oldBill -> oldTransferBillMap.put(oldBill.getLong("id"), oldBill));
            }
            List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
            occupyTransferBills.forEach(newBill -> {
                TransferStaffVO transferStaffVO = new TransferStaffVO((DynamicObject)newBill);
                LOGGER.info("TransferStaffServiceImpl before build param,newBill:{},", newBill);
                Function<StaffUseParam, StaffUseParam> staffUseParamStaffUseParamFunction = transferStaffVO.genNewTransferInStaffParam((DynamicObject)newBill, isUpdate, dimension).andThen(transferStaffVO.genNewTransferOutStaffParam((DynamicObject)newBill, isUpdate));
                DynamicObject oldBill = (DynamicObject)oldTransferBillMap.get(newBill.getLong("id"));
                if (isUpdate && oldBill != null) {
                    LOGGER.info("TransferStaffServiceImpl before build param,oldBill:{},", (Object)oldBill);
                    staffUseParamStaffUseParamFunction.andThen(transferStaffVO.genOldTransferInStaffParam(oldBill, isUpdate, dimension)).andThen(transferStaffVO.genOldTransferOutStaffParam(oldBill, isUpdate)).apply(staffUseParam);
                } else {
                    staffUseParamStaffUseParamFunction.apply(staffUseParam);
                }
            });
            HRPluginProxy paramPluginProxy = HRPlugInProxyFactory.create(null, IStaffTransferExtendService.class, (String)"kd.sdk.hr.hdm.business.transfer.IStaffTransferExtendService", null);
            paramPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.setStaffUseParamExtend(staffUseParam, occupyTransferBills, oldTransferBillMap);
                return null;
            });
            LOGGER.info("TransferStaffServiceImpl start invoke tcc param :{}", (Object)staffUseParam.toString());
            TCCGlobalSession.Try((String)"hdm_IHAOSStaffUseService", (String)"hrmp", (String)"haos", (String)"IHAOSStaffUseService", (Param)staffUseParam, null, (DBRoute)DBRoute.of((String)"hrb.hdm"));
            LOGGER.info("TransferStaffServiceImpl end invoke tcc");
        }
        catch (Exception exception) {
            this.dealStaffException(exception);
        }
    }

    @Override
    public List<Map<String, String>> queryStaffDynamicdimension() throws KDBizException {
        String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7ef4\u5ea6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferStaffServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]);
        try {
            StaffResponse result = (StaffResponse)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStaffService", (String)"queryStaffDynamicdimension", (Object[])new Object[]{"hdm_transferbasebill"});
            LOGGER.info("queryStaffDynamicdimension end,result|{}", (Object)result);
            if (!result.isSuccess()) {
                List errorList = result.getErrorMsg();
                if (errorList != null && !errorList.isEmpty()) {
                    errorMsg = (String)errorList.get(0);
                }
                throw new KDBizException(errorMsg);
            }
            return (List)result.getData();
        }
        catch (Exception e) {
            LOGGER.error("queryStaffDynamicdimension error", (Throwable)e);
            throw new KDBizException(errorMsg);
        }
    }

    @Override
    public Object getDimensionValue(String mapField, DynamicObject bill) {
        LOGGER.info("TransferStaffServiceImpl.getDimensionValue start mapField:{}", (Object)mapField);
        if (HRStringUtils.isEmpty((String)mapField) || !bill.containsProperty(mapField.split("\\.")[0])) {
            LOGGER.info("TransferStaffServiceImpl.getDimensionValue invalid mapField:{}", (Object)mapField);
            return null;
        }
        Object value = null;
        try {
            value = bill.get(mapField);
        }
        catch (ORMDesignException exception) {
            LOGGER.error("TransferStaffServiceImpl.getDimensionValue invalid mapField", (Throwable)exception);
        }
        LOGGER.info("TransferStaffServiceImpl.getDimensionValue mapField:{},value:{}", (Object)mapField, value);
        if (value == null) {
            return null;
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).get("id");
        }
        if (value instanceof MulBasedataDynamicObjectCollection) {
            return ((MulBasedataDynamicObjectCollection)value).stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        return value;
    }

    @Override
    public long getRealOrgTeamId(String key, DynamicObject transferBill) {
        DynamicObject adminKeyDy = DevParamConfigRepository.queryConfigByBusinessKey((String)"staff_adminorg");
        Long realAdminOrg = transferBill.getLong(key);
        LOGGER.info("TransferStaffServiceImpl.getRealOrgTeamId start,base adminorg={}", (Object)realAdminOrg);
        if (adminKeyDy == null || HRStringUtils.isEmpty((String)adminKeyDy.getString("businessvalue"))) {
            LOGGER.info("TransferStaffServiceImpl.getRealOrgTeamId end,not set staff_adminorg,realAdminOrg={}", (Object)realAdminOrg);
            return realAdminOrg;
        }
        String adminkey = adminKeyDy.getString("businessvalue");
        if (transferBill.containsProperty(adminkey) && !ObjectUtils.isEmpty((Object)transferBill.get(adminkey))) {
            realAdminOrg = transferBill.getLong(adminkey + ".id");
        } else {
            DynamicObject dy = TransferBillRepository.getInstance().queryOne(adminkey, transferBill.getLong("id"));
            if (dy != null && dy.containsProperty(adminkey) && !ObjectUtils.isEmpty((Object)dy.get(adminkey))) {
                realAdminOrg = dy.getLong(adminkey + ".id");
            }
        }
        LOGGER.info("TransferStaffServiceImpl.getRealOrgTeamId end,realAdminOrg={}", (Object)realAdminOrg);
        return realAdminOrg;
    }

    @Override
    public Set<String> getMapFieldSet() {
        DynamicObject adminKeyDy;
        List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
        HashSet<String> mapFieldSet = new HashSet<String>(16);
        if (dimension != null && !dimension.isEmpty()) {
            dimension.forEach(item -> mapFieldSet.add((String)item.get("mapfield")));
        }
        if ((adminKeyDy = DevParamConfigRepository.queryConfigByBusinessKey((String)"staff_adminorg")) != null && HRStringUtils.isNotEmpty((String)adminKeyDy.getString("businessvalue"))) {
            mapFieldSet.add(adminKeyDy.getString("businessvalue"));
        }
        return mapFieldSet;
    }

    @Override
    public String getSelectProperties() {
        Set<String> selectProperties = this.getMapFieldSet();
        if (selectProperties.isEmpty()) {
            return TransferPageHelperUtil.QUERYFIELD;
        }
        return String.join((CharSequence)",", selectProperties) + "," + TransferPageHelperUtil.QUERYFIELD;
    }

    private void dealStaffException(Exception exception) {
        LOGGER.error("TransferStaffServiceImpl.dealStaffException stacktrace :", (Throwable)exception);
        Class<?> aClass = exception.getClass();
        if (aClass.equals(KDBizException.class)) {
            KdtxException kdtxException = (KdtxException)exception.getCause();
            if (!KDBizException.class.equals(kdtxException.getCause().getClass())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7f16\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u7ba1\u7406\u5458\u3002", (String)"TransferStaffServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            KDBizException bizException = (KDBizException)kdtxException.getCause();
            ErrorCode errorCode = bizException.getErrorCode();
            String code = errorCode.getCode();
            this.throwExceptionByCode(exception, code);
        } else if (aClass.equals(TCCTryException.class)) {
            KdtxException kdtxException = (KdtxException)exception.getCause();
            BranchBizException branchBizException = (BranchBizException)kdtxException.getCause();
            if (!KDBizException.class.equals(branchBizException.getCause().getClass())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7f16\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u7ba1\u7406\u5458\u3002", (String)"TransferStaffServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            KDBizException kdBizException = (KDBizException)branchBizException.getCause();
            String errorCode = kdBizException.getErrorCode().getCode();
            this.throwExceptionByCode(exception, errorCode);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7f16\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u7ba1\u7406\u5458\u3002", (String)"TransferStaffServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
    }

    private void throwExceptionByCode(Exception exception, String errorCode) {
        if (HRStringUtils.equals((String)errorCode, (String)"hrmp.haos.overStaffing")) {
            throw new KDBizException((Throwable)exception, new ErrorCode(errorCode, ResManager.loadKDString((String)"\u7f16\u5236\u5df2\u6ee1\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferStaffServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0])), new Object[0]);
        }
        if (HRStringUtils.equals((String)errorCode, (String)"hrmp.haos.wrongParams")) {
            throw new KDBizException((Throwable)exception, new ErrorCode(errorCode, ResManager.loadKDString((String)"\u7f16\u5236\u8c03\u7528\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferStaffServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0])), new Object[0]);
        }
        throw new KDBizException((Throwable)exception, new ErrorCode(errorCode, ResManager.loadKDString((String)"\u7f16\u5236\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferStaffServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0])), new Object[0]);
    }
}

