/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.IEffectTransferService;
import kd.hr.hdm.business.domain.transfer.service.ITransferEffectForSecondDevelopService;
import kd.hr.hdm.business.domain.transfer.service.ITransferScheduleEffectValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferEffectForSecondDevelopServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferScheduleEffectValidatorServiceImpl;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;

public class EffectTransferServiceImpl
implements IEffectTransferService {
    private static final Log LOGGER = LogFactory.getLog(EffectTransferServiceImpl.class);
    private static final String SELECT_FIELDS = "id,billno,,effectdate,bemployee,bmanagescope,transferdate,auditstatus,plandate,person,org,transferstatus,postype,transferinstatus,transferoutstatus,billstatus,workflowflag,originator,transferstage,bdepemp,borg,postpattern,arealitystposition,arealitybaselocation,bcountry,realitydate,transferclassify,affaction,isinternationaltransfer,bcompany,isinternationaltransfer,bcompany,aplancompany,aplanorg,acompany,aorg,arealitycompany,arealityorg,baffiliateorg,aaffiliateorg,borglonghis,aplanorglonghis,aorglonghis,ahrbu,arealityorglonghis,baffiliateorglonghis,aaffiliateorglonghis,aposition,bposition,aplanposition,arealityposition,ajob,arealityjob,aevaluationjob,bevaluationjob,ajobclasstext,bjobclasstext,transfertype";

    @Override
    public void excuteEffectTransfer() {
        try {
            Calendar now = Calendar.getInstance();
            QFilter effectDateFilter = new QFilter("realitydate", "<=", (Object)now.getTime());
            QFilter transferStatusFilter = new QFilter("transferstatus", "=", (Object)"4");
            QFilter transferEffectStatusFilter = new QFilter("transfereffectstatus", "!=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{effectDateFilter, transferStatusFilter, transferEffectStatusFilter};
            DynamicObject[] transBills = TransferBillRepository.getInstance().query(SELECT_FIELDS, qFilters);
            LOGGER.info("To_effect transferbills counts:{}", (Object)transBills.length);
            if (0 == transBills.length) {
                return;
            }
            for (DynamicObject transBill : transBills) {
                this.effectTransfer(transBill);
            }
        }
        catch (Exception e) {
            LOGGER.error("excuteEffectTransfer exception:", (Throwable)e);
        }
    }

    private DynamicObject getEffectTransferDys(Long id) {
        Calendar now = Calendar.getInstance();
        QFilter effectDateFilter = new QFilter("realitydate", "<=", (Object)now.getTime());
        QFilter transferEffectStatusFilter = new QFilter("transfereffectstatus", "!=", (Object)"1");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        QFilter[] qFilters = new QFilter[]{idFilter, effectDateFilter, transferEffectStatusFilter};
        DynamicObject[] transBills = TransferBillRepository.getInstance().query(SELECT_FIELDS, qFilters);
        return transBills.length > 0 ? transBills[0] : null;
    }

    @Override
    public void excuteEffectTransfer(Long id) {
        LOGGER.info("EffectTransferServiceImpl.excuteEffectTransfer start, id:{}", (Object)id);
        DynamicObject transferDy = this.getEffectTransferDys(id);
        if (transferDy != null) {
            this.effectTransfer(transferDy);
        }
        LOGGER.info("EffectTransferServiceImpl.excuteEffectTransfer end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void effectTransfer(DynamicObject transBill) {
        try {
            TransferScheduleEffectValidatorServiceImpl transferValidatorService = (TransferScheduleEffectValidatorServiceImpl)ITransferScheduleEffectValidatorService.getInstance();
            DataDiv dataDiv = new DataDiv(transBill, new ValidateContext());
            boolean quitValideBoolean = transferValidatorService.getQuitPredicate().test(dataDiv);
            if (!quitValideBoolean) {
                LOGGER.warn("the person has quit, transfer effective terminate, the transferbill id is [{}]", (Object)transBill.getLong("id"));
                return;
            }
            transferValidatorService.excutePersonChangeCrossValidate(dataDiv);
            if ("1".equals(dataDiv.getValidatorContext().getResultLevel())) {
                LOGGER.warn("the transfer bill execute person change cross validate fail, the billId is :[{}], the validate message is :[{}]", (Object)transBill.getLong("id"), dataDiv.getValidatorContext().getValidateResult());
                return;
            }
            boolean validatePass = this.validateMustInputFields().test(dataDiv);
            if (!validatePass) {
                LOGGER.warn("the transfer bill execute must input fields fail, the billId is :[{}], the validate message is :[{}]", (Object)transBill.getLong("id"), dataDiv.getValidatorContext().getValidateResult());
                return;
            }
            ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"", (String)"", (Object[])new Object[0])).test(Collections.singletonList(dataDiv));
            if (dataDiv.getValidatorContext().getValidateResult().size() > 0) {
                LOGGER.error("validateBaseDataEnable error the billId is :[{}],, the validate message is :[{}]", (Object)transBill.getLong("id"), dataDiv.getValidatorContext().getValidateResult());
                return;
            }
            LOGGER.info("Start event change service:");
            TransferEffectForSecondDevelopServiceImpl effectForSecondDevelopService = (TransferEffectForSecondDevelopServiceImpl)ITransferEffectForSecondDevelopService.getInstance();
            try (TXHandle tx = TX.required();){
                effectForSecondDevelopService.excutePersonChangeEffect(transBill.getLong("id"), PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_EFFECT);
            }
            LOGGER.info("End  event change service");
        }
        catch (Exception e) {
            LOGGER.error("Transfer effect fail bills [{}], reason:{}", transBill.getPkValue(), (Object)e);
        }
    }

    @Override
    public Predicate<DataDiv> validateMustInputFields() {
        return dataDiv -> {
            String fieldsName;
            String postPattern;
            String fieldsName2;
            DynamicObject data = dataDiv.getDynamicObject();
            ArrayList<String> fieldsNameList = new ArrayList<String>(4);
            DynamicObject arealityCompany = data.getDynamicObject("arealitycompany");
            DynamicObject arealityOrg = data.getDynamicObject("arealityorg");
            DynamicObject arealityStPosition = data.getDynamicObject("arealitystposition");
            DynamicObject arealitypPsition = data.getDynamicObject("arealityposition");
            DynamicObject arealityJob = data.getDynamicObject("arealityjob");
            if (Objects.isNull(arealityCompany)) {
                fieldsName2 = ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8c03\u5165\u516c\u53f8\u201d", (String)"EffectTransferServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]);
                fieldsNameList.add(fieldsName2);
            }
            if (Objects.isNull(arealityOrg)) {
                fieldsName2 = ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8c03\u5165\u90e8\u95e8\u201d", (String)"EffectTransferServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]);
                fieldsNameList.add(fieldsName2);
            }
            if (StringUtils.isBlank((CharSequence)(postPattern = data.getString("postpattern")))) {
                fieldsName = ResManager.loadKDString((String)"\u201c\u4efb\u5c97\u6a21\u5f0f\u201d", (String)"EffectTransferServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]);
                fieldsNameList.add(fieldsName);
            }
            if ("0".equals(postPattern) && Objects.isNull(arealityStPosition)) {
                fieldsName = ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8c03\u5165\u6807\u51c6\u5c97\u4f4d\u201d", (String)"EffectTransferServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]);
                fieldsNameList.add(fieldsName);
            }
            if ("1".equals(postPattern) && Objects.isNull(arealitypPsition)) {
                fieldsName = ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8c03\u5165\u5c97\u4f4d\u201d", (String)"EffectTransferServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[0]);
                fieldsNameList.add(fieldsName);
            }
            if ("2".equals(postPattern) && Objects.isNull(arealityJob)) {
                fieldsName = ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8c03\u5165\u4efb\u804c\u804c\u4f4d\u201d", (String)"EffectTransferServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]);
                fieldsNameList.add(fieldsName);
            }
            if (!CollectionUtils.isEmpty(fieldsNameList)) {
                LOGGER.warn("EffectTransferServiceImpl.validateMustInputFields error msg:{}", fieldsNameList);
                String errMsg = ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u66f4\u591a>\u4fe1\u606f\u53d8\u66f4\u201d\u8865\u5145\u4fe1\u606f\u3002", (String)"EffectTransferServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]);
                dataDiv.getValidatorContext().setResult("EffectTransferServiceImpl_7", errMsg);
                return false;
            }
            return true;
        };
    }
}

