/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Collections;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.domain.transfer.entity.StaffIsUpdateJudgementVO;
import kd.hr.hdm.business.domain.transfer.repository.BatchTransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBatchEntryService;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;

public class TransferBatchEntryServiceImpl
implements ITransferBatchEntryService {
    private static final Log LOG = LogFactory.getLog(TransferBatchEntryServiceImpl.class);

    @Override
    public DynamicObject[] queryEntryEntities(Long mid) {
        if (Objects.isNull(mid)) {
            return new DynamicObject[0];
        }
        return BatchTransferBillRepository.getInstance().queryEntryEntities(mid);
    }

    @Override
    public void update(DynamicObject newDynamicObject) {
        try (TXHandle tx = TX.required();){
            DynamicObject oldDynamicObject = ITransferBillService.getInstance().queryOne(TransferStaffService.getInstance().getSelectProperties(), newDynamicObject.getLong("id"));
            StaffIsUpdateJudgementVO staffIsUpdateJudgementVO = new StaffIsUpdateJudgementVO(oldDynamicObject, newDynamicObject);
            boolean update = staffIsUpdateJudgementVO.isUpdate();
            newDynamicObject.set("billstatus", (Object)oldDynamicObject.getString("billstatus"));
            try {
                BatchTransferBillRepository.getInstance().update(newDynamicObject);
                LOG.info("ITransferBatchEntryService.update: ", (Object)update);
                if (update) {
                    TransferStaffService.getInstance().occupyStaff(Collections.singletonList(newDynamicObject), true);
                }
            }
            catch (Exception exception) {
                LOG.error("ITransferBatchEntryService error: ", (Throwable)exception);
                tx.markRollback();
                throw new KDBizException(exception.getMessage());
            }
        }
    }
}

