/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.DevParamConfigExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.domain.transfer.service.validator.Validator;
import kd.hr.hdm.common.transfer.constants.TransferLabRelConstants;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;

public class TransferConfirmValidatorServiceImpl
implements ITransferConfirmValidatorService {
    private static final Log LOGGER = LogFactory.getLog(TransferConfirmValidatorServiceImpl.class);
    private static final int CORE_THREAD = Runtime.getRuntime().availableProcessors();
    private static final int MAX_THREAD = CORE_THREAD * 5;
    private static final String APPID_HR = "hr";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"TransferQuitExecutor-Thread", (int)CORE_THREAD, (int)MAX_THREAD, (String)"hr");

    @Override
    public Predicate<DataDiv> confirmValidate(String errormsg) {
        return Validator.CUSTOMIZE.testOnCustomized("transferstatus", errormsg, temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            String transferstatus = dynamicObject.getString("transferstatus");
            String transferEffectStattus = dynamicObject.getString("transfereffectstatus");
            boolean isToEffect = HRStringUtils.equals((String)transferstatus, (String)"4");
            boolean isSynchronizing = HRStringUtils.equals((String)transferEffectStattus, (String)"1");
            if (isToEffect && !isSynchronizing) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    @Override
    public Predicate<DataDiv> synchronizeStatusValidate() {
        return Validator.CUSTOMIZE.testOnCustomized("transfereffectstatus", ResManager.loadKDString((String)"\u4eba\u4e8b\u4e8b\u52a1\u53d8\u52a8\u540c\u6b65\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TransferConfirmValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]), temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            String transfereffectstatus = dynamicObject.getString("transfereffectstatus");
            if (HRStringUtils.equals((String)transfereffectstatus, (String)"1")) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Predicate<DataDiv> quitValidate() {
        return Validator.CUSTOMIZE.testOnCustomized("bemployee", ResManager.loadKDString((String)"\u786e\u8ba4\u8c03\u52a8\u5931\u8d25\uff0c\u5458\u5de5\u5df2\u79bb\u804c\u3002", (String)"TransferConfirmValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]), dataDiv -> this.getQuitPredicate().test((DataDiv)dataDiv));
    }

    @Override
    public Predicate<DataDiv> getQuitPredicate() {
        return dataDiv -> {
            DynamicObject transferBill = dataDiv.getDynamicObject();
            Long bemployee = transferBill.getLong("bemployee.id");
            Map<Long, DynamicObject> employeeList = PersonExternalService.getInstance().invokeGetEmployeeStatus(Collections.singletonList(bemployee));
            if (CollectionUtils.isEmpty(employeeList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferConfirmValidatorServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            DynamicObject employee = employeeList.get(bemployee);
            if (TransferLabRelConstants.QUIT.equals((Long)employee.get("labrelstatuscls_id"))) {
                THREAD_POOL.execute(() -> ITransferBillApplicationService.getInstance().discardTransferBills(Collections.singletonList(transferBill.getLong("id"))));
                return false;
            }
            return true;
        };
    }

    @Override
    public Map<String, Boolean> getDevConfigFields(String menuFlag) {
        LOGGER.info("###TransferConfirmValidatorServiceImpl.getDevConfigFields,menuFlag is:{}", (Object)menuFlag);
        String selectFields = "businesskey,app,businessvalue,description";
        DynamicObject[] devConfigList = DevParamConfigExternalService.getInstance().listDevParamConfigByAppNumber(selectFields, "hdm");
        HashMap<String, Boolean> configMap = new HashMap<String, Boolean>(8);
        block36: for (DynamicObject dynamicObject : devConfigList) {
            String businessKey = dynamicObject.getString("businesskey");
            Boolean value = Boolean.parseBoolean(dynamicObject.getString("businessvalue"));
            if ("in".equals(menuFlag) || "out".equals(menuFlag)) {
                switch (businessKey) {
                    case "hdm_transfer_in_and_out_require_aposition": {
                        configMap.put("aposition", value);
                        break;
                    }
                    case "hdm_transfer_in_and_out_require_astposition": {
                        configMap.put("astposition", value);
                        break;
                    }
                    case "hdm_transfer_in_and_out_require_ajob": {
                        configMap.put("ajob", value);
                        break;
                    }
                    case "hdm_transfer_in_and_out_require_ajobgrade": {
                        configMap.put("ajobgrade", value);
                        break;
                    }
                    default: {
                        continue block36;
                    }
                }
            }
            if ("apply".equals(menuFlag)) {
                switch (businessKey) {
                    case "hdm_transfer_apply_require_aposition": {
                        configMap.put("aposition", value);
                        break;
                    }
                    case "hdm_transfer_apply_require_astposition": {
                        configMap.put("astposition", value);
                        break;
                    }
                    case "hdm_transfer_apply_require_ajob": {
                        configMap.put("ajob", value);
                        break;
                    }
                    case "hdm_transfer_in_and_out_require_ajobgrade": {
                        configMap.put("ajobgrade", value);
                    }
                }
            }
            if (!"batch".equals(menuFlag)) continue;
            switch (businessKey) {
                case "hdm_my_transfer_require_aposition": {
                    configMap.put("aposition", value);
                    continue block36;
                }
                case "hdm_my_transfer_require_astposition": {
                    configMap.put("astposition", value);
                    continue block36;
                }
                case "hdm_my_transfer_require_ajob": {
                    configMap.put("ajob", value);
                    continue block36;
                }
                case "hdm_transfer_in_and_out_require_ajobgrade": {
                    configMap.put("ajobgrade", value);
                }
            }
        }
        LOGGER.info("###TransferConfirmValidatorServiceImpl.getDevConfigFields configMap is:{}", (Object)JSONObject.toJSONString(configMap));
        return configMap;
    }

    @Override
    public Map<String, Boolean> getDevConfigFieldsByOriginator(String originator) {
        if (TransferOriginatorEnum.IN.getOriginator().equals(originator) || TransferOriginatorEnum.OUT.getOriginator().equals(originator)) {
            return this.getDevConfigFields("in");
        }
        if (TransferOriginatorEnum.APPLY.getOriginator().equals(originator)) {
            return this.getDevConfigFields("apply");
        }
        if (TransferOriginatorEnum.MY.getOriginator().equals(originator)) {
            return this.getDevConfigFields("batch");
        }
        return new HashMap<String, Boolean>(){
            private static final long serialVersionUID = 4089927389285211483L;
            {
                this.put("aposition", Boolean.TRUE);
                this.put("astposition", Boolean.TRUE);
                this.put("ajob", Boolean.TRUE);
            }
        };
    }
}

