/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.StaffIsUpdateJudgementVO;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.repository.PermissionRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferInfoChangeDialogValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.TransferCrossVerifyEnum;
import kd.hr.hdm.common.transfer.enums.TransferStaffEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;

public class TransferInfoChangeDialogValidatorServiceImpl
implements ITransferInfoChangeDialogValidatorService {
    @Override
    public Predicate<DataDiv> validateAuth(String customParam) {
        return this.validateAuth(PermissionValidateUtil.getPermissionAppId(null), customParam);
    }

    @Override
    public Predicate<DataDiv> validateAuth(String appId, String customParam) {
        return dataDiv -> {
            if (!PermissionRepository.getInstance().checkOperatePermission(customParam, "HRQXX0300", appId)) {
                dataDiv.getValidatorContext().setResult("validateAuth", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fe1\u606f\u53d8\u66f4\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"TransferInfoChangeEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> validateStaff(DynamicObject transferBill, IDataModel model, ThreadLocal<StaffIsUpdateJudgementVO> cache) {
        return dataDiv -> {
            StaffIsUpdateJudgementVO staffIsUpdateJudgementVO = new StaffIsUpdateJudgementVO(transferBill, model);
            transferBill.set("realitydate", model.getValue("realitydate"));
            transferBill.set("ajob", model.getValue("ajob"));
            transferBill.set("arealityjob", model.getValue("arealityjob"));
            transferBill.set("aposition", model.getValue("aposition"));
            transferBill.set("arealityposition", model.getValue("arealityposition"));
            transferBill.set("astposition", model.getValue("astposition"));
            transferBill.set("arealitystposition", model.getValue("arealitystposition"));
            transferBill.set("postpattern", model.getValue("postpattern"));
            transferBill.set("aorg", model.getValue("aorg"));
            transferBill.set("arealityorg", model.getValue("arealityorg"));
            transferBill.set("acompany", model.getValue("acompany"));
            transferBill.set("arealitycompany", model.getValue("arealitycompany"));
            transferBill.set("aevaluationjob", model.getValue("aevaluationjob"));
            cache.set(staffIsUpdateJudgementVO);
            boolean update = staffIsUpdateJudgementVO.isUpdate();
            if (update) {
                this.setInfoChange(transferBill, model);
                StaffResponse<StaffQueryOutParamMap> staffUseInfoDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(TransferStaffEnum.UPDATE.name(), Collections.singletonList(transferBill));
                if (staffUseInfoDetail == null) {
                    dataDiv.getValidatorContext().setResult("validateStaff", ResManager.loadKDString((String)"\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferInfoChangeEdit_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                StaffQueryOutParamMap staffUseInfoDetailData = (StaffQueryOutParamMap)staffUseInfoDetail.getData();
                StaffQueryOutParam staffQueryOutParam = (StaffQueryOutParam)staffUseInfoDetailData.get((Object)TransferStaffVO.getQueryStaffKey(transferBill));
                boolean allow = staffQueryOutParam.isAllow();
                if (!allow) {
                    dataDiv.getValidatorContext().setResult("validateStaff", staffQueryOutParam.getReasonList().toString());
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> perChgCrossValidate(DynamicObject transferBill, IDataModel model) {
        return dataDiv -> {
            Map<String, Object> crossResultMap = this.excutePerChgCrossValidate(transferBill, TransferCrossVerifyEnum.CROSS_INFOCHANGE);
            switch ((String)crossResultMap.get("key")) {
                case "999": 
                case "1": {
                    model.setValue("realitydate", null);
                    dataDiv.getValidatorContext().setResult("perChgCrossValidate", (String)crossResultMap.get("info"));
                    return false;
                }
                case "0": {
                    dataDiv.getValidatorContext().setResult("perChgCrossValidate_callBack", (String)crossResultMap.get("info"));
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public boolean checkVersion(DynamicObject lastestTransferBill, IDataModel oldVersion) {
        Date version1 = lastestTransferBill.getDate("modifytime");
        Date version2 = (Date)oldVersion.getValue("modifytime");
        return ((String)TransferCommonUtil.formatStandardDate.apply(version1)).equals(TransferCommonUtil.formatStandardDate.apply(version2));
    }

    @Override
    public Predicate<DataDiv> validateBillStatus() {
        return dataDiv -> {
            DynamicObject transferbill = dataDiv.getDynamicObject();
            String transferStatus = transferbill.getString("transferstatus");
            if (HRStringUtils.equals((String)transferStatus, (String)"3")) {
                dataDiv.getValidatorContext().setResult("validateBillStatus", String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u53d8\u66f4\u5931\u8d25\uff0c\u201c%1$s\u201d\u7684\u8c03\u52a8\u5355\uff08%2$s\uff09\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"TransferInfoChangeEdit_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]), transferbill.getString("person.name"), transferbill.getString("billno")));
                return false;
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> validateExteranlProfileAndChgRecord(Long employeeId) {
        return dataDiv -> {
            ITransferValidatorService.getInstance().validateExteranlProfileAndChgRecord(Collections.singletonList(employeeId)).test(Collections.singletonList(dataDiv));
            return dataDiv.getValidatorContext().getValidateResult().size() <= 0;
        };
    }

    @Override
    public Predicate<DataDiv> validateSavePostpatternEffctDate(String condition, String menuFlag, String orgValidateConfig, String companyValidateConfig) {
        return dataDiv -> ITransferValidatorService.getInstance().validateBusinessFieldEffectDate(condition, menuFlag, orgValidateConfig, companyValidateConfig).test(Collections.singletonList(dataDiv));
    }

    @Override
    public Map<String, Object> excutePerChgCrossValidate(DynamicObject ermanfile, TransferCrossVerifyEnum corss) {
        return ITransferPersonChangeService.getInstance().excutePerChgCrossValidate(ermanfile, corss);
    }

    private void setInfoChange(DynamicObject data, IDataModel model) {
        DynamicObject arealitycompany = (DynamicObject)model.getValue("acompany");
        DynamicObject arealityorg = (DynamicObject)model.getValue("aorg");
        DynamicObject arealityposition = (DynamicObject)model.getValue("aposition");
        DynamicObject arealitystposition = (DynamicObject)model.getValue("astposition");
        DynamicObject arealitybaselocation = (DynamicObject)model.getValue("abaselocation");
        Date realitydate = (Date)model.getValue("realitydate");
        DynamicObject amanagescope = (DynamicObject)model.getValue("amanagescope");
        DynamicObject workingplan = (DynamicObject)model.getValue("workingplan");
        DynamicObject ajob = (DynamicObject)model.getValue("ajob");
        DynamicObjectCollection arealitysuperior = (DynamicObjectCollection)model.getValue("arealitysuperior");
        DynamicObjectCollection arealityorgleader = (DynamicObjectCollection)model.getValue("arealityorgleader");
        data.set("arealitycompany", (Object)arealitycompany);
        data.set("arealityorg", (Object)arealityorg);
        data.set("arealityposition", (Object)arealityposition);
        data.set("arealitystposition", (Object)arealitystposition);
        data.set("arealitybaselocation", (Object)arealitybaselocation);
        data.set("realitydate", (Object)realitydate);
        data.set("amanagescope", (Object)amanagescope);
        data.set("arealitysuperior", (Object)arealitysuperior);
        data.set("arealityorgleader", (Object)arealityorgleader);
        data.set("aaffiliateorg", (Object)arealityorg);
        data.set("workingplan", (Object)workingplan);
        data.set("arealityjob", (Object)ajob);
        data.set("postpattern", model.getValue("postpattern"));
        data.set("transferoutlastdate", TransferCommonUtil.GETYESTERDAY.apply(realitydate));
    }
}

