/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.domain.transfer.repository.TransferBatchRepository;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBatchService;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillDomainService;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferOperationService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferBillServiceImpl;
import kd.hr.hdm.business.mq.sender.TransferStaffSend;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferApproveStatusEnum;
import kd.hr.hdm.common.transfer.enums.TransferStageEnum;
import kd.hr.hdm.common.transfer.enums.WorkFlowFlagEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;

public class TransferOperationServiceImpl
implements ITransferOperationService {
    private static final Log LOGGER = LogFactory.getLog(TransferBillServiceImpl.class);

    @Override
    public String submit(List<DynamicObject> dynamicObjects) {
        try {
            LOGGER.info("Submit update result start.");
            dynamicObjects.forEach(temp -> {
                temp.set("transferstatus", (Object)"1");
                String transferstage = (String)TransferCommonUtil.STRINGADDONE.apply(temp.getString("transferstage"));
                temp.set("transferstage", (Object)transferstage);
                this.setFirstApproveStatus((DynamicObject)temp);
                ITransferBillService.getInstance().setBMainOrg((DynamicObject)temp);
            });
            ITransferBillService.getInstance().setAMainOrg(dynamicObjects);
            LOGGER.info("Submit update result end.");
            LOGGER.info("Submit notice persontransaction change start.");
            ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(dynamicObjects, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
            LOGGER.info("Submit notice persontransaction change end.");
        }
        catch (Exception exception) {
            LOGGER.error("TransferOperationServiceImpl submit error", (Throwable)exception);
        }
        return " ";
    }

    @Override
    public String submitApply(List<DynamicObject> dynamicObjects) {
        try {
            LOGGER.info("submitApply update result start.");
            dynamicObjects.forEach(temp -> {
                temp.set("transferstatus", (Object)"1");
                temp.set("billstatus", (Object)"B");
                temp.set("auditstatus", (Object)"B");
            });
            LOGGER.info("submitApply update result end.");
            LOGGER.info("submitApply notice persontransaction change start.");
            ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(dynamicObjects, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
            LOGGER.info("submitApply notice persontransaction change end.");
        }
        catch (Exception exception) {
            LOGGER.error("submitApply fail.", (Throwable)exception);
        }
        return " ";
    }

    @Override
    public String submitEffect(List<DynamicObject> dynamicObjects) {
        try {
            LOGGER.info("submitEffect update result start.");
            dynamicObjects.forEach(temp -> {
                temp.set("transferstatus", (Object)"4");
                temp.set("billstatus", (Object)"C");
                temp.set("auditstatus", (Object)"C");
            });
            ITransferBillService.getInstance().update(dynamicObjects);
            LOGGER.info("submitEffect update result end.");
            LOGGER.info("submitEffect notice persontransaction change start.");
            ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(dynamicObjects, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
            LOGGER.info("submitEffect notice persontransaction change end.");
        }
        catch (Exception exception) {
            LOGGER.error("submitEffect fail.", (Throwable)exception);
        }
        return " ";
    }

    @Override
    public String uncommitTransfer(List<DynamicObject> billDys) {
        billDys.forEach(temp -> {
            temp.set("workflowflag", (Object)WorkFlowFlagEnum.INIT.getFlag());
            temp.set("transferstage", (Object)TransferStageEnum.INIT.getName());
            if ("1".equals(temp.getString("originator"))) {
                temp.set("transferoutstatus", (Object)TransferApproveStatusEnum.transferOutInit.getApproveStatus());
                temp.set("transferstatus", (Object)"0");
            } else if ("2".equals(temp.getString("originator"))) {
                temp.set("transferinstatus", (Object)TransferApproveStatusEnum.transferInInit.getApproveStatus());
                temp.set("transferstatus", (Object)"0");
            } else if ("3".equals(temp.getString("originator"))) {
                temp.set("transferstatus", (Object)"0");
                temp.set("auditstatus", (Object)"A");
                temp.set("billstatus", (Object)"A");
            }
        });
        ITransferBillService.getInstance().update(billDys);
        ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(billDys, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO);
        TransferStaffSend.sendStaffTerminalMsg(billDys);
        return " ";
    }

    @Override
    public String rejectToSubmitTransfer(List<DynamicObject> billDys) {
        billDys.forEach(temp -> {
            temp.set("workflowflag", (Object)WorkFlowFlagEnum.INIT.getFlag());
            temp.set("transferstage", (Object)TransferStageEnum.INIT.getName());
            temp.set("transferstatus", (Object)"1");
            temp.set("auditstatus", (Object)"A");
            temp.set("billstatus", (Object)"G");
        });
        ITransferBillService.getInstance().update(billDys);
        ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(billDys, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO);
        TransferStaffSend.sendStaffTerminalMsg(billDys);
        return "";
    }

    private void setFirstApproveStatus(DynamicObject dynamicObject) {
        String workflowflag = dynamicObject.getString("workflowflag");
        String originator = dynamicObject.getString("originator");
        LOGGER.info("TransferBillServiceImpl setApproveStatus workflowflag :{} , originator : {}", (Object)workflowflag, (Object)originator);
        if (originator.equals("1")) {
            dynamicObject.set("transferoutstatus", (Object)TransferApproveStatusEnum.transferOutSubmit.getApproveStatus());
        } else if (originator.equals("2")) {
            dynamicObject.set("transferinstatus", (Object)TransferApproveStatusEnum.transferInSubmit.getApproveStatus());
        } else {
            throw new KDBizException("get transfer originator error");
        }
    }

    @Override
    public Tuple<Boolean, String> handleTermination(Long id, IDataModel dataModel) {
        DynamicObject dy = TransferBillRepository.getInstance().queryOne(TransferPageHelperUtil.QUERYFIELD, id);
        if ("2".equals(dy.getString("transferstatus"))) {
            return Tuple.create((Object)Boolean.TRUE, (Object)"");
        }
        if (!"4".equals(dy.getString("transferstatus"))) {
            ITransferBillDomainService.getInstance().terminateWorkFlow(dy);
        }
        if (dataModel != null) {
            dy.set("terminationreason", dataModel.getValue("terminationreason"));
            dy.set("terminationdesc", dataModel.getValue("terminationdesc"));
        }
        dy.set("terminationperson", (Object)RequestContext.get().getCurrUserId());
        dy.set("terminationtime", (Object)new Date());
        dy.set("auditstatus", (Object)"F");
        dy.set("billstatus", (Object)"F");
        dy.set("transferstatus", (Object)"3");
        dy.set("transferinstatus", (Object)TransferApproveStatusEnum.transferInDiscard.getApproveStatus());
        dy.set("transferoutstatus", (Object)TransferApproveStatusEnum.transferOutDiscard.getApproveStatus());
        ITransferPersonChangeService.getInstance().excutePersonChangeNotice(dy, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO);
        TransferBillRepository.getInstance().update(dy);
        TransferStaffSend.sendStaffTerminalMsg(Collections.singletonList(dy));
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    @Override
    public Tuple<Boolean, String> batchHandleTermination(Long id, IDataModel dataModel) {
        DynamicObject dy = ITransferBatchService.getInstance().queryOne(TransferPageHelperUtil.BATCHQUERYFIELD, id);
        if ("B".equals(dy.getString("billstatus")) || "D".equals(dy.getString("billstatus"))) {
            dy.set("billstatus", (Object)"F");
            ITransferBillDomainService.getInstance().terminateWorkFlow(dy);
        }
        DynamicObjectCollection entryDyCollection = dy.getDynamicObjectCollection("entryentity");
        List<DynamicObject> terminateDyList = entryDyCollection.stream().filter(temp -> {
            if (!"F".equals(temp.getString("entrybillstatus")) && ("0".equals(temp.getString("transfereffectstatus")) || "3".equals(temp.getString("transfereffectstatus")))) {
                if (dataModel != null) {
                    temp.set("terminationreason", dataModel.getValue("terminationreason"));
                    temp.set("terminationdesc", dataModel.getValue("terminationdesc"));
                }
                temp.set("terminationperson", (Object)RequestContext.get().getCurrUserId());
                temp.set("terminationtime", (Object)new Date());
                temp.set("entryauditstatus", (Object)"F");
                temp.set("entrybillstatus", (Object)"F");
                temp.set("transferstatus", (Object)"3");
                temp.set("transferinstatus", (Object)TransferApproveStatusEnum.transferInDiscard.getApproveStatus());
                temp.set("transferoutstatus", (Object)TransferApproveStatusEnum.transferOutDiscard.getApproveStatus());
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        List terminatedDyList = entryDyCollection.stream().filter(temp -> "F".equals(temp.getString("entrybillstatus"))).collect(Collectors.toList());
        if (terminatedDyList.size() == entryDyCollection.size()) {
            dy.set("auditstatus", (Object)"F");
        } else {
            dy.set("auditstatus", (Object)"H");
        }
        TransferBatchRepository.getInstance().update(dy);
        ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(terminateDyList, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO);
        TransferStaffSend.sendStaffTerminalMsg(terminateDyList);
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }
}

