/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.service.HdmFunction;
import kd.hr.hdm.business.domain.transfer.service.ITransferPropertyChangeValidatorService;

public class TransferPropertyChangeValidatorServiceImpl
implements ITransferPropertyChangeValidatorService {
    @Override
    public HdmFunction<IFormView, IDataModel, Integer, Boolean> isCompanyRemained(String keyComSource, String keyComTarget, long affActionId) {
        return (view, model, rowIndex) -> {
            boolean result = true;
            DynamicObject comSource = (DynamicObject)model.getValue(keyComSource);
            DynamicObject comTarget = (DynamicObject)model.getValue(keyComTarget);
            if (null == comSource || null == comTarget) {
                return true;
            }
            boolean comRemained = Objects.equals(comSource, comTarget);
            if (comRemained && (affActionId == 1060L || affActionId == 201060L)) {
                model.setValue(keyComTarget, null);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8de8\u516c\u53f8\u8c03\u52a8\u65f6\uff0c\u8c03\u5165\u516c\u53f8\u5e94\u4e0e\u8c03\u51fa\u516c\u53f8\u4e0d\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferPropertyChangeValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]));
                model.setValue("aorg", null);
                model.setValue("acompany", null);
                result = false;
            } else if (!(comRemained || 1050L != affActionId && 201050L != affActionId)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u516c\u53f8\u5185\u8c03\u52a8\u65f6\uff0c\u8c03\u5165\u516c\u53f8\u5e94\u4e0e\u8c03\u51fa\u516c\u53f8\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferBillPropChangedEdit_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                model.setValue("aorg", null);
                model.setValue("acompany", model.getValue("bcompany"));
                result = false;
            }
            return result;
        };
    }

    @Override
    public HdmFunction<IFormView, IDataModel, Integer, Boolean> validatePosition(long affActionId) {
        return (view, model, rowIndex) -> {
            DynamicObject dy = model.getDataEntity();
            if (!this.isInnerTransfer(dy)) {
                return true;
            }
            boolean result = true;
            Object aPosition = model.getValue("aposition");
            Object bPosition = model.getValue("bposition");
            boolean comRemained = !Objects.isNull(bPosition) && Objects.equals(aPosition, bPosition);
            Object aOrg = model.getValue("aorg");
            Object bOrg = model.getValue("borg");
            boolean orgRemained = Objects.equals(aOrg, bOrg);
            String postPattern = (String)model.getValue("postpattern");
            if (orgRemained && comRemained && HRStringUtils.equals((String)postPattern, (String)"1")) {
                model.setValue("aposition", null);
                view.showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8c03\u51fa\u548c\u8c03\u5165\u5c97\u4f4d\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u8c03\u5165\u5c97\u4f4d\u201d\u3002", (String)"TransferPropertyChangeValidatorServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]));
                result = false;
            }
            return result;
        };
    }

    @Override
    public HdmFunction<IFormView, IDataModel, Integer, Boolean> validateStPosition(long affActionId) {
        return (view, model, rowIndex) -> {
            Object bOrg;
            DynamicObject dy = model.getDataEntity();
            if (!this.isInnerTransfer(dy)) {
                return true;
            }
            boolean result = true;
            Object aStdPosition = model.getValue("astposition");
            Object bStdPosition = model.getValue("bstposition");
            boolean comRemained = !Objects.isNull(bStdPosition) && Objects.equals(aStdPosition, bStdPosition);
            String postPattern = (String)model.getValue("postpattern");
            Object aOrg = model.getValue("aorg");
            boolean orgRemained = Objects.equals(aOrg, bOrg = model.getValue("borg"));
            if (orgRemained && comRemained && HRStringUtils.equals((String)postPattern, (String)"0")) {
                model.setValue("astposition", null);
                view.showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8c03\u51fa\u548c\u8c03\u5165\u6807\u51c6\u5c97\u4f4d\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u8c03\u5165\u6807\u51c6\u5c97\u4f4d\u201d\u3002", (String)"TransferPropertyChangeValidatorServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]));
                result = false;
            }
            return result;
        };
    }

    @Override
    public HdmFunction<IFormView, IDataModel, Integer, Boolean> validateJob(long affActionId) {
        return (view, model, rowIndex) -> {
            Object bOrg;
            DynamicObject dy = model.getDataEntity();
            if (!this.isInnerTransfer(dy)) {
                return true;
            }
            boolean result = true;
            Object aJob = model.getValue("ajob");
            Object bJob = model.getValue("bjob");
            boolean comRemained = !Objects.isNull(bJob) && Objects.equals(aJob, bJob);
            String postPattern = (String)model.getValue("postpattern");
            String bPostPattern = (String)model.getValue("bpostpattern");
            boolean postPatternCompare = HRStringUtils.equals((String)postPattern, (String)"2") && HRStringUtils.equals((String)bPostPattern, (String)"2");
            Object aOrg = model.getValue("aorg");
            boolean orgRemained = Objects.equals(aOrg, bOrg = model.getValue("borg"));
            if (orgRemained && comRemained && postPatternCompare) {
                model.setValue("ajob", null);
                view.showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8c03\u51fa\u548c\u8c03\u5165\u4efb\u804c\u804c\u4f4d\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u8c03\u5165\u4efb\u804c\u804c\u4f4d\u201d\u3002", (String)"TransferPropertyChangeValidatorServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]));
                result = false;
            }
            return result;
        };
    }

    public boolean isInnerTransfer(DynamicObject dy) {
        long affActionId = dy.getLong("affaction.id");
        if (affActionId == 1050L || affActionId == 201050L) {
            return true;
        }
        if (affActionId == 0L) {
            long bCompanyId;
            long aCompanyId = dy.getLong("acompany.id");
            return aCompanyId == (bCompanyId = dy.getLong("bcompany.id"));
        }
        return false;
    }
}

