/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.StaffIsUpdateJudgementVO;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.service.ITransferSaveValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.TransferStaffEnum;

public class TransferSaveValidatorServiceImpl
implements ITransferSaveValidatorService {
    @Override
    public Predicate<DataDiv> validateBillStatus() {
        return dataDiv -> {
            DynamicObject transferbill = dataDiv.getDynamicObject();
            String transferStatus = transferbill.getString("transferstatus");
            if (HRStringUtils.equals((String)transferStatus, (String)"3")) {
                dataDiv.getValidatorContext().setResult("validateBillStatus", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s\u7684\u8c03\u52a8\u6d41\u7a0b\u5df2\u7ec8\u6b62\u3002", (String)"TransferSaveValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]), transferbill.getString("person.name")));
                return false;
            }
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateSavePostpatternEffctDate(String condition, String menuFlag, String orgValidateConfig, String companyValidateConfig) {
        return dataDiv -> ITransferValidatorService.getInstance().validateBusinessFieldEffectDate(condition, menuFlag, orgValidateConfig, companyValidateConfig).test((List<DataDiv>)dataDiv);
    }

    @Override
    public Predicate<DataDiv> validateStaffInfo(DynamicObject oldTransferBill) {
        return dataDiv -> {
            boolean update;
            DynamicObject newTransferBill = dataDiv.getDynamicObject();
            if (oldTransferBill != null) {
                StaffIsUpdateJudgementVO staffIsUpdateJudgementVO = new StaffIsUpdateJudgementVO(oldTransferBill, newTransferBill);
                update = staffIsUpdateJudgementVO.isUpdate();
            } else {
                update = false;
            }
            String billStatus = (String)newTransferBill.get("billstatus");
            boolean isCommit = billStatus.equals("A");
            String condition = TransferStaffEnum.NEW.name();
            if (isCommit) {
                condition = TransferStaffEnum.NEW.name();
            }
            if (!isCommit && update) {
                condition = TransferStaffEnum.UPDATE.name();
            }
            if (isCommit || !isCommit && update) {
                StaffResponse<StaffQueryOutParamMap> staffUseInfoDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(condition, Collections.singletonList(newTransferBill));
                if (staffUseInfoDetail == null) {
                    dataDiv.getValidatorContext().setResult("validateStaffInfo", ResManager.loadKDString((String)"\u8c03\u7528\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferSaveValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                    return false;
                }
                StaffQueryOutParamMap data = (StaffQueryOutParamMap)staffUseInfoDetail.getData();
                StaffQueryOutParam staffQueryOutParam = (StaffQueryOutParam)data.get((Object)TransferStaffVO.getQueryStaffKey(newTransferBill));
                boolean allow = staffQueryOutParam.isAllow();
                if (!allow) {
                    dataDiv.getValidatorContext().setResult("validateStaffInfo", staffQueryOutParam.getReasonList().toString());
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateStaffInfo() {
        return dataDivs -> {
            List<DynamicObject> newTransferBill = dataDivs.stream().map(DataDiv::getDynamicObject).collect(Collectors.toList());
            StaffResponse<StaffQueryOutParamMap> staffUseInfoDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(TransferStaffEnum.NEW.name(), newTransferBill);
            if (staffUseInfoDetail == null) {
                dataDivs.forEach(temp -> temp.getValidatorContext().setResult("validateStaffInfo", ResManager.loadKDString((String)"\u8c03\u7528\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferSaveValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0])));
                return false;
            }
            StaffQueryOutParamMap data = (StaffQueryOutParamMap)staffUseInfoDetail.getData();
            for (DataDiv dynamicObject : dataDivs) {
                boolean allow;
                StaffQueryOutParam staffQueryOutParam = (StaffQueryOutParam)data.get((Object)TransferStaffVO.getQueryStaffKey(dynamicObject.getDynamicObject()));
                if (staffQueryOutParam == null) {
                    dynamicObject.getValidatorContext().setResult("validateStaffInfo", ResManager.loadKDString((String)"\u8c03\u7528\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferSaveValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
                if (allow = staffQueryOutParam.isAllow()) continue;
                dynamicObject.getValidatorContext().setResult("validateStaffInfo", staffQueryOutParam.getReasonList().toString());
            }
            return true;
        };
    }
}

