/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.ITransferSubmitValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.HrcsExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.domain.transfer.service.validator.Validator;
import kd.hr.hdm.common.transfer.enums.TransferApproveStatusEnum;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.enums.TransferStaffEnum;
import kd.hr.hdm.common.transfer.enums.TransferTypeEnum;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;

public class TransferSubmitValidatorServiceImpl
implements ITransferSubmitValidatorService {
    private static final Log LOGGER = LogFactory.getLog(TransferSubmitValidatorServiceImpl.class);

    @Override
    public Predicate<List<DataDiv>> checkSubmitDataRule(String permItemId, String appid, String pageId, String errorMsg) {
        return dataDivs -> {
            List<DataDiv> tmps = dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).collect(Collectors.toList());
            if (tmps.size() < 1) {
                return true;
            }
            List id = tmps.stream().map(temp -> temp.getDynamicObject().get("id")).collect(Collectors.toList());
            QFilter[] ids = new QFilter("id", "in", id).toArray();
            Map<Object, Boolean> hasPermission = HrcsExternalService.getInstance().invokeMatchDataRule(RequestContext.get().getCurrUserId(), appid, pageId, permItemId, ids, null);
            LOGGER.info("TransferValidatorServiceImpl checkDataRule invoke result : {}", (Object)hasPermission.toString());
            tmps.forEach(dataDiv -> {
                DynamicObject dynamicObject = dataDiv.getDynamicObject();
                Object key = dynamicObject.get("id");
                Boolean result = (Boolean)hasPermission.get(key);
                if (result == null) {
                    LOGGER.error("TransferValidatorServiceImpl checkDataRule error the value is null for id : {} ", (Object)key.toString());
                }
                if (!result.booleanValue()) {
                    dataDiv.getValidatorContext().setResult("dataRule", errorMsg);
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> checkRepeatInDb(List<DynamicObject> dynamicObjects) {
        return dataDivs -> {
            List tmps = dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).collect(Collectors.toList());
            if (tmps.size() < 1) {
                return true;
            }
            DynamicObjectCollection submitTransferBillById = ITransferBillService.getInstance().getSubmitTransferBillById(dynamicObjects);
            List ids = submitTransferBillById.stream().map(temp -> temp.getLong("bdepemp")).collect(Collectors.toList());
            Map<Long, DynamicObject> bdepemp = submitTransferBillById.stream().collect(Collectors.toMap(temp -> temp.getLong("bdepemp"), temp -> temp, (o1, o2) -> o1));
            tmps.stream().filter(temp -> ids.contains(temp.getDynamicObject().getLong("bdepemp.id"))).collect(Collectors.toList()).forEach(temp -> {
                DynamicObject processingBill = (DynamicObject)bdepemp.get(temp.getDynamicObject().getLong("bdepemp.id"));
                if (TransferTypeEnum.BATCH.getType().equals(processingBill.getLong("transfertype"))) {
                    temp.getValidatorContext().setResult("bdepemp", String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u4e2d\uff0c\u6279\u91cf\u8c03\u52a8\u5355\u636e\u7f16\u7801\u4e3a%2$s\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u52a8\u4eba\u5458\u3002", (String)"TransferSubmitValidatorServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0]), temp.getDynamicObject().getString("person.name"), processingBill.getString("mid.billno")));
                } else {
                    temp.getValidatorContext().setResult("bdepemp", String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u4e2d\uff0c\u8c03\u52a8\u5355\u636e\u7f16\u7801\u4e3a%2$s\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u52a8\u4eba\u5458\u3002", (String)"TransferSubmitValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]), temp.getDynamicObject().getString("person.name"), ((DynamicObject)bdepemp.get(temp.getDynamicObject().getLong("bdepemp.id"))).getString("billno")));
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> checkRepeat() {
        return transferBills -> {
            transferBills.stream().filter(temp -> temp.getDynamicObject().getLong("bdepemp.id") != 0L && temp.getValidatorContext().getValidateResult().size() < 1).collect(Collectors.toMap(key -> key.getDynamicObject().getLong("bdepemp.id"), value -> Lists.newArrayList((Object[])new DataDiv[]{value}), (o1, o2) -> {
                o1.addAll(o2);
                return o1;
            })).forEach((key, value) -> {
                if (value.size() > 1) {
                    value.forEach(temp -> {
                        if (temp.getValidatorContext().getValidateResult().size() < 1) {
                            DynamicObject transferBill = temp.getDynamicObject();
                            if (TransferTypeEnum.BATCH.getType().equals(transferBill.getLong("transfertype.id"))) {
                                temp.getValidatorContext().setResult("bdepemp", String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5b58\u5728\u591a\u884c\u6570\u636e\u3002", (String)"TransferSubmitValidatorServiceImpl_14", (String)"hr-hdm-business", (Object[])new Object[0]), transferBill.getString("person.name")));
                            } else {
                                temp.getValidatorContext().setResult("bdepemp", ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5b58\u5728\u9488\u5bf9\u540c\u4e00\u8c03\u52a8\u4eba\u5458\u7684\u540c\u4e00\u4efb\u804c\u8c03\u52a8\u7684\u591a\u5f20\u5355\u636e\u3002", (String)"TransferSubmitValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                            }
                        }
                    });
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateSubmitPostpatternEffctDate(String condition, String menuFlag, String orgValidateConfig, String companyValidateConfig) {
        return dataDiv -> ITransferValidatorService.getInstance().validateBusinessFieldEffectDate(condition, menuFlag, orgValidateConfig, companyValidateConfig).test((List<DataDiv>)dataDiv);
    }

    @Override
    public Predicate<List<DataDiv>> batchCheckRepeatInPerChg() {
        return dataDivs -> {
            List<DataDiv> tmps = dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).collect(Collectors.toList());
            ITransferPersonChangeService.getInstance().excuteBatchPersonChangeCrossValidate(tmps);
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> getStaffInfo() {
        return dataDivs -> {
            List<DataDiv> dataDivList = dataDivs.stream().filter(dataDiv -> {
                DynamicObject transferBill = dataDiv.getDynamicObject();
                return dataDiv.getValidatorContext().getValidateResult().size() < 1 && 0L != transferBill.getLong("arealityorg.id") && !HRObjectUtils.isEmpty((Object)transferBill.get("realitydate"));
            }).collect(Collectors.toList());
            if (dataDivList.size() < 1) {
                return true;
            }
            List<DynamicObject> transferBills = dataDivList.stream().map(DataDiv::getDynamicObject).collect(Collectors.toList());
            StaffResponse<StaffQueryOutParamMap> staffUseInfoDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(TransferStaffEnum.NEW.name(), transferBills);
            if (staffUseInfoDetail == null) {
                dataDivList.forEach(dataDiv -> this.setStaffReason((DataDiv)dataDiv, null));
                return false;
            }
            StaffQueryOutParamMap data = (StaffQueryOutParamMap)staffUseInfoDetail.getData();
            dataDivList.forEach(dataDiv -> {
                DynamicObject dynamicObject = dataDiv.getDynamicObject();
                String queryStaffKey = TransferStaffVO.getQueryStaffKey(dynamicObject);
                StaffQueryOutParam staffQueryOutParam = (StaffQueryOutParam)data.get((Object)queryStaffKey);
                boolean allow = staffQueryOutParam.isAllow();
                if (!allow) {
                    this.setStaffReason((DataDiv)dataDiv, staffQueryOutParam.getReasonList().toString());
                }
            });
            return true;
        };
    }

    private void setStaffReason(DataDiv dataDiv, String reason) {
        ValidateContext validatorContext = dataDiv.getValidatorContext();
        Map<String, String> validateResult = validatorContext.getValidateResult();
        if (validateResult.size() < 1) {
            reason = HRStringUtils.isEmpty((String)reason) || "null".equals(reason) ? ResManager.loadKDString((String)"\u7f16\u5236\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferValidatorServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]) : reason;
            validateResult.put("queryStaff", reason);
        }
    }

    @Override
    public Predicate<List<DataDiv>> submitValidate(String menuFlag) {
        return dataDivs -> {
            dataDivs.forEach(temp -> this.getPredicate(menuFlag).test((DataDiv)temp));
            return true;
        };
    }

    private Predicate<DataDiv> getPredicate(String menuFlag) {
        return Validator.CUSTOMIZE.testOnCustomized("auditstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u8c03\u5165\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u8c03\u5165\u90e8\u95e8\u63d0\u4ea4\u201d\u201c\u5f85\u8c03\u5165\u90e8\u95e8\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]), temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            if ("in".equals(menuFlag)) {
                String auditstatus = dynamicObject.getString("transferinstatus");
                if (HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInInit.getApproveStatus()) || HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInReSubmit.getApproveStatus())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }).and(Validator.CUSTOMIZE.testOnCustomized("auditstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u8c03\u51fa\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u8c03\u51fa\u90e8\u95e8\u63d0\u4ea4\u201d\u201c\u5f85\u8c03\u51fa\u90e8\u95e8\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferSubmitValidatorServiceImpl_10", (String)"hr-hdm-business", (Object[])new Object[0]), temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            if ("out".equals(menuFlag)) {
                String auditstatus = dynamicObject.getString("transferoutstatus");
                if (HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInInit.getApproveStatus()) || HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInReSubmit.getApproveStatus())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        })).and(Validator.CUSTOMIZE.testOnCustomized("auditstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"TransferSubmitValidatorServiceImpl_11", (String)"hr-hdm-business", (Object[])new Object[0]), temp -> {
            String auditstatus;
            DynamicObject dynamicObject = temp.getDynamicObject();
            if ("apply".equals(menuFlag) && !HRStringUtils.equals((String)(auditstatus = dynamicObject.getString("auditstatus")), (String)"A")) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }));
    }

    @Override
    public Predicate<List<DataDiv>> submitEffectValidate(String menuFlag) {
        return dataDivs -> {
            if ("apply".equals(menuFlag)) {
                dataDivs.stream().filter(temp -> !"A".equals(temp.getDynamicObject().getString("billstatus"))).forEach(temp -> temp.getValidatorContext().setResult("billstatus", ResManager.loadKDString((String)"\u53ea\u53ef\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"TransferSubmitValidatorServiceImpl_12", (String)"hr-hdm-business", (Object[])new Object[0])));
            }
            return true;
        };
    }

    private Function<List<DataDiv>, List<DataDiv>> getPassDataDiv() {
        return dataDivs -> dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).collect(Collectors.toList());
    }

    private DynamicObject[] getTransfers(List<DynamicObject> dynamicObjects, String operateType) {
        ArrayList<Long> depIds = new ArrayList<Long>(dynamicObjects.size());
        ArrayList<Long> ids = new ArrayList<Long>(dynamicObjects.size());
        for (DynamicObject dy : dynamicObjects) {
            depIds.add(dy.getLong("bdepemp.id"));
            ids.add(dy.getLong("id"));
        }
        QFilter depFilter = new QFilter("bdepemp", "in", depIds);
        QFilter idFilter = new QFilter("id", "not in", ids);
        if ("save".equals(operateType)) {
            QFilter originatorFilter = new QFilter("originator", "=", (Object)TransferOriginatorEnum.MY.getOriginator());
            depFilter.and(originatorFilter);
        }
        QFilter billStatusFilter1 = new QFilter("billstatus", "in", (Object)new String[]{"A", "G", "B", "D"});
        QFilter billStatusFilter2 = new QFilter("billstatus", "=", (Object)"C");
        QFilter transferStatusFilter = new QFilter("transferstatus", "=", (Object)"4");
        depFilter.and(idFilter).and(billStatusFilter1.or(billStatusFilter2.and(transferStatusFilter)));
        return TransferBillRepository.getInstance().query("billno,bdepemp,billstatus,originator,mid", new QFilter[]{depFilter});
    }

    private Predicate<List<DataDiv>> inProcessValidate(List<DynamicObject> dynamicObjects, String operateType) {
        return dataDivs -> {
            List<DataDiv> passList = this.getPassDataDiv().apply((List<DataDiv>)dataDivs);
            if (passList.size() < 1) {
                return true;
            }
            DynamicObject[] transferDys = this.getTransfers(dynamicObjects, operateType);
            if (transferDys == null || transferDys.length < 1) {
                return true;
            }
            Map<Long, List<DynamicObject>> transferMap = Arrays.stream(transferDys).collect(Collectors.groupingBy(temp -> temp.getLong("bdepemp.id")));
            passList.forEach(temp -> {
                long depId = temp.getDynamicObject().getLong("bdepemp.id");
                if (transferMap.get(depId) != null) {
                    List repeatList;
                    if ("save".equals(operateType)) {
                        temp.getValidatorContext().setResult("bdepemp", String.format(ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u201c%1$s\uff09\u4e2d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u8c03\u52a8\u7533\u8bf7\u3002", (String)"TransferSubmitValidatorServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0]), ((DynamicObject)((List)transferMap.get(depId)).get(0)).getString("billno")));
                    }
                    if ("submit".equals(operateType) && HRCollUtil.isNotEmpty(repeatList = ((List)transferMap.get(depId)).stream().filter(transfer -> !"A".equals(transfer.getString("billstatus")) || TransferOriginatorEnum.MY.getOriginator().equals(transfer.getString("originator"))).collect(Collectors.toList()))) {
                        String billNo = ((DynamicObject)repeatList.get(0)).getDynamicObject("mid") == null ? ((DynamicObject)repeatList.get(0)).getString("billno") : ((DynamicObject)repeatList.get(0)).getDynamicObject("mid").getString("billno");
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u201c%1$s\u201d\u4e2d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8c03\u52a8\u7533\u8bf7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferSubmitValidatorServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]), billNo);
                        long count = repeatList.stream().filter(transfer -> TransferOriginatorEnum.MY.getOriginator().equals(transfer.getString("originator"))).count();
                        if (count > 0L) {
                            errorMsg = String.format(ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u201c%1$s\u201d\u4e2d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8c03\u52a8\u7533\u8bf7\u3002", (String)"TransferSubmitValidatorServiceImpl_15", (String)"hr-hdm-business", (Object[])new Object[0]), billNo);
                        }
                        temp.getValidatorContext().setResult("bdepemp", errorMsg);
                    }
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> saveInProcessValidate(List<DynamicObject> dynamicObjects) {
        return dataDivs -> {
            this.inProcessValidate(dynamicObjects, "save").test((List<DataDiv>)dataDivs);
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> submitInProcessValidate(List<DynamicObject> dynamicObjects) {
        return dataDivs -> {
            this.inProcessValidate(dynamicObjects, "submit").test((List<DataDiv>)dataDivs);
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateLicense() {
        return dataDivs -> {
            List<DataDiv> passList = this.getPassDataDiv().apply((List<DataDiv>)dataDivs);
            if (passList.size() < 1) {
                return true;
            }
            List personIds = dataDivs.stream().map(dataDiv -> dataDiv.getDynamicObject().getLong("person.id")).collect(Collectors.toList());
            Map personLicenseMap = HRCertValidateServiceHelper.checkPersonLicenses(personIds);
            if (personLicenseMap == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"TransferSubmitValidatorServiceImpl_16", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            passList.forEach(dataDiv -> {
                long personId = dataDiv.getDynamicObject().getLong("person.id");
                Map personMap = (Map)personLicenseMap.get(personId);
                if (personMap != null && personMap.size() > 0 && !((Boolean)personMap.get("status")).booleanValue()) {
                    dataDiv.getValidatorContext().setResult("license", ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"TransferSubmitValidatorServiceImpl_16", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> saveValidateBillStatus(String operateKey) {
        return dataDivs -> {
            List<DataDiv> passList = this.getPassDataDiv().apply((List<DataDiv>)dataDivs);
            if (passList.size() < 1) {
                return true;
            }
            passList.forEach(dataDiv -> {
                String billStatus = dataDiv.getDynamicObject().getString("billstatus");
                if (!"A".equals(billStatus) && !"G".equals(billStatus)) {
                    if ("save".equals(operateKey)) {
                        dataDiv.getValidatorContext().setResult("billstatus", ResManager.loadKDString((String)"\u53ea\u53ef\u4fdd\u5b58\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u548c\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferSubmitValidatorServiceImpl_17", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                    if ("submit".equals(operateKey)) {
                        dataDiv.getValidatorContext().setResult("billstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u548c\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferSubmitValidatorServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                }
            });
            return true;
        };
    }
}

