/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.service.ITransferUnSubmitValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.HrcsExternalService;
import kd.hr.hdm.business.domain.transfer.service.validator.Validator;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;

public class TransferUnSubmitValidatorServiceImpl
implements ITransferUnSubmitValidatorService {
    private static final Log LOGGER = LogFactory.getLog(TransferUnSubmitValidatorServiceImpl.class);

    @Override
    public Predicate<List<DataDiv>> checkUnSubmitDataRule(String permItemId, String appid, String pageId, String errorMsg) {
        return dataDivs -> {
            List id = dataDivs.stream().map(temp -> temp.getDynamicObject().get("id")).collect(Collectors.toList());
            QFilter[] ids = new QFilter("id", "in", id).toArray();
            Map<Object, Boolean> hasPermission = HrcsExternalService.getInstance().invokeMatchDataRule(RequestContext.get().getCurrUserId(), appid, pageId, permItemId, ids, null);
            LOGGER.info("TransferValidatorServiceImpl checkDataRule invoke result : {}", (Object)hasPermission.toString());
            dataDivs.forEach(dataDiv -> {
                DynamicObject dynamicObject = dataDiv.getDynamicObject();
                Object key = dynamicObject.get("id");
                Boolean result = (Boolean)hasPermission.get(key);
                if (result == null) {
                    LOGGER.error("TransferValidatorServiceImpl checkDataRule error the value is null for id : {} ", (Object)key.toString());
                }
                if (!result.booleanValue()) {
                    dataDiv.getValidatorContext().setResult("dataRule", errorMsg);
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> unsubmitValidate(String menuflag) {
        return dataDivs -> {
            dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).forEach(temp -> {
                Predicate<DataDiv> dataDivPredicate = this.unSubmitValidateBillStatus();
                if (!HRStringUtils.equals((String)"apply", (String)menuflag)) {
                    dataDivPredicate.and(this.unSubmitValidate(menuflag)).test((DataDiv)temp);
                } else {
                    dataDivPredicate.and(this.unSubmitValidateMytransfer()).test((DataDiv)temp);
                }
            });
            return true;
        };
    }

    private Predicate<DataDiv> unSubmitValidate(String menuflag) {
        String msg = ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u8d77\u65b9\u53ef\u4ee5\u64a4\u9500\u3002", (String)"TransferUnSubmitValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]);
        return Validator.CUSTOMIZE.testOnCustomized("originator", msg, temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            String originator = dynamicObject.getString("originator");
            return TransferJudgementUtil.isOrginator((String)menuflag, (String)originator);
        });
    }

    private Predicate<DataDiv> unSubmitValidateBillStatus() {
        String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6838\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"TransferUnSubmitValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]);
        return Validator.CUSTOMIZE.testOnCustomized("auditstatus", msg, temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            String auditStatus = dynamicObject.getString("auditstatus");
            return "B".equals(auditStatus) || "D".equals(auditStatus);
        });
    }

    private Predicate<DataDiv> unSubmitValidateMytransfer() {
        String msg = ResManager.loadKDString((String)"\u8be5\u8c03\u52a8\u7533\u8bf7\u4e3a\u5458\u5de5\u53d1\u8d77\uff0c\u6682\u4e0d\u5141\u8bb8\u64a4\u9500\u64cd\u4f5c\u3002", (String)"TransferUnSubmitValidatorServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]);
        return Validator.CUSTOMIZE.testOnCustomized("auditstatus", msg, temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            String originatorStr = dynamicObject.getString("originator");
            return !HRStringUtils.equals((String)TransferOriginatorEnum.MY.getOriginator(), (String)originatorStr);
        });
    }
}

