/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonCallBackService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferPersonCallBackServiceImpl;
import kd.hr.hdm.common.transfer.enums.TransferStatusEnum;

public class TransferAckPersonChangeCallBack
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(TransferAckPersonChangeCallBack.class);
    private static final String SUCCESS = "success";
    private static final String BILL_ID = "billId";
    private static final String ERROR_MESSAGE = "errMsg";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        LOGGER.info("TransferAckPersonChangeCallBack, the response message is : [{}]", (Object)JSONObject.toJSONString((Object)message));
        JSONArray messageArray = (JSONArray)JSONObject.parse((String)((String)message));
        JSONObject chgResult = (JSONObject)messageArray.get(0);
        Long billId = chgResult.getLong(BILL_ID);
        if (!this.idempotentVal(billId)) {
            return;
        }
        TransferPersonCallBackServiceImpl transferValidatorService = (TransferPersonCallBackServiceImpl)ITransferPersonCallBackService.getInstance();
        DynamicObject transferBill = TransferBillRepository.getInstance().queryOne("", billId);
        try {
            if (!chgResult.getBoolean(SUCCESS).booleanValue()) {
                LOGGER.error("Personal change effect deal result is fail, the billId is : [{}], the error message is :[{}]", (Object)billId, chgResult.get((Object)ERROR_MESSAGE));
                transferValidatorService.executeFailCallBack(transferBill, chgResult, billId);
                LOGGER.info("TransferAckPersonChangeCallBack start sendMsg for sumary");
            } else {
                LOGGER.info("Personal change effect deal result is success, the billId is : [{}]", (Object)billId);
                transferValidatorService.executeSuccessCallBack(transferBill, chgResult, billId, messageArray);
            }
        }
        catch (Exception exception) {
            LOGGER.error("TransferAckPersonChangeCallBack exception  info : [{}] ", (Object)exception.getMessage());
        }
    }

    private boolean idempotentVal(Long billId) {
        DynamicObject transferBill = TransferBillRepository.getInstance().queryOne("transferstatus", billId);
        String transferStatus = transferBill.getString("transferstatus");
        return !TransferStatusEnum.TRANSFER_FINISH.getStatus().equals(transferStatus) && !TransferStatusEnum.TRANSFER_TERM.getStatus().equals(transferStatus);
    }
}

