/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.mq.consumer;

import com.alibaba.fastjson.JSONObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;

public class TransferNoticePersonChangeCallBack
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(TransferNoticePersonChangeCallBack.class);
    private static final String SUCCESS = "success";
    private static final String BILL_ID = "billid";
    private static final String OPERATION = "operation";
    private static final String ERROR_MESSAGE = "errMsg";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        LOGGER.info("TransferNoticePersonChangeCallBack, the response message is : [{}]", (Object)JSONObject.toJSONString((Object)message));
        JSONObject chgResult = (JSONObject)JSONObject.parse((String)((String)message));
        Long billId = chgResult.getLong(BILL_ID);
        Integer operation = chgResult.getInteger(OPERATION);
        try {
            if (!chgResult.getBoolean(SUCCESS).booleanValue()) {
                LOGGER.error("Personal change notice deal result is fail, the billId is : [{}], the operation is :[{}], the error message is :[{}]", new Object[]{billId, operation, chgResult.get((Object)ERROR_MESSAGE)});
            } else {
                LOGGER.info("Personal change notice deal result is success, the billId is : [{}], the operation is :[{}],", (Object)billId, (Object)operation);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }
}

