/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.mq.sender;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.common.HPFSTemplatePropertyHandler;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.business.reg.RegNewHpfsServiceHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.common.reg.constants.RegActionConstants;
import kd.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.hr.hpfs.business.perchg.bizentity.PerChgParam;

public class RegMQHelper {
    private static final Log LOG = LogFactory.getLog(RegMQHelper.class);

    private RegMQHelper() {
    }

    public static RegMQHelper getInstance() {
        return RegMQHelperHolder.INSTANCE;
    }

    public void syncProcessStatus(Long erManFileId, boolean isChangeStatus, boolean isSynExamResult) {
        if (HPFSTemplatePropertyHandler.isNewChgAction("hdm_reg_hpfs_new")) {
            RegNewHpfsServiceHelper.getInstance().regNewHpfsChgAsync(erManFileId);
            return;
        }
        HashMap<String, Integer> msg = new HashMap<String, Integer>();
        msg.put("operatetype", 1020);
        PerChgParam param = new PerChgParam();
        param.setAppId("hdm");
        param.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        PerChgBizInfo bizInfo = new PerChgBizInfo();
        HashMap<String, List<Long>> dataRow = new HashMap<String, List<Long>>();
        Map ermanfile = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{erManFileId});
        bizInfo.setOldErfileId(erManFileId);
        bizInfo.setOldPersonId((Long)ermanfile.get("person_id"));
        Long employeeId = (Long)ermanfile.get("employee_id");
        bizInfo.setOldEmployeeId(employeeId);
        bizInfo.setOldComempId((Long)ermanfile.get("cmpemp_id"));
        bizInfo.setOldDepempId((Long)ermanfile.get("depemp_id"));
        bizInfo.setBsed(new Date());
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        List<Long> trialPeriodIds = IPersonAboutService.getInstance().buildTrailsPKs(employeeId, "hrpi_trialperiod");
        List<Long> trialPeriodRstIds = IPersonAboutService.getInstance().buildTrailsPKs(employeeId, "hrpi_trialperiodrst");
        dataRow.put("hrpi_trialperiod", trialPeriodIds);
        dataRow.put("hrpi_trialperiodrst", trialPeriodRstIds);
        DynamicObject process = RegProcessServiceHelper.PROCESS_SERVICE_HELPER.queryOne("id,regstatus", employeeFilter);
        LOG.info("process regstatus:{}", (Object)process);
        if (isChangeStatus) {
            ArrayList<Long> processId = new ArrayList<Long>();
            processId.add(process.getLong("id"));
            dataRow.put("hdm_regprocess", processId);
        }
        bizInfo.setBillId(Long.valueOf(process.getLong("id")));
        bizInfo.setBillSource("hdm_regprocess" + System.currentTimeMillis());
        bizInfo.setActionId(RegActionConstants.REG_HALF_ACTION_ID);
        if (isSynExamResult) {
            DynamicObject exam = RegExamServiceHelper.RESULT_SERVICE_HELPER.queryOne("id", employeeFilter);
            ArrayList<Long> examId = new ArrayList<Long>();
            examId.add(exam.getLong("id"));
            dataRow.put("hdm_regexamresult", examId);
        }
        ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>();
        bizInfo.setDataRow(dataRow);
        bizInfoList.add(bizInfo);
        param.setBizInfoList(bizInfoList);
        msg.put("billdata", (Integer)param);
        this.publish(JSONObject.toJSONString(msg), "hpfs_perchg_queue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(String msg, String queueName) {
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("hr", queueName);){
            publisher.publish(msg);
        }
    }

    private static final class RegMQHelperHolder {
        private static final RegMQHelper INSTANCE = new RegMQHelper();

        private RegMQHelperHolder() {
        }
    }
}

