/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.mq.sender;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.mq.sender.TransferAckPersonChangeSend;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class TransferStaffSend {
    private static final Log LOGGER = LogFactory.getLog(TransferAckPersonChangeSend.class);
    private static final String TERMINAL_MSGNUMB = "MP20220926002003";
    private static final String EFFECT_MSGNUMB = "MP20220926002002";
    private static final String INEFFECT_CHANGEEVENT_NUMBER = "1060_S";
    private static final String OUTEFFECT_CHANGEEVENT_NUMBER = "1080_S";

    public static void sendStaffEffectMsg(List<DynamicObject> transferBills, long newDepEmpId) {
        try {
            LOGGER.info("TransferStaffSend start send staff msg");
            HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
            messageParams.put("msgNumber", String.valueOf(new Date().getTime()));
            messageParams.put("msgPubNo", EFFECT_MSGNUMB);
            messageParams.put("msgTitle", String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u7f16\u5236\u751f\u6548", (String)"TransferStaffSend_0", (String)"hr-hdm-business", (Object[])new Object[0]), transferBills.get(0).getString("person.name"), transferBills.get(0).getString("person.number")));
            messageParams.put("actionId", 12701L);
            messageParams.put("senderId", RequestContext.get().getCurrUserId());
            messageParams.put("sendTime", new Date());
            messageParams.put("params", SerializationUtils.serializeToBase64(TransferStaffSend.getEFFectMessageContent(newDepEmpId, transferBills)));
            LOGGER.info(String.format("HRProducerServiceHelper------sendToHRMP----messageParams:%s", JSONObject.toJSONString(messageParams)));
            HRProducerServiceHelper.publishAction(messageParams);
        }
        catch (Exception exception) {
            LOGGER.error("TransferStaffSend error exceptionMessage :{}", (Object)exception.getMessage());
            LOGGER.error("TransferStaffSend error exceptionStackTrace :{}", (Object)Arrays.toString(exception.getStackTrace()));
            throw new KDBizException("TransferStaffSend sendStaffEffectMsg");
        }
    }

    public static void sendStaffTerminalMsg(List<DynamicObject> transferBills) {
        if (ObjectUtils.isEmpty(transferBills)) {
            return;
        }
        HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
        messageParams.put("msgNumber", String.valueOf(new Date().getTime()));
        messageParams.put("msgPubNo", TERMINAL_MSGNUMB);
        messageParams.put("msgTitle", String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u7f16\u5236\u7ec8\u6b62", (String)"TransferStaffSend_1", (String)"hr-hdm-business", (Object[])new Object[0]), transferBills.get(0).getString("person.name"), transferBills.get(0).getString("person.number")));
        messageParams.put("actionId", 12702L);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(TransferStaffSend.getTerminalMessageContent(transferBills)));
        LOGGER.info(String.format("HRProducerServiceHelper------sendToHRMP----messageParams:%s", JSONObject.toJSONString(messageParams)));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private static List<Map<String, Object>> getEFFectMessageContent(long newDepEmpId, List<DynamicObject> transferBills) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        List<Map<String, String>> dimension = TransferStaffService.getInstance().queryStaffDynamicdimension();
        transferBills.forEach(transferBill -> {
            HashMap<String, Object> afterParam = new HashMap<String, Object>(16);
            TransferStaffVO transferStaffVO = new TransferStaffVO((DynamicObject)transferBill);
            afterParam.put("personId", transferStaffVO.getPersonId());
            afterParam.put("depEmpId", newDepEmpId);
            afterParam.put("oldDepEmpId", transferStaffVO.getDepEmpId());
            afterParam.put("orgTeamId", transferStaffVO.getOrgTeamId());
            afterParam.put("dutyWorkRoleId", transferStaffVO.getDutyWorkRoleId());
            afterParam.put("jobId", transferStaffVO.getJobId());
            afterParam.put("joblevelId", transferStaffVO.getJobLevelId());
            afterParam.put("laborRelTypeId", transferStaffVO.getLaborRelTypeId());
            afterParam.put("effDate", transferStaffVO.getEffDate());
            afterParam.put("bizBillId", transferStaffVO.getBizBillId());
            afterParam.put("changeEventNumber", INEFFECT_CHANGEEVENT_NUMBER);
            if (dimension != null && !dimension.isEmpty()) {
                HashMap other = Maps.newHashMapWithExpectedSize((int)dimension.size());
                dimension.stream().forEach(item -> other.put(item.get("staffdimension"), TransferStaffService.getInstance().getDimensionValue((String)item.get("mapfield"), (DynamicObject)transferBill)));
                afterParam.put("other", other);
            }
            HashMap<String, Object> beforeParam = new HashMap<String, Object>(16);
            beforeParam.put("personId", transferStaffVO.getPersonId());
            beforeParam.put("depEmpId", transferStaffVO.getDepEmpId());
            beforeParam.put("orgTeamId", transferStaffVO.getbOrgTeamId());
            beforeParam.put("effDate", transferStaffVO.getEffDate());
            beforeParam.put("bizBillId", transferStaffVO.getBizBillId());
            beforeParam.put("changeEventNumber", OUTEFFECT_CHANGEEVENT_NUMBER);
            params.add(afterParam);
            params.add(beforeParam);
        });
        return params;
    }

    private static List<Map<String, Object>> getTerminalMessageContent(List<DynamicObject> transferBills) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        transferBills.forEach(transferBill -> {
            HashMap<String, Long> param = new HashMap<String, Long>(16);
            TransferStaffVO transferStaffVO = new TransferStaffVO((DynamicObject)transferBill);
            param.put("personId", transferStaffVO.getPersonId());
            param.put("depEmpId", transferStaffVO.getDepEmpId());
            param.put("orgTeamId", transferStaffVO.getOrgTeamId());
            param.put("bizBillId", transferStaffVO.getBizBillId());
            params.add(param);
        });
        return params;
    }
}

