/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.business.reg.RegMessageServiceHelper;

public class RegAskServiceHelper {
    public static final HRBaseServiceHelper RESULT_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regaskresult");
    public static final HRBaseServiceHelper DETAILS_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regaskdetails");

    public static Long updateAskResult(Long employee, Long personId, String askResult) {
        QFilter filter = new QFilter("bemployee", "=", (Object)employee);
        DynamicObject result = RESULT_SERVICE_HELPER.queryOne("bemployee,person,askresult", new QFilter[]{filter});
        if (result == null) {
            result = RESULT_SERVICE_HELPER.generateEmptyDynamicObject();
        }
        result.set("bemployee", (Object)employee);
        result.set("person", (Object)personId);
        if (askResult != null) {
            result.set("askresult", (Object)askResult);
        } else {
            result.set("askresult", (Object)"");
        }
        DynamicObject saveResult = (DynamicObject)RESULT_SERVICE_HELPER.saveOne(result);
        return saveResult.getLong("id");
    }

    public static void newAskDetails(Long employee, Long personId, List<Long> askPersonIds, Long resultId, List<Long> messageIds, Map<Long, Long> detailMap, Map<Long, String> roleMap) {
        int size = askPersonIds.size();
        DynamicObjectCollection detailsObjects = new DynamicObjectCollection();
        for (int i = 0; i < size; ++i) {
            DynamicObject detailsObject = DETAILS_SERVICE_HELPER.generateEmptyDynamicObject();
            detailsObject.set("id", (Object)detailMap.get(messageIds.get(i)));
            detailsObject.set("bemployee", (Object)employee);
            detailsObject.set("person", (Object)personId);
            detailsObject.set("askperson", (Object)askPersonIds.get(i));
            detailsObject.set("role", (Object)roleMap.get(askPersonIds.get(i)));
            detailsObject.set("result", (Object)resultId);
            detailsObject.set("message", (Object)messageIds.get(i));
            detailsObject.set("initiator", (Object)RequestContext.get().getCurrUserId());
            detailsObject.set("initiatetime", (Object)new Date());
            detailsObject.set("status", (Object)"1020");
            detailsObject.set("isnewest", (Object)Boolean.TRUE);
            detailsObjects.add((Object)detailsObject);
        }
        DETAILS_SERVICE_HELPER.save(detailsObjects);
    }

    public static Map<String, Long> sendAskMessageToUser(Long ermanFileId, Long askPerson, String messageTemplateNumber) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        Long detailId = ORM.create().genLongId("hdm_regaskdetails");
        String contentUrl = UrlService.getDomainContextUrl() + "/?formId=hdm_regaskreply&detailId=" + detailId + "&ermanfile=" + ermanFileId;
        LocaleString tag = ResManager.getLocaleString((String)"\u8f6c\u6b63\u95ee\u8be2", (String)"RegAskServiceHelper_2", (String)"hr-hdm-business");
        long messageId = RegMessageServiceHelper.sendMessageNotice(contentUrl, Collections.singletonList(askPerson), messageTemplateNumber, (long)ermanFileId, tag);
        resultMap.put("messageId", messageId);
        resultMap.put("detailId", detailId);
        return resultMap;
    }

    public static void updateOldAskDetails(Long employee, List<Long> askPersonIds, Long detailId) {
        QFilter filter = new QFilter("bemployee", "=", (Object)employee).and("askperson", "in", askPersonIds).and("isnewest", "=", (Object)Boolean.TRUE).and("id", "!=", (Object)detailId);
        DynamicObject[] objects = DETAILS_SERVICE_HELPER.query("isnewest", new QFilter[]{filter});
        if (objects.length > 0) {
            for (DynamicObject object : objects) {
                object.set("isnewest", (Object)Boolean.FALSE);
            }
            DETAILS_SERVICE_HELPER.update(objects);
        }
    }
}

