/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hdm.business.reg.domain.repository.database.RegExamResultRepository;
import kd.hr.hdm.business.reg.domain.repository.database.RegProcessRepository;
import kd.hr.hdm.common.reg.constants.RegActionConstants;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.utils.HpfsSetSysAndEnddateUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import kd.sdk.hr.hspm.common.result.PerChgSend;

public class RegNewHpfsServiceHelper {
    private static final Date END_DATA = DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD);
    private static final Log LOGGER = LogFactory.getLog(RegNewHpfsServiceHelper.class);
    private static final RegNewHpfsServiceHelper INSTANCE = new RegNewHpfsServiceHelper();
    private static final int CORE_THREAD = Runtime.getRuntime().availableProcessors();
    private static final int MAX_THREAD = CORE_THREAD * 5;
    private static final String APPID_HR = "hr";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"RegNewHpfsServiceHelper-Thread", (int)CORE_THREAD, (int)MAX_THREAD, (String)"hr");

    public static RegNewHpfsServiceHelper getInstance() {
        return INSTANCE;
    }

    public void regNewHpfsChgAsync(Long erManFileId) {
        THREAD_POOL.execute(() -> {
            LOGGER.info("regNewHpfsChgAsync execute start");
            this.regNewHpfsChg(erManFileId);
        });
    }

    public void regNewHpfsChg(Long erManFileId) {
        Map ermanfile = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{erManFileId});
        Long employeeId = (Long)ermanfile.get("employee_id");
        QFilter bemployeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        DynamicObject regprocess = RegProcessRepository.getInstance().queryOriginalOne("bemployee, trialperiodrst.id, examstatus,askstatus,regstatus", bemployeeFilter);
        DynamicObject regexamresult = RegExamResultRepository.getInstance().queryOriginalOne("bemployee, examscore", bemployeeFilter);
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)"1");
        DynamicObject trialperiod = RepositoryUtils.queryDynamicObject((String)"hrpi_trialperiod", null, (QFilter[])new QFilter[]{iscurrentversionFilter, employeeFilter, dataStatusFilter});
        DynamicObject trialperiodrst = RepositoryUtils.queryDynamicObject((String)"hrpi_trialperiodrst", null, (QFilter[])new QFilter[]{iscurrentversionFilter, employeeFilter, dataStatusFilter});
        Date date = new Date();
        BigDecimal examscore = regexamresult == null ? new BigDecimal(0) : regexamresult.getBigDecimal("examscore");
        DynamicObject newTrialperiod = this.getNewTrialperiod(trialperiod, regprocess, examscore, date);
        DynamicObjectCollection trialperiods = new DynamicObjectCollection();
        trialperiods.add((Object)newTrialperiod);
        DynamicObject newTrialperiodrst = this.getNewTrialperiodrst(trialperiodrst, regprocess, date);
        DynamicObjectCollection trialperiodrsts = new DynamicObjectCollection();
        trialperiodrsts.add((Object)newTrialperiodrst);
        Map<String, Object> personParam = this.buildDatasByCollection(trialperiods, trialperiodrsts);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{personParam});
        LOGGER.info("Reg saveBatchPersonAttach result:{}", (Object)result);
        this.recordHPFSChgBySendMsg(ermanfile, trialperiod, newTrialperiod, trialperiodrst, newTrialperiodrst);
    }

    private void recordHPFSChgBySendMsg(Map<String, Object> ermanfile, DynamicObject trialperiod, DynamicObject newTrialperiod, DynamicObject trialperiodrst, DynamicObject newTrialperiodrst) {
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        long now = System.currentTimeMillis();
        requestParam.put("personId", (Long)ermanfile.get("person_id"));
        requestParam.put("employeeId", (Long)ermanfile.get("employee_id"));
        requestParam.put("cmpEmpId", (Long)ermanfile.get("cmpemp_id"));
        requestParam.put("depEmpId", (Long)ermanfile.get("depemp_id"));
        requestParam.put("actionId", RegActionConstants.REG_HALF_ACTION_ID_NEW);
        requestParam.put("billNo", (String)ermanfile.get("number") + now);
        requestParam.put("billSource", "hdm_regprocess" + now);
        requestParam.put("bsed", now);
        ArrayList<HashMap<String, List<Map<String, Object>>>> dataRowList = new ArrayList<HashMap<String, List<Map<String, Object>>>>();
        HashMap<String, List<Map<String, Object>>> dataRowMap = new HashMap<String, List<Map<String, Object>>>();
        this.getDataRow("hrpi_trialperiod", trialperiod, newTrialperiod, dataRowMap);
        this.getDataRow("hrpi_trialperiodrst", trialperiodrst, newTrialperiodrst, dataRowMap);
        dataRowList.add(dataRowMap);
        requestParam.put("dataRow", dataRowList);
        String msg = SerializationUtils.toJsonString(requestParam);
        PerChgSend.sendMsg((String)msg);
    }

    private void getDataRow(String entityName, DynamicObject oldDy, DynamicObject newDy, Map<String, List<Map<String, Object>>> dataRowMap) {
        HashMap<String, Object> dataRowEntityMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> dataRowEntityMapList = new ArrayList<HashMap<String, Object>>();
        dataRowEntityMap.put("idBefore", oldDy.getLong("boid"));
        dataRowEntityMap.put("vidBefore", oldDy.getLong("id"));
        dataRowEntityMap.put("idAfter", newDy.getLong("boid"));
        dataRowEntityMap.put("vidAfter", newDy.getLong("id"));
        dataRowEntityMap.put("flowType", ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType());
        dataRowEntityMap.put("chgMode", ChgModeEnum.MODIFY.getChgMode());
        dataRowEntityMapList.add(dataRowEntityMap);
        dataRowMap.put(entityName, dataRowEntityMapList);
    }

    public static void savePersonsAndRecordHpfsChg(List<PerChgBizInfoNew> perChgBizInfoNews, String[] entityNumbers) {
        HpfsSetSysAndEnddateUtils.setSysDateAndEnddate(perChgBizInfoNews);
        long now = System.currentTimeMillis();
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            try {
                Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{perChgBizInfoNew.getPersonParams()});
                LOGGER.info("saveBatchPersonAttach result:{}", (Object)result);
                Map delPersonParams = perChgBizInfoNew.getDelPersonParams();
                if (delPersonParams != null && delPersonParams.size() > 0) {
                    Object deleteBatchResult = HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonGenericService", (String)"deleteBatch", (Object[])new Object[]{delPersonParams});
                    LOGGER.info("deleteBatchResult:{}", deleteBatchResult);
                }
                RegNewHpfsServiceHelper.recordHpfsChg(perChgBizInfoNew, now, entityNumbers);
            }
            catch (Exception e) {
                LOGGER.error("saveBatchPersonAttach error, billid is:{}", (Object)perChgBizInfoNew.getBillId(), (Object)e);
            }
        });
    }

    private static void recordHpfsChg(PerChgBizInfoNew perChgBizInfoNew, long now, String[] entityNumbers) {
        DynamicObject bill = perChgBizInfoNew.getDy();
        Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("personId", bill.getLong("ermanfile.person.id"));
        requestParam.put("employeeId", bill.getLong("ermanfile.employee.id"));
        requestParam.put("cmpEmpId", bill.getLong("ermanfile.cmpemp.id"));
        requestParam.put("depEmpId", bill.getLong("ermanfile.depemp.id"));
        requestParam.put("actionId", perChgBizInfoNew.getChgActionId());
        requestParam.put("billNo", bill.getString("billno"));
        requestParam.put("billSource", "hdm_regbasebill");
        requestParam.put("bsed", now);
        ArrayList dataRowList = new ArrayList();
        HashMap dataRowMap = new HashMap();
        Arrays.stream(entityNumbers).forEach(entityNumber -> {
            ArrayList dataRowEntityMapList = new ArrayList();
            List chgRecordEntryDtos = (List)entityRecordMap.get(entityNumber);
            chgRecordEntryDtos.forEach(chgRecordEntryDto -> {
                HashMap<String, Object> dataRowEntityMap = new HashMap<String, Object>(16);
                dataRowEntityMap.put("idBefore", chgRecordEntryDto.getIdBefore());
                dataRowEntityMap.put("vidBefore", chgRecordEntryDto.getVidBefore());
                dataRowEntityMap.put("idAfter", chgRecordEntryDto.getIdAfter());
                dataRowEntityMap.put("vidAfter", chgRecordEntryDto.getVidAfter());
                dataRowEntityMap.put("flowType", chgRecordEntryDto.getFlowType());
                dataRowEntityMap.put("chgMode", chgRecordEntryDto.getChgMode());
                dataRowEntityMapList.add(dataRowEntityMap);
            });
            dataRowMap.put(entityNumber, dataRowEntityMapList);
        });
        dataRowList.add(dataRowMap);
        requestParam.put("dataRow", dataRowList);
        String msg = SerializationUtils.toJsonString(requestParam);
        PerChgSend.sendMsg((String)msg);
    }

    private DynamicObject getNewTrialperiodrst(DynamicObject trialperiodrst, DynamicObject regprocess, Date date) {
        MainEntityType trialperiodrstType = EntityMetadataCache.getDataEntityType((String)"hrpi_trialperiodrst");
        DynamicObject newTrialperiodrst = (DynamicObject)trialperiodrstType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)trialperiodrst, (DynamicObject)newTrialperiodrst);
        long id = ORM.create().genLongId("hrpi_trialperiodrst");
        newTrialperiodrst.set("id", (Object)id);
        newTrialperiodrst.set("probationrst", regprocess == null ? null : Long.valueOf(regprocess.getLong("trialperiodrst.id")));
        newTrialperiodrst.set("bsed", (Object)date);
        newTrialperiodrst.set("bsled", (Object)END_DATA);
        return newTrialperiodrst;
    }

    private DynamicObject getNewTrialperiod(DynamicObject trialperiod, DynamicObject regprocess, BigDecimal examscore, Date date) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_trialperiod");
        DynamicObject newHisDy = (DynamicObject)dataEntityType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)trialperiod, (DynamicObject)newHisDy);
        long id = ORM.create().genLongId("hrpi_trialperiod");
        newHisDy.set("id", (Object)id);
        newHisDy.set("trialperiodrst", (Object)regprocess.getLong("trialperiodrst.id"));
        newHisDy.set("examstatus", (Object)regprocess.getString("examstatus"));
        newHisDy.set("askstatus", (Object)regprocess.getString("askstatus"));
        newHisDy.set("regstatus", (Object)regprocess.getString("regstatus"));
        newHisDy.set("examscore", (Object)examscore);
        newHisDy.set("bsed", (Object)date);
        newHisDy.set("bsled", (Object)END_DATA);
        return newHisDy;
    }

    private Map<String, Object> buildDatasByCollection(DynamicObjectCollection ... collections) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)collections.length);
        for (DynamicObjectCollection collection : collections) {
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("hisDyns", collection);
            datas.add(item);
        }
        paramMap.put("data", datas);
        paramMap.put("caller", "hpfs");
        paramMap.put("mustAllSuccess", Boolean.TRUE);
        Long eventId = ORM.create().genLongId("hrpi_event");
        paramMap.put("eventId", eventId);
        return paramMap;
    }
}

