/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hdm.business.domain.transfer.service.invoke.InvokeHandler;
import kd.hr.hdm.business.domain.transfer.service.invoke.InvokeParam;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.constants.RegActionConstants;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;

public class PersonAboutServiceImpl
implements IPersonAboutService {
    private static final Log LOGGER = LogFactory.getLog(PersonAboutServiceImpl.class);
    private static final String QUIT_BUSINESS = "1020";
    private static final String QUIT_BUSINESS_NEW = "201020";
    private static final String BILLNO = "billNo";
    private static final String ACTIONNAME = "actionName";
    private static final String CROSSVALIDRES = "crossValidRes";
    private static final String SUGGEST = "0";
    private static final String FORBID = "1";
    private static final String CROSSVALIDNOTI = "crossValidNoti";
    private static final String WARNING = "2";
    private static final String ERROR = "3";
    private static final String HRPI_TRIALPERIOD = "hrpi_trialperiod";

    @Override
    public Map<String, Object> buildPersonChangeParams(DynamicObject erManFile) {
        List<Long> argsForInterface = Collections.singletonList(erManFile.getLong("id"));
        List<Map<String, Object>> listMaps = this.batchBuildPersonChangeParams(argsForInterface);
        if (HRCollUtil.isEmpty(listMaps)) {
            return null;
        }
        return listMaps.get(0);
    }

    @Override
    public List<Map<String, Object>> batchBuildPersonChangeParams(List<Long> erManFileIds) {
        if (HRCollUtil.isEmpty(erManFileIds)) {
            return Collections.emptyList();
        }
        return (List)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIds});
    }

    @Override
    public Map<String, Object> buildRegInfo(DynamicObject erManFile) {
        List<Map<String, Object>> listMaps = this.batchBuildRegInfo(Collections.singletonList(erManFile.getLong("employee.id")));
        if (HRCollUtil.isEmpty(listMaps)) {
            return null;
        }
        return listMaps.get(0);
    }

    @Override
    public List<Map<String, Object>> batchBuildRegInfo(List<Long> employeeIds) {
        if (HRCollUtil.isEmpty(employeeIds)) {
            return Collections.emptyList();
        }
        return (List)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchEmployeeAttachs", (Object[])new Object[]{employeeIds, null, HRPI_TRIALPERIOD});
    }

    @Override
    public List<Long> buildTrailsPKs(Long employeeId, String entityName) {
        QFilter filterId = new QFilter("employee", "=", (Object)employeeId);
        QFilter filterVersion = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)Character.valueOf('1'));
        DynamicObject[] ids = new HRBaseServiceHelper(entityName).query("id", new QFilter[]{filterId, filterVersion, dataStatusFilter});
        return Arrays.stream(ids).map(temp -> temp.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public Map<Long, DynamicObject> queryStatusOfAlreadyReg(List<Long> actionIdList) {
        Map map = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgRuleByActionIds", (Object[])new Object[]{actionIdList});
        try {
            boolean success = (Boolean)map.get("success");
            Object errorMsg = map.get("errorMsg");
            if (!success || errorMsg != null) {
                throw new KDBizException("method getChgRuleByActionIds error");
            }
            Map dataMap = (Map)map.get("data");
            HashMap<Long, DynamicObject> laborrelStatusMap = new HashMap<Long, DynamicObject>(16);
            dataMap.forEach((k, list) -> {
                DynamicObjectCollection beforeLaborrelStatusCollection = (DynamicObjectCollection)((Map)list.get(0)).get("beforelaborrelstatus");
                DynamicObject beforeLaborrelStatus = (DynamicObject)beforeLaborrelStatusCollection.get(0);
                laborrelStatusMap.put((Long)k, beforeLaborrelStatus);
            });
            return laborrelStatusMap;
        }
        catch (KDBizException e) {
            LOGGER.error("method getChgRuleByActionIds result: {}", (Object)map.toString());
            throw new KDBizException("method getChgRuleByActionIds error");
        }
    }

    @Override
    public Map<Long, List<DynamicObject>> queryLaborrelstatusStatusByNewAffactions(List<Long> actionIdList) {
        LOGGER.info("getNewChgRuleByActionIds actionIdList: {}", actionIdList);
        HashMap<Long, List<DynamicObject>> laborrelstatusMap = new HashMap<Long, List<DynamicObject>>();
        Map result = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSNewChgService", (String)"getNewChgRuleByActionIds", (Object[])new Object[]{actionIdList});
        LOGGER.info("getNewChgRuleByActionIds result: {}", (Object)result);
        if (!((Boolean)result.get("success")).booleanValue()) {
            return laborrelstatusMap;
        }
        Map data = (Map)result.get("data");
        actionIdList.forEach(affactionId -> {
            DynamicObjectCollection laborrelstatusDys = (DynamicObjectCollection)((Map)data.get(affactionId)).get("laborrelstatus");
            List laborrelstatusIds = laborrelstatusDys.stream().collect(Collectors.toList());
            if (laborrelstatusIds != null && !laborrelstatusIds.isEmpty()) {
                laborrelstatusMap.put((Long)affactionId, laborrelstatusIds);
            }
        });
        return laborrelstatusMap;
    }

    @Override
    public Map<Long, List<DynamicObject>> queryLaborrelstatusStatusByOldAffactions(List<Long> actionIdList) {
        LOGGER.info("queryLaborrelstatusStatusByOldAffactions actionIdList: {}", actionIdList);
        HashMap<Long, List<DynamicObject>> laborrelstatusMap = new HashMap<Long, List<DynamicObject>>();
        Map result = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgRuleByActionIds", (Object[])new Object[]{actionIdList});
        LOGGER.info("getChgRuleByActionIds result: {}", (Object)result);
        if (!((Boolean)result.get("success")).booleanValue()) {
            return laborrelstatusMap;
        }
        Map data = (Map)result.get("data");
        actionIdList.forEach(affactionId -> {
            List laborrelstatusList = (List)data.get(affactionId);
            DynamicObjectCollection laborrelstatusDys = (DynamicObjectCollection)((Map)laborrelstatusList.get(0)).get("beforelaborrelstatus");
            List laborrelstatusIds = laborrelstatusDys.stream().collect(Collectors.toList());
            if (laborrelstatusIds != null && !laborrelstatusIds.isEmpty()) {
                laborrelstatusMap.put((Long)affactionId, laborrelstatusIds);
            }
        });
        return laborrelstatusMap;
    }

    @Override
    public boolean doPersonCrossValidate(DynamicObject billObj, Map<String, List<String>> errorMap, Boolean tipsWithBillNo) {
        Map<String, Object> argParamsIn = this.buildRequestParams(billObj);
        Map perChgResult = (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"crossValidate", (Object[])new Object[]{argParamsIn});
        AtomicBoolean flag = new AtomicBoolean(false);
        if (!((Boolean)perChgResult.get("success")).booleanValue()) {
            LOGGER.error("hpfs execute failed : " + perChgResult.get("errorMsg"));
            return flag.get();
        }
        List data = (List)perChgResult.get("data");
        return this.executeDataMap(errorMap, billObj, tipsWithBillNo, flag, data);
    }

    @Override
    public boolean doPersonCrossValidateForBatch(DynamicObject billObj, Map<String, List<String>> errorMap, List<Map<String, Object>> maps, Boolean tipsWithBillNo) {
        return this.executeDataMap(errorMap, billObj, tipsWithBillNo, new AtomicBoolean(false), maps);
    }

    @Override
    public boolean doPersonCrossValidateForBatch(DynamicObject billObj, Map<String, List<String>> errorMap, List<Map<String, Object>> maps) {
        return this.doPersonCrossValidateForBatch(billObj, errorMap, maps, Boolean.TRUE);
    }

    @Override
    public boolean isExistQuiting(DynamicObject erManFile) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("actionId", RegActionConstants.REG_ACTION_ID);
        Long employeeId = erManFile.getLong("employee_id");
        params.put("personId", erManFile.getString("person_id"));
        params.put("employeeId", erManFile.getString("employee_id"));
        params.put("managingScopeId", erManFile.getString("cmpemp_id"));
        params.put("depEmpId", erManFile.getString("depemp_id"));
        List trialPeriodList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, HRPI_TRIALPERIOD});
        Map trialPeriod = (Map)trialPeriodList.get(0);
        Date effectDate = (Date)trialPeriod.get("preregulardate");
        params.put("effectTime", effectDate.getTime());
        Map perChgResult = (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"crossValidate", (Object[])new Object[]{params});
        List data = (List)perChgResult.get("data");
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)data)) {
            List filterData = data.stream().filter(item -> {
                String actionId = (String)item.get("actionId");
                String result = (String)item.get(CROSSVALIDRES);
                return StringUtils.equals((CharSequence)actionId, (CharSequence)QUIT_BUSINESS) && StringUtils.equals((CharSequence)FORBID, (CharSequence)result);
            }).collect(Collectors.toList());
            return org.apache.commons.collections4.CollectionUtils.isNotEmpty(filterData);
        }
        return false;
    }

    @Override
    public void doUpdatePersonCrossData(DynamicObject billObj, String opType) {
        String params = this.buildMQParams(billObj, opType);
        this.sendMQ(params);
    }

    private String buildMQParams(DynamicObject billObj, String opType) {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("operation", opType);
        reqMap.put("actionId", billObj.getLong("affaction.id"));
        reqMap.put("personId", billObj.getString("person.id"));
        reqMap.put("employeeId", billObj.getString("bemployee.id"));
        Map erManFileMap = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{billObj.getLong("ermanfile.id")});
        reqMap.put("managingScopeId", String.valueOf(erManFileMap.get("cmpemp_id")));
        reqMap.put("depEmpId", String.valueOf(erManFileMap.get("depemp_id")));
        reqMap.put("billId", String.valueOf(billObj.getPkValue()));
        reqMap.put(BILLNO, billObj.getString("billno"));
        reqMap.put("appId", "hdm");
        reqMap.put("billSource", "hdm_regbasebill");
        Date effectDate = billObj.getDate("effectdate");
        Date preActDate = billObj.getDate("preactualdate");
        reqMap.put("bsed", null != effectDate ? effectDate.getTime() : preActDate.getTime());
        return JSONObject.toJSONString(reqMap);
    }

    private void sendMQ(String params) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_chgrecord_queue");){
            pub.publish(params);
        }
    }

    @Override
    public void doUpdatePersonCrossData(DynamicObject[] billObj, String opType) {
        Arrays.stream(billObj).forEach(temp -> this.doUpdatePersonCrossData((DynamicObject)temp, opType));
    }

    @Override
    public void doUpdatePersonCrossData(List<DynamicObject> billObj, String opType) {
        billObj.forEach(temp -> this.doUpdatePersonCrossData((DynamicObject)temp, opType));
    }

    @Override
    public boolean doValidatePersonQuitAlready(DynamicObject billObj, Map<String, List<String>> errorMap, Boolean tipsWithBillNo) {
        long empId = billObj.getLong("bemployee.id");
        Map<Long, DynamicObject> labStatusByEmpId = this.getLabStatusByEmpId(Collections.singletonList(empId));
        return this.validateLabStatus(billObj, errorMap, labStatusByEmpId.get(empId), tipsWithBillNo);
    }

    @Override
    public Map<Long, DynamicObject> getLabStatusByEmpId(List<Long> empIds) {
        Map empIdsWithLabStatus = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployeeStatus", (Object[])new Object[]{empIds});
        if (CollectionUtils.isEmpty((Map)empIdsWithLabStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonAboutServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        return empIdsWithLabStatus;
    }

    @Override
    public boolean validateLabStatus(DynamicObject billObj, Map<String, List<String>> errorMap, DynamicObject labStatus, Boolean tipsWithBillNo) {
        Long labStatusClsId = (Long)labStatus.get("labrelstatuscls_id");
        if (!LabRelConstants.PROBATION.equals(labStatusClsId)) {
            List<String> errorMsgList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
            String errorMsg = tipsWithBillNo != false ? String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u5458\u5de5%2$s\uff0c\u5bfc\u81f4\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"PersonAboutServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]), this.getBillno(billObj), labStatus.getString("name")) : String.format(ResManager.loadKDString((String)"\u8be5\u5458\u5de5%1$s\uff0c\u5bfc\u81f4\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"PersonAboutServiceImpl_8", (String)"hr-hdm-business", (Object[])new Object[0]), labStatus.getString("name"));
            if (RegBillTypeEnum.EMP.getStatus().equals(billObj.getString("regbilltype"))) {
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5bfc\u81f4\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"PersonAboutServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[0]), labStatus.getString("name"));
            }
            errorMsgList.add(errorMsg);
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), errorMsgList);
            return true;
        }
        return false;
    }

    @Override
    public void syncHPFSAfterTerminate(DynamicObject billObj) {
        try {
            this.doUpdatePersonCrossData(billObj, "1040");
            IRegEffectService.getInstance().updateReg(billObj);
        }
        catch (Exception exception) {
            LOGGER.error("syncHPFSAfterTerminate occur exception : " + exception);
        }
    }

    @Override
    public List<Map<String, Object>> getQuitEffectTime(List<Long> erManFiles) {
        return (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFiles});
    }

    @Override
    public List<Long> getIdsOfQuitAlready(Map<Long, DynamicObject> labStatusByEmpId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Map.Entry<Long, DynamicObject> entry : labStatusByEmpId.entrySet()) {
            Long key = entry.getKey();
            DynamicObject value = entry.getValue();
            Long labStatusClsId = (Long)value.get("labrelstatuscls_id");
            if (!LabRelConstants.QUIT.equals(labStatusClsId)) continue;
            list.add(key);
        }
        return list;
    }

    @Override
    public Map<String, Object> doPersonCrossValidateBatch(List<DynamicObject> dynamicObjects) {
        LOGGER.info("==doPersonCrossValidateBatch start===");
        long startTime = System.currentTimeMillis();
        List<Map<String, Object>> params = this.buildRequestParams(dynamicObjects);
        LOGGER.info("PersonAboutServiceImpl.doPersonCrossValidateBatch build params,cost {}", (Object)(System.currentTimeMillis() - startTime));
        LOGGER.info("==doPersonCrossValidateBatch start===");
        return (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"crossValidateBatch", (Object[])new Object[]{params});
    }

    @Override
    public Map<String, Object> doPersonCrossValidateBatchForRegAppImport(List<DynamicObject> dynamicObjects) {
        ArrayList params = new ArrayList(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
            DynamicObject erManFile = dynamicObject.getDynamicObject("ermanfile");
            paramsMap.put("actionId", dynamicObject.getString("affaction.id"));
            paramsMap.put("effectTime", this.getBusinessEffectTime(dynamicObject));
            paramsMap.put("personId", String.valueOf(erManFile.get("person_id")));
            paramsMap.put("employeeId", String.valueOf(erManFile.get("employee_id")));
            paramsMap.put("managingScopeId", String.valueOf(erManFile.get("cmpemp_id")));
            paramsMap.put("depEmpId", String.valueOf(erManFile.get("depemp_id")));
            params.add(paramsMap);
        }
        return (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"crossValidateBatch", (Object[])new Object[]{params});
    }

    private boolean executeDataMap(Map<String, List<String>> errorMap, DynamicObject billObj, Boolean tipsWithBillNo, AtomicBoolean flag, List<Map<String, Object>> data) {
        org.apache.commons.collections4.CollectionUtils.emptyIfNull(data).forEach(validateResult -> {
            String actionId;
            switch (actionId = (String)validateResult.get("actionId")) {
                case "1020": 
                case "201020": {
                    flag.set(this.dealQuitCrossValidate(errorMap, (Map<String, Object>)validateResult, billObj, tipsWithBillNo));
                    break;
                }
                default: {
                    flag.set(this.dealWithOtherCrossValidate(errorMap, (Map<String, Object>)validateResult, billObj, tipsWithBillNo));
                }
            }
        });
        return flag.get();
    }

    private boolean dealWithOtherCrossValidate(Map<String, List<String>> returnMap, Map<String, Object> validateResult, DynamicObject billObj, Boolean tipsWithBillNo) {
        String msg_02;
        String msg_13;
        String billNo = (String)validateResult.get(BILLNO);
        String actionName = (String)validateResult.get(ACTIONNAME);
        if (tipsWithBillNo.booleanValue()) {
            msg_13 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u68c0\u6d4b\u5230\u201c%2$s\u201d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u201c%3$s\u201d\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%4$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u8f6c\u6b63\u3002", (String)"PersonAboutServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]), this.getBillno(billObj), billObj.getString("ermanfile.name"), actionName, billNo);
            msg_02 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u68c0\u6d4b\u5230\u201c%2$s\u201d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u201c%3$s\u201d\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%4$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"PersonAboutServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0]), this.getBillno(billObj), billObj.getString("ermanfile.name"), actionName, billNo);
        } else {
            msg_13 = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u201c%2$s\u201d\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u8f6c\u6b63\u3002", (String)"PersonAboutServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]), billObj.getString("ermanfile.name"), actionName, billNo);
            msg_02 = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u201c%2$s\u201d\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"PersonAboutServiceImpl_14", (String)"hr-hdm-business", (Object[])new Object[0]), billObj.getString("ermanfile.name"), actionName, billNo);
        }
        return this.createCommonMsg(returnMap, validateResult, msg_02, msg_13);
    }

    private boolean dealQuitCrossValidate(Map<String, List<String>> returnMap, Map<String, Object> validateResult, DynamicObject billObj, Boolean tipsWithBillNo) {
        String msg_02;
        String msg_13;
        String billNoOfQuit = (String)validateResult.get(BILLNO);
        if (tipsWithBillNo.booleanValue()) {
            msg_13 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u68c0\u6d4b\u5230\u201c%2$s\u201d\u5728\u8bd5\u7528\u671f\u5185\u5df2\u53d1\u751f\u79bb\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u8f6c\u6b63\u3002", (String)"PersonAboutServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]), this.getBillno(billObj), billObj.getString("ermanfile.name"), billNoOfQuit);
            msg_02 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u68c0\u6d4b\u5230\u201c%2$s\u201d\u5728\u8bd5\u7528\u671f\u95f4\u5916\u5df2\u53d1\u751f\u79bb\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"PersonAboutServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]), this.getBillno(billObj), billObj.getString("ermanfile.name"), billNoOfQuit);
        } else {
            msg_13 = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5728\u8bd5\u7528\u671f\u5185\u5df2\u53d1\u751f\u79bb\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u8f6c\u6b63\u3002", (String)"PersonAboutServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]), billObj.getString("ermanfile.name"), billNoOfQuit);
            msg_02 = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5728\u8bd5\u7528\u671f\u95f4\u5916\u5df2\u53d1\u751f\u79bb\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"PersonAboutServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[0]), billObj.getString("ermanfile.name"), billNoOfQuit);
        }
        return this.createCommonMsg(returnMap, validateResult, msg_02, msg_13);
    }

    private boolean createCommonMsg(Map<String, List<String>> returnMap, Map<String, Object> validateResult, String msg0, String msg1) {
        boolean flag = false;
        String crossValidateRes = (String)validateResult.get(CROSSVALIDRES);
        String crossValidNot = (String)validateResult.get(CROSSVALIDNOTI);
        if (StringUtils.isEmpty((CharSequence)crossValidateRes) || StringUtils.isEmpty((CharSequence)crossValidNot)) {
            LOGGER.error("kd.hr.hdm.business.reg.domain.service.impl.bill.PersonAboutServiceImpl.createCommonMsg hpfs return the wrong msg : " + JSONObject.toJSONString(validateResult));
            return false;
        }
        List<String> warningMsgList = returnMap.get(RegBillServiceEnum.WARNING.getCode());
        List<String> errorMsgList = returnMap.get(RegBillServiceEnum.ERROR.getCode());
        if (SUGGEST.equals(crossValidateRes)) {
            if (WARNING.equals(crossValidNot)) {
                warningMsgList.add(msg0);
            } else if (ERROR.equals(crossValidNot)) {
                LOGGER.error("invalidate code of hpfs , kd.hr.hdm.business.reg.domain.service.impl.bill.PersonAboutServiceImpl.executeReturnMap");
            }
        } else if (FORBID.equals(crossValidateRes)) {
            if (WARNING.equals(crossValidNot)) {
                LOGGER.error("invalidate code of hpfs , kd.hr.hdm.business.reg.domain.service.impl.bill.PersonAboutServiceImpl.executeReturnMap");
            } else if (ERROR.equals(crossValidNot)) {
                errorMsgList.add(msg1);
                flag = true;
            }
        }
        returnMap.put(RegBillServiceEnum.WARNING.getCode(), warningMsgList);
        returnMap.put(RegBillServiceEnum.ERROR.getCode(), errorMsgList);
        return flag;
    }

    private Map<String, Object> buildRequestParams(DynamicObject billObj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("actionId", billObj.getString("affaction.id"));
        params.put("effectTime", this.getBusinessEffectTime(billObj));
        Map erManFileMap = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{billObj.getLong("ermanfile.id")});
        params.put("personId", String.valueOf(erManFileMap.get("person_id")));
        params.put("employeeId", String.valueOf(erManFileMap.get("employee_id")));
        params.put("managingScopeId", String.valueOf(erManFileMap.get("cmpemp_id")));
        params.put("depEmpId", String.valueOf(erManFileMap.get("depemp_id")));
        return params;
    }

    private List<Map<String, Object>> buildRequestParams(List<DynamicObject> dynamicObjects) {
        List ids = dynamicObjects.stream().map(item -> item.get("ermanfile.id")).collect(Collectors.toList());
        DynamicObject[] dys = (DynamicObject[])InvokeHandler.getInstance().invokeService(new InvokeParam("hr", "hspm", "IHSPMService", "listErManFilesByPkIds"), ids);
        Map<Long, DynamicObject> ermanfileMap = Arrays.stream(dys).collect(Collectors.toMap(item -> item.getLong("id"), item -> item));
        return dynamicObjects.stream().map(item -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("actionId", item.getString("affaction.id"));
            params.put("effectTime", this.getBusinessEffectTime((DynamicObject)item));
            DynamicObject dy = (DynamicObject)ermanfileMap.get(item.get("ermanfile.id"));
            params.put("personId", String.valueOf(dy.get("person.id")));
            params.put("employeeId", String.valueOf(dy.get("employee.id")));
            params.put("managingScopeId", String.valueOf(dy.get("cmpemp.id")));
            params.put("depEmpId", String.valueOf(dy.get("depemp.id")));
            return params;
        }).collect(Collectors.toList());
    }

    private long getBusinessEffectTime(DynamicObject billObj) {
        if (ObjectUtils.isEmpty((Object)billObj)) {
            return 0L;
        }
        return ObjectUtils.isEmpty((Object)billObj.getDate("effectdate")) ? billObj.getDate("preactualdate").getTime() : billObj.getDate("effectdate").getTime();
    }

    private String getBillno(DynamicObject regbill) {
        String thisBillNo = "entryentity".equals(regbill.getDynamicObjectType().toString()) ? regbill.getString("ebillno") : regbill.getString("billno");
        return thisBillNo;
    }

    @Override
    public DynamicObject[] queryTrialPeriodByEmployeeId(List<Long> employeeIds) {
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds);
        this.setDefaultFilter(employeeFilter);
        return RepositoryUtils.queryDynamicObjects((String)HRPI_TRIALPERIOD, null, (QFilter[])new QFilter[]{employeeFilter});
    }

    @Override
    public DynamicObject[] queryTrialPeriodRstByEmployeeId(List<Long> employeeIds) {
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds);
        this.setDefaultFilter(employeeFilter);
        return RepositoryUtils.queryDynamicObjects((String)"hrpi_trialperiodrst", null, (QFilter[])new QFilter[]{employeeFilter});
    }

    private void setDefaultFilter(QFilter qFilter) {
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)FORBID)).and(new QFilter("datastatus", "=", (Object)FORBID)).and(new QFilter("businessstatus", "=", (Object)FORBID));
    }

    @Override
    public void reviseVersionBatch(List<DynamicObject> dynamicObjects) {
        ArrayList datas = new ArrayList();
        dynamicObjects.forEach(dy -> {
            HashMap<String, DynamicObjectCollection> personGenericDataEntityMap = new HashMap<String, DynamicObjectCollection>(16);
            DynamicObjectCollection hisDyns = new DynamicObjectCollection();
            hisDyns.add(dy);
            personGenericDataEntityMap.put("hisDyns", hisDyns);
            datas.add(personGenericDataEntityMap);
        });
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("data", datas);
        paramMap.put("caller", "hdm");
        paramMap.put("mustAllSuccess", true);
        LOGGER.info("IHRPIPersonGenericService reviseVersionBatch param:{}", paramMap);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"reviseVersionBatch", (Object[])new Object[]{paramMap});
        LOGGER.info("IHRPIPersonGenericService reviseVersionBatch result:{}", (Object)result);
    }

    @Override
    public void discardBatch(Map<String, List<Long>> map) {
        ArrayList datas = new ArrayList();
        map.forEach((entityNumber, idList) -> {
            HashMap<String, Object> dataEntityMap = new HashMap<String, Object>(16);
            dataEntityMap.put("entityNumber", entityNumber);
            dataEntityMap.put("boIdList", idList);
            datas.add(dataEntityMap);
        });
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("data", datas);
        paramMap.put("caller", "hdm");
        LOGGER.info("IHRPIPersonGenericService discardBatch param:{}", paramMap);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"discardBatch", (Object[])new Object[]{paramMap});
        LOGGER.info("IHRPIPersonGenericService discardBatch result:{}", (Object)result);
    }

    @Override
    public boolean validateErmanFile(DynamicObject bill, Map<String, List<String>> errorMap) {
        if (!RegBillStatusEnum.TEMPSTORAGE.getCode().equals(bill.getString("billstatus"))) {
            return false;
        }
        long personId = bill.getLong("person_id");
        long ermanFileId = bill.getLong("ermanfile_id");
        DynamicObject currentErmanFile = HRServiceUtil.getPrimaryErmanFile((Long)personId);
        List<String> errorMsgList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
        if (currentErmanFile == null || ermanFileId != currentErmanFile.getLong("id")) {
            errorMsgList.add(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u4efb\u804c\u4fe1\u606f\u5df2\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"PersonAboutServiceImpl_15", (String)"hr-hdm-business", (Object[])new Object[0]));
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), errorMsgList);
            return true;
        }
        return false;
    }
}

