/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.mq.sender.RegMQHelper;
import kd.hr.hdm.business.reg.RegEffectHPFSTemplateHandler;
import kd.hr.hdm.business.reg.RegWaitEffectHPFSTemplateHandler;
import kd.hr.hdm.business.reg.domain.repository.database.RegExamResultRepository;
import kd.hr.hdm.business.reg.domain.repository.database.RegProcessRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.common.reg.constants.RegActionConstants;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.hr.hpfs.business.perchg.bizentity.PerChgParam;

public class RegEffectServiceImpl
implements IRegEffectService {
    private static final Log LOGGER = LogFactory.getLog(RegEffectServiceImpl.class);
    private static final String HDM_REG_PERCHG_RESULT_QUEUE = "hdm_reg_perchg_result_queue";
    private static final String HPFS_PERCHG_QUEUE = "hpfs_perchg_queue";

    @Override
    public void effectReg(DynamicObject billObj) {
        if (billObj.getBoolean("affaction.isnewchgaction")) {
            RegEffectHPFSTemplateHandler.getInstance().saveHPFSEffectMessage(new DynamicObject[]{billObj});
        } else {
            this.effectRegOld(billObj);
        }
    }

    public void effectRegOld(DynamicObject billObj) {
        LOGGER.info("Starting to effect reg " + billObj.getString("id"));
        try {
            Long billId = billObj.getLong("id");
            PerChgParam perChgParam = new PerChgParam();
            perChgParam.setAppId("hdm");
            perChgParam.setUserId(Long.valueOf(1L));
            ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>();
            PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
            perChgBizInfo.setActionId(Long.valueOf(billObj.getLong("affaction.id")));
            perChgBizInfo.setBillId(billId);
            perChgBizInfo.setBillNo(billObj.getString("billno"));
            perChgBizInfo.setBillSource("hdm_regbasebill");
            perChgBizInfo.setOldPersonId(Long.valueOf(billObj.getLong("person.id")));
            perChgBizInfo.setOldEmployeeId(Long.valueOf(billObj.getLong("bemployee.id")));
            Map erManFile = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{billObj.getLong("ermanfile.id")});
            perChgBizInfo.setOldComempId((Long)erManFile.get("cmpemp_id"));
            perChgBizInfo.setOldDepempId((Long)erManFile.get("depemp_id"));
            perChgBizInfo.setBsed(billObj.getDate("effectdate"));
            HashMap<String, List<Long>> dataRow = new HashMap<String, List<Long>>();
            long employeeId = billObj.getLong("bemployee.id");
            List<Long> trialPeriodIds = IPersonAboutService.getInstance().buildTrailsPKs(employeeId, "hrpi_trialperiod");
            List<Long> trialPeriodRstIds = IPersonAboutService.getInstance().buildTrailsPKs(employeeId, "hrpi_trialperiodrst");
            dataRow.put("hrpi_trialperiod", trialPeriodIds);
            dataRow.put("hrpi_trialperiodrst", trialPeriodRstIds);
            dataRow.put("hdm_regbasebill", Collections.singletonList(billObj.getLong("id")));
            Long processId = RegProcessRepository.getInstance().queryPK(billObj.getLong("bemployee.id"));
            dataRow.put("hdm_regprocess", Collections.singletonList(processId));
            Long examId = RegExamResultRepository.getInstance().queryPK(employeeId);
            if (!ObjectUtils.isEmpty((Object)examId)) {
                dataRow.put("hdm_regexamresult", Collections.singletonList(examId));
            }
            perChgBizInfo.setDataRow(dataRow);
            bizInfoList.add(perChgBizInfo);
            perChgParam.setBizInfoList(bizInfoList);
            perChgParam.setResultCallBackQueue(HDM_REG_PERCHG_RESULT_QUEUE);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("operatetype", 1020);
            params.put("billdata", (Integer)perChgParam);
            LOGGER.info(String.format("send to perchg:%s", JSONObject.toJSONString(params)));
            this.sendMQMessage(JSONObject.toJSONString(params));
        }
        catch (KDException exception) {
            LOGGER.error(exception.getMessage());
        }
        LOGGER.info("The bill id " + billObj.getString("id") + " have sent MQ_message to personChange ");
    }

    private void sendMQMessage(String params) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", HPFS_PERCHG_QUEUE);){
            pub.publish(params);
        }
    }

    @Override
    public void effectReg(DynamicObject[] billObjs) {
        Arrays.stream(billObjs).forEach(this::effectReg);
    }

    @Override
    public void effectReg(List<DynamicObject> billObjs) {
        if (billObjs.get(0).getBoolean("affaction.isnewchgaction")) {
            RegEffectHPFSTemplateHandler.getInstance().saveHPFSEffectMessageAsync(billObjs.toArray(new DynamicObject[0]));
            return;
        }
        billObjs.forEach(this::effectReg);
    }

    @Override
    public void updateReg(DynamicObject[] billObjs) {
        if (billObjs == null || billObjs.length == 0) {
            return;
        }
        Arrays.stream(billObjs).forEach(this::updateReg);
    }

    @Override
    public void updateReg(List<DynamicObject> billObjs) {
        billObjs.forEach(this::updateReg);
    }

    @Override
    public void updateReg(DynamicObject billObj) {
        LOGGER.info("Starting to update reg  status" + billObj.getString("id"));
        try {
            RegMQHelper.getInstance().syncProcessStatus(billObj.getLong("ermanfile.id"), true, false);
        }
        catch (Exception e) {
            LOGGER.error("syncProcessStatus error", (Throwable)e);
        }
        LOGGER.info("The bill id " + billObj.getString("id") + " have sent MQ_message to personChange ");
    }

    @Override
    public void delayReg(DynamicObject[] billObjs) {
        Arrays.stream(billObjs).forEach(this::delayReg);
    }

    @Override
    public void delayReg(List<DynamicObject> billObjs) {
        if (billObjs == null || billObjs.size() == 0) {
            return;
        }
        if (billObjs.get(0).getBoolean("affaction.isnewchgaction")) {
            RegWaitEffectHPFSTemplateHandler.getInstance().saveHPFSEffectMessageAsync(billObjs.toArray(new DynamicObject[0]));
            return;
        }
        billObjs.forEach(this::delayReg);
    }

    @Override
    public void delayReg(DynamicObject billObj) {
        if (billObj.getBoolean("affaction.isnewchgaction")) {
            RegWaitEffectHPFSTemplateHandler.getInstance().saveHPFSEffectMessage(new DynamicObject[]{billObj});
            return;
        }
        LOGGER.info("Starting to delay reg " + billObj.getString("id"));
        try {
            Long billId = billObj.getLong("id");
            PerChgParam perChgParam = new PerChgParam();
            perChgParam.setAppId("hdm");
            perChgParam.setUserId(Long.valueOf(1L));
            ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>();
            PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
            perChgBizInfo.setActionId(RegActionConstants.REG_DELAY_ACTION_ID);
            perChgBizInfo.setBillId(billId);
            perChgBizInfo.setBillNo(billObj.getString("billno"));
            perChgBizInfo.setBillSource("hdm_regbasebill");
            perChgBizInfo.setOldPersonId(Long.valueOf(billObj.getLong("person.id")));
            perChgBizInfo.setOldEmployeeId(Long.valueOf(billObj.getLong("bemployee.id")));
            Map erManFile = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{billObj.getLong("ermanfile.id")});
            perChgBizInfo.setOldComempId((Long)erManFile.get("cmpemp_id"));
            perChgBizInfo.setOldDepempId((Long)erManFile.get("depemp_id"));
            perChgBizInfo.setBsed(new Date());
            HashMap<String, List<Long>> dataRow = new HashMap<String, List<Long>>(1);
            List<Long> empTrials = IPersonAboutService.getInstance().buildTrailsPKs(billObj.getLong("bemployee.id"), "hrpi_trialperiod");
            dataRow.put("hrpi_trialperiod", empTrials);
            dataRow.put("hdm_regbasebill", Collections.singletonList(billObj.getLong("id")));
            perChgBizInfo.setDataRow(dataRow);
            bizInfoList.add(perChgBizInfo);
            perChgParam.setBizInfoList(bizInfoList);
            HashMap<String, Integer> params = new HashMap<String, Integer>(2);
            params.put("operatetype", 1020);
            params.put("billdata", (Integer)perChgParam);
            LOGGER.info(String.format("send to perchg:%s", JSONObject.toJSONString(params)));
            this.sendMQMessage(JSONObject.toJSONString(params));
        }
        catch (KDException exception) {
            LOGGER.error(exception.getMessage());
        }
        LOGGER.info("The bill id " + billObj.getString("id") + " have sent MQ_message to personChange ");
    }
}

