/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;

public class ProbationKeyEventImportValidateHelper
extends AbstractValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(ProbationKeyEventImportValidateHelper.class);

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        HashSet<Long> personIdSet = new HashSet<Long>(billDataList.size());
        for (ImportBillData importBillData : billDataList) {
            Object person = importBillData.getBaseDataJson("person");
            if (HRObjectUtils.isEmpty((Object)person)) continue;
            Long personId = ((JSONObject)person).getLong("id");
            personIdSet.add(personId);
        }
        Map<Long, DynamicObject> trailPeriodMap = IRegProbationService.getInstance().getTrailPeriodByPersonId(personIdSet);
        for (ImportBillData importBillData : billDataList) {
            try {
                Date entryDate;
                Object person = importBillData.getBaseDataJson("person");
                if (HRObjectUtils.isEmpty((Object)person)) continue;
                Long personId = ((JSONObject)person).getLong("id");
                DynamicObject trailPeriod = trailPeriodMap.get(personId);
                if (trailPeriod == null) {
                    String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u5b58\u5728\u8bd5\u7528\u671f\uff0c\u65e0\u9700\u7ef4\u62a4\u5173\u952e\u4e8b\u4ef6\u3002", (String)"ProbationKeyEventImportValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[0]);
                    importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
                    continue;
                }
                String regStatus = trailPeriod.getString("regstatus");
                if (HRStringUtils.isNotEmpty((String)regStatus) && !RegBusinessStatusEnum.WAIT_REG.getCode().equals(regStatus)) {
                    String errorMsg = ResManager.loadKDString((String)"\u4ec5\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63\u201d\u65f6\u624d\u80fd\u7ef4\u62a4\u5458\u5de5\u7684\u8bd5\u7528\u671f\u5173\u952e\u4e8b\u4ef6\u3002", (String)"ProbationKeyEventImportValidateHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]);
                    importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
                    continue;
                }
                JSONObject data = (JSONObject)importBillData.getData().get((Object)"hdm_regevent");
                Date occurDate = data.getDate("occurdate");
                if (occurDate == null || !HRDateTimeUtils.dayBefore((Date)occurDate, (Date)(entryDate = trailPeriod.getDate("entrydate")))) continue;
                String errorMsg = ResManager.loadKDString((String)"\u4e8b\u4ef6\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ProbationKeyEventImportValidateHelper_2", (String)"hr-hdm-business", (Object[])new Object[0]);
                importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
            }
            catch (Exception e) {
                LOGGER.error("ProbationKeyEventImportValidateHelper exception", (Throwable)e);
                importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), e.getMessage());
            }
        }
    }
}

