/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.validator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.hr.hdm.business.reg.RegAskServiceHelper;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.common.reg.util.RegStatusUtil;
import org.apache.commons.lang3.StringUtils;

public class RegCommonValidatorHelper {
    public static final String KEY_VALIDATE_RESULT = "validateResult";
    public static final String KEY_MSG = "msg";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";

    private RegCommonValidatorHelper() {
    }

    public static RegCommonValidatorHelper getInstance() {
        return RegCommonValidatorHelperHolder.INSTANCE;
    }

    public Map<String, String> validateAskRegStatus(Long employeeId, IFormView view) {
        HashMap<String, String> result = new HashMap<String, String>();
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee(employeeId);
        view.getPageCache().put("regstatus", regStatus);
        if ("1040".equals(regStatus) || "1050".equals(regStatus)) {
            String regStatusDesc = RegStatusUtil.getRegStatusDesc((String)regStatus);
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            String parentFormId = view.getFormShowParameter().getFormId();
            if (StringUtils.equals((CharSequence)parentFormId, (CharSequence)"hdm_regaskreply")) {
                result.put(KEY_MSG, ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u95ee\u8be2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d0\u4ea4\u3002", (String)"RegCommonValidatorHelper_5", (String)"hr-hdm-business", (Object[])new Object[]{regStatusDesc}));
            } else {
                result.put(KEY_MSG, ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u95ee\u8be2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u3002", (String)"RegCommonValidatorHelper_8", (String)"hr-hdm-business", (Object[])new Object[]{regStatusDesc}));
            }
            return result;
        }
        result.put(KEY_VALIDATE_RESULT, VALUE_TRUE);
        return result;
    }

    public Map<String, String> validateExamRegStatus(Long employeeId, IFormView view) {
        HashMap<String, String> result = new HashMap<String, String>();
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee(employeeId);
        view.getPageCache().put("regstatus", regStatus);
        if ("1040".equals(regStatus) || "1050".equals(regStatus)) {
            String regStatusDesc = RegStatusUtil.getRegStatusDesc((String)regStatus);
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            String parentFormId = view.getFormShowParameter().getFormId();
            if (StringUtils.equals((CharSequence)parentFormId, (CharSequence)"hdm_regexamreply")) {
                result.put(KEY_MSG, ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u8003\u8bc4\u7ec8\u6b62\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d0\u4ea4\u3002", (String)"RegCommonValidatorHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{regStatusDesc}));
            } else {
                result.put(KEY_MSG, ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u8003\u8bc4\u7ec8\u6b62\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u3002", (String)"RegCommonValidatorHelper_7", (String)"hr-hdm-business", (Object[])new Object[]{regStatusDesc}));
            }
            return result;
        }
        result.put(KEY_VALIDATE_RESULT, VALUE_TRUE);
        return result;
    }

    public Map<String, String> validateUrgeAsk(Long detailId, Long employeeId) {
        HashMap<String, String> result = new HashMap<String, String>();
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee(employeeId);
        if ("1040".equals(regStatus) || "1050".equals(regStatus)) {
            String regStatusDesc = RegStatusUtil.getRegStatusDesc((String)regStatus);
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            result.put(KEY_MSG, ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u95ee\u8be2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u6267\u884c\u50ac\u529e\u3002", (String)"RegCommonValidatorHelper_10", (String)"hr-hdm-business", (Object[])new Object[]{regStatusDesc}));
            return result;
        }
        DynamicObject object = RegAskServiceHelper.DETAILS_SERVICE_HELPER.queryOne("opinion", (Object)detailId);
        String opinion = object.getString("opinion");
        if (StringUtils.isNotEmpty((CharSequence)opinion)) {
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            result.put(KEY_MSG, ResManager.loadKDString((String)"\u5f53\u524d\u95ee\u8be2\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u6267\u884c\u201c\u50ac\u529e\u201d\u64cd\u4f5c\u3002", (String)"RegCommonValidatorHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            return result;
        }
        result.put(KEY_VALIDATE_RESULT, VALUE_TRUE);
        return result;
    }

    public Map<String, String> validateRetractAsk(Long detailId) {
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicObject object = RegAskServiceHelper.DETAILS_SERVICE_HELPER.queryOne("opinion", (Object)detailId);
        String opinion = object.getString("opinion");
        if (StringUtils.isNotEmpty((CharSequence)opinion)) {
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            result.put(KEY_MSG, ResManager.loadKDString((String)"\u5f53\u524d\u95ee\u8be2\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u6267\u884c\u201c\u64a4\u56de\u201d\u64cd\u4f5c\u3002", (String)"RegCommonValidatorHelper_2", (String)"hr-hdm-business", (Object[])new Object[0]));
            return result;
        }
        result.put(KEY_VALIDATE_RESULT, VALUE_TRUE);
        return result;
    }

    public Map<String, String> validateUrgeExam(Long detailId, Long employeeId) {
        HashMap<String, String> result = new HashMap<String, String>();
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee(employeeId);
        if ("1040".equals(regStatus) || "1050".equals(regStatus)) {
            String regStatusDesc = RegStatusUtil.getRegStatusDesc((String)regStatus);
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            result.put(KEY_MSG, ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u8003\u8bc4\u7ec8\u6b62\uff0c\u65e0\u6cd5\u6267\u884c\u50ac\u529e\u3002", (String)"RegCommonValidatorHelper_11", (String)"hr-hdm-business", (Object[])new Object[]{regStatusDesc}));
            return result;
        }
        DynamicObject object = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("opinion", (Object)detailId);
        String opinion = object.getString("opinion");
        if (StringUtils.isNotEmpty((CharSequence)opinion)) {
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            result.put(KEY_MSG, ResManager.loadKDString((String)"\u5f53\u524d\u8003\u8bc4\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u6267\u884c\u201c\u50ac\u529e\u201d\u64cd\u4f5c\u3002", (String)"RegCommonValidatorHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]));
            return result;
        }
        result.put(KEY_VALIDATE_RESULT, VALUE_TRUE);
        return result;
    }

    public Map<String, String> validateRetractExam(Long detailId) {
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicObject object = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("opinion", (Object)detailId);
        String opinion = object.getString("opinion");
        if (StringUtils.isNotEmpty((CharSequence)opinion)) {
            result.put(KEY_VALIDATE_RESULT, VALUE_FALSE);
            result.put(KEY_MSG, ResManager.loadKDString((String)"\u5f53\u524d\u8003\u8bc4\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u6267\u884c\u201c\u64a4\u56de\u201d\u64cd\u4f5c\u3002", (String)"RegCommonValidatorHelper_4", (String)"hr-hdm-business", (Object[])new Object[0]));
            return result;
        }
        result.put(KEY_VALIDATE_RESULT, VALUE_TRUE);
        return result;
    }

    public Map<String, String> validateKeyEvent(Long employeeId) {
        HashMap<String, String> result = new HashMap<String, String>();
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee(employeeId);
        if (!"1010".equals(regStatus)) {
            result.put(KEY_MSG, ResManager.loadKDString((String)"\u4ec5\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63\u201d\u65f6\u624d\u80fd\u7ef4\u62a4\u5458\u5de5\u7684\u8bd5\u7528\u671f\u5173\u952e\u4e8b\u4ef6\u3002", (String)"RegCommonValidatorHelper_9", (String)"hr-hdm-business", (Object[])new Object[0]));
            return result;
        }
        result.put(KEY_VALIDATE_RESULT, VALUE_TRUE);
        return result;
    }

    private static class RegCommonValidatorHelperHolder {
        private static final RegCommonValidatorHelper INSTANCE = new RegCommonValidatorHelper();

        private RegCommonValidatorHelperHolder() {
        }
    }
}

