/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.repository;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HpfsNoticeSendRecordRepository
extends HRBaseServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HpfsNoticeSendRecordRepository.class);
    private static final HpfsNoticeSendRecordRepository REPOSITORY = new HpfsNoticeSendRecordRepository("hpfs_noticesendrecord");
    private static final String NOTICE_CY_CONFIG = "noticecyconfig";
    private static final String DATA_SOURCE_ID = "datasourceid";
    private static final String TYPE = "type";
    private static final String CHANNEL = "channel";
    private static final String USER = "user";
    private static final String USER_ID = "user_id";

    public HpfsNoticeSendRecordRepository(String entityName) {
        super(entityName);
    }

    public static HpfsNoticeSendRecordRepository getRepository() {
        return REPOSITORY;
    }

    public DynamicObject generateNoticeSendRecord(Long userId, String channel, String type, Long noticeCyConfigId, Long dataSourceId) {
        LOGGER.info("addNoticeSendRecord userIds:{},channels\uff1a{}\uff0ctype:{},noticeCyConfigId:{}", new Object[]{userId, channel, type, noticeCyConfigId, dataSourceId});
        DynamicObject dynamicObject = REPOSITORY.generateEmptyDynamicObject();
        dynamicObject.set(NOTICE_CY_CONFIG, (Object)noticeCyConfigId);
        dynamicObject.set(DATA_SOURCE_ID, (Object)dataSourceId);
        dynamicObject.set(TYPE, (Object)type);
        dynamicObject.set(CHANNEL, (Object)channel);
        dynamicObject.set(USER, (Object)userId);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        return dynamicObject;
    }

    public Map<Long, Set<String>> getUserSendCycSendNoticeChannelMap(Set<Long> userIds, int sendCycle, String type, Long noticeCyConfigId, Long dataSourceId) {
        QFilter[] filters = new QFilter[]{new QFilter(NOTICE_CY_CONFIG, "=", (Object)noticeCyConfigId), new QFilter(DATA_SOURCE_ID, "=", (Object)dataSourceId), new QFilter(TYPE, "=", (Object)type), new QFilter(USER, "in", userIds), new QFilter("createtime", ">=", (Object)HRDateTimeUtils.addDay((Date)new Date(), (long)(-sendCycle)))};
        String selectProperties = String.join((CharSequence)",", CHANNEL, USER);
        DynamicObject[] records = REPOSITORY.query(selectProperties, filters);
        if (records.length == 0) {
            return new HashMap<Long, Set<String>>();
        }
        return Arrays.stream(records).collect(Collectors.groupingBy(record -> record.getLong(USER_ID), Collectors.mapping(record -> record.getString(CHANNEL), Collectors.toSet())));
    }
}

