/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.repository;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hcrs.IHRCSService;
import kd.hr.hdm.common.reg.constants.LabRelConstants;

public class RegProbationPersonQueryRepository
extends HRBaseServiceHelper {
    private static final RegProbationPersonQueryRepository REPOSITORY = new RegProbationPersonQueryRepository("hspm_regprobationpersonquery");

    public RegProbationPersonQueryRepository(String entityName) {
        super(entityName);
    }

    public static RegProbationPersonQueryRepository getInstance() {
        return REPOSITORY;
    }

    public QFilter getOrgAndAffiliateAdminOrgFilter(IFormView formView, String affiliateAdminOrg, String org) {
        QFilter adminOrgFilter;
        if (formView == null) {
            return null;
        }
        IFormView parentView = formView;
        while (!HRStringUtils.equals((String)parentView.getEntityId(), (String)"hdm_apphome_reg")) {
            if ((parentView = parentView.getParentView()) != null) continue;
            return null;
        }
        IPageCache pageCache = parentView.getPageCache();
        String affiliateAdminOrgStr = pageCache.get("baffiliateadminorg");
        List<Long> adminOrgIds = this.getMulBaseDataIdSetByStr(affiliateAdminOrgStr);
        String orgStr = pageCache.get("borg");
        List<Long> orgIds = this.getMulBaseDataIdSetByStr(orgStr);
        QFilter orgFilter = orgIds != null ? new QFilter(org, "in", orgIds) : RegProbationPersonQueryRepository.getInstance().getOrgPermissionFilter(org);
        QFilter qFilter = adminOrgFilter = adminOrgIds != null ? new QFilter(affiliateAdminOrg, "in", adminOrgIds) : RegProbationPersonQueryRepository.getInstance().getAdminOrgPermissionFilter(affiliateAdminOrg);
        if (orgFilter != null && adminOrgFilter != null) {
            return orgFilter.and(adminOrgFilter);
        }
        if (adminOrgFilter == null) {
            return orgFilter;
        }
        return adminOrgFilter;
    }

    public void setMulBaseDataDefaultFilter(FilterColumn filterColumn, String baseDataFormId, String baseDataIdsStr) {
        DynamicObject[] dynamicObjects;
        List<Long> baseDataIds = this.getMulBaseDataIdSetByStr(baseDataIdsStr);
        if (baseDataIds == null || baseDataIds.size() == 0) {
            filterColumn.setDefaultValue(null);
            return;
        }
        List defaultValues = filterColumn.getDefaultValues();
        defaultValues.clear();
        List comboItems = ((CommonBaseDataFilterColumn)filterColumn).getComboItems();
        ArrayList<Long> notExitComboItems = new ArrayList<Long>();
        for (Long baseDataId : baseDataIds) {
            boolean exitComboItemFlag = false;
            for (ComboItem comboItem : comboItems) {
                String value = comboItem.getValue();
                if (!HRStringUtils.equals((String)String.valueOf(baseDataId), (String)value)) continue;
                defaultValues.add(value);
                exitComboItemFlag = true;
                break;
            }
            if (exitComboItemFlag) continue;
            notExitComboItems.add(baseDataId);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(baseDataFormId);
        for (DynamicObject dynamicObject : dynamicObjects = serviceHelper.query("name", new QFilter[]{new QFilter("id", "in", notExitComboItems)}, null, 30)) {
            Long baseDataId = dynamicObject.getLong("id");
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(baseDataId));
            comboItem.setCaption(new LocaleString(dynamicObject.getLocaleString("name").getLocaleValue()));
            comboItems.add(comboItem);
            defaultValues.add(String.valueOf(baseDataId));
        }
    }

    public QFilter getAdminOrgPermissionFilter(String adminOrgIdFieldName) {
        AuthorizedOrgResult result = IHRCSService.getInstance().getAuthorizedAdminOrgsF7("hdm_probationquery", "47150e89000000ac", "affiliateadminorg");
        if (result == null) {
            return new QFilter(adminOrgIdFieldName, "in", new ArrayList());
        }
        if (!result.isHasAllOrgPerm()) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
            DynamicObject[] orgDys = serviceHelper.query("id", new QFilter[]{new QFilter("id", "in", (Object)result.getHasPermOrgs()), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")});
            if (orgDys.length == 0) {
                return new QFilter(adminOrgIdFieldName, "in", new ArrayList());
            }
            return new QFilter(adminOrgIdFieldName, "in", Arrays.stream(orgDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        }
        return null;
    }

    public QFilter getOrgPermissionFilter(String orgIdFieldName) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"hpb", (String)"hdm_probationquery", (String)"47150e89000000ac");
        if (result == null) {
            return new QFilter(orgIdFieldName, "in", new ArrayList());
        }
        if (!result.hasAllOrgPerm()) {
            return new QFilter(orgIdFieldName, "in", (Object)result.getHasPermOrgs());
        }
        return null;
    }

    private List<Long> getMulBaseDataIdSetByStr(String idsStr) {
        JSONArray array = (JSONArray)JSONObject.parse((String)idsStr);
        if (array != null && array.size() != 0) {
            ArrayList<Long> ids = new ArrayList<Long>(array.size());
            array.forEach(idStr -> ids.add(Long.valueOf((String)idStr)));
            return ids;
        }
        return null;
    }

    public QFilter getRegProbationPersonFilters() {
        QFilter filter = new QFilter("hrpi_empentrel.isprobation", "=", (Object)"1");
        filter.and("filetype.erfiletypeassign", "in", (Object)new Long[]{LabRelConstants.FILE_TYPE_EMP, LabRelConstants.FILE_TYPE_QUIT});
        filter.and("hrpi_empposorgrel.isprimary", "=", (Object)"1");
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("hrpi_empentrel.iscurrentversion", "=", (Object)"1");
        filter.and("hrpi_empposorgrel.iscurrentversion", "=", (Object)"1");
        filter.and("hrpi_trialperiod.iscurrentversion", "=", (Object)"1");
        filter.and("businessstatus", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        return filter;
    }

    public QFilter getDueRegQFilters(QFilter customFilter) {
        QFilter filter = this.getRegProbationPersonFilters();
        if (customFilter != null) {
            filter.and(customFilter);
        }
        filter.and(new QFilter("hrpi_trialperiod.regstatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{"1040", "1050"})));
        filter.and(new QFilter("hrpi_trialperiod.preregulardate", "<=", (Object)new Date()));
        return filter;
    }

    public QFilter getRegExamQFilters(QFilter customFilter) {
        QFilter filter = this.getRegProbationPersonFilters();
        if (customFilter != null) {
            filter.and(customFilter);
        }
        filter.and("hrpi_trialperiod.examstatus", "in", (Object)new String[]{"1020", "1030"});
        return filter;
    }

    public QFilter getRegAskQFilters(QFilter customFilter) {
        QFilter filter = this.getRegProbationPersonFilters();
        if (customFilter != null) {
            filter.and(customFilter);
        }
        filter.and("hrpi_trialperiod.askstatus", "in", (Object)new String[]{"1020", "1030"});
        return filter;
    }

    public int dueRgeCount(QFilter customFilter) {
        QFilter filter = this.getDueRegQFilters(customFilter);
        return REPOSITORY.count("hspm_regprobationpersonquery", new QFilter[]{filter});
    }

    public int regExamCount(QFilter customFilter) {
        QFilter filter = this.getRegProbationPersonFilters();
        if (customFilter != null) {
            filter.and(customFilter);
        }
        filter.and("hrpi_trialperiod.examstatus", "=", (Object)"1020");
        return REPOSITORY.count("hspm_regprobationpersonquery", new QFilter[]{filter});
    }

    public int regAskCount(QFilter customFilter) {
        QFilter filter = this.getRegProbationPersonFilters();
        if (customFilter != null) {
            filter.and(customFilter);
        }
        filter.and("hrpi_trialperiod.askstatus", "=", (Object)"1020");
        return REPOSITORY.count("hspm_regprobationpersonquery", new QFilter[]{filter});
    }

    public Map<Long, DynamicObject> queryByIds(List<Long> ids, String[] selectProperties) {
        DynamicObject[] dys;
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjectArray = dys = selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObjectArray(new QFilter[]{filter}) : REPOSITORY.query(String.join((CharSequence)",", selectProperties), new QFilter[]{filter});
        if (dys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
    }
}

