/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.external.IJobExternalService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.transfer.service.external.PositionExternalService;

public class PartEffectTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PartEffectTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.partEffectTask();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        try {
            this.partEndEffectTask();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }

    private void partEndEffectTask() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hdm_parttimeendbill");
        QFilter isEndFilter = new QFilter("isend", "=", (Object)Boolean.FALSE);
        QFilter dateQFilter = new QFilter("enddate", "<=", (Object)HRDateTimeUtils.addDay((Date)new Date(), (long)-1L));
        Object[] endBills = serviceHelper.loadDynamicObjectArray(new QFilter[]{isEndFilter, dateQFilter});
        PerChgBizUtils.personChangeOfEndPart((DynamicObject[])endBills);
        serviceHelper.update((DynamicObject[])endBills);
        logger.info("partEndEffetTask end :{}", (Object)Arrays.toString(endBills));
    }

    private void partEffectTask() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hdm_parttimeapplybill");
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter partStatusQFilter = new QFilter("parttimestatus", "=", (Object)"0");
        QFilter partDateQFilter = new QFilter("effectdate", "<=", (Object)new Date());
        Object[] bills = serviceHelper.loadDynamicObjectArray(new QFilter[]{statusQFilter, partStatusQFilter, partDateQFilter});
        if (bills.length == 0) {
            return;
        }
        List<DynamicObject> discardBills = ParttimeServiceHelper.getDiscardBills(Arrays.asList(bills));
        DynamicObject[] effectiveBills = (DynamicObject[])Arrays.stream(bills).filter(bill -> !discardBills.contains(bill)).toArray(DynamicObject[]::new);
        List<Map<String, Object>> reqList = IParttimeBillService.getInstance().createReqList(effectiveBills);
        if (null != reqList && reqList.size() > 0) {
            ArrayList<Map<String, Object>> bJobReqList = new ArrayList<Map<String, Object>>(reqList.size());
            ArrayList<Map<String, Object>> stdPositionReqList = new ArrayList<Map<String, Object>>(reqList.size());
            for (Map<String, Object> map : reqList) {
                if (map.get("job") != null) {
                    bJobReqList.add(map);
                }
                if (map.get("standardposition") == null) continue;
                stdPositionReqList.add(map);
            }
            if (bJobReqList.size() > 0) {
                Map<String, Object> darkPositionByJob = IJobExternalService.getInstance().getDarkPositionByJob(bJobReqList);
                IParttimeBillService.getInstance().fillTheDarkPosition(effectiveBills, darkPositionByJob);
            }
            if (stdPositionReqList.size() > 0) {
                Map<String, Object> darkPositionByStdPosition = PositionExternalService.getInstance().invokerAddDarkPosition(stdPositionReqList);
                IParttimeBillService.getInstance().fillTheDarkPosition(effectiveBills, darkPositionByStdPosition);
            }
        }
        IParttimeBillService.getInstance().changeToBoId(effectiveBills);
        serviceHelper.update((DynamicObject[])bills);
        serviceHelper.update(effectiveBills);
        PerChgBizUtils.personChangeOfPart(effectiveBills);
        logger.info("partEffetTask end :{}", (Object)Arrays.toString(bills));
    }
}

