/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.warn.reg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnCustomReceiver;
import kd.bos.entity.earlywarn.warnschedule.WarnMessageConfig;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageSendType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.repository.HpfsNoticeCyConfigRepository;
import kd.hr.hdm.business.repository.HpfsNoticeSendRecordRepository;

public class NearPreRegDateEarlyWarnCustomReceive
implements IEarlyWarnCustomReceiver {
    private static final Log LOGGER = LogFactory.getLog(NearPreRegDateEarlyWarnCustomReceive.class);

    public List<Long> getReceiverIds(EarlyWarnContext earlyWarnContext, DynamicObject[] dynamicObjects) {
        LOGGER.info("NearPreRegDateWarnCustomReceive.getReceiverIds start");
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (dynamicObjects.length > 0) {
            Map receiverUserIdMap = (Map)earlyWarnContext.getCustomData("receiverMap");
            if (receiverUserIdMap == null || receiverUserIdMap.isEmpty()) {
                LOGGER.info("NearPreRegDateWarnCustomReceive.getReceiverIds receiverUserIdMap is empty");
                return userIds;
            }
            DynamicObject dynamicObject = dynamicObjects[0];
            String number = dynamicObject.getString("person.number");
            Set receiverUserIdSet = (Set)receiverUserIdMap.get(number);
            LOGGER.info("NearPreRegDateWarnCustomReceive.getReceiverIds receiverUserIdSet:{}", (Object)receiverUserIdSet);
            if (receiverUserIdSet != null) {
                HpfsNoticeCyConfigRepository configRepository = HpfsNoticeCyConfigRepository.getRepository();
                HpfsNoticeSendRecordRepository recordRepository = HpfsNoticeSendRecordRepository.getRepository();
                DynamicObject sendCycleConfig = configRepository.getNearPreRegDateEarlyWarnNoticeSendCycle();
                HashMap<Long, Set<String>> userSendNoticeChannelMap = new HashMap<Long, Set<String>>(16);
                int noticeSendCycle = configRepository.getNoticeSendCycle(sendCycleConfig);
                if (noticeSendCycle != 0) {
                    userSendNoticeChannelMap.putAll(recordRepository.getUserSendCycSendNoticeChannelMap(receiverUserIdSet, noticeSendCycle, "warning", sendCycleConfig.getLong("id"), dynamicObject.getLong("id")));
                }
                WarnMessageConfig messageConfig = earlyWarnContext.getWarnSchedule().getMessageConfig();
                Set channels = messageConfig.getSendTypes().stream().map(WarnMessageSendType::getSendType).map(WarnMessageSendType.SendType::getValue).collect(Collectors.toSet());
                ArrayList noticeSendRecords = new ArrayList(16);
                userIds.addAll(receiverUserIdSet.stream().filter(userId -> {
                    Set userSendCycSendNoticeChannels = (Set)userSendNoticeChannelMap.get(userId);
                    if (userSendCycSendNoticeChannels != null && userSendCycSendNoticeChannels.containsAll(channels)) {
                        return false;
                    }
                    if (!HRObjectUtils.isEmpty((Object)sendCycleConfig)) {
                        channels.forEach(channel -> {
                            DynamicObject noticeSendRecord = recordRepository.generateNoticeSendRecord((Long)userId, (String)channel, "warning", sendCycleConfig.getLong("id"), dynamicObject.getLong("id"));
                            noticeSendRecords.add(noticeSendRecord);
                        });
                    }
                    return true;
                }).collect(Collectors.toSet()));
                if (noticeSendRecords.size() > 0) {
                    recordRepository.save(noticeSendRecords.toArray(new DynamicObject[0]));
                    LOGGER.info("NearPreRegDateWarnCustomReceive.getReceiverIds userIds:{}", userIds);
                }
            }
        }
        return userIds;
    }
}

