/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.warn.reg;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnWriteOut;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.repository.RegNearPreDateRepository;

public class NearPreRegDateEarlyWarnWriteOut
implements IEarlyWarnWriteOut {
    private static final Log LOGGER = LogFactory.getLog(NearPreRegDateEarlyWarnWriteOut.class);

    public void writeOut(DynamicObjectCollection collection, EarlyWarnContext context) {
        if (collection.isEmpty()) {
            LOGGER.warn("early warn data is empty");
            return;
        }
        String selectProperties = String.join((CharSequence)",", "probation", "probationunit", "preregulardate", "preregulardate", "entrydate", "person", "regstatus");
        List pkValues = collection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        Map earlyWarnLevelMap = (Map)context.getCustomData("earlyWarnLevelMap");
        Map erManFileIdMap = (Map)context.getCustomData("erManFileIdMap");
        if (earlyWarnLevelMap == null || earlyWarnLevelMap.isEmpty()) {
            LOGGER.warn("earlyWarnLevelMap is empty");
            return;
        }
        int batchSize = 500;
        int dataSize = pkValues.size();
        int batch = dataSize / batchSize;
        for (int i = 0; i < batch + 1; ++i) {
            int indexStart = i * batchSize;
            int indexEnd = Math.min(indexStart + batchSize, dataSize);
            LOGGER.info("batchSize:{} i:{} indexStart:{} indexEnd:{}", new Object[]{batchSize, i, indexStart, indexEnd});
            DynamicObject[] trialPeriods = IHRPIService.getInstance().listFieldsFilterInfo(selectProperties, new QFilter("id", "in", pkValues.subList(indexStart, indexEnd)), "hrpi_trialperiod");
            List<String> empNumbers = Arrays.stream(trialPeriods).map(dy -> dy.getString("person.number")).collect(Collectors.toList());
            DynamicObject[] erManFileDys = IHSPMService.getInstance().listPrimaryErManFilesByEmpNumber(empNumbers);
            if (erManFileDys == null || erManFileDys.length == 0) {
                LOGGER.warn("erManFileDys.length == 0");
                break;
            }
            List<Long> erManFileIds = Arrays.stream(erManFileDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            Map<Object, Map<String, Object>> erManFileMap = IHSPMService.getInstance().getCardFieldByErManFileIds(erManFileIds, "person_id");
            if (erManFileMap == null || erManFileMap.isEmpty()) {
                LOGGER.warn("erManFileMap is empty");
                break;
            }
            RegNearPreDateRepository repository = RegNearPreDateRepository.getRepository();
            DynamicObjectCollection regNearPreDatePeronList = new DynamicObjectCollection();
            Arrays.stream(trialPeriods).forEach(trialPeriod -> {
                DynamicObject dy = repository.generateEmptyDynamicObject();
                long personId = trialPeriod.getLong("person.id");
                String personNumber = trialPeriod.getString("person.number");
                LOGGER.info("trialPeriodId:{} personId:{} personNumber:{}", new Object[]{trialPeriod.getLong("id"), personId, personNumber});
                Map erManFile = (Map)erManFileMap.get(personId);
                if (HRObjectUtils.isEmpty((Object)erManFile)) {
                    LOGGER.warn("{} erManFile is empty", (Object)personNumber);
                    return;
                }
                Long erManFileId = (Long)erManFileIdMap.get(personId);
                String earlyWarnLevel = (String)earlyWarnLevelMap.get(erManFileId);
                if (HRStringUtils.isEmpty((String)earlyWarnLevel)) {
                    LOGGER.warn("{} earlyWarnLevel is empty", (Object)personNumber);
                    return;
                }
                regNearPreDatePeronList.add((Object)dy);
                dy.set("earlywarnlevel", (Object)earlyWarnLevel);
                dy.set("id", (Object)erManFileId);
                dy.set("ermainfile", (Object)erManFileId);
                dy.set("person", (Object)personId);
                dy.set("name", (Object)trialPeriod.getString("person.name"));
                dy.set("number", (Object)personNumber);
                dy.set("empgroup", erManFile.get("empgroup_id"));
                dy.set("affiliateadminorg", erManFile.get("affiliateadminorg_id"));
                dy.set("org", erManFile.get("org_id"));
                dy.set("company", erManFile.get("company_id"));
                dy.set("position", erManFile.get("position_id"));
                dy.set("job", erManFile.get("job_id"));
                dy.set("adminorg", erManFile.get("adminorg_id"));
                dy.set("stdposition", erManFile.get("stdposition_id"));
                dy.set("probation", trialPeriod.get("probation"));
                dy.set("probationunit", trialPeriod.get("probationunit"));
                dy.set("preregulardate", trialPeriod.get("preregulardate"));
                String regStatus = trialPeriod.getString("regstatus");
                dy.set("regstatus", (Object)(HRStringUtils.isEmpty((String)regStatus) ? "1010" : regStatus));
                dy.set("entrydate", trialPeriod.get("entrydate"));
            });
            int size = regNearPreDatePeronList.size();
            LOGGER.info("regNearPreDatePeronList size:{}", (Object)size);
            if (size <= 0) continue;
            repository.save(regNearPreDatePeronList);
        }
    }
}

