/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.mservice;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hlcm.business.domian.service.hrpi.IHrpiService;
import kd.hr.hlcm.business.domian.service.sync.ISyncPersonInfoService;
import kd.hr.hlcm.mservice.api.IHLCMPersonTransferService;

public class HLCMPersonTransferService
implements IHLCMPersonTransferService {
    private static final Log LOGGER = LogFactory.getLog(HLCMPersonTransferService.class);

    public HRMServiceResult consumerSaveMsg(DynamicObject tplDy) {
        LOGGER.info("==HLCMPersonTransferService start to consumer msg==");
        try {
            Map msgCon = (Map)SerializationUtils.deSerializeFromBase64((String)tplDy.getString("msgcontent"));
            Long recordId = (Long)msgCon.get("recordId");
            if (recordId != null && recordId != 0L) {
                LOGGER.info("==recordId:{}==", (Object)recordId);
                Map chgMap = IHrpiService.getInstance().getChgInfoDetailByRecordId(recordId);
                LOGGER.info("==chgMap:{}==", (Object)chgMap);
                if (!CollectionUtils.isEmpty((Map)chgMap)) {
                    this.syncPersonInfo(chgMap);
                }
            } else {
                LOGGER.info("==recordId is 0L==");
            }
            LOGGER.info("success to consumer msg");
            return HRMServiceResult.success();
        }
        catch (Exception exp) {
            LOGGER.error("fail to consumer msg", (Throwable)exp);
            return HRMServiceResult.fail((String)exp.getMessage());
        }
    }

    private void syncPersonInfo(Map<String, Object> chgMap) {
        List chgList = (List)((Map)chgMap.get("data")).get("data");
        if (CollectionUtils.isEmpty((Collection)chgList)) {
            return;
        }
        chgList.stream().filter(map -> "hrpi_employee".equals(map.get("entity"))).findFirst().ifPresent(entity -> {
            Long employeeId = (Long)entity.get("idafter");
            LOGGER.info("start to sync PersonInfo employeeId|{}", (Object)employeeId);
            ISyncPersonInfoService.getInstance().syncPersonInfo(employeeId);
            LOGGER.info("sync PersonInfo success", (Object)employeeId);
        });
    }
}

