/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class BosAttachmentRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("bos_attachment");
    private static final BosAttachmentRepository REPOSITORY = new BosAttachmentRepository();
    private static final Log LOGGER = LogFactory.getLog(BosAttachmentRepository.class);

    private BosAttachmentRepository() {
    }

    public static BosAttachmentRepository getInstance() {
        return REPOSITORY;
    }

    public DynamicObject[] queryByInterId(String interId, String formId, String selectProperties) {
        QFilter[] filters = new QFilter[]{new QFilter("fbilltype", "=", (Object)formId), new QFilter("finterid", "=", (Object)interId)};
        return SERVICE_HELPER.query(selectProperties, filters);
    }

    public void delAttment(QFilter[] filters) {
        SERVICE_HELPER.deleteByFilter(filters);
    }

    public DynamicObject[] queryByFilter(String selectProperties, QFilter[] filters) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return SERVICE_HELPER.loadDynamicObjectArray(filters);
        }
        return SERVICE_HELPER.query(selectProperties, filters);
    }

    public List<DynamicObject> copyAtt(DynamicObject[] sourceAtt, String interId, String formId) {
        if (sourceAtt != null && sourceAtt.length > 0) {
            ArrayList<DynamicObject> attachments = new ArrayList<DynamicObject>(sourceAtt.length);
            for (DynamicObject att : sourceAtt) {
                DynamicObject targeAtt = SERVICE_HELPER.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)att, (DynamicObject)targeAtt);
                targeAtt.set("fbilltype", (Object)formId);
                targeAtt.set("finterid", (Object)interId);
                targeAtt.set("FNUMBER", (Object)this.getAttUid(att.getString("FNUMBER")));
                attachments.add(targeAtt);
            }
            return attachments;
        }
        return new ArrayList<DynamicObject>();
    }

    public void saveAtt(DynamicObject[] atts) {
        SERVICE_HELPER.save(atts);
    }

    public String getAttUid(String origUid) {
        return "rc-upload-" + this.randomNum() + "-1";
    }

    public String randomNum() {
        StringBuilder verifyCode = new StringBuilder();
        verifyCode.append(System.currentTimeMillis()).append(RandomStringUtils.randomNumeric((int)4));
        return verifyCode.toString();
    }

    public void repairAttach(String entityId, long sourceId, long id) {
        List<DynamicObject> targetAtt;
        HashSet pannels = Sets.newHashSet((Object[])new String[]{"attachmentpanel", "paperattachment"});
        QFilter typeFilter = new QFilter("fbilltype", "=", (Object)entityId).and("fattachmentpanel", "in", (Object)pannels);
        QFilter idFilter = new QFilter("finterid", "=", (Object)String.valueOf(sourceId));
        QFilter idCurrFilter = new QFilter("finterid", "=", (Object)String.valueOf(id));
        BosAttachmentRepository.getInstance().delAttment(new QFilter[]{idFilter, typeFilter});
        DynamicObject[] sourceAtt = BosAttachmentRepository.getInstance().queryByFilter("", new QFilter[]{idCurrFilter, typeFilter});
        if (sourceAtt != null && sourceAtt.length > 0 && !CollectionUtils.isEmpty(targetAtt = BosAttachmentRepository.getInstance().copyAtt(sourceAtt, String.valueOf(sourceId), entityId))) {
            BosAttachmentRepository.getInstance().saveAtt(targetAtt.toArray(new DynamicObject[0]));
        }
    }

    public void modifyCurrAttachNum(String entityId, long id) {
        HashSet pannels = Sets.newHashSet((Object[])new String[]{"attachmentpanel", "paperattachment"});
        QFilter typeFilter = new QFilter("fbilltype", "=", (Object)entityId).and("fattachmentpanel", "in", (Object)pannels);
        QFilter idCurrFilter = new QFilter("finterid", "=", (Object)String.valueOf(id));
        DynamicObject[] sourceAtt = BosAttachmentRepository.getInstance().queryByFilter("", new QFilter[]{idCurrFilter, typeFilter});
        if (sourceAtt != null && sourceAtt.length > 0) {
            for (DynamicObject att : sourceAtt) {
                att.set("FNUMBER", (Object)this.getAttUid(att.getString("FNUMBER")));
            }
            BosAttachmentRepository.getInstance().saveAtt(sourceAtt);
        }
    }

    public List<DynamicObject> assembleFile(Map<Long, Map<String, Object>> idMap) {
        ArrayList<DynamicObject> fileList = new ArrayList<DynamicObject>(idMap.size());
        for (Map.Entry<Long, Map<String, Object>> next : idMap.entrySet()) {
            Long id = next.getKey();
            Map<String, Object> map = next.getValue();
            DynamicObject fileObject = SERVICE_HELPER.generateEmptyDynamicObject();
            String protocolType = String.valueOf(map.get("protocolType"));
            fileObject.set("fbilltype", (Object)this.getDataPanelType(protocolType));
            fileObject.set("finterid", (Object)String.valueOf(id));
            fileObject.set("FNUMBER", (Object)this.getAttUid(""));
            fileObject.set("ffileid", map.get("fileId"));
            fileObject.set("faliasfilename", map.get("fileName"));
            fileObject.set("fattachmentname", map.get("fileName"));
            fileObject.set("fextname", map.get("extName"));
            fileObject.set("fattachmentsize", map.get("fileSize"));
            fileObject.set("fattachmentpanel", (Object)"paperattachment");
            fileObject.set("fcreatetime", (Object)new Date());
            fileObject.set("fmodifytime", (Object)new Date());
            fileList.add(fileObject);
        }
        return fileList;
    }

    public String getDataPanelType(String protocolType) {
        String panelType = "";
        switch (protocolType) {
            case "1": {
                panelType = "hlcm_contract";
                break;
            }
            case "2": {
                panelType = "hlcm_contractfileemp";
                break;
            }
            case "3": {
                panelType = "hlcm_contractfileother";
                break;
            }
        }
        return panelType;
    }
}

