/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.BosAttachmentRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.service.PermissionService;
import kd.hr.hlcm.business.service.PersonService;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.ComboUtils;

public class ContractRepository {
    private static final Log logger = LogFactory.getLog(ContractRepository.class);
    private HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hlcm_contractsource");
    private static final ContractRepository CONTRACT_REPOSITORY = new ContractRepository();
    private static final String SELECTFIELDS_CONTRACTFILE = "id,number,employee,iscurrentversion,actualsigncompany,actualsigncompanyhis,cancelreason,contracttype,startdate,enddate,signeddate,period,periodtype,periodunit,cardtype,cardnumber,householdregister,residentialaddress,empphone";

    private ContractRepository() {
    }

    public static ContractRepository getInstance() {
        return CONTRACT_REPOSITORY;
    }

    public DynamicObject[] getExpiredUnsignedContract() {
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        DynamicObject[] effectContracts = this.getEffectContractPersonIds();
        logger.info("effectContractPersonIds:{}", Collections.singletonList(effectContracts));
        QFilter noEffectStatusFilter = new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
        QFilter protocolTypeFilter = new QFilter("protocoltype", "not in", (Object)ProtocolTypeEnum.FS.getCombKey());
        DynamicObject[] tempContracts = this.SERVICE_HELPER.query("employee,person.id,protocoltype,empnumber,personname,ermanfile.id,postype.id,signstatus,startdate,ermanorg,adminororg,ermanperorg", new QFilter[]{currentVersionFilter, noEffectStatusFilter, protocolTypeFilter, initStatusFilter});
        Function<DynamicObject, String> calKeyFun = effectContract -> String.format(Locale.ROOT, "%s_%d_%d", effectContract.getString("protocoltype"), effectContract.getLong(String.format("%s_id", "employee")), effectContract.getLong(String.format("%s_id", "postype")));
        DynamicObject[] differContract = this.differ(tempContracts, effectContracts, calKeyFun);
        ArrayList contracts = new ArrayList(100);
        Map<String, List<DynamicObject>> collect = Arrays.stream(differContract).collect(Collectors.groupingBy(calKeyFun));
        Comparator<DynamicObject> comparingStartDate = Comparator.comparing(dy -> dy.getDate("startdate"));
        Comparator<DynamicObject> comparingId = Comparator.comparingLong(dy -> dy.getLong("id"));
        collect.values().forEach(dys -> dys.stream().max(comparingStartDate.thenComparing(comparingId)).ifPresent(contracts::add));
        Object[] employeeIds = (Long[])contracts.stream().map(dynamicObject -> dynamicObject.getLong("employee_id")).distinct().toArray(Long[]::new);
        logger.info("expiredAndNotsignPersonIds:{}", Arrays.asList(employeeIds));
        Object[] onJobEmployeeIds = PersonService.getInstance().getOnJobEmployeeIds(Lists.newArrayList((Object[])employeeIds));
        ArrayList onJobEmployeeIdLists = Lists.newArrayList((Object[])onJobEmployeeIds);
        logger.info("expiredAndNotsignAndOnJobPersonIds:{}", (Object)onJobEmployeeIdLists);
        return (DynamicObject[])contracts.stream().filter(contract -> onJobEmployeeIdLists.contains(contract.getLong("employee.id"))).toArray(DynamicObject[]::new);
    }

    private DynamicObject[] differ(DynamicObject[] tempContracts, DynamicObject[] effectContracts, Function<DynamicObject, String> calKeyFun) {
        Set existSet = Stream.of(effectContracts).map(calKeyFun).collect(Collectors.toSet());
        return (DynamicObject[])Stream.of(tempContracts).filter(contract -> !existSet.contains(calKeyFun.apply((DynamicObject)contract))).toArray(DynamicObject[]::new);
    }

    private DynamicObject[] getEffectContractPersonIds() {
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        ArrayList contractEffectStatusList = Lists.newArrayList((Object[])new String[]{ContractStatusEnum.STATUS_PENDING.getCode(), ContractStatusEnum.STATUS_IN_EFFECT.getCode()});
        QFilter effectStatusFilter = new QFilter("contractstatus", "in", (Object)contractEffectStatusList);
        QFilter protocolTypeFilter = new QFilter("protocoltype", "not in", (Object)ProtocolTypeEnum.FS.getCombKey());
        String selectProperties = String.join((CharSequence)",", "employee.id", "postype", "protocoltype");
        return this.SERVICE_HELPER.query(selectProperties, new QFilter[]{currentVersionFilter, effectStatusFilter, initStatusFilter, protocolTypeFilter});
    }

    public boolean existWaitEffect(long personId, long posTypeId, String protocolType) {
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter posTypeFilter = new QFilter("postype", "=", (Object)posTypeId);
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)protocolType);
        QFilter statusFilter = new QFilter("contractstatus", "=", (Object)"0");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.SERVICE_HELPER.isExists(new QFilter[]{personFilter, posTypeFilter, protocolTypeFilter, statusFilter, versionFilter});
    }

    public boolean isAllInvalid(long personId, long posTypeId, String protocolType) {
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter posTypeFilter = new QFilter("postype", "=", (Object)posTypeId);
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)protocolType);
        QFilter statusFilter = new QFilter("contractstatus", "in", (Object)new String[]{"1", "0"});
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return !this.SERVICE_HELPER.isExists(new QFilter[]{personFilter, posTypeFilter, protocolTypeFilter, statusFilter, versionFilter});
    }

    public DynamicObject[] getEmploymentAgreementToBeCancel(long personId, long posTypeId) {
        if (personId == 0L || posTypeId == 0L) {
            return new DynamicObject[0];
        }
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.YG.getCombKey());
        QFilter posTypeFilter = new QFilter("postype", "=", (Object)posTypeId);
        QFilter contractStatusFilter = new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode());
        QFilter personFilter = new QFilter("person_id", "=", (Object)personId);
        return CommonRepository.queryDynamicObjectByFilters("hlcm_contract", SELECTFIELDS_CONTRACTFILE, new QFilter[]{protocolTypeFilter, posTypeFilter, contractStatusFilter, personFilter, isCurrentVersionFilter}, "id desc", 1);
    }

    public void setEmploymentAgreementToBeTerminatedValue(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        long personId = dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "person"));
        long posTypeId = dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "postype"));
        DynamicObject[] dynamicObjects = ContractRepository.getInstance().getEmploymentAgreementToBeCancel(personId, posTypeId);
        if (!HRObjectUtils.isEmpty((Object)dynamicObjects) && dynamicObjects.length > 0) {
            DynamicObject oldContract = dynamicObjects[0];
            ContractSignUtils.setCancelPartyABInfo(oldContract, model);
        }
    }

    public DynamicObject[] findContractsByField(Set<String> fieldSet, String key) {
        String selProp = "ermanfile" + ',' + "startdate" + ',' + "enddate" + ',' + "actualenddate" + ',' + "person" + ',' + "signstatus" + ',' + "oldcontract.number";
        QFilter filter = new QFilter(key, "in", fieldSet);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.SERVICE_HELPER.query(selProp, new QFilter[]{filter, versionFilter});
    }

    public DynamicObject[] findContractsByErmanId(Set<Long> fieldSet, String key, Set<String> type) {
        String selProp = "ermanfile" + ',' + "startdate" + ',' + "actualenddate" + ',' + "enddate";
        QFilter filter = new QFilter(key, "in", fieldSet).and("protocoltype", "in", type);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.SERVICE_HELPER.query(selProp, new QFilter[]{filter, versionFilter}, "startdate");
    }

    public DynamicObject[] findOriContractsByField(Set<String> orgNumSet, String type) {
        QFilter filter = new QFilter("number", "in", orgNumSet);
        if (HRStringUtils.equals((String)"othertype", (String)type)) {
            HashSet<String> proType = new HashSet<String>(2);
            proType.add(ProtocolTypeEnum.YG.getCombKey());
            proType.add(ProtocolTypeEnum.CON.getCombKey());
            filter.and("protocoltype", "in", proType);
        }
        String selProp = "number" + "," + "maincontract" + "," + "ermanfile";
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.SERVICE_HELPER.query(selProp, new QFilter[]{filter, versionFilter});
    }

    public void findAndSetHisId(Map<Long, DynamicObject> filterMap, List<Long> departIds, List<Long> positionIds, List<Long> stdPositionIds, List<Long> jobIds, List<Long> companyIds) {
        Map<Long, Long> adminOrgHisMap = IHbpmService.getInstance().getAdminOrgHis(departIds);
        Map<Long, Long> hisPosMap = IHbpmService.getInstance().getPosHis(positionIds);
        Map<Long, Long> hisStdPosMap = IHbpmService.getInstance().getStdPosHis(stdPositionIds);
        Map<Long, Long> jobHisMap = IHbpmService.getInstance().getJobHis(jobIds);
        Map<Long, Long> companyHisMap = IHbpmService.getInstance().getAdminOrgHis(companyIds);
        for (Map.Entry<Long, DynamicObject> entry : filterMap.entrySet()) {
            DynamicObject value = entry.getValue();
            this.setHisId(adminOrgHisMap, value, "department_id");
            this.setHisId(hisPosMap, value, "position_id");
            this.setHisId(hisStdPosMap, value, "stdposition_id");
            this.setHisId(jobHisMap, value, "job_id");
            this.setHisId(companyHisMap, value, "signedcompany_id");
        }
    }

    public void setHisId(Map<Long, Long> hisMap, DynamicObject value, String key) {
        Long id = value.getLong(key);
        if (id != 0L && !CollectionUtils.isEmpty(hisMap)) {
            value.set(key, (Object)hisMap.get(id));
        }
    }

    public void setRepartHisId(Map<Long, Long> hisMap, DynamicObject value, String key) {
        Long id = value.getLong(key);
        if (id != 0L && !CollectionUtils.isEmpty(hisMap) && hisMap.get(id) != null) {
            value.set(key, (Object)hisMap.get(id));
        }
    }

    public DynamicObject[] loadBySignBills(DynamicObject[] signBills, String selectProperties) {
        if (signBills == null || signBills.length < 1) {
            return new DynamicObject[0];
        }
        ArrayList contractNumbers = new ArrayList(signBills.length);
        ArrayList oldContractIds = new ArrayList(signBills.length);
        Arrays.stream(signBills).forEach(signBill -> {
            if (BusinessTypeEnum.CANCEL.getCombKey().equals(signBill.getString("businesstype")) || BusinessTypeEnum.STOP.getCombKey().equals(signBill.getString("businesstype"))) {
                oldContractIds.add(signBill.getLong("oldcontract.id"));
            } else {
                contractNumbers.add(signBill.getString("contractnumber"));
            }
        });
        QFilter contractFilter = null;
        if (contractNumbers.size() > 0 && oldContractIds.size() == 0) {
            contractFilter = new QFilter("number", "in", contractNumbers);
        }
        if (oldContractIds.size() > 0 && contractNumbers.size() == 0) {
            contractFilter = new QFilter("id", "in", oldContractIds);
        }
        if (contractNumbers.size() > 0 && oldContractIds.size() > 0) {
            contractFilter = new QFilter("number", "in", contractNumbers).or(new QFilter("id", "in", oldContractIds));
        }
        QFilter[] filters = new QFilter[]{contractFilter, new QFilter("iscurrentversion", "=", (Object)"1")};
        return HRStringUtils.isEmpty((String)selectProperties) ? this.SERVICE_HELPER.loadDynamicObjectArray(filters) : this.SERVICE_HELPER.query(selectProperties, filters);
    }

    public DynamicObject[] loadByNumbers(Set<String> numbers, String selectProperties) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", numbers), new QFilter("iscurrentversion", "=", (Object)"1")};
        return HRStringUtils.isEmpty((String)selectProperties) ? this.SERVICE_HELPER.loadDynamicObjectArray(filters) : this.SERVICE_HELPER.query(selectProperties, filters);
    }

    public String hasInitingContract(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        List<DynamicObject> contractList = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)contract.getString("protocoltype"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = Lists.newArrayList((Object[])new String[]{"0", "1"}).contains(contract.getString("initstatus"));
            return protocoltype && iscurrentversion && postypeequals && initstatus;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(contractList)) {
            String msg = this.assembleNumber(contractList);
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u6709\u521d\u59cb\u5316\u672a\u5b8c\u6210\u7684\u52b3\u52a8\u5408\u540c\uff0c\u5408\u540c\u7f16\u7801\u4e3a%2$s\uff0c\u4e0d\u53ef\u53d1\u8d77\u52b3\u52a8\u5408\u540c\u65b0\u7b7e\u7533\u8bf7\u3002", (String)"ContractRepository_3", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), msg);
        }
        return "";
    }

    public String hasInitingEmpProtocol(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        List<DynamicObject> empProtocolList = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = Lists.newArrayList((Object[])new String[]{"0", "1"}).contains(contract.getString("initstatus"));
            return protocoltype && iscurrentversion && postypeequals && initstatus;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(empProtocolList)) {
            String msg = this.assembleNumber(empProtocolList);
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u6709\u521d\u59cb\u5316\u672a\u5b8c\u6210\u7684\u7528\u5de5\u534f\u8bae\uff0c\u5408\u540c\u7f16\u7801\u4e3a%2$s\uff0c\u4e0d\u53ef\u53d1\u8d77\u7528\u5de5\u534f\u8bae\u65b0\u7b7e\u7533\u8bf7\u3002", (String)"ContractRepository_4", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), msg);
        }
        return "";
    }

    private String assembleNumber(List<DynamicObject> fileList) {
        HashSet numberSet = new HashSet();
        fileList.forEach(file -> numberSet.add(file.getString("number")));
        ArrayList numberList = Lists.newArrayList(numberSet);
        return String.join((CharSequence)"\u3001", numberList);
    }

    public void reviseAttach(IFormView view, String entityId, DynamicObject preDy) {
        String preId = preDy.getString("id");
        String pkId = view.getModel().getDataEntity().getString("id");
        HRBaseServiceHelper attachmentService = new HRBaseServiceHelper("bos_attachment");
        QFilter[] paperFilters = new QFilter[]{new QFilter("fbilltype", "=", (Object)entityId), new QFilter("finterid", "=", (Object)pkId)};
        DynamicObject[] queryAtt = attachmentService.loadDynamicObjectArray(paperFilters);
        ArrayList<DynamicObject> papreAttachments = new ArrayList<DynamicObject>();
        for (DynamicObject att : queryAtt) {
            DynamicObject dynamicObject = attachmentService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)att, (DynamicObject)dynamicObject, new HashSet());
            dynamicObject.set("finterid", (Object)preId);
            dynamicObject.set("FNUMBER", (Object)BosAttachmentRepository.getInstance().getAttUid(att.getString("FNUMBER")));
            papreAttachments.add(dynamicObject);
        }
        if (papreAttachments.size() > 0) {
            QFilter idFilter = new QFilter("finterid", "=", (Object)preId);
            QFilter typeFilter1 = new QFilter("fbilltype", "=", (Object)view.getEntityId());
            attachmentService.deleteByFilter(new QFilter[]{idFilter, typeFilter1});
            attachmentService.save(papreAttachments.toArray(new DynamicObject[0]));
        }
    }

    public void reviseData(IFormView view, DynamicObject preDy) {
        preDy.set("changedescription", (Object)view.getModel().getDataEntity().getString("changedescription"));
        preDy.set("modifier", view.getModel().getDataEntity().get("modifier"));
        preDy.set("modifytime", view.getModel().getDataEntity().get("modifytime"));
        CommonRepository.updateOne(view.getEntityId(), preDy);
    }

    public String tplConTypeValid(DynamicObject dynamicObject) {
        DynamicObjectCollection dys = dynamicObject.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)dys)) {
            String protocolMsg;
            StringBuilder errMsg = new StringBuilder();
            String protocolType = dynamicObject.getString("protocoltype");
            ProtocolTypeEnum protocolTypeEnum = ProtocolTypeEnum.getValueByKey((String)protocolType);
            for (DynamicObject dy : dys) {
                DynamicObject templateDy = dy.getDynamicObject("contracttemplate");
                if (templateDy == null) continue;
                String num = templateDy.getString("number");
                Long id = templateDy.getLong("contracttype.id");
                DynamicObject groupObject = CommonRepository.queryById("hbss_contracttypes", "group.number", id);
                long contractTypeId = groupObject.getLong("group_id");
                if (!this.checkContractType(protocolTypeEnum, contractTypeId) && !this.checkOtherContract(protocolTypeEnum, contractTypeId)) continue;
                errMsg.append('\"').append(num).append('\"').append(' ');
            }
            if (HRStringUtils.isNotEmpty((String)errMsg.toString()) && HRStringUtils.isNotEmpty((String)(protocolMsg = this.getProtocolMsg(protocolTypeEnum)))) {
                return String.format(protocolMsg, errMsg.toString());
            }
        }
        return "";
    }

    private boolean checkOtherContract(ProtocolTypeEnum protocolTypeEnum, long contractTypeId) {
        return ProtocolTypeEnum.FS == protocolTypeEnum && !Objects.equals(ContractTypeCatEnum.OTHER.getPkId(), contractTypeId);
    }

    private boolean checkContractType(ProtocolTypeEnum protocolTypeEnum, long contractTypeId) {
        HashSet conSets = Sets.newHashSet((Object[])new Long[]{ContractTypeCatEnum.CON.getPkId(), ContractTypeCatEnum.OTHER.getPkId()});
        HashSet ygSets = Sets.newHashSet((Object[])new Long[]{ContractTypeCatEnum.EMP.getPkId(), ContractTypeCatEnum.OTHER.getPkId()});
        return ProtocolTypeEnum.CON == protocolTypeEnum && !conSets.contains(contractTypeId) || ProtocolTypeEnum.YG == protocolTypeEnum && !ygSets.contains(contractTypeId);
    }

    public String getProtocolMsg(ProtocolTypeEnum protocolTypeEnum) {
        if (ProtocolTypeEnum.CON == protocolTypeEnum) {
            return ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%s\u201d\u4e2d\u7684\u5408\u540c\u7c7b\u578b\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u52b3\u52a8\u5408\u540c\u6216\u8005\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractRepository_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        if (ProtocolTypeEnum.YG == protocolTypeEnum) {
            return ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%s\u201d\u4e2d\u7684\u5408\u540c\u7c7b\u578b\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u7528\u5de5\u534f\u8bae\u6216\u8005\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractRepository_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        if (ProtocolTypeEnum.FS == protocolTypeEnum) {
            return ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%s\u201d\u4e2d\u7684\u5408\u540c\u7c7b\u578b\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractRepository_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String checkCompTaskValid(DynamicObject signDy) {
        String businessType;
        DynamicObject periodTypeDy = signDy.getDynamicObject("periodtype");
        String periodUnit = signDy.getString("periodunit");
        BigDecimal period = signDy.getBigDecimal("period");
        Date endDate = signDy.getDate("enddate");
        if (HRObjectUtils.isEmpty((Object)periodTypeDy)) {
            return "";
        }
        long pkId = periodTypeDy.getLong("id");
        HashSet types = Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey()});
        if (ContractPeriodTypeEnum.COMPTASK.getPkId() == pkId && types.contains(businessType = signDy.getString("businesstype"))) {
            if (!HRObjectUtils.isEmpty((Object)period) && period.compareTo(BigDecimal.ZERO) != 0 && (HRStringUtils.isEmpty((String)periodUnit) || periodUnit.equals("0"))) {
                return ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractRepository_5", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            if ((HRObjectUtils.isEmpty((Object)period) || period.compareTo(BigDecimal.ZERO) == 0) && endDate != null) {
                return ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u4e0e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u9700\u540c\u65f6\u6709\u503c\u6216\u65e0\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContractRepository_6", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            if (!HRObjectUtils.isEmpty((Object)period) && period.compareTo(BigDecimal.ZERO) != 0 && endDate == null) {
                return ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u4e0e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u9700\u540c\u65f6\u6709\u503c\u6216\u65e0\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContractRepository_6", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public void signCompanyAndReasonFilter(BeforeFilterF7SelectEvent args, IFormView view) {
        String fieldName = args.getFieldName();
        HashSet fieldNames = Sets.newHashSet((Object[])new String[]{"actualsigncompany.name", "cancelreasontype.name", "oldcontract.actualsigncompany.name"});
        if (fieldNames.contains(fieldName)) {
            QFilter filter = null;
            if ("actualsigncompany.name".equals(fieldName) || "oldcontract.actualsigncompany.name".equals(fieldName)) {
                filter = PermissionService.getBaseDataFilterByOrg("hbss_signcompany", true);
            } else {
                Map customParams = args.getCustomParams();
                customParams.put("islistfilter", ((ListView)view).getBillFormId());
                args.setCustomParams(customParams);
                filter = PermissionService.getBaseDataFilterByOrg("hlcm_contractreason", true);
            }
            if (filter != null) {
                List qFilterList = args.getQfilters();
                QFilter enableFilter = new QFilter("status", "=", (Object)"C");
                qFilterList.add(filter);
                qFilterList.add(enableFilter);
                args.setQfilters(qFilterList);
            }
        }
    }

    public String checkOldContractStatus(DynamicObject applyBill, List<DynamicObject> contractObjects, DynamicObject erManFile) {
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean contractstatus = HRStringUtils.equals((String)ContractStatusEnum.STATUS_IN_EFFECT.getCode(), (String)contract.getString("contractstatus"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            return contractstatus && iscurrentversion;
        }).findAny();
        if (!any.isPresent()) {
            String personName = erManFile.getString("name");
            String businessTypeLocaleName = ComboUtils.getComboOptionLocaleName((DynamicObject)applyBill, (String)"businesstype");
            if (HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)applyBill.getString("protocoltype"))) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u65e0\u751f\u6548\u4e2d\u7684\u52b3\u52a8\u5408\u540c\u6863\u6848\uff0c\u4e0d\u53ef\u53d1\u8d77\u52b3\u52a8\u5408\u540c%2$s\u7533\u8bf7\u3002", (String)"ContractRepository_7", (String)"hr-hlcm-business", (Object[])new Object[0]), personName, businessTypeLocaleName);
            }
            if (HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)applyBill.getString("protocoltype"))) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u65e0\u751f\u6548\u4e2d\u7684\u7528\u5de5\u534f\u8bae\u8bb0\u5f55\uff0c\u4e0d\u53ef\u53d1\u8d77\u7528\u5de5\u534f\u8bae%2$s\u7533\u8bf7\u3002", (String)"ContractRepository_8", (String)"hr-hlcm-business", (Object[])new Object[0]), personName, businessTypeLocaleName);
            }
        }
        return "";
    }

    public DynamicObject queryById(long oldcontractId) {
        String properties = "id, empphone";
        return this.SERVICE_HELPER.queryOriginalOne(properties, new QFilter("id", "=", (Object)oldcontractId));
    }
}

