/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.common.constants.HLCMBaseConstants;
import kd.hr.hlcm.common.constants.HLCMContractApplyConstants;
import kd.hr.hlcm.common.entity.NoticeEntity;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.DateTimeUnitEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.PostypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.ComboUtils;
import kd.hr.hlcm.common.utils.DateUtil;
import kd.hr.hlcm.common.utils.IDCardUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ContractSignApplyRepository {
    private static final Log LOGGER = LogFactory.getLog(ContractSignApplyRepository.class);
    private static final Set<String> IN_AUDIT_STATUS = Sets.newHashSet((Object[])new String[]{BillStatusEnum.STATUS_STAGING.getCode(), BillStatusEnum.STATUS_RESUBMIT.getCode(), BillStatusEnum.STATUS_SUBMITED.getCode(), BillStatusEnum.STATUS_APPROVED.getCode()});
    private static final Set<String> IN_HANDLE_STATUS = Sets.newHashSet((Object[])new String[]{HandleStatusEnum.TOSUBMIT.getCombKey(), HandleStatusEnum.PROCESSIN.getCombKey()});
    private static final ContractSignApplyRepository CONTRACT_SIGN_APPLY_REPOSITORY = new ContractSignApplyRepository();
    private static final String HANDLE_STATUS_NON_TERMINATE_FLAG = "1";
    private static final String PROCESS_STATUS_NON_TERMINATE_FLAG = "2";
    private static final String SIGN_STATUS_CANCEL = "7";
    public static final HRBaseServiceHelper CONTRACT_APPLY_HELPER = new HRBaseServiceHelper("hlcm_contractapplybase");
    public static final HRBaseServiceHelper CONTRACT_HELPER = new HRBaseServiceHelper("hlcm_contractsource");
    public static final List<String> FIELD_KEYS = new ArrayList<String>();

    private ContractSignApplyRepository() {
    }

    public static ContractSignApplyRepository getInstance() {
        return CONTRACT_SIGN_APPLY_REPOSITORY;
    }

    public List<Object> getInfoByEmp(DynamicObject dynamicObject) {
        ArrayList<Object> resultData = new ArrayList<Object>();
        DynamicObject erManFile = dynamicObject.getDynamicObject("ermanfile");
        long personId = erManFile.getLong("person.id");
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG);
        HRBaseServiceHelper applyHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
        List<DynamicObject> applyObjects = Arrays.asList(applyHelper.query("ermanorg,billno,protocoltype,billstatus,handlestatus,postype,businesstype,person.id", new QFilter[]{personFilter}));
        List<DynamicObject> contractObjects = Arrays.asList(contractHelper.query("protocoltype,contractstatus,iscurrentversion,postype,signstatus,initstatus,startdate,enddate,number,businesstype,person.id", new QFilter[]{personFilter, versionFilter}));
        Map<String, Object> erManFileInfo = IHSPMFileService.getInstance().getCardFieldByErManFileId((Long)erManFile.getPkValue());
        resultData.add(applyObjects);
        resultData.add(contractObjects);
        resultData.add(erManFile);
        resultData.add(erManFileInfo);
        return resultData;
    }

    public Map<DynamicObject, List<Object>> getInfoListByEmp(List<DynamicObject> dynamicObjects) {
        HashMap<DynamicObject, List<Object>> resultMap = new HashMap<DynamicObject, List<Object>>();
        Set personIds = dynamicObjects.stream().map(dy -> dy.getLong("ermanfile.person.id")).collect(Collectors.toSet());
        List<Long> idSet = dynamicObjects.stream().map(dy -> dy.getLong("ermanfile.id")).collect(Collectors.toList());
        QFilter personFilter = new QFilter("person", "in", personIds);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG);
        HRBaseServiceHelper applyHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
        List<DynamicObject> applyObjects = Arrays.asList(applyHelper.query("billno,protocoltype,billstatus,handlestatus,postype,businesstype,empnumber,person.id", new QFilter[]{personFilter}));
        Map<Long, List<DynamicObject>> applyObjectMap = applyObjects.stream().collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        List<DynamicObject> contractObjects = Arrays.asList(contractHelper.query("protocoltype,contractstatus,iscurrentversion,postype,signstatus,initstatus,startdate,enddate,actualenddate,planenddate,number,businesstype,empnumber,person.id", new QFilter[]{personFilter, versionFilter}));
        Map<Long, List<DynamicObject>> contractObjectMap = contractObjects.stream().collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        List<Map<String, Object>> erManFileInfos = IHSPMFileService.getInstance().getAllCardFieldByErManFileIds(idSet);
        Map<Long, Map> erManFileInfoMap = erManFileInfos.stream().collect(Collectors.toMap(erManFileInfo -> Long.valueOf(erManFileInfo.get("id").toString()), erManFileInfo -> erManFileInfo));
        dynamicObjects.forEach(dy -> {
            ArrayList<Object> resultData = new ArrayList<Object>();
            long personId = dy.getLong("person.id");
            resultData.add(Optional.ofNullable(applyObjectMap.get(personId)).orElseGet(ArrayList::new));
            resultData.add(Optional.ofNullable(contractObjectMap.get(personId)).orElseGet(ArrayList::new));
            DynamicObject erManFile = dy.getDynamicObject("ermanfile");
            resultData.add(erManFile);
            resultData.add(Optional.ofNullable(erManFileInfoMap.get(erManFile.getLong("id"))).orElseGet(HashMap::new));
            resultMap.put((DynamicObject)dy, (List<Object>)resultData);
        });
        return resultMap;
    }

    public String isContractInValueValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> first = applyObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)contract.getString("protocoltype"));
            boolean billStatus = IN_AUDIT_STATUS.contains(contract.getString("billstatus"));
            boolean handlestatus = IN_HANDLE_STATUS.contains(contract.getString("handlestatus"));
            boolean idequals = !HRStringUtils.equals((String)dynamicObject.getString("id"), (String)contract.getString("id"));
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            return protocoltype && billStatus && handlestatus && idequals && postypeequals;
        }).findFirst();
        if (first.isPresent()) {
            String businessTypeName = BusinessTypeEnum.getValueByKey((String)first.get().getString("businesstype"));
            String billNo = first.get().getString("billno");
            String protocolType = dynamicObject.getString("protocoltype");
            String protocolTypeDesc = ProtocolTypeEnum.loadKDStringByKey((String)protocolType);
            String businessType = dynamicObject.getString("businesstype");
            String businessTypeDesc = BusinessTypeEnum.getValueByKey((String)businessType);
            String billDesc = protocolTypeDesc.concat(businessTypeDesc);
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u52b3\u52a8\u5408\u540c%2$s\u7533\u8bf7\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u4e0d\u53ef\u518d\u53d1\u8d77%4$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_0", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), businessTypeName, billNo, billDesc);
        }
        return "";
    }

    public String isContractExistValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)contract.getString("protocoltype"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)contract.getString("initstatus"), (String)PROCESS_STATUS_NON_TERMINATE_FLAG);
            return protocoltype && iscurrentversion && postypeequals && initstatus;
        }).findAny();
        if (!any.isPresent()) {
            String businessType = dynamicObject.getString("businesstype");
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u65e0\u52b3\u52a8\u5408\u540c\u6863\u6848\uff0c\u4e0d\u53ef\u53d1\u8d77\u52b3\u52a8\u5408\u540c%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_1", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), BusinessTypeEnum.getValueByKey((String)businessType));
        }
        return "";
    }

    public String isEmpProtocolExistValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        String posTypeId = String.valueOf(erManFileInfo.get("postype_id"));
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)posTypeId, (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)PROCESS_STATUS_NON_TERMINATE_FLAG, (String)contract.getString("initstatus"));
            return protocoltype && iscurrentversion && postypeequals && initstatus;
        }).findAny();
        if (!any.isPresent()) {
            String businessType = dynamicObject.getString("businesstype");
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u65e0\u7528\u5de5\u534f\u8bae\u8bb0\u5f55\uff0c\u4e0d\u53ef\u53d1\u8d77\u7528\u5de5\u534f\u8bae%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_2", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), BusinessTypeEnum.getValueByKey((String)businessType));
        }
        return "";
    }

    public String isContractNewestValueValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> newestContract = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)contract.getString("protocoltype"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)contract.getString("initstatus"), (String)PROCESS_STATUS_NON_TERMINATE_FLAG);
            return protocoltype && iscurrentversion && postypeequals && initstatus;
        }).max(this.buildNewestComparator());
        if (newestContract.isPresent()) {
            String businessType = dynamicObject.getString("businesstype");
            String contractStatus = newestContract.get().getString("contractstatus");
            if (HRStringUtils.equals((String)ContractStatusEnum.STATUS_NO_EFFECT.getCode(), (String)contractStatus)) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5f53\u524d\u6700\u65b0\u7684\u52b3\u52a8\u5408\u540c\u6863\u6848\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u53d1\u8d77\u52b3\u52a8\u5408\u540c%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_3", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), BusinessTypeEnum.getValueByKey((String)businessType));
            }
        }
        return "";
    }

    public String isProtocolNewestValueValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        String postypeId = String.valueOf(erManFileInfo.get("postype_id"));
        Optional<DynamicObject> newestContract = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)postypeId, (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)PROCESS_STATUS_NON_TERMINATE_FLAG, (String)contract.getString("initstatus"));
            return protocoltype && iscurrentversion && postypeequals && initstatus;
        }).max(this.buildNewestComparator());
        if (newestContract.isPresent()) {
            String businessType = dynamicObject.getString("businesstype");
            String contractStatus = newestContract.get().getString("contractstatus");
            if (HRStringUtils.equals((String)ContractStatusEnum.STATUS_NO_EFFECT.getCode(), (String)contractStatus)) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5f53\u524d\u6700\u65b0\u7684\u7528\u5de5\u534f\u8bae\u8bb0\u5f55\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u53d1\u8d77\u7528\u5de5\u534f\u8bae%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_4", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), BusinessTypeEnum.getValueByKey((String)businessType));
            }
        }
        return "";
    }

    public String isContractToBeValueValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)contract.getString("protocoltype"));
            boolean contractstatus = HRStringUtils.equals((String)ContractStatusEnum.STATUS_PENDING.getCode(), (String)contract.getString("contractstatus"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)contract.getString("initstatus"), (String)PROCESS_STATUS_NON_TERMINATE_FLAG);
            return protocoltype && contractstatus && iscurrentversion && postypeequals && initstatus;
        }).findAny();
        if (any.isPresent()) {
            String protocolType = dynamicObject.getString("protocoltype");
            String protocolTypeDesc = ProtocolTypeEnum.loadKDStringByKey((String)protocolType);
            String businessType = dynamicObject.getString("businesstype");
            String applyDesc = protocolTypeDesc.concat(BusinessTypeEnum.getValueByKey((String)businessType));
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u5f85\u751f\u6548\u7684\u52b3\u52a8\u5408\u540c\u6863\u6848\uff0c\u4e0d\u53ef\u53d1\u8d77%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_5", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), applyDesc);
        }
        return "";
    }

    public String isContractValuingValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)contract.getString("protocoltype"));
            boolean contractstatus = HRStringUtils.equals((String)ContractStatusEnum.STATUS_IN_EFFECT.getCode(), (String)contract.getString("contractstatus"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)contract.getString("initstatus"), (String)PROCESS_STATUS_NON_TERMINATE_FLAG);
            return protocoltype && contractstatus && iscurrentversion && postypeequals && initstatus;
        }).findAny();
        if (any.isPresent()) {
            String protocolType = dynamicObject.getString("protocoltype");
            String protocolTypeDesc = ProtocolTypeEnum.loadKDStringByKey((String)protocolType);
            String businessType = dynamicObject.getString("businesstype");
            String applyDesc = protocolTypeDesc.concat(BusinessTypeEnum.getValueByKey((String)businessType));
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u751f\u6548\u4e2d\u7684\u52b3\u52a8\u5408\u540c\u6863\u6848\uff0c\u4e0d\u53ef\u53d1\u8d77%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_6", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), applyDesc);
        }
        return "";
    }

    public String isProtocolInValueValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> first = applyObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            boolean billStatus = IN_AUDIT_STATUS.contains(contract.getString("billstatus"));
            boolean handlestatus = IN_HANDLE_STATUS.contains(contract.getString("handlestatus"));
            boolean idequals = !HRStringUtils.equals((String)dynamicObject.getString("id"), (String)contract.getString("id"));
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            List<String> businessTypeList = Arrays.asList(BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey());
            boolean businesstype = businessTypeList.contains(contract.getString("businesstype"));
            return protocoltype && billStatus && handlestatus && idequals && postypeequals && businesstype;
        }).findFirst();
        if (first.isPresent()) {
            String businessType = dynamicObject.getString("businesstype");
            String businessTypeName = BusinessTypeEnum.getValueByKey((String)first.get().getString("businesstype"));
            String billNo = first.get().getString("billno");
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u7528\u5de5\u534f\u8bae%2$s\u7533\u8bf7\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u4e0d\u53ef\u518d\u53d1\u8d77\u52b3\u52a8\u5408\u540c%4$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_7", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), businessTypeName, billNo, BusinessTypeEnum.getValueByKey((String)businessType));
        }
        return "";
    }

    public String isEmpProtocolOnValueValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> first = applyObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            boolean billStatus = IN_AUDIT_STATUS.contains(contract.getString("billstatus"));
            boolean handlestatus = IN_HANDLE_STATUS.contains(contract.getString("handlestatus"));
            boolean idequals = !HRStringUtils.equals((String)dynamicObject.getString("id"), (String)contract.getString("id"));
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            return protocoltype && billStatus && handlestatus && idequals && postypeequals;
        }).findFirst();
        if (first.isPresent()) {
            String businessTypeName = BusinessTypeEnum.getValueByKey((String)first.get().getString("businesstype"));
            String billNo = first.get().getString("billno");
            String businessType = dynamicObject.getString("businesstype");
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u7528\u5de5\u534f\u8bae%2$s\u7533\u8bf7\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u4e0d\u53ef\u518d\u53d1\u8d77\u7528\u5de5\u534f\u8bae%4$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_8", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), businessTypeName, billNo, BusinessTypeEnum.getValueByKey((String)businessType));
        }
        return "";
    }

    public String isFixedRequiredField(DynamicObject dynamicObject) {
        DynamicObject periodtype = dynamicObject.getDynamicObject("periodtype");
        if (!HRObjectUtils.isEmpty((Object)periodtype)) {
            Object periodTypeId = periodtype.getPkValue();
            if (Objects.equals(ContractPeriodTypeEnum.FIXED.getPkId(), periodTypeId)) {
                StringBuilder errMsg = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"ContractSignApplyRepository_47", (String)"hr-hlcm-business", (Object[])new Object[0]));
                ArrayList errFields = Lists.newArrayListWithExpectedSize((int)2);
                if (HRObjectUtils.isEmpty((Object)dynamicObject.get("enddate")) || HRObjectUtils.isEmpty((Object)dynamicObject.get("period")) || dynamicObject.getBigDecimal("period").compareTo(BigDecimal.ZERO) == 0) {
                    if (HRObjectUtils.isEmpty((Object)dynamicObject.get("enddate"))) {
                        errFields.add(ResManager.loadKDString((String)"\u201c\u5408\u540c\u7ed3\u675f\u65e5\u671f\u201d", (String)"ContractSignApplyRepository_48", (String)"hr-hlcm-business", (Object[])new Object[0]));
                    }
                    if (HRObjectUtils.isEmpty((Object)dynamicObject.get("period")) || dynamicObject.getBigDecimal("period").compareTo(BigDecimal.ZERO) == 0) {
                        errFields.add(ResManager.loadKDString((String)"\u201c\u5408\u540c\u671f\u9650\u201d", (String)"ContractSignApplyRepository_49", (String)"hr-hlcm-business", (Object[])new Object[0]));
                    }
                    return errMsg.append(String.join((CharSequence)"\u3001", errFields)).toString();
                }
            }
        }
        return "";
    }

    public String isProtocolToBeValueValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            boolean contractstatus = HRStringUtils.equals((String)ContractStatusEnum.STATUS_PENDING.getCode(), (String)contract.getString("contractstatus"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)PROCESS_STATUS_NON_TERMINATE_FLAG, (String)contract.getString("initstatus"));
            return protocoltype && contractstatus && iscurrentversion && postypeequals && initstatus;
        }).findAny();
        if (any.isPresent()) {
            String businessType = dynamicObject.getString("businesstype");
            String protocoltype = dynamicObject.getString("protocoltype");
            String protocolTypeDesc = ProtocolTypeEnum.loadKDStringByKey((String)protocoltype);
            String applyDesc = protocolTypeDesc.concat(BusinessTypeEnum.getValueByKey((String)businessType));
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u5f85\u751f\u6548\u7684\u7528\u5de5\u534f\u8bae\u8bb0\u5f55\uff0c\u4e0d\u53ef\u53d1\u8d77%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_9", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), applyDesc);
        }
        return "";
    }

    public String isProtocolValuingValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            boolean contractstatus = HRStringUtils.equals((String)ContractStatusEnum.STATUS_IN_EFFECT.getCode(), (String)contract.getString("contractstatus"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            boolean initstatus = HRStringUtils.equals((String)PROCESS_STATUS_NON_TERMINATE_FLAG, (String)contract.getString("initstatus"));
            return protocoltype && contractstatus && iscurrentversion && postypeequals && initstatus;
        }).findAny();
        if (any.isPresent()) {
            String businessType = dynamicObject.getString("businesstype");
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u751f\u6548\u4e2d\u7684\u7528\u5de5\u534f\u8bae\u8bb0\u5f55\uff0c\u4e0d\u53ef\u53d1\u8d77\u7528\u5de5\u534f\u8bae%2$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_10", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), BusinessTypeEnum.getValueByKey((String)businessType));
        }
        return "";
    }

    public String isProtocolToBeValueOrValuingValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Optional<DynamicObject> any = contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            List<String> contractstatusList = Arrays.asList("0", HANDLE_STATUS_NON_TERMINATE_FLAG);
            boolean contractstatus = contractstatusList.contains(contract.getString("contractstatus"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean postypeequals = HRStringUtils.equals((String)String.valueOf(erManFileInfo.get("postype_id")), (String)contract.getString("postype.id"));
            return protocoltype && contractstatus && iscurrentversion && postypeequals;
        }).findAny();
        if (any.isPresent()) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u751f\u6548\u4e2d/\u5f85\u751f\u6548\u7684\u7528\u5de5\u534f\u8bae\u8bb0\u5f55\uff0c\u5408\u540c\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u52b3\u52a8\u5408\u540c\u7eed\u7b7e\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_11", (String)"hr-hlcm-business", (Object[])new Object[0]), erManFile.getString("name"), any.get().getString("number"));
        }
        return "";
    }

    public String isProtocolCrossValidate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        DynamicObject[] contractDys = (DynamicObject[])contractObjects.stream().filter(contract -> {
            boolean protocoltype = HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)contract.getString("protocoltype"));
            List<String> contractstatusList = Arrays.asList("0", HANDLE_STATUS_NON_TERMINATE_FLAG);
            boolean contractstatus = contractstatusList.contains(contract.getString("contractstatus"));
            boolean iscurrentversion = contract.getBoolean("iscurrentversion");
            boolean initstatus = HRStringUtils.equals((String)contract.getString("initstatus"), (String)PROCESS_STATUS_NON_TERMINATE_FLAG);
            return protocoltype && contractstatus && iscurrentversion && initstatus;
        }).toArray(DynamicObject[]::new);
        String errorMsg = this.checkDateCross(erManFile.getString("name"), contractDys, dynamicObject, ProtocolTypeEnum.YG.getCombKey());
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            return errorMsg;
        }
        return "";
    }

    public String isContractCrossValidate(DynamicObject dynamicObject) {
        DynamicObject erManFile = dynamicObject.getDynamicObject("ermanfile");
        long personId = dynamicObject.getLong("person.id");
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter statusFilter = new QFilter("contractstatus", "in", Arrays.asList("0", HANDLE_STATUS_NON_TERMINATE_FLAG));
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey());
        QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG);
        DynamicObject[] contractDys = CONTRACT_HELPER.queryOriginalArray("startdate,enddate,number,actualenddate,planenddate", new QFilter[]{personFilter, protocolTypeFilter, statusFilter, isCurFilter});
        String errorMsg = this.checkDateCross(erManFile.getString("name"), contractDys, dynamicObject, ProtocolTypeEnum.CON.getCombKey());
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            return errorMsg;
        }
        return "";
    }

    private String checkDateCross(String name, DynamicObject[] contractDys, DynamicObject applyDy, String protocolType) {
        Date applyStartDate = applyDy.getDate("startdate");
        Date applyEndDate = applyDy.getDate("enddate");
        LOGGER.info("ContractSignApplyRepository.checkDateCross applyStartDate:{},applyEndDate:{}", (Object)applyStartDate, (Object)applyEndDate);
        if (HRObjectUtils.isEmpty((Object)applyStartDate)) {
            return "";
        }
        for (DynamicObject contract : contractDys) {
            Date ygStartDate = contract.getDate("startdate");
            Date ygEndDate = contract.getDate("actualenddate");
            ygEndDate = HRObjectUtils.isEmpty((Object)ygEndDate) ? contract.getDate("planenddate") : ygEndDate;
            boolean isCross = DateUtil.isInterSection((Date)applyStartDate, (Date)applyEndDate, (Date)ygStartDate, (Date)(ygEndDate = HRObjectUtils.isEmpty((Object)ygEndDate) ? contract.getDate("enddate") : ygEndDate));
            if (!isCross) continue;
            if (HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)protocolType)) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u7684\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3001\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e0e\u52b3\u52a8\u5408\u540c\u6863\u6848\u4e2d\u5408\u540c\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\u5b58\u5728\u4ea4\u53c9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignApplyRepository_12", (String)"hr-hlcm-business", (Object[])new Object[0]), name, contract.getString("number"));
            }
            if (!HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)protocolType)) continue;
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u7684\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3001\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e0e\u7528\u5de5\u534f\u8bae\u8bb0\u5f55\u4e2d\u5408\u540c\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\u5b58\u5728\u4ea4\u53c9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignApplyRepository_13", (String)"hr-hlcm-business", (Object[])new Object[0]), name, contract.getString("number"));
        }
        return "";
    }

    public String isDateStartEndValidate(DynamicObject dynamicObject) {
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        if (!HRObjectUtils.isEmpty((Object)endDate) && !HRObjectUtils.isEmpty((Object)startDate) && endDate.compareTo(startDate) < 0) {
            return ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u3002", (String)"ContractSignApplyRepository_15", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String isEntryDateStartEndValidate(DynamicObject dynamicObject) {
        Date startDate = dynamicObject.getDate("entrystartdate");
        Date endDate = dynamicObject.getDate("entryenddate");
        if (!HRObjectUtils.isEmpty((Object)endDate) && !HRObjectUtils.isEmpty((Object)startDate) && endDate.compareTo(startDate) < 0) {
            return ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u3002", (String)"ContractSignApplyRepository_15", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String checkEmpContractUseStartDate(Date startDate, Date useStartDate) {
        long dateDiff;
        if (ProxyUtils.isNewNeedCheckUseDate() && !HRObjectUtils.isEmpty((Object)startDate) && !HRObjectUtils.isEmpty((Object)useStartDate) && (dateDiff = HRDateTimeUtils.dateDiff((String)"d", (Date)useStartDate, (Date)startDate)) < 0L) {
            return ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u3002", (String)"ContractSignApplyRepository_27", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String isDateEndSignValidate(DynamicObject dynamicObject) {
        Date endDate = dynamicObject.getDate("enddate");
        Date signDate = dynamicObject.getDate("signeddate");
        BigDecimal period = dynamicObject.getBigDecimal("period");
        DynamicObject periodTypeDy = dynamicObject.getDynamicObject("periodtype");
        if (HRObjectUtils.isEmpty((Object)endDate) || HRObjectUtils.isEmpty((Object)signDate) || HRObjectUtils.isEmpty((Object)periodTypeDy) || period == null || BigDecimal.ZERO.compareTo(period) == 0) {
            return "";
        }
        if (signDate.after(endDate) && !Objects.equals(periodTypeDy.getPkValue(), ContractPeriodTypeEnum.NONFIXED.getPkId())) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u9884\u8ba1\u7b7e\u8ba2\u65e5\u671f\u5e94\u65e9\u4e8e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u201c%1$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_16", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)endDate));
        }
        return "";
    }

    public ImmutablePair<Boolean, String> isDateStartOldEndValidate(DynamicObject dynamicObject) {
        DynamicObject oldContract = dynamicObject.getDynamicObject("oldcontract");
        if (HRObjectUtils.isEmpty((Object)oldContract)) {
            LOGGER.info("oldContract isEmpty");
            return ImmutablePair.of((Object)Boolean.TRUE, (Object)"");
        }
        Date startDate = dynamicObject.getDate("startdate");
        Date oldEndDate = oldContract.getDate("enddate");
        if (HRObjectUtils.isEmpty((Object)startDate) || HRObjectUtils.isEmpty((Object)oldEndDate)) {
            return ImmutablePair.of((Object)Boolean.TRUE, (Object)"");
        }
        String contractStatus = oldContract.getString("contractstatus");
        if (HRStringUtils.equals((String)ContractStatusEnum.STATUS_NO_EFFECT.getCode(), (String)contractStatus)) {
            Date oldActualEndDate = oldContract.getDate("actualenddate");
            Date nextDay = HRDateTimeUtils.getNextDay((Date)oldActualEndDate);
            if (!DateUtils.isSameDay((Date)nextDay, (Date)startDate)) {
                String errorTip = ResManager.loadKDString((String)"\u7eed\u7b7e\u5408\u540c\u7684\u5f00\u59cb\u65e5\u671f\u65e5\u671f\u5fc5\u987b\u4e3a\u539f\u5408\u540c\u5b9e\u9645\u7ed3\u675f\u65e5\u671f\u7684\u7b2c\u4e8c\u5929\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_52", (String)"hr-hlcm-business", (Object[])new Object[]{HRDateTimeUtils.formatDate((Date)nextDay)});
                return ImmutablePair.of((Object)Boolean.FALSE, (Object)errorTip);
            }
        } else {
            Date oldStartDate = oldContract.getDate("startdate");
            if (!HRDateTimeUtils.dayAfter((Date)startDate, (Date)oldStartDate)) {
                String errorTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u201c%1$s\u201d\u5fc5\u987b\u665a\u4e8e\u539f\u5408\u540c\u7684\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_53", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)oldStartDate));
                return ImmutablePair.of((Object)Boolean.FALSE, (Object)errorTip);
            }
            Date nextDay = HRDateTimeUtils.getNextDay((Date)oldEndDate);
            if (!DateUtils.isSameDay((Date)nextDay, (Date)startDate)) {
                String warnTip = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7eed\u7b7e\u5408\u540c\u7684\u5f00\u59cb\u65e5\u671f\u4e0d\u7b49\u4e8e\u539f\u5408\u540c\u7ed3\u675f\u65e5\u671f\u7684\u7b2c\u4e8c\u5929\u201c%s\u201d\u3002", (String)"ContractSignApplyRepository_17", (String)"hr-hlcm-business", (Object[])new Object[]{HRDateTimeUtils.formatDate((Date)nextDay)});
                return ImmutablePair.of((Object)Boolean.TRUE, (Object)warnTip);
            }
        }
        return ImmutablePair.of((Object)Boolean.TRUE, (Object)"");
    }

    public String renewStartEndDate4OldContractValidate(DynamicObject signBill) {
        ImmutablePair<Boolean, String> validateResult = this.isDateStartOldEndValidate(signBill);
        if (!((Boolean)validateResult.getLeft()).booleanValue()) {
            return (String)validateResult.getRight();
        }
        DynamicObject oldContract = signBill.getDynamicObject("oldcontract");
        if (HRObjectUtils.isEmpty((Object)oldContract)) {
            return "";
        }
        Date oldEndDate = oldContract.getDate("enddate");
        Date endDate = signBill.getDate("enddate");
        if (Objects.isNull(oldEndDate) || Objects.isNull(endDate)) {
            return "";
        }
        String contractStatus = oldContract.getString("contractstatus");
        if (HRStringUtils.equals((String)contractStatus, (String)ContractStatusEnum.STATUS_IN_EFFECT.getCode()) && !HRDateTimeUtils.dayBefore((Date)oldEndDate, (Date)endDate)) {
            String errorTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201c%1$s\u201d\u5fc5\u987b\u665a\u4e8e\u539f\u5408\u540c\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_54", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)endDate), HRDateTimeUtils.formatDate((Date)oldEndDate));
            return errorTip;
        }
        return "";
    }

    public String isDateStartOldEnd2Validate(DynamicObject dynamicObject) {
        Date startDate = dynamicObject.getDate("startdate");
        DynamicObject oldContract = (DynamicObject)dynamicObject.get("oldcontract");
        if (HRObjectUtils.isEmpty((Object)oldContract)) {
            LOGGER.info("ContractSignApplyRepository.isDateStartOldEnd2Validate======oldContract======isEmpty...");
            return "";
        }
        Date oldEndDate = oldContract.getDate("enddate");
        if (HRObjectUtils.isEmpty((Object)startDate) || HRObjectUtils.isEmpty((Object)oldEndDate)) {
            LOGGER.info("ContractSignApplyRepository.isDateStartOldEnd2Validate======startDate||oldEndDate======isEmpty...");
            return "";
        }
        if (startDate.after(oldEndDate)) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u539f\u5408\u540c\u7684\u5408\u540c\u7ed3\u675f\u65e5\u671f%1$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_31", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)oldEndDate));
        }
        return "";
    }

    public String isDateStartOldStartValidate(DynamicObject dynamicObject) {
        Date startDate = dynamicObject.getDate("startdate");
        DynamicObject oldContract = (DynamicObject)dynamicObject.get("oldcontract");
        if (HRObjectUtils.isEmpty((Object)oldContract)) {
            LOGGER.info("ContractSignApplyRepository.isDateStartOldStartValidate======oldContract======isEmpty...");
            return "";
        }
        Date oldStartDate = oldContract.getDate("startdate");
        if (HRObjectUtils.isEmpty((Object)startDate) || HRObjectUtils.isEmpty((Object)oldStartDate)) {
            LOGGER.info("ContractSignApplyRepository.isDateStartOldStartValidate======startDate||oldStartDate======isEmpty...");
            return "";
        }
        if (startDate.before(oldStartDate)) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u539f\u5408\u540c\u7684\u5408\u540c\u5f00\u59cb\u65e5\u671f%1$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_34", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)oldStartDate));
        }
        return "";
    }

    public String isDateStartOldEnd3Validate(DynamicObject dynamicObject) {
        Date cancelDate = dynamicObject.getDate("canceldate");
        if (HRObjectUtils.isEmpty((Object)cancelDate)) {
            LOGGER.info("cancelDate isEmpty...");
            return "";
        }
        DynamicObject oldContract = (DynamicObject)dynamicObject.get("oldcontract");
        if (HRObjectUtils.isEmpty((Object)oldContract)) {
            LOGGER.info("oldContract isEmpty...");
            return "";
        }
        Date oldEndDate = oldContract.getDate("enddate");
        String businessType = ComboUtils.getComboOptionLocaleName((DynamicObject)dynamicObject, (String)"businesstype");
        if (!HRObjectUtils.isEmpty((Object)oldEndDate) && oldEndDate.before(cancelDate)) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c%1$s\u65e5\u671f\u201c%2$s\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u539f\u5408\u540c\u7684\u7ed3\u675f\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u5408\u540c%1$s\u65e5\u671f\u3002", (String)"ContractSignApplyRepository_32", (String)"hr-hlcm-business", (Object[])new Object[0]), businessType, HRDateTimeUtils.formatDate((Date)cancelDate), HRDateTimeUtils.formatDate((Date)oldEndDate));
        }
        Date startDate = oldContract.getDate("startdate");
        if (!HRObjectUtils.isEmpty((Object)startDate) && cancelDate.before(startDate)) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c%1$s\u65e5\u671f\u201c%2$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u539f\u5408\u540c\u7684\u5f00\u59cb\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u5408\u540c%1$s\u65e5\u671f\u3002", (String)"ContractSignApplyRepository_37", (String)"hr-hlcm-business", (Object[])new Object[0]), businessType, HRDateTimeUtils.formatDate((Date)cancelDate), HRDateTimeUtils.formatDate((Date)startDate));
        }
        return "";
    }

    public String checkOldContractSignStatus(DynamicObject applyBill) {
        DynamicObject oldContract = applyBill.getDynamicObject("oldcontract");
        DynamicObject erManFile = applyBill.getDynamicObject("ermanfile");
        if (HRObjectUtils.isEmpty((Object)oldContract) || HRObjectUtils.isEmpty((Object)erManFile)) {
            LOGGER.info("oldContract or erManFile isEmpty...");
            return "";
        }
        String signStatus = oldContract.getString("signstatus");
        if (!Lists.newArrayList((Object[])new String[]{"4", "5"}).contains(signStatus)) {
            return "";
        }
        String businessType = applyBill.getString("businesstype");
        String businessTypeLocaleName = ComboUtils.getComboOptionLocaleName((DynamicObject)applyBill, (String)"businesstype");
        String personName = applyBill.getString("empname");
        String signStatusLocaleName = ComboUtils.getComboOptionLocaleName((DynamicObject)oldContract, (String)"signstatus");
        if (Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()}).contains(businessType)) {
            String protocolType = oldContract.getString("protocoltype");
            if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.CON.getCombKey())) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5f53\u524d\u52b3\u52a8\u5408\u540c\u6863\u6848\u5df2\u53d1\u751f%2$s\uff0c\u4e0d\u53ef\u53d1\u8d77\u52b3\u52a8\u5408\u540c%3$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_33", (String)"hr-hlcm-business", (Object[])new Object[0]), personName, signStatusLocaleName, businessTypeLocaleName);
            }
            if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.YG.getCombKey())) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5f53\u524d\u7528\u5de5\u534f\u8bae\u5df2\u53d1\u751f%2$s\uff0c\u4e0d\u53ef\u53d1\u8d77\u7528\u5de5\u534f\u8bae%3$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_35", (String)"hr-hlcm-business", (Object[])new Object[0]), personName, signStatusLocaleName, businessTypeLocaleName);
            }
        }
        String contractStatus = oldContract.getString("contractstatus");
        if (HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType) && HRStringUtils.equals((String)contractStatus, (String)ContractStatusEnum.STATUS_IN_EFFECT.getCode())) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5f53\u524d\u52b3\u52a8\u5408\u540c\u6863\u6848\u5df2\u53d1\u751f%2$s\uff0c\u4e0d\u53ef\u53d1\u8d77\u52b3\u52a8\u5408\u540c%3$s\u7533\u8bf7\u3002", (String)"ContractSignApplyRepository_33", (String)"hr-hlcm-business", (Object[])new Object[0]), personName, signStatusLocaleName, businessTypeLocaleName);
        }
        return "";
    }

    public ImmutablePair<Boolean, BigDecimal> calcContractPeriod(DynamicObject dynamicObject, int scale) {
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        ImmutablePair immutablePair = ImmutablePair.of((Object)Boolean.FALSE, (Object)BigDecimal.ZERO);
        if (HRObjectUtils.isEmpty((Object)startDate) || HRObjectUtils.isEmpty((Object)endDate)) {
            return immutablePair;
        }
        Instant startInstant = startDate.toInstant();
        Instant endInstant = endDate.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDate startLocalDate = LocalDateTime.ofInstant(startInstant, zone).toLocalDate();
        LocalDate endLocalDate = LocalDateTime.ofInstant(endInstant, zone).toLocalDate();
        long durationToDatabase = ChronoUnit.DAYS.between(startLocalDate, endLocalDate);
        BigDecimal bigDecimal = BigDecimal.valueOf(durationToDatabase + 1L);
        BigDecimal year = new BigDecimal(365);
        BigDecimal divide = bigDecimal.divide(year, scale, RoundingMode.HALF_UP);
        return ImmutablePair.of((Object)Boolean.TRUE, (Object)divide);
    }

    public String isCheckContractUseStartDate(DynamicObject dynamicObject, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        Date startDate = dynamicObject.getDate("startdate");
        Date useStartDate = Optional.ofNullable(erManFileInfo.get("startdate")).map(Date.class::cast).orElse(null);
        ArrayList errorMsg = Lists.newArrayListWithExpectedSize((int)8);
        if (ProxyUtils.isNewNeedCheckUseDate() && !HRObjectUtils.isEmpty((Object)startDate) && !HRObjectUtils.isEmpty((Object)useStartDate)) {
            long dateDiff = HRDateTimeUtils.dateDiff((String)"d", (Date)useStartDate, (Date)startDate);
            if (dateDiff < 0L) {
                errorMsg.add(ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f", (String)"ContractSignApplyRepository_51", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entryEntityCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryEntityCollection) {
                Date entryStartDate = row.getDate("entrystartdate");
                if (entryStartDate == null || HRDateTimeUtils.dateDiff((String)"d", (Date)useStartDate, (Date)entryStartDate) >= 0L || Objects.equals(ContractTypeCatEnum.CON.getPkId(), row.getLong("entrycontracttype.group.id"))) continue;
                String contractTypeName = row.getString("entrycontracttype.name");
                errorMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e3a%1$s\u7684\u5408\u540c\u6216\u534f\u8bae\uff0c\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f", (String)"ContractSignApplyRepository_50", (String)"hr-hlcm-business", (Object[])new Object[0]), contractTypeName));
            }
        }
        return String.join((CharSequence)",", errorMsg);
    }

    public ImmutablePair<Boolean, String> isCheckContractUseStartDate(DynamicObject dynamicObject) {
        Date startDate = dynamicObject.getDate("startdate");
        long erManFileId = dynamicObject.getDynamicObject("ermanfile").getLong("id");
        Map<String, Object> erManFileInfo = IHSPMFileService.getInstance().getCardFieldByErManFileId(erManFileId);
        Date useStartDate = (Date)erManFileInfo.get("startdate");
        Long posTypeId = HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("postype_id"));
        if (!HRObjectUtils.isEmpty((Object)startDate) && !HRObjectUtils.isEmpty((Object)useStartDate)) {
            long dateDiff = HRDateTimeUtils.dateDiff((String)"d", (Date)useStartDate, (Date)startDate);
            if (dateDiff > 30L && !Objects.equals(posTypeId, PostypeEnum.EXPATRIATE.getCombKey())) {
                String errMsg = ResManager.loadKDString((String)"\u6839\u636e\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u52b3\u52a8\u5408\u540c\u6cd5\u300b\uff0c\u4f01\u4e1a\u5e94\u5f53\u81ea\u7528\u5de5\u4e4b\u65e5\u8d77\u4e00\u4e2a\u6708\u5185\u8ba2\u7acb\u52b3\u52a8\u5408\u540c\uff0c\u8bf7\u4fee\u6539\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3002", (String)"ContractSignApplyRepository_18", (String)"hr-hlcm-business", (Object[])new Object[0]);
                return ImmutablePair.of((Object)Boolean.TRUE, (Object)errMsg);
            }
            if (ProxyUtils.isNewNeedCheckUseDate() && dateDiff < 0L) {
                String errMsg = ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u3002", (String)"ContractSignApplyRepository_36", (String)"hr-hlcm-business", (Object[])new Object[0]);
                return ImmutablePair.of((Object)Boolean.FALSE, (Object)errMsg);
            }
            LOGGER.info("startDate|{},useStartDate|{}", (Object)HRDateTimeUtils.formatDate((Date)startDate), (Object)HRDateTimeUtils.formatDate((Date)useStartDate));
        }
        return ImmutablePair.of((Object)Boolean.TRUE, (Object)"");
    }

    public String isCheckContractPeriod(DynamicObject contractDy) {
        BigDecimal periodMonth;
        String empName = contractDy.getString("empname");
        DynamicObject periodTypeDy = contractDy.getDynamicObject("periodtype");
        long posTypeId = contractDy.getLong("postype.id");
        int periodUnit = contractDy.getInt("periodunit");
        if (HRObjectUtils.isEmpty((Object)periodTypeDy) || Objects.equals(posTypeId, PostypeEnum.EXPATRIATE.getCombKey())) {
            return "";
        }
        Object periodTypeId = periodTypeDy.getPkValue();
        String periodTypeName = periodTypeDy.getString("name");
        String probationPeriodUnit = contractDy.getString("probationperiodunit");
        BigDecimal probationPeriodMonth = ContractSignUtils.calcProbationPeriodMonth(contractDy);
        if (Objects.equals(periodTypeId, ContractPeriodTypeEnum.FIXED.getPkId()) && periodUnit == 0) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u56fa\u5b9a\u671f\u9650\u7c7b\u578b\u201d\uff0c\u5408\u540c\u671f\u9650\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_46", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        BigDecimal period = contractDy.getBigDecimal("period");
        if (null == period || BigDecimal.ZERO.compareTo(period) == 0) {
            return "";
        }
        DateTimeUnitEnum unitEnumByOrdinal = DateTimeUnitEnum.getUnitEnumByOrdinal((int)periodUnit);
        switch (unitEnumByOrdinal) {
            case YEAR: {
                periodMonth = period.multiply(new BigDecimal(12));
                break;
            }
            case MONTH: {
                periodMonth = period;
                break;
            }
            case WEEK: {
                periodMonth = period.multiply(new BigDecimal(7)).divide(new BigDecimal(30), 1, RoundingMode.HALF_UP);
                break;
            }
            case DAY: {
                periodMonth = period.divide(new BigDecimal(30), 1, RoundingMode.HALF_UP);
                break;
            }
            default: {
                return "";
            }
        }
        assert (periodMonth != null);
        if (periodMonth.compareTo(BigDecimal.ZERO) == 0) {
            int scale = 5;
            ImmutablePair<Boolean, BigDecimal> immutablePair = ContractSignApplyRepository.getInstance().calcContractPeriod(contractDy, scale);
            if (((Boolean)immutablePair.getLeft()).booleanValue()) {
                periodMonth = (BigDecimal)immutablePair.getRight();
            }
        }
        if (Objects.equals(periodTypeId, ContractPeriodTypeEnum.FIXED.getPkId()) && periodMonth.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal periodFormat = period.setScale(1, RoundingMode.HALF_UP);
            String periodUnitText = ComboUtils.getComboOptionLocaleName((DynamicObject)contractDy, (String)"periodunit");
            if (periodMonth.compareTo(new BigDecimal(3)) < 0 && probationPeriodMonth.compareTo(BigDecimal.ZERO) > 0) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a%1$s\uff0c\u5408\u540c\u671f\u9650\u4e3a%2$s%5$s\uff0c\u4e0d\u5f97\u7ea6\u5b9a\u8bd5\u7528\u671f\uff0c\u68c0\u6d4b\u5230%3$s\u8bd5\u7528\u671f\u9650\u4e3a%4$s\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignApplyRepository_19", (String)"hr-hlcm-business", (Object[])new Object[0]), periodTypeName, periodFormat, empName, probationPeriodUnit, periodUnitText);
            }
            if (periodMonth.compareTo(new BigDecimal(12)) < 0 && periodMonth.compareTo(new BigDecimal(3)) >= 0 && probationPeriodMonth.compareTo(BigDecimal.ONE) > 0) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a%1$s\uff0c\u5408\u540c\u671f\u9650\u4e3a%2$s%5$s\uff0c\u8bd5\u7528\u671f\u4e0d\u5f97\u8d85\u8fc71\u4e2a\u6708\uff0c\u68c0\u6d4b\u5230%3$s\u8bd5\u7528\u671f\u9650\u4e3a%4$s\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignApplyRepository_20", (String)"hr-hlcm-business", (Object[])new Object[0]), periodTypeName, periodFormat, empName, probationPeriodUnit, periodUnitText);
            }
            if (periodMonth.compareTo(new BigDecimal(36)) < 0 && periodMonth.compareTo(new BigDecimal(12)) >= 0 && probationPeriodMonth.compareTo(new BigDecimal(2)) > 0) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a%1$s\uff0c\u5408\u540c\u671f\u9650\u4e3a%2$s%5$s\uff0c\u8bd5\u7528\u671f\u4e0d\u5f97\u8d85\u8fc72\u4e2a\u6708\uff0c\u68c0\u6d4b\u5230%3$s\u8bd5\u7528\u671f\u9650\u4e3a%4$s\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignApplyRepository_21", (String)"hr-hlcm-business", (Object[])new Object[0]), periodTypeName, periodFormat, empName, probationPeriodUnit, periodUnitText);
            }
            if (periodMonth.compareTo(new BigDecimal(36)) >= 0 && probationPeriodMonth.compareTo(new BigDecimal(6)) > 0) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a%1$s\uff0c\u5408\u540c\u671f\u9650\u4e3a%2$s%5$s\uff0c\u8bd5\u7528\u671f\u4e0d\u5f97\u8d85\u8fc76\u4e2a\u6708\uff0c\u68c0\u6d4b\u5230%3$s\u8bd5\u7528\u671f\u9650\u4e3a%4$s\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignApplyRepository_22", (String)"hr-hlcm-business", (Object[])new Object[0]), periodTypeName, periodFormat, empName, probationPeriodUnit, periodUnitText);
            }
        }
        return "";
    }

    public ImmutablePair<String, String> isTerminateBill(Long pkId) {
        DynamicObject signBill = CONTRACT_APPLY_HELPER.queryOne("handlestatus,activityins.id", (Object)pkId);
        if (Objects.isNull(signBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"UnSubmitContractApplyTemplate_13", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        String handleStatus = signBill.getString("handlestatus");
        String handleStatusDesc = ComboUtils.getComboOptionLocaleName((DynamicObject)signBill, (String)"handlestatus");
        if (HLCMBaseConstants.HANDLE_STATUSLIST.contains(handleStatus)) {
            return ImmutablePair.of((Object)HANDLE_STATUS_NON_TERMINATE_FLAG, (Object)handleStatusDesc);
        }
        Long activityInsId = signBill.getLong("activityins.id");
        return this.handlerSigningStatus(activityInsId);
    }

    public ImmutablePair<String, String> handlerSigningStatus(Long activityInsId) {
        LOGGER.info("handlerSigningStatus#activityInsId={}", (Object)activityInsId);
        DynamicObject activityDy = HLCMCommonRepository.queryDynamicObject("hlcm_activity", "processstatus", new QFilter("activityIns", "=", (Object)activityInsId));
        LOGGER.info("handlerSigningStatus#activityDy={}", (Object)activityDy);
        if (activityDy != null) {
            String processStatus = activityDy.getString("processstatus");
            return ImmutablePair.of((Object)PROCESS_STATUS_NON_TERMINATE_FLAG, (Object)processStatus);
        }
        return ImmutablePair.of((Object)"", (Object)"");
    }

    public NoticeEntity isUnSubmitBill(Long pkId) {
        DynamicObject contractInfo = CONTRACT_APPLY_HELPER.queryOriginalOne("billstatus", (Object)pkId);
        String billStatus = contractInfo.getString("billstatus");
        HashSet canUnSubmit = Sets.newHashSet((Object[])new String[]{BillStatusEnum.STATUS_SUBMITED.getCode(), BillStatusEnum.STATUS_APPROVED.getCode()});
        if (!canUnSubmit.contains(billStatus)) {
            return new NoticeEntity(Integer.valueOf(NoticeEntity.NoticeLevel.ERROR.getVal()), ResManager.loadKDString((String)"\u53ea\u53ef\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u3001\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u4e0d\u53ef\u64a4\u9500\u3002", (String)"ContractSignApplyRepository_25", (String)"hr-hlcm-business", (Object[])new Object[]{BillStatusEnum.getValueByKey((String)billStatus)}));
        }
        AtomicBoolean isError = new AtomicBoolean(false);
        QFilter signApplyFilter = new QFilter("signapply", "=", (Object)pkId);
        DynamicObject[] activityDys = ContractSignUtils.ACTIVITY_HELPER.queryOriginalArray("id,activityins.taskstatus", new QFilter[]{signApplyFilter});
        Arrays.asList(activityDys).forEach(activity -> {
            String taskStatus = activity.getString("activityins.taskstatus");
            if (HRStringUtils.equals((String)"COMPLETED", (String)taskStatus) || HRStringUtils.equals((String)"TERMINATED", (String)taskStatus)) {
                isError.set(true);
            }
        });
        if (isError.get()) {
            return new NoticeEntity(Integer.valueOf(NoticeEntity.NoticeLevel.ERROR.getVal()), ResManager.loadKDString((String)"\u4e0d\u53ef\u64a4\u9500\u4e1a\u52a1\u6d3b\u52a8\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210/\u5df2\u7ec8\u6b62\u7684\u6d3b\u52a8\u3002", (String)"ContractSignApplyRepository_26", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        return new NoticeEntity();
    }

    public DynamicObject getOldContract(DynamicObject applyObject) {
        long personId = applyObject.getLong("person.id");
        Long posTypeId = applyObject.getLong("postype.id");
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey());
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter postCateGoryFilter = new QFilter("postype", "=", (Object)posTypeId);
        List<String> statusList = Arrays.asList(ContractStatusEnum.STATUS_NO_EFFECT.getCode(), ContractStatusEnum.STATUS_PENDING.getCode(), ContractStatusEnum.STATUS_IN_EFFECT.getCode());
        QFilter signFilter = new QFilter("signstatus", "!=", (Object)SIGN_STATUS_CANCEL);
        QFilter contractStatusFilter = new QFilter("contractstatus", "in", statusList);
        QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG).and("datastatus", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG);
        DynamicObject[] contractDy = ContractSignUtils.CONTRACT_HELPER.query("id,startdate,enddate,contractstatus,actualsigncompany,actualenddate", new QFilter[]{protocolTypeFilter, personFilter, postCateGoryFilter, contractStatusFilter, isCurFilter, signFilter}, "id desc");
        return this.getNewestContract(contractDy).orElse(null);
    }

    public DynamicObject getCancelContractByErManFile(DynamicObject dataEntity) {
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey());
        QFilter personFilter = new QFilter("person", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "person")));
        QFilter posTypeFilter = new QFilter("postype", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "postype")));
        QFilter contractStatusFilter = new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode());
        QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG);
        DynamicObject[] contractDy = ContractSignUtils.CONTRACT_HELPER.query("startdate,enddate,number,suggestsigncompany,actualsigncompany,contractstatus,empname,cardtype,cardnumber,householdregister,residentialaddress,empphone,actualsigncompanyhis,periodtype,periodunit,period", new QFilter[]{protocolTypeFilter, personFilter, contractStatusFilter, posTypeFilter, isCurFilter}, "id desc");
        return this.getNewestContract(contractDy).orElse(null);
    }

    public int getRenewCount(DynamicObject signBill) {
        DynamicObject oldContract = signBill.getDynamicObject("oldcontract");
        String businessType = signBill.getString("businesstype");
        if (Objects.isNull(oldContract)) {
            LOGGER.warn("renew select oldContract is null,curBusinessType|{}", (Object)businessType);
            return 0;
        }
        DynamicObject preContract = HLCMCommonRepository.queryDynamicObjectByPk("hlcm_contract", "renewcount", oldContract.getPkValue());
        int preRenewCount = preContract.getInt("renewcount");
        LOGGER.info("preRenewCount|{},curBusinessType|{}", (Object)preRenewCount, (Object)businessType);
        if (HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.RENEW.getCombKey())) {
            return preRenewCount + 1;
        }
        return preRenewCount;
    }

    public DynamicObject getSignStatusDynamicObject(DynamicObject contractInfo) {
        Long pkValue = (Long)contractInfo.getPkValue();
        return CONTRACT_APPLY_HELPER.queryOne("id,billstatus,handleStatus,businesstype,isexistsworkflow", (Object)pkValue);
    }

    public void setContractCode(DynamicObject signBill) {
        boolean signprotocol;
        String billFormId;
        String businessTypeEnum;
        long pkId = signBill.getLong("id");
        List<String> businessType = Arrays.asList(BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey());
        if (businessType.contains(businessTypeEnum = ContractSignUtils.getBusinessTypeByBillFormId(billFormId = signBill.getDataEntityType().getName())) && (pkId == 0L || !CONTRACT_APPLY_HELPER.isExists((Object)pkId))) {
            boolean isTrue;
            String htNumber = ContractSignUtils.getNumber(billFormId, true, String.valueOf(signBill.getLong("ermanorg.id")));
            LOGGER.info("ContractSignApplyRepository.setContractCode.htNumber={}|| contractNum = {}", (Object)htNumber, (Object)signBill.getString("contractnumber"));
            String fileTypeName = ContractSignUtils.getContractNameBySignBill(billFormId);
            boolean bl = isTrue = !ContractSignUtils.codeRuleIsModify(fileTypeName, String.valueOf(signBill.getLong("ermanorg.id"))) || HRStringUtils.equals((String)"LDHT-20020231-00001", (String)signBill.getString("contractnumber"));
            if (!HRStringUtils.isEmpty((String)htNumber) && isTrue) {
                signBill.set("contractnumber", (Object)htNumber);
            }
            LOGGER.info("ContractSignApplyRepository========setContractCode======number|{}======htNumber|{}", (Object)signBill.getString("empnumber"), (Object)signBill.getString("contractnumber"));
            boolean signother = signBill.getBoolean("issignother");
            if (signother) {
                this.setEntryContractCode(signBill.getDynamicObjectCollection("entryentity"));
            }
        }
        if (HRStringUtils.equals((String)businessTypeEnum, (String)BusinessTypeEnum.CANCEL.getCombKey()) && (pkId == 0L || !CONTRACT_APPLY_HELPER.isExists((Object)pkId)) && (signprotocol = signBill.getBoolean("issignprotocol"))) {
            this.setEntryContractCode(signBill.getDynamicObjectCollection("entryentity"));
        }
    }

    private void setEntryContractCode(DynamicObjectCollection entryCol) {
        if (entryCol != null && entryCol.size() > 0) {
            for (DynamicObject entry : entryCol) {
                boolean isTrue = HRStringUtils.equals((String)"LDHT-20020231-00001", (String)entry.getString("entrycontractnumber"));
                if (!isTrue) continue;
                String htNumber = ContractSignUtils.getNumber("hlcm_otheragreements", true);
                entry.set("entrycontractnumber", (Object)htNumber);
            }
        }
    }

    public String isCrossBillsValidate(DynamicObject contractInfo, List<String> numbers) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("hlcm");
        DynamicObject erManFile = (DynamicObject)contractInfo.get("ermanfile");
        Map<String, Object> erManFileInfo = IHSPMFileService.getInstance().getCardFieldByErManFileId((Long)erManFile.getPkValue());
        if (CollectionUtils.isEmpty(erManFileInfo)) {
            LOGGER.info("ContractSignApplyRepository========crossValidate======isEmpty======employeeId|{}", erManFile.getPkValue());
            return "";
        }
        Long employeeId = Long.valueOf(String.valueOf(erManFileInfo.get("employee_id")));
        String empName = (String)erManFileInfo.get("name");
        HashMap<String, String> params = new HashMap<String, String>();
        String employeeIdStr = String.valueOf(employeeId);
        params.put("employeeId", employeeIdStr);
        String crossResultInfo = (String)cache.get(employeeIdStr);
        try {
            Map crossResult;
            if (HRStringUtils.isEmpty((String)crossResultInfo)) {
                crossResult = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getCrossValidateBills", (Object[])new Object[]{params});
                LOGGER.info("ContractSignApplyRepository========crossValidate======employeeId|{}==========numbers|{}==========crossResult|{}", new Object[]{employeeId, numbers, JSONObject.toJSONString((Object)crossResult)});
                cache.put(employeeIdStr, (Object)JSONObject.toJSONString((Object)crossResult), 60);
            } else {
                crossResult = (Map)JSON.parseObject((String)crossResultInfo, Map.class);
            }
            return this.compareCategoryId(crossResult, numbers, empName);
        }
        catch (Exception ex) {
            LOGGER.error("ContractSignApplyRepository========crossValidate==========employeeId|{}==========numbers|{}==========error..", new Object[]{employeeId, numbers, ex});
            return "";
        }
    }

    private String compareCategoryId(Map<String, Object> crossResult, List<String> numbers, String empName) {
        if (Boolean.FALSE.equals(crossResult.get("success"))) {
            LOGGER.info("crossValidate#errorMsg|{}", crossResult.get("errorMsg"));
            return "";
        }
        List results = (List)crossResult.get("data");
        if (CollectionUtils.isEmpty((Collection)results)) {
            LOGGER.info("crossValidate#results isEmpty");
            return "";
        }
        for (Map data : results) {
            String chgCategoryId = String.valueOf(data.get("chgCategoryId"));
            String billNo = String.valueOf(data.get("billNo"));
            if (!numbers.contains(chgCategoryId)) continue;
            if (HLCMContractApplyConstants.QUITE_NUMBERS.contains(chgCategoryId)) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u79bb\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractSignApplyRepository_28", (String)"hr-hlcm-business", (Object[])new Object[0]), empName, billNo);
            }
            if (HLCMContractApplyConstants.TRANSFER_NUMBERS.contains(chgCategoryId)) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u8c03\u52a8\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractSignApplyRepository_29", (String)"hr-hlcm-business", (Object[])new Object[0]), empName, billNo);
            }
            if (!HLCMContractApplyConstants.RETIRE_NUMBERS.contains(chgCategoryId)) continue;
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u9000\u4f11\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractSignApplyRepository_30", (String)"hr-hlcm-business", (Object[])new Object[0]), empName, billNo);
        }
        return "";
    }

    public String checkIsOtherProtocol(DynamicObject otherProtocolBill) {
        Long id = otherProtocolBill.getLong("contracttype.id");
        DynamicObject groupObject = CommonRepository.queryById("hbss_contracttypes", "group.number", id);
        String contractTypeNum = groupObject.getString("group.number");
        if (!HRStringUtils.equals((String)"1030_S", (String)contractTypeNum)) {
            return ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5c5e\u4e8e\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff1b", (String)"ContractSignApplyRepository_38", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String checkPaperSign(DynamicObjectCollection dys, String tmpMsg) {
        for (DynamicObject dy : dys) {
            String temSignWay;
            DynamicObject templateDy = dy.getDynamicObject("contracttemplate");
            if (templateDy == null || (temSignWay = templateDy.getString("signway")).contains(PROCESS_STATUS_NON_TERMINATE_FLAG)) continue;
            tmpMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5408\u540c\u7684\u7b7e\u7f72\u65b9\u5f0f\u4e3a\u7eb8\u8d28\u7b7e\u7f72\uff0c\u5408\u540c\u7b7e\u7f72\u6a21\u677f\u5fc5\u987b\u9009\u62e9\u7b7e\u7f72\u65b9\u5f0f\u5305\u542b\u7eb8\u8d28\u7b7e\u7f72\u7684\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_59", (String)"hr-hlcm-business", (Object[])new Object[0]);
            break;
        }
        return tmpMsg;
    }

    public String checkEleSign(DynamicObjectCollection dys, String tmpMsg) {
        for (DynamicObject templateDyEntry : dys) {
            String tempSignWay;
            DynamicObject templateDy = templateDyEntry.getDynamicObject("contracttemplate");
            if (templateDy == null || (tempSignWay = templateDy.getString("signway")).contains(HANDLE_STATUS_NON_TERMINATE_FLAG)) continue;
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5408\u540c\u7684\u7b7e\u7f72\u65b9\u5f0f\u4e3a\u7535\u5b50\u7b7e\u7f72\uff0c\u5408\u540c\u7b7e\u7f72\u6a21\u677f\u5fc5\u987b\u9009\u62e9\u7b7e\u7f72\u65b9\u5f0f\u5305\u542b\u7535\u5b50\u7b7e\u7f72\u7684\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_57", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return null;
    }

    public String checkEleSignOnly(DynamicObjectCollection dys) {
        for (DynamicObject templateDyEntry : dys) {
            String tempSignWay;
            DynamicObject templateDy = templateDyEntry.getDynamicObject("contracttemplate");
            if (templateDy == null || (tempSignWay = templateDy.getString("signway")).contains(HANDLE_STATUS_NON_TERMINATE_FLAG)) continue;
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5408\u540c\u7684\u7b7e\u7f72\u65b9\u5f0f\u4e3a\u7535\u5b50\u7b7e\u7f72\uff0c\u5408\u540c\u7b7e\u7f72\u6a21\u677f\u5fc5\u987b\u9009\u62e9\u7b7e\u7f72\u65b9\u5f0f\u5305\u542b\u7535\u5b50\u7b7e\u7f72\u7684\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_57", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String contractTypeCatValidate(DynamicObject dynamicObject) {
        Long id = dynamicObject.getLong("contracttype.id");
        DynamicObject groupObject = CommonRepository.queryById("hbss_contracttypes", "group.number", id);
        long contractTypeId = groupObject.getLong("group_id");
        String protocolType = dynamicObject.getString("protocoltype");
        ProtocolTypeEnum protocolTypeEnum = ProtocolTypeEnum.getValueByKey((String)protocolType);
        if (ProtocolTypeEnum.CON == protocolTypeEnum && !Objects.equals(ContractTypeCatEnum.CON.getPkId(), contractTypeId)) {
            return ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5c5e\u4e8e\u52b3\u52a8\u5408\u540c\uff1b", (String)"ContractSignApplyRepository_39", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        if (ProtocolTypeEnum.YG == protocolTypeEnum && !Objects.equals(ContractTypeCatEnum.EMP.getPkId(), contractTypeId)) {
            return ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5c5e\u4e8e\u7528\u5de5\u534f\u8bae\uff1b", (String)"ContractSignApplyRepository_40", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        if (ProtocolTypeEnum.FS == protocolTypeEnum && !Objects.equals(ContractTypeCatEnum.OTHER.getPkId(), contractTypeId)) {
            return ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5c5e\u4e8e\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff1b", (String)"ContractSignApplyRepository_38", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String isContractTypeValidate(DynamicObject dynamicObject) {
        Long id = dynamicObject.getLong("contracttype.id");
        DynamicObject groupObject = CommonRepository.queryById("hbss_contracttypes", "group.number", id);
        long groupId = groupObject.getLong("group.id");
        if (!Objects.equals(ContractTypeCatEnum.CON.getPkId(), groupId)) {
            return ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5c5e\u4e8e\u52b3\u52a8\u5408\u540c\uff1b", (String)"ContractSignApplyRepository_39", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String checkIsEmpProtocol(DynamicObject dynamicObject) {
        Long id = dynamicObject.getLong("contracttype.id");
        DynamicObject groupObject = CommonRepository.queryById("hbss_contracttypes", "group.number", id);
        long groupId = groupObject.getLong("group.id");
        if (!Objects.equals(ContractTypeCatEnum.EMP.getPkId(), groupId)) {
            return ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5c5e\u4e8e\u7528\u5de5\u534f\u8bae\uff1b", (String)"ContractSignApplyRepository_40", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String checkEntryIsOtherProtocol(DynamicObject dynamicObject) {
        DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entryentity");
        if (entryCol != null && entryCol.size() > 0) {
            for (DynamicObject entry : entryCol) {
                Long groupId = entry.getLong("entrycontracttype.group.id");
                if (Objects.equals(ContractTypeCatEnum.OTHER.getPkId(), groupId)) continue;
                return ResManager.loadKDString((String)"\u5206\u5f55\u884c\u4e2d\u5b58\u5728\u5408\u540c\u7c7b\u578b\u4e0d\u5c5e\u4e8e\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\u7684\u6570\u636e\uff1b", (String)"ContractSignApplyRepository_61", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public String checkCancelDate(DynamicObject dataEntity) {
        Date cancelDate = dataEntity.getDate("canceldate");
        DynamicObject oldContract = dataEntity.getDynamicObject("oldcontract");
        if (HRObjectUtils.isEmpty((Object)cancelDate) || HRObjectUtils.isEmpty((Object)oldContract)) {
            return "";
        }
        String businessType = dataEntity.getString("businesstype");
        Date startDate = HRDateTimeUtils.truncateDate((Date)oldContract.getDate("startdate"));
        Date endDate = HRDateTimeUtils.truncateDate((Date)oldContract.getDate("enddate"));
        Date cancelDateStr = HRDateTimeUtils.truncateDate((Date)cancelDate);
        String errHead = "";
        errHead = HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType) ? ResManager.loadKDString((String)"\u5408\u540c\u89e3\u9664\u65e5\u671f", (String)"ContractSignApplyRepository_44", (String)"hr-hlcm-business", (Object[])new Object[0]) : (HRStringUtils.equals((String)BusinessTypeEnum.STOP.getCombKey(), (String)businessType) ? ResManager.loadKDString((String)"\u5408\u540c\u7ec8\u6b62\u65e5\u671f", (String)"ContractSignApplyRepository_45", (String)"hr-hlcm-business", (Object[])new Object[0]) : "");
        String errHeadResult = errHead.concat(HRDateTimeUtils.formatDate((Date)cancelDateStr));
        if (HRDateTimeUtils.dayBefore((Date)cancelDateStr, (Date)startDate)) {
            return String.format(ResManager.loadKDString((String)"%1$s\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u539f\u5408\u540c\u7684\u5f00\u59cb\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539%3$s\u3002", (String)"ContractSignApplyRepository_42", (String)"hr-hlcm-business", (Object[])new Object[0]), errHeadResult, HRDateTimeUtils.formatDate((Date)startDate), errHead);
        }
        if (Objects.nonNull(endDate) && HRDateTimeUtils.dayAfter((Date)cancelDateStr, (Date)endDate)) {
            return String.format(ResManager.loadKDString((String)"%1$s\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u539f\u5408\u540c\u7684\u7ed3\u675f\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539%3$s\u3002", (String)"ContractSignApplyRepository_43", (String)"hr-hlcm-business", (Object[])new Object[0]), errHeadResult, HRDateTimeUtils.formatDate((Date)endDate), errHead);
        }
        return "";
    }

    public boolean isExistsContractNumber(String contractNumber) {
        QFilter applyFilter = new QFilter("contractnumber", "=", (Object)contractNumber);
        return CONTRACT_APPLY_HELPER.isExists(applyFilter);
    }

    public String isExistsContractNumber(DynamicObject dataEntity) {
        QFilter initStatusFilter;
        QFilter contractNumberFilter;
        QFilter versionFilter;
        HRBaseServiceHelper contractHelper;
        boolean exists;
        String contractNumber = dataEntity.getString("contractnumber");
        String tip = ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7\u201c%s\u201d\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_41", (String)"hr-hlcm-business", (Object[])new Object[]{contractNumber});
        String billFormId = dataEntity.getDataEntityType().getName();
        String contractName = ContractSignUtils.getContractNameBySignBill(billFormId);
        boolean existCodeRule = ContractSignUtils.isExistByCurrentDy(contractName);
        if (existCodeRule && HRStringUtils.equals((String)contractNumber, (String)"LDHT-20020231-00001")) {
            return "";
        }
        if (!existCodeRule && !HRStringUtils.isEmpty((String)contractNumber) || ContractSignUtils.codeRuleIsModify(contractName, String.valueOf(dataEntity.getLong("ermanorg.id")))) {
            QFilter applyFilter = new QFilter("contractnumber", "=", (Object)contractNumber);
            QFilter businessTypeFilter = new QFilter("businesstype", "not in", (Object)new String[]{BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()});
            applyFilter.and(businessTypeFilter);
            DynamicObject dynamicObject = CONTRACT_APPLY_HELPER.queryOne("id", applyFilter);
            if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                long id = dynamicObject.getLong("id");
                if (HRObjectUtils.isEmpty((Object)dataEntity) || dataEntity.getLong("id") != id) {
                    return tip;
                }
            }
        }
        if (exists = (contractHelper = new HRBaseServiceHelper("hlcm_contractsource")).isExists(new QFilter[]{versionFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG), contractNumberFilter = new QFilter("number", "=", (Object)contractNumber), initStatusFilter = new QFilter("initstatus", "=", (Object)PROCESS_STATUS_NON_TERMINATE_FLAG)})) {
            LOGGER.info("contractNumber|{} is exists in init", (Object)contractNumber);
            return tip;
        }
        if (ContractSignUtils.isContractNotStop(billFormId)) {
            return this.isExistsConEntryContractNumber(dataEntity);
        }
        return "";
    }

    private String isExistsConEntryContractNumber(DynamicObject dataEntity) {
        QFilter initStatusFilter;
        QFilter contractNumberFilter;
        QFilter versionFilter;
        HRBaseServiceHelper contractHelper;
        DynamicObject[] sourceArray;
        DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection("entryentity");
        if (!dataEntity.getBoolean("issignother") || dys == null || dys.isEmpty()) {
            LOGGER.info("issignother disable or entry data is empty");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> numbers = new HashSet<String>(dys.size());
        for (DynamicObject row : dys) {
            String number = row.getString("entrycontractnumber");
            if (HRStringUtils.equals((String)number, (String)"LDHT-20020231-00001") || !HRStringUtils.isNotEmpty((String)number) || numbers.add(number)) continue;
            this.addErrorInfo(sb, number);
        }
        if (numbers.isEmpty()) {
            LOGGER.info("all entrycontractnumber is empty");
            return "";
        }
        QFilter applyFilter = new QFilter("contractnumber", "in", numbers);
        applyFilter.or("entryentity.entrycontractnumber", "in", numbers);
        DynamicObject[] dyArray = CONTRACT_APPLY_HELPER.query("contractnumber,entryentity.entrycontractnumber", new QFilter[]{applyFilter});
        HashSet<String> hasTip = new HashSet<String>(dys.size());
        long pkId = dataEntity.getLong("id");
        String contractNumber = dataEntity.getString("contractnumber");
        hasTip.add(contractNumber);
        if (dyArray != null && dyArray.length > 0) {
            HashSet<String> numberList = new HashSet<String>(8);
            for (DynamicObject applyDy : dyArray) {
                if (applyDy.getLong("id") == pkId) continue;
                numberList.add(applyDy.getString("contractnumber"));
                DynamicObjectCollection datas = applyDy.getDynamicObjectCollection("entryentity");
                if (datas == null || datas.isEmpty()) continue;
                for (DynamicObject data : datas) {
                    numberList.add(data.getString("entrycontractnumber"));
                }
            }
            for (DynamicObject dy : dys) {
                String num = dy.getString("entrycontractnumber");
                if (num == null || num.equals(contractNumber) || !numberList.contains(num)) continue;
                this.addErrorInfo(sb, num);
                hasTip.add(num);
            }
        }
        if ((sourceArray = (contractHelper = new HRBaseServiceHelper("hlcm_contractsource")).query("number", new QFilter[]{versionFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG), contractNumberFilter = new QFilter("number", "in", numbers), initStatusFilter = new QFilter("initstatus", "=", (Object)PROCESS_STATUS_NON_TERMINATE_FLAG)})) != null && sourceArray.length > 0) {
            Set existNumbers = Arrays.stream(sourceArray).map(val -> val.getString("number")).collect(Collectors.toSet());
            for (DynamicObject dy : dys) {
                String num = dy.getString("entrycontractnumber");
                if (!existNumbers.contains(num) || hasTip.contains(num)) continue;
                this.addErrorInfo(sb, num);
            }
        }
        return sb.toString();
    }

    private void addErrorInfo(StringBuilder sb, String contractNumber) {
        String tip = ResManager.loadKDString((String)"\u5206\u5f55\u5408\u540c\u7f16\u53f7\u201c%s\u201d\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSignApplyRepository_60", (String)"hr-hlcm-business", (Object[])new Object[]{contractNumber});
        sb.append(tip);
    }

    public String checkIDCard(DynamicObject dy) {
        long cardTypeId;
        String cardNum = dy.getString("cardnumber");
        DynamicObject cardType = dy.getDynamicObject("cardtype");
        if (HRStringUtils.isNotEmpty((String)cardNum) && cardType != null && (cardTypeId = cardType.getLong("id")) == 1010L && !IDCardUtils.validIdentityCardNo(null, (String)"CN01", (String)cardNum)) {
            String msg = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"Validator_5", (String)"hr-hlcm-business", (Object[])new Object[0]);
            return msg;
        }
        return "";
    }

    private Optional<DynamicObject> getNewestContract(DynamicObject[] contracts) {
        Comparator<DynamicObject> multipleComparator = this.buildNewestComparator();
        return Stream.of(contracts).max(multipleComparator);
    }

    private Comparator<DynamicObject> buildNewestComparator() {
        Comparator<DynamicObject> contractStatusComparator = Comparator.comparing(dy -> dy.getString("contractstatus"));
        Comparator<DynamicObject> comparingStartDate = Comparator.comparing(dy -> dy.getDate("startdate"));
        Comparator<DynamicObject> comparingId = Comparator.comparingLong(dy -> dy.getLong("id"));
        Comparator<DynamicObject> multipleComparing = contractStatusComparator.thenComparing(comparingStartDate).thenComparing(comparingId);
        return multipleComparing;
    }

    public DynamicObject getByContractNumber(String selectProperties, String contractNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("contractnumber", "=", (Object)contractNumber)};
        return HRStringUtils.isEmpty((String)selectProperties) ? CONTRACT_APPLY_HELPER.loadDynamicObject(filters) : CONTRACT_APPLY_HELPER.queryOne(selectProperties, filters);
    }

    public String existFutureContract(DynamicObject dynamicObject) {
        QFilter protocolTypeFilter;
        QFilter futureFilter;
        QFilter currentVersionFilter;
        QFilter posTypeFilter;
        String businessType = dynamicObject.getString("businesstype");
        long erManFileId = dynamicObject.getLong("ermanfile.id");
        if (!Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()}).contains(businessType) || HRObjectUtils.isEmpty((Object)erManFileId)) {
            return "";
        }
        Map<String, Object> erManFileInfo = IHSPMFileService.getInstance().getCardFieldByErManFileId(erManFileId);
        long personId = HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get(String.format(Locale.ROOT, "%s_id", "person")));
        long posTypeId = HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("postype_id"));
        String protocolType = dynamicObject.getString("protocoltype");
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        DynamicObject[] futureContracts = HLCMCommonRepository.queryDynamicObjects("hlcm_contractsource", "number", personFilter, posTypeFilter = new QFilter("postype", "=", (Object)posTypeId), currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)HANDLE_STATUS_NON_TERMINATE_FLAG), futureFilter = new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_PENDING.getCode()), protocolTypeFilter = new QFilter("protocoltype", "=", (Object)protocolType));
        if (futureContracts.length > 0) {
            String numbers = Stream.of(futureContracts).map(contract -> contract.getString("number")).collect(Collectors.joining(","));
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u7684\u5f85\u751f\u6548\u5408\u540c\u5c06\u4f1a\u4e00\u5e76\u5931\u6548\uff0c\u5408\u540c\u7f16\u53f7\u4e3a\u201c%s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractSignApplyRepository_55", (String)"hr-hlcm-business", (Object[])new Object[0]), numbers);
        }
        return "";
    }

    static {
        FIELD_KEYS.add("billno");
        FIELD_KEYS.add("businesstype");
        FIELD_KEYS.add("signstatus");
        FIELD_KEYS.add("businessstatus");
        FIELD_KEYS.add("handlestatus");
        FIELD_KEYS.add("activityins.id");
        FIELD_KEYS.add("ermanfile");
        FIELD_KEYS.add("startdate");
        FIELD_KEYS.add("enddate");
        FIELD_KEYS.add("signeddate");
        FIELD_KEYS.add("oldcontract");
        FIELD_KEYS.add("protocoltype");
        FIELD_KEYS.add("person.id");
        FIELD_KEYS.add("empname");
        FIELD_KEYS.add("empnumber");
        FIELD_KEYS.add("periodtype");
        FIELD_KEYS.add("number");
        FIELD_KEYS.add("period");
        FIELD_KEYS.add("probationperiod");
        FIELD_KEYS.add("probationunit");
        FIELD_KEYS.add("probationperiodunit");
        FIELD_KEYS.add("contractnumber");
        FIELD_KEYS.add("usestartdate");
        FIELD_KEYS.add("postype");
        FIELD_KEYS.add("periodunit");
        FIELD_KEYS.add("signway");
        FIELD_KEYS.add("actualsigncompany");
        FIELD_KEYS.add("entryentity.contracttemplate");
        FIELD_KEYS.add("entryentity.texthis");
    }
}

