/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.domian.repository.ContractApplyRepository;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.common.enums.PreWarnPersonStatusEnum;

public class HiredPersonRepository {
    HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hlcm_hiredperson");
    private static final HiredPersonRepository HIRED_PERSON_REPOSITORY = new HiredPersonRepository();

    private HiredPersonRepository() {
    }

    public static HiredPersonRepository getInstance() {
        return HIRED_PERSON_REPOSITORY;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return this.SERVICE_HELPER.generateEmptyDynamicObject();
    }

    public void save(DynamicObject dynamicObject) {
        this.SERVICE_HELPER.saveOne(dynamicObject);
    }

    public int geHiredUnSignedCount() {
        QFilter statusFilter = new QFilter("startstatus", "!=", (Object)PreWarnPersonStatusEnum.ARCHIVE.getCombKey());
        QFilter ruleFilter = IHRCSService.getInstance().getCurrUserDataRuleByEntityNumberAndPermItemId("hlcm_hiredperson", "47150e89000000ac");
        HasPermOrgResult orgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"hlcm", (String)"hlcm_hiredperson", (String)"47150e89000000ac");
        if (!HRObjectUtils.isEmpty((Object)orgResult) && !orgResult.hasAllOrgPerm()) {
            List hasPermOrgs = orgResult.getHasPermOrgs();
            ruleFilter = HRObjectUtils.isEmpty((Object)ruleFilter) ? new QFilter("ermanorg", "in", (Object)hasPermOrgs) : ruleFilter.and(new QFilter("ermanorg", "in", (Object)hasPermOrgs));
        }
        return this.SERVICE_HELPER.count("hlcm_hiredperson", new QFilter[]{statusFilter, ruleFilter});
    }

    public void updateIsStarSignTerminateByApplyIds(Object[] applyIds) {
        DynamicObject[] personIdsDataByApplyIds = ContractApplyRepository.getInstance().getPersonIdsDataByApplyIds(applyIds);
        Object[] personIds = Arrays.stream(personIdsDataByApplyIds).map(dynamicObject -> dynamicObject.get("person.id")).toArray();
        DynamicObject[] prewarns = this.SERVICE_HELPER.query("startstatus", new QFilter[]{new QFilter("person.id", "in", (Object)personIds)});
        Arrays.stream(prewarns).forEach(dynamicObject -> dynamicObject.set("startstatus", (Object)PreWarnPersonStatusEnum.PROCESSEND.getCombKey()));
        this.SERVICE_HELPER.update(prewarns);
    }

    public void updateStartStatus(Object[] personIds, PreWarnPersonStatusEnum preWarnPersonStatus) {
        DynamicObject[] preWarns = this.SERVICE_HELPER.query("startstatus", new QFilter[]{new QFilter("person.id", "in", (Object)personIds)});
        Arrays.stream(preWarns).forEach(dynamicObject -> dynamicObject.set("startstatus", (Object)preWarnPersonStatus.getCombKey()));
        this.SERVICE_HELPER.update(preWarns);
    }
}

