/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;

public class PreWarnRepository {
    private HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hlcm_prewarn");
    private static final PreWarnRepository PRE_WARN_REPOSITORY = new PreWarnRepository();

    private PreWarnRepository() {
    }

    public static PreWarnRepository getInstance() {
        return PRE_WARN_REPOSITORY;
    }

    public int getCountByWarningType(String warningType) {
        String entityNumber = String.format(Locale.ROOT, "hlcm_prewarn_type%slist", warningType);
        QFilter ruleFilter = IHRCSService.getInstance().getCurrUserDataRuleByEntityNumberAndPermItemId(entityNumber, "47150e89000000ac");
        HasPermOrgResult orgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"hlcm", (String)entityNumber, (String)"47150e89000000ac");
        if (!HRObjectUtils.isEmpty((Object)orgResult) && !orgResult.hasAllOrgPerm()) {
            List hasPermOrgs = orgResult.getHasPermOrgs();
            ruleFilter = HRObjectUtils.isEmpty((Object)ruleFilter) ? new QFilter("ermanorg", "in", (Object)hasPermOrgs) : ruleFilter.and(new QFilter("ermanorg", "in", (Object)hasPermOrgs));
        }
        QFilter typeFilter = new QFilter("warntype", "=", (Object)warningType);
        return this.SERVICE_HELPER.count("hlcm_prewarn", new QFilter[]{typeFilter, ruleFilter});
    }

    public void deletePreWarn2(long personId, long posTypeId, String protocolType) {
        ContractRepository contractRepository = ContractRepository.getInstance();
        if (contractRepository.existWaitEffect(personId, posTypeId, protocolType) || contractRepository.isAllInvalid(personId, posTypeId, protocolType)) {
            QFilter personFilter = new QFilter("person", "=", (Object)personId);
            QFilter posTypeFilter = new QFilter("contract.postype", "=", (Object)posTypeId);
            QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)protocolType);
            this.SERVICE_HELPER.deleteByFilter(new QFilter[]{posTypeFilter, personFilter, protocolTypeFilter});
        }
    }
}

