/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.common.template;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.business.domian.service.common.TemplateAnnotation;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.SignStatusEnum;

@TemplateAnnotation(operateKey="archive")
public class ArchiveTemplate
implements MulSelectConfirmTemplate {
    protected static final Set<String> BILL_STATUS_SET = Sets.newHashSet((Object[])new String[]{BillStatusEnum.STATUS_APPROVED.getCode(), BillStatusEnum.STATUS_PASS.getCode()});

    @Override
    public String getName() {
        return ResManager.loadKDString((String)"\u786e\u8ba4\u5f52\u6863", (String)"ArchiveTemplate_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getFileName() {
        return ResManager.loadKDString((String)"\u786e\u8ba4\u5f52\u6863\u6570\u636e", (String)"ArchiveTemplate_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getEmptySelectMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u786e\u8ba4\u5f52\u6863\u7684\u5355\u636e\u3002", (String)"ArchiveTemplate_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getSingleOkSuccessMessage() {
        return ResManager.loadKDString((String)"\u786e\u8ba4\u5f52\u6863\u6210\u529f\u3002", (String)"ArchiveTemplate_3", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] dynamicObjects) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(signBill -> {
            String signStatus = signBill.getString("signstatus");
            String billStatus = signBill.getString("billstatus");
            String handleStatus = signBill.getString("handlestatus");
            String result = null;
            if (!HRStringUtils.equals((String)signStatus, (String)SignStatusEnum.COMPLETE_SIGN.getCombKey())) {
                result = ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25\uff0c\u53ea\u53ef\u5bf9\u7b7e\u7f72\u72b6\u6001\u4e3a\u201c\u5df2\u5b8c\u6210\u7b7e\u7f72\u201d\u7684\u6570\u636e\u8fdb\u884c\u5f52\u6863\u3002", (String)"ArchiveTemplate_4", (String)"hr-hlcm-business", (Object[])new Object[0]);
            } else if (!BILL_STATUS_SET.contains(billStatus)) {
                result = ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25\uff0c\u53ea\u53ef\u5bf9\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u4e2d\u201d\u6216\u201c\u5ba1\u6279\u901a\u8fc7\u4e14\u5f85\u751f\u6548\u201d\u7684\u5355\u636e\u8fdb\u884c\u5f52\u6863\u3002", (String)"ArchiveTemplate_5", (String)"hr-hlcm-business", (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.ARCHIVE.getCombKey())) {
                result = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u4e1a\u52a1\u5904\u7406\u72b6\u6001\u4e3a\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u518d\u6b21\u5f52\u6863\u3002", (String)"ArchiveTemplate_6", (String)"hr-hlcm-business", (Object[])new Object[0]);
            } else {
                LOGGER.info("signStatus|{},billStatus|{},handleStatus|{}", new Object[]{signStatus, billStatus, handleStatus});
            }
            resultMap.put(signBill.getLong("id"), result);
        });
        return resultMap;
    }

    @Override
    public Map<Long, String> doOperation(List<Long> ids) {
        DynamicObject[] signBills;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        for (DynamicObject signBill : signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids)) {
            String result = ISignManageService.getInstance().confirmArchiveHandler(signBill);
            if (!HRStringUtils.isNotEmpty((String)result)) continue;
            resultMap.put(signBill.getLong("id"), result);
        }
        return resultMap;
    }

    @Override
    public void singleOkCancelBox(IFormView formView, Object pkValue, ConfirmCallBackListener confirmCallBackListener) {
        formView.showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5f52\u6863\u540e\uff0c%s\u7b7e\u7f72\u7684\u5408\u540c\u5c06\u81ea\u52a8\u5f52\u6863\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"ArchiveTemplate_7", (String)"hr-hlcm-business", (Object[])new Object[]{this.getActivityEmpName(formView, pkValue)}), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public void multiOkCancelBox(IFormView formView, ConfirmCallBackListener confirmCallBackListener) {
        formView.showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5f52\u6863\u540e\uff0c\u6240\u9009\u5458\u5de5\u7b7e\u7f72\u7684\u5408\u540c\u5c06\u81ea\u52a8\u5f52\u6863\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"ArchiveTemplate_8", (String)"hr-hlcm-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public List<HRExportHeadObject> getMulSelectConfirmExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5f52\u6863", (String)"ArchiveTemplate_9", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u4e0d\u53ef\u5f52\u6863\u539f\u56e0", (String)"ArchiveTemplate_10", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<HRExportHeadObject> getConfirmResultExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u5f52\u6863\u6210\u529f", (String)"ArchiveTemplate_11", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25\u539f\u56e0", (String)"ArchiveTemplate_12", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<Map<String, Object>> getMulSelectConfirmExportData(Object[] pkValues, Map<Object, String> preErrorInfoMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, preErrorInfoMap);
    }

    @Override
    public List<Map<String, Object>> getConfirmResultExportData(Object[] pkValues, Map<Object, String> errorMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, errorMap);
    }
}

