/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.common.template;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ActivityRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.business.domian.service.common.TemplateAnnotation;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.ActivityProcessStatusEnum;
import kd.hr.hlcm.common.enums.ActivityStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

@TemplateAnnotation(operateKey="beginsign")
public class BeginSignTemplate
implements MulSelectConfirmTemplate {
    private static final Log LOGGER = LogFactory.getLog(BeginSignTemplate.class);

    @Override
    public String getName() {
        return ResManager.loadKDString((String)"\u53d1\u8d77\u7b7e\u7f72", (String)"BeginSignTemplate_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getFileName() {
        return ResManager.loadKDString((String)"\u53d1\u8d77\u7b7e\u7f72\u6570\u636e", (String)"BeginSignTemplate_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getEmptySelectMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u53d1\u8d77\u7b7e\u7f72\u7684\u5355\u636e\u3002", (String)"BeginSignTemplate_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getSingleOkSuccessMessage() {
        return ResManager.loadKDString((String)"\u53d1\u8d77\u7b7e\u7f72\u6210\u529f\u3002", (String)"BeginSignTemplate_15", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] dynamicObjects) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(dynamicObjects.length);
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", "signway", Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        DynamicObject[] activities = ActivityRepository.getInstance().queryBeginSignActivities(Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        Map<Long, ActivityProcessStatusEnum> activityProcessStatusMap = ISignManageService.getInstance().getActivityProcessStatusEnumMap(activities);
        Map<Long, ActivityStatusEnum> activityStatusMap = ISignManageService.getInstance().getActivityStatusEnumMap(dynamicObjects);
        Arrays.stream(signBills).forEach(signBill -> {
            Long id = signBill.getLong("id");
            ActivityProcessStatusEnum activityProcessStatusEnum = (ActivityProcessStatusEnum)activityProcessStatusMap.get(id);
            String activityStatus = Optional.ofNullable(activityProcessStatusEnum).map(ActivityProcessStatusEnum::getDesc).map(MultiLangEnumBridge::loadKDString).orElse(null);
            ActivityStatusEnum activityStatusEnum = (ActivityStatusEnum)activityStatusMap.get(id);
            String result = null;
            if (!ISignManageService.getInstance().isAbleBeginSign(activityStatusEnum)) {
                if (activityProcessStatusEnum == null) {
                    result = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5b58\u5728\u5f02\u5e38\uff0c\u4e0d\u53ef\u53d1\u8d77\u7b7e\u7f72\u3002", (String)"BeginSignTemplate_13", (String)"hr-hlcm-business", (Object[])new Object[0]);
                } else if (HRStringUtils.equals((String)signBill.getString("signway"), (String)SignWayEnum.ELECTRONIC.getCombKey())) {
                    result = activityStatusEnum == ActivityStatusEnum.TERMINATED ? ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5458\u5de5\u7b7e\u7f72\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u4e0d\u53ef\u53d1\u8d77\u7b7e\u7f72\u3002", (String)"BeginSignTemplate_17", (String)"hr-hlcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5458\u5de5\u5df2\u7b7e\u7f72\u7535\u5b50\u5408\u540c\uff0c\u4e0d\u53ef\u518d\u6b21\u53d1\u8d77\u7b7e\u7f72\u3002", (String)"BeginSignTemplate_16", (String)"hr-hlcm-business", (Object[])new Object[0]);
                } else if (!HRStringUtils.equals((String)ActivityProcessStatusEnum.P_BEGIN_PENDING.getDesc().loadKDString(), (String)activityStatus)) {
                    result = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u53ef\u53d1\u8d77\u7b7e\u7f72\u3002", (String)"BeginSignTemplate_4", (String)"hr-hlcm-business", (Object[])new Object[0]), activityStatus);
                }
            }
            resultMap.put(id, result);
        });
        return resultMap;
    }

    @Override
    public Map<Long, String> doOperation(List<Long> ids) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids);
        Map<DynamicObject, DynamicObject> nextActivityMap = ISignActivity.getInstance().getNextActivityMap(signBills);
        nextActivityMap.forEach((signBill, nextActivity) -> {
            String result = ISignManageService.getInstance().beginSignHandler((DynamicObject)signBill, (DynamicObject)nextActivity);
            if (HRStringUtils.isNotEmpty((String)result)) {
                resultMap.put(signBill.getLong("id"), result);
            }
        });
        LOGGER.info("BeginSignTemplate#resultMap={}", JSON.toJSON((Object)resultMap));
        return resultMap;
    }

    @Override
    public void singleOkCancelBox(IFormView formView, Object pkValue, ConfirmCallBackListener confirmCallBackListener) {
        String entityId = formView instanceof IListView ? ((IListView)formView).getBillFormId() : formView.getEntityId();
        boolean isPaperSignPage = HRStringUtils.equals((String)entityId, (String)SignTabEnum.P_BEGIN.getSourceListFormId()) || HRStringUtils.equals((String)entityId, (String)SignTabEnum.P_BEGIN.getListFormId());
        formView.showConfirm(isPaperSignPage ? ResManager.loadKDString((String)"\u5c06\u4e3a%s\u53d1\u8d77\u7b7e\u7f72\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"BeginSignTemplate_6", (String)"hr-hlcm-business", (Object[])new Object[]{this.getActivityEmpName(formView, pkValue)}) : ResManager.loadKDString((String)"\u5c06\u4e3a%s\u53d1\u9001\u7b7e\u7f72\u901a\u77e5\u6d88\u606f\uff0c\u662f\u5426\u786e\u8ba4\u53d1\u9001\uff1f", (String)"BeginSignTemplate_5", (String)"hr-hlcm-business", (Object[])new Object[]{this.getActivityEmpName(formView, pkValue)}), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public void multiOkCancelBox(IFormView formView, ConfirmCallBackListener confirmCallBackListener) {
        String formId = ((IListView)formView).getBillFormId();
        formView.showConfirm(HRStringUtils.equals((String)formId, (String)SignTabEnum.P_BEGIN.getListFormId()) ? ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u5458\u5de5\u53d1\u8d77\u7b7e\u7f72\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"BeginSignTemplate_9", (String)"hr-hlcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u5458\u5de5\u53d1\u9001\u7b7e\u7f72\u901a\u77e5\u6d88\u606f\uff0c\u786e\u8ba4\u5168\u90e8\u53d1\u9001\uff1f", (String)"BeginSignTemplate_3", (String)"hr-hlcm-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public List<HRExportHeadObject> getMulSelectConfirmExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u53d1\u8d77\u7b7e\u7f72", (String)"BeginSignTemplate_7", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u4e0d\u53ef\u53d1\u8d77\u7b7e\u7f72\u539f\u56e0", (String)"BeginSignTemplate_8", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<HRExportHeadObject> getConfirmResultExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u53d1\u8d77\u7b7e\u7f72\u6210\u529f", (String)"BeginSignTemplate_11", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u53d1\u8d77\u7b7e\u7f72\u5931\u8d25\u539f\u56e0", (String)"BeginSignTemplate_12", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<Map<String, Object>> getMulSelectConfirmExportData(Object[] pkValues, Map<Object, String> preErrorInfoMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, preErrorInfoMap);
    }

    @Override
    public List<Map<String, Object>> getConfirmResultExportData(Object[] pkValues, Map<Object, String> errorMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, errorMap);
    }
}

