/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hismodel.abs.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.service.hismodel.abs.GetDyHis;
import kd.hr.hlcm.business.domian.service.hismodel.abs.vo.DyHisVO;
import kd.hr.hlcm.business.domian.service.hismodel.helper.ContractHisHelper;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class CancelGetDyHis
implements GetDyHis {
    private static final Log LOGGER = LogFactory.getLog(CancelGetDyHis.class);

    @Override
    public List<DynamicObject> getDyHis(DyHisVO dyHisVO) {
        List<DynamicObject> list;
        DynamicObject oldContract = dyHisVO.getOldContract();
        DynamicObject signBill = dyHisVO.getSignBill();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)3);
        DynamicObject oldHisInvalid = ContractHisHelper.getInstance().copyContractVersion(oldContract);
        result.addAll(this.cancel(signBill, oldContract, oldHisInvalid));
        List<DynamicObject> discardFutureVersions = ContractHisHelper.getInstance().getDiscardFutureVersions(dyHisVO.getFutureContracts());
        result.addAll(discardFutureVersions);
        if (ProtocolTypeEnum.CON.getCombKey().equals(signBill.getString("protocoltype")) && BusinessTypeEnum.CANCEL.getCombKey().equals(signBill.getString("businesstype")) && !CollectionUtils.isEmpty(list = this.handleCancelLaborContract(signBill, oldContract))) {
            result.addAll(list);
        }
        LOGGER.info("result size|{}", (Object)result.size());
        return result;
    }

    private List<DynamicObject> cancel(DynamicObject signBill, DynamicObject oldContract, DynamicObject oldHisInvalid) {
        Date today;
        ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
        Date cancelDate = HRDateTimeUtils.truncateDate((Date)signBill.getDate("canceldate"));
        boolean isFuture = !cancelDate.before(today = HRDateTimeUtils.truncateDate((Date)new Date()));
        oldHisInvalid.set("signstatus", (Object)signBill.getString("businesstype"));
        String cancelReason = signBill.getString("cancelreason");
        DynamicObject conReasonDy = signBill.getDynamicObject("cancelreasontype");
        oldHisInvalid.set("bsed", (Object)HRDateTimeUtils.getNextDay((Date)cancelDate));
        oldHisInvalid.set("bsled", null);
        oldHisInvalid.set("actualenddate", (Object)cancelDate);
        oldHisInvalid.set("cancelreason", (Object)cancelReason);
        oldHisInvalid.set("cancelreasontype", (Object)conReasonDy);
        oldHisInvalid.set("contractstatus", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
        if (isFuture) {
            long id = ORM.create().genLongId(oldContract.getDataEntityType());
            oldHisInvalid.set("planenddate", (Object)cancelDate);
            oldHisInvalid.set("sourcevid", (Object)id);
            DynamicObject oldHisSignStatus = ContractHisHelper.getInstance().copyContractVersion(oldContract);
            oldHisSignStatus.set("id", (Object)id);
            oldHisSignStatus.set("signstatus", (Object)signBill.getString("businesstype"));
            oldHisSignStatus.set("bsed", (Object)today);
            oldHisSignStatus.set("bsled", (Object)cancelDate);
            oldHisSignStatus.set("planenddate", (Object)cancelDate);
            oldHisSignStatus.set("cancelreason", (Object)cancelReason);
            oldHisSignStatus.set("cancelreasontype", (Object)conReasonDy);
            result.add(oldHisSignStatus);
        }
        result.add(oldHisInvalid);
        return result;
    }

    private List<DynamicObject> handleCancelLaborContract(DynamicObject signBill, DynamicObject oldMainContract) {
        DynamicObjectCollection dys;
        ArrayList result = Lists.newArrayListWithExpectedSize((int)4);
        boolean issignprotocol = signBill.getBoolean("issignprotocol");
        if (issignprotocol && !CollectionUtils.isEmpty((Collection)(dys = signBill.getDynamicObjectCollection("entryentity")))) {
            DynamicObject newHis = ContractHisHelper.getInstance().convertContract(signBill);
            newHis.set("actualenddate", null);
            List<DynamicObject> list = ContractHisHelper.getInstance().handleLaborContract(signBill, newHis);
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(val -> val.set("maincontract", (Object)oldMainContract));
                result.addAll(list);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(dys = signBill.getDynamicObjectCollection("otherprotocol")))) {
            Object[] ids = (Long[])dys.stream().map(val -> val.getLong("fbasedataid.id")).filter(val -> val != 0L).toArray(Long[]::new);
            LOGGER.info("otherprotocol dys size:{}, ids size:{}", (Object)dys.size(), (Object)ids.length);
            if (ids.length > 0) {
                DynamicObject[] oldContracts = HLCMCommonRepository.queryDynamicObjectByPks("hlcm_contractsource", null, ids);
                LOGGER.info("query oldContracts length:{}", (Object)(oldContracts != null ? oldContracts.length : 0));
                if (oldContracts != null && oldContracts.length > 0) {
                    for (DynamicObject oldContract : oldContracts) {
                        DynamicObject oldHisInvalid = ContractHisHelper.getInstance().copyContractVersion(oldContract);
                        result.addAll(this.cancel(signBill, oldContract, oldHisInvalid));
                    }
                }
            }
        }
        return result;
    }
}

