/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hismodel.contract.valid;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.hismodel.helper.LocaleStringComparator;

public abstract class AbstractContractValidator {
    protected final HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
    private final List<String> lengthFields = Arrays.asList("number", "changedescription", "cancelreason", "cardnumber", "empphone");
    private final LocaleStringComparator localeStringComparator = new LocaleStringComparator();
    private final Map<Long, String> result;
    private final List<DynamicObject> dyList;
    private Map<String, List<Long>> numberVsIdList;

    public AbstractContractValidator(List<DynamicObject> list) {
        this.result = new HashMap<Long, String>(list.size());
        this.dyList = list;
    }

    public abstract void valid();

    protected final void checkTextLength(DynamicObject otDy) {
        DynamicObjectType objectType = otDy.getDynamicObjectType();
        this.lengthFields.forEach(field -> {
            DynamicProperty property = objectType.getProperty(field);
            if (!(property instanceof TextProp)) {
                return;
            }
            int maxLength = ((TextProp)property).getMaxLenth();
            if (property instanceof MuliLangTextProp) {
                List<EnabledLang> enabledLangList = this.localeStringComparator.getEnabledLangList();
                ILocaleString localeString = otDy.getLocaleString(field);
                for (EnabledLang enabledLang : enabledLangList) {
                    String value = (String)localeString.get((Object)enabledLang.getNumber());
                    if (!HRStringUtils.isNotEmpty((String)value) || value.length() <= maxLength) continue;
                    this.addMsg(otDy, String.format(this.getLengthMessage(), property.getDisplayName(), maxLength));
                    break;
                }
                return;
            }
            String value = otDy.getString(field);
            if (HRStringUtils.isEmpty((String)value)) {
                return;
            }
            if (value.length() > maxLength) {
                this.addMsg(otDy, String.format(this.getLengthMessage(), property.getDisplayName(), maxLength));
            }
        });
    }

    protected final void checkMustInput(DynamicObject otDy, List<String> filedList) {
        DynamicObjectType objectType = otDy.getDynamicObjectType();
        filedList.forEach(field -> {
            DynamicProperty property = objectType.getProperty(field);
            Object value = otDy.get(field);
            if (value == null) {
                this.addMsg(otDy, String.format(this.getMustInputMessage(), property.getDisplayName()));
                return;
            }
            if (!(property instanceof TextProp)) {
                return;
            }
            if (value instanceof ILocaleString) {
                if (this.localeStringComparator.isBizEmpty((ILocaleString)value)) {
                    this.addMsg(otDy, String.format(this.getMustInputMessage(), property.getDisplayName()));
                }
            } else if (HRStringUtils.isEmpty((String)otDy.getString(field))) {
                this.addMsg(otDy, String.format(this.getMustInputMessage(), property.getDisplayName()));
            }
        });
    }

    final void checkComboValue(DynamicObject dy) {
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            ComboProp comboProp;
            Set valueSet;
            String comboValue;
            if (!(property instanceof ComboProp) || HRStringUtils.isEmpty((String)(comboValue = Optional.ofNullable(property.getValue((Object)dy)).map(Object::toString).orElse(""))) || (valueSet = (comboProp = (ComboProp)property).getComboItems().stream().map(ValueMapItem::getValue).collect(Collectors.toSet())).contains(comboValue)) continue;
            this.addMsg(dy, String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7684\u503c\u4ec5\u53ef\u4e3a\u201c%2$s\u201d\u3002", (String)"AbstractContractValidator_7", (String)"hr-hlcm-business", (Object[])new Object[0]), comboProp.getDisplayName(), String.join((CharSequence)",", valueSet)));
        }
    }

    protected void checkPosType(DynamicObject dy) {
        long posTypeId;
        if (Objects.isNull(dy.get("ermanfile"))) {
            return;
        }
        if ("1".equals(dy.getString("protocoltype")) && (posTypeId = this.getId(dy, "postype")) != 1010L && posTypeId != 1040L) {
            String msg = ResManager.loadKDString((String)"\u5408\u540c\u534f\u8bae\u7c7b\u578b\u548c\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u4e0d\u5339\u914d\u3002", (String)"AbstractContractValidator_4", (String)"hr-hlcm-business", (Object[])new Object[0]);
            this.addMsg(dy, msg);
        }
    }

    final void checkPositionMode(DynamicObject dy) {
        Object jobDy = dy.get("curjob");
        Object stdPositionDy = dy.get("curstdpostion");
        Object positionDy = dy.get("curpostion");
        int nullCount = (HRObjectUtils.isEmpty((Object)jobDy) ? 0 : 1) + (HRObjectUtils.isEmpty((Object)stdPositionDy) ? 0 : 1) + (HRObjectUtils.isEmpty((Object)positionDy) ? 0 : 1);
        if (nullCount == 0) {
            this.addMsg(dy, ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801\u3001\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u3001\u804c\u4f4d\u7f16\u7801\u5fc5\u987b\u586b\u5199\u4e00\u4e2a\u3002", (String)"AbstractContractValidator_5", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        if (nullCount > 1) {
            this.addMsg(dy, ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801\u3001\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u3001\u804c\u4f4d\u7f16\u7801\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\u3002", (String)"AbstractContractValidator_6", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
    }

    final void checkContractTemplate(DynamicObject dy) {
        DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
        if (entryEntity.size() > 1) {
            this.addMsg(dy, ResManager.loadKDString((String)"\u540c\u4e00\u4eba\u5458\uff0c\u5408\u540c\u7684\u5c5e\u6027\u5b8c\u5168\u76f8\u540c\u65f6\uff0c\u4ec5\u53ef\u6dfb\u52a0\u4e00\u4efd\u5408\u540c\u6a21\u7248\u3002", (String)"AbstractContractValidator_8", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
    }

    protected void checkNumber(DynamicObject dy) {
        String number = dy.getString("number");
        List boList = this.getNumberVsBoList().getOrDefault(number, Collections.emptyList());
        if (boList.stream().anyMatch(bo -> !bo.equals(dy.getLong("boid")))) {
            String msg = ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u552f\u4e00", (String)"AbstractContractValidator_3", (String)"hr-hlcm-business", (Object[])new Object[0]);
            this.addMsg(dy, msg);
        }
    }

    protected List<DynamicObject> getDyList() {
        return this.dyList;
    }

    public Map<Long, String> getResult() {
        return this.result;
    }

    protected final void addMsg(Long id, String msg) {
        String oldMsg = this.result.get(id);
        String newMsg = msg;
        if (HRStringUtils.isNotEmpty((String)oldMsg)) {
            StringBuilder sb = new StringBuilder(oldMsg);
            newMsg = sb.append(";").append(msg).toString();
        }
        this.result.put(id, newMsg);
    }

    protected final void addMsg(DynamicObject otDy, String msg) {
        this.addMsg(otDy.getLong("id"), msg);
    }

    private long getId(DynamicObject dy, String propertyName) {
        Object obj = dy.get(propertyName);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return 0L;
    }

    private String getLengthMessage() {
        return ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c%2$s]\u3002", (String)"AbstractContractValidator_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    private String getMustInputMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u4ee5\u4e0b\u5185\u5bb9\uff1a%s\u3002", (String)"AbstractContractValidator_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    private Map<String, List<Long>> getNumberVsBoList() {
        if (this.numberVsIdList == null) {
            HashSet numberSet = Sets.newHashSetWithExpectedSize((int)this.dyList.size());
            HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)this.dyList.size());
            this.dyList.forEach(dy -> {
                numberSet.add(dy.getString("number"));
                boIdSet.add(dy.getLong("boid"));
            });
            QFilter numberFilter = new QFilter("number", "in", (Object)numberSet);
            if (!CollectionUtils.isEmpty((Collection)boIdSet)) {
                numberFilter.and("boid", "not in", (Object)boIdSet);
            }
            numberFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
            numberFilter.and("datastatus", "=", (Object)Character.valueOf('1'));
            numberFilter.and("initstatus", "=", (Object)"2");
            DynamicObjectCollection bdList = this.contractHelper.queryOriginalCollection("boid,number", numberFilter.toArray());
            this.numberVsIdList = Stream.concat(bdList.stream(), this.dyList.stream()).collect(Collectors.groupingBy(dy -> dy.getString("number"), Collectors.mapping(dy -> dy.getLong("boid"), Collectors.toList())));
        }
        return this.numberVsIdList;
    }
}

