/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hismodel.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.proxy.impl.GenerateContractService;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractFileSignStatusEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.sdk.hr.hlcm.business.domain.hismodel.IGenerateContractService;

public class ContractHisHelper {
    private static final Log LOGGER = LogFactory.getLog(ContractHisHelper.class);

    private ContractHisHelper() {
        if (SingletonHolder.INSTANCE != null) {
            throw new IllegalStateException();
        }
    }

    public static ContractHisHelper getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public DynamicObject convertContract(DynamicObject signBill) {
        HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
        DynamicObject hisDy = contractHelper.generateEmptyDynamicObject();
        Date startDate = HRDateTimeUtils.truncateDate((Date)signBill.getDate("startdate"));
        Date endDate = HRDateTimeUtils.truncateDate((Date)signBill.getDate("enddate"));
        hisDy.set("protocoltype", (Object)signBill.getString("protocoltype"));
        hisDy.set("name", (Object)signBill.getString("empname"));
        hisDy.set("periodunit", (Object)signBill.getString("periodunit"));
        hisDy.set("empnumber", (Object)signBill.getString("empnumber"));
        hisDy.set("suggestsigncompany", (Object)signBill.getDynamicObject("suggestsigncompany"));
        hisDy.set("actualsigncompany", (Object)signBill.getDynamicObject("actualsigncompany"));
        hisDy.set("suggestsigncompanyhis", (Object)signBill.getDynamicObject("suggestsigncomphis"));
        hisDy.set("actualsigncompanyhis", (Object)signBill.getDynamicObject("actualsigncompanyhis"));
        hisDy.set("cardtype", (Object)signBill.getDynamicObject("cardtype"));
        hisDy.set("cardnumber", (Object)signBill.getString("cardnumber"));
        hisDy.set("householdregister", (Object)signBill.getString("householdregister"));
        hisDy.set("residentialaddress", (Object)signBill.getString("residentialaddress"));
        hisDy.set("empphone", (Object)signBill.getString("empphone"));
        hisDy.set("signedcompany", (Object)signBill.getDynamicObject("signedcompanyhis"));
        hisDy.set("stdposition", (Object)signBill.getDynamicObject("stdpostionhis"));
        hisDy.set("number", (Object)signBill.getString("contractnumber"));
        hisDy.set("contracttype", (Object)signBill.getDynamicObject("contracttype"));
        hisDy.set("period", (Object)signBill.getBigDecimal("period"));
        hisDy.set("periodtype", (Object)signBill.getDynamicObject("periodtype"));
        hisDy.set("startdate", (Object)startDate);
        hisDy.set("enddate", (Object)endDate);
        this.setTemplateValue(hisDy);
        hisDy.set("signeddate", (Object)Optional.ofNullable(signBill.getDate("actualsigndate")).orElseGet(() -> signBill.getDate("signeddate")));
        hisDy.set("renewcount", (Object)ContractSignApplyRepository.getInstance().getRenewCount(signBill));
        hisDy.set("probationstartdate", (Object)signBill.getDate("probationstartdate"));
        hisDy.set("probationenddate", (Object)signBill.getDate("probationenddate"));
        hisDy.set("probationperiod", (Object)signBill.getBigDecimal("probationperiod"));
        hisDy.set("probationunit", (Object)signBill.getString("probationunit"));
        hisDy.set("signedcompany", (Object)signBill.getDynamicObject("signedcompanyhis"));
        hisDy.set("department", (Object)signBill.getDynamicObject("departmenthis"));
        hisDy.set("position", (Object)signBill.getDynamicObject("postionhis"));
        hisDy.set("postype", (Object)signBill.getDynamicObject("postype"));
        hisDy.set("curcompany", (Object)signBill.getDynamicObject("curcompany"));
        hisDy.set("curdept", (Object)signBill.getDynamicObject("curdept"));
        hisDy.set("curpostion", (Object)signBill.getDynamicObject("curpostion"));
        hisDy.set("curstdpostion", (Object)signBill.getDynamicObject("curstdpostion"));
        hisDy.set("curjob", (Object)signBill.getDynamicObject("curjob"));
        hisDy.set("contractcategory", (Object)signBill.getString("contractcategory"));
        hisDy.set("businesstype", (Object)signBill.getString("businesstype"));
        hisDy.set("oldcontract", (Object)signBill.getDynamicObject("oldcontract"));
        hisDy.set("maincontract", (Object)signBill.getDynamicObject("maincontract"));
        hisDy.set("signreason", (Object)signBill.getString("signreason"));
        hisDy.set("cancelreason", (Object)signBill.getString("cancelreason"));
        hisDy.set("cancelreasontype", (Object)signBill.getString("cancelreasontype"));
        hisDy.set("actualenddate", (Object)signBill.getDate("canceldate"));
        hisDy.set("person", (Object)signBill.getDynamicObject("person"));
        hisDy.set("org", (Object)signBill.getDynamicObject("org"));
        hisDy.set("ermanfile", (Object)signBill.getDynamicObject("ermanfile"));
        hisDy.set("signway", (Object)signBill.getString("signway"));
        hisDy.set("baselocation", (Object)signBill.getDynamicObject("baselocation"));
        hisDy.set("nation", (Object)signBill.getDynamicObject("nation"));
        hisDy.set("ermanorg", (Object)signBill.getDynamicObject("ermanorg"));
        hisDy.set("adminororg", (Object)signBill.getDynamicObject("adminororg"));
        hisDy.set("ermanperorg", (Object)signBill.getDynamicObject("ermanperorg"));
        hisDy.set("job", (Object)signBill.getDynamicObject("job"));
        hisDy.set("employee", (Object)signBill.getDynamicObject("employee"));
        this.setContractStatus(startDate, endDate, hisDy);
        this.setContractEndDate(endDate, hisDy);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new GenerateContractService(), IGenerateContractService.class, (String)"kd.sdk.hr.hlcm.business.domain.hismodel.IGenerateContractService", null);
        pluginProxy.callReplace(proxy -> {
            proxy.setContractFieldsForExt(signBill, hisDy);
            return null;
        });
        this.copySignTextToContract(hisDy, signBill);
        return hisDy;
    }

    public List<DynamicObject> handleLaborContract(DynamicObject signBill, DynamicObject mainContract) {
        try {
            DynamicObjectCollection dys;
            String protocolType = signBill.getString("protocoltype");
            if (!ProtocolTypeEnum.CON.getCombKey().equals(protocolType)) {
                LOGGER.info("protocoltype is not laborcontract");
                return null;
            }
            String businessType = signBill.getString("businesstype");
            if (BusinessTypeEnum.STOP.getCombKey().equals(businessType)) {
                LOGGER.info("business type is stop");
                return null;
            }
            if ((signBill.getBoolean("issignother") || signBill.getBoolean("issignprotocol")) && !CollectionUtils.isEmpty((Collection)(dys = signBill.getDynamicObjectCollection("entryentity")))) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)dys.size());
                for (DynamicObject entryRow : dys) {
                    DynamicObject hisDy;
                    if (Objects.equals(ContractTypeCatEnum.CON.getPkId(), entryRow.getLong("entrycontracttype.group.id"))) {
                        hisDy = mainContract;
                    } else {
                        hisDy = new DynamicObject(mainContract.getDynamicObjectType());
                        HRDynamicObjectUtils.copy((DynamicObject)mainContract, (DynamicObject)hisDy);
                        Date startDate = HRDateTimeUtils.truncateDate((Date)entryRow.getDate("entrystartdate"));
                        Date endDate = HRDateTimeUtils.truncateDate((Date)entryRow.getDate("entryenddate"));
                        hisDy.set("protocoltype", (Object)ProtocolTypeEnum.FS.getCombKey());
                        hisDy.set("number", entryRow.get("entrycontractnumber"));
                        hisDy.set("contracttype", entryRow.get("entrycontracttype"));
                        hisDy.set("period", entryRow.get("entryperiod"));
                        hisDy.set("periodtype", entryRow.get("entryperiodtype"));
                        hisDy.set("periodunit", entryRow.get("entryperiodunit"));
                        hisDy.set("startdate", (Object)startDate);
                        hisDy.set("enddate", (Object)endDate);
                        this.setContractStatus(startDate, endDate, hisDy);
                        this.setContractEndDate(endDate, hisDy);
                        hisDy.set("oldcontract", null);
                        hisDy.set("maincontract", (Object)mainContract);
                        result.add(hisDy);
                    }
                    DynamicObjectCollection dynamics = hisDy.getDynamicObjectCollection("entryentity");
                    dynamics.clear();
                    this.copyEntryEntity(entryRow, dynamics.addNew());
                }
                return result;
            }
        }
        catch (Exception ex) {
            LOGGER.error("handleLaborContract ex", (Throwable)ex);
            throw new KDBizException("system error");
        }
        return null;
    }

    public List<DynamicObject> getDiscardFutureVersions(List<DynamicObject> futureContracts) {
        if (CollectionUtils.isEmpty(futureContracts)) {
            LOGGER.info("futureContracts is empty");
            return new ArrayList<DynamicObject>();
        }
        ArrayList discardFutureVersions = Lists.newArrayListWithCapacity((int)futureContracts.size());
        futureContracts.forEach(contract -> {
            DynamicObject discardFutureVersion = this.copyContractVersion((DynamicObject)contract);
            Date today = HRDateTimeUtils.truncateDate((Date)new Date());
            discardFutureVersion.set("bsed", (Object)today);
            discardFutureVersion.set("actualenddate", (Object)today);
            discardFutureVersion.set("cancelreasontype", (Object)0);
            discardFutureVersion.set("contractstatus", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
            discardFutureVersion.set("signstatus", (Object)ContractFileSignStatusEnum.DISCARD_SIGNED.getCombKey());
            discardFutureVersions.add(discardFutureVersion);
        });
        return discardFutureVersions;
    }

    private void setContractEndDate(Date endDate, DynamicObject dy) {
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        if (endDate != null && endDate.before(today)) {
            dy.set("actualenddate", (Object)endDate);
        }
    }

    public void copySignTextToContract(DynamicObject contractDy, DynamicObject signBill) {
        DynamicObjectCollection contractText = contractDy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection signText = signBill.getDynamicObjectCollection("entryentity");
        signText.forEach(text -> {
            DynamicObject dy = contractText.addNew();
            this.copyEntryEntity((DynamicObject)text, dy);
        });
    }

    public void copyEntryEntity(DynamicObject oriDy, DynamicObject targetDy) {
        targetDy.set("contracttemplate", (Object)oriDy.getDynamicObject("contracttemplate"));
        targetDy.set("opperson", (Object)oriDy.getDynamicObject("opperson"));
        targetDy.set("opdate", (Object)oriDy.getDate("opdate"));
        targetDy.set("remark", (Object)oriDy.getString("remark"));
        targetDy.set("presigndocurl", (Object)oriDy.getString("presigndocurl"));
        targetDy.set("contractno", (Object)oriDy.getString("contractno"));
        targetDy.set("texthis", (Object)oriDy.getDynamicObject("texthis"));
    }

    public DynamicObject copyContractVersion(DynamicObject contract) {
        HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
        DynamicObject newDy = contractHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)contract, (DynamicObject)newDy);
        return newDy;
    }

    public HisResponse<VersionChangeRespData> callHisModel(DynamicObject[] hisDyns) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setEntityNumber("hlcm_contractsource");
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        HisResponse versionChangeRespDataHisResponse = HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        return versionChangeRespDataHisResponse;
    }

    public HisResponse<VersionChangeRespData> callHisModel(DynamicObject[] hisDyns, String type) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(true);
        if ("1".equals(type)) {
            hisVersionParamBo.setEntityNumber("hlcm_contract");
        } else if ("3".equals(type)) {
            hisVersionParamBo.setEntityNumber("hlcm_contractfileother");
        } else {
            hisVersionParamBo.setEntityNumber("hlcm_contractfileemp");
        }
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        return HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
    }

    public void reviseVersion(String entityNumber, DynamicObject[] reviseDys) {
        HisVersionReviseParamBo paramBo = new HisVersionReviseParamBo();
        paramBo.setEntityNumber(entityNumber);
        paramBo.setReviseDys(reviseDys);
        HrApiResponse response = HisModelController.getInstance().reviseVersion(paramBo);
        if (!"200".equals(response.getCode())) {
            throw new KDBizException(response.getErrorMessage());
        }
        DynamicObject[] returnData = ((HisVersionReviseResultBo)response.getData()).getReturnDataBo().getReturnData();
        HLCMCommonRepository.updateDynamicObjects(entityNumber, returnData);
    }

    public void callHisModelForDelete(DynamicObject[] hisDyns) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        List boList = Arrays.stream(hisDyns).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        hisBaseBo.setEntityNumber("hlcm_contractsource");
        hisBaseBo.setBoIdList(boList);
        HisModelController.getInstance().deleteBo(hisBaseBo);
    }

    public void callHisModelForUpdate(DynamicObject[] dyns) {
        HisResponse<VersionChangeRespData> response;
        HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
        ArrayList hisDyns = Lists.newArrayListWithExpectedSize((int)dyns.length);
        for (DynamicObject contract : dyns) {
            DynamicObject contractHis = contractHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)contract, (DynamicObject)contractHis);
            contractHis.set("maincontract", (Object)0L);
            contractHis.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
            hisDyns.add(contractHis);
        }
        if (!hisDyns.isEmpty() && !HRStringUtils.equals((String)"200", (String)(response = ContractHisHelper.getInstance().callHisModel(hisDyns.toArray(new DynamicObject[0]))).getCode())) {
            throw new KDBizException(response.getErrorMessage());
        }
    }

    public void setTemplateValue(DynamicObject hisDy, Long id) {
        this.setBsed(hisDy);
        if (id == null || id == 0L) {
            hisDy.set("id", (Object)ORM.create().genLongId(hisDy.getDataEntityType()));
        }
        hisDy.set("signstatus", (Object)Optional.ofNullable(hisDy.getString("signstatus")).filter(HRStringUtils::isNotEmpty).orElse("1"));
        hisDy.set("status", (Object)"C");
        hisDy.set("enable", (Object)"1");
    }

    private void setTemplateValue(DynamicObject hisDy) {
        this.setBsed(hisDy);
        hisDy.set("id", (Object)ORM.create().genLongId(hisDy.getDataEntityType()));
        hisDy.set("signstatus", (Object)Optional.ofNullable(hisDy.getString("signstatus")).filter(HRStringUtils::isNotEmpty).orElse("1"));
        hisDy.set("status", (Object)"C");
        hisDy.set("enable", (Object)"1");
        hisDy.set("initstatus", (Object)"2");
    }

    public void setContractStatus(Date startDate, Date endDate, DynamicObject dy) {
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        if (HRObjectUtils.isEmpty((Object)endDate)) {
            if (today.before(startDate)) {
                dy.set("contractstatus", (Object)ContractStatusEnum.STATUS_PENDING.getCode());
            } else {
                dy.set("contractstatus", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode());
            }
        } else if (today.before(startDate)) {
            dy.set("contractstatus", (Object)ContractStatusEnum.STATUS_PENDING.getCode());
        } else if (endDate.before(today)) {
            dy.set("contractstatus", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
        } else {
            dy.set("contractstatus", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode());
        }
    }

    private void setBsed(DynamicObject hisDy) {
        Date startDate = HRDateTimeUtils.truncateDate((Date)hisDy.getDate("startdate"));
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        hisDy.set("bsed", (Object)(today.before(startDate) ? today : startDate));
    }

    private static class SingletonHolder {
        private static final ContractHisHelper INSTANCE = new ContractHisHelper();

        private SingletonHolder() {
        }
    }
}

