/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hismodel.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.hismodel.IContractHisModel;
import kd.hr.hlcm.business.domian.service.hismodel.abs.GenContractService;
import kd.hr.hlcm.business.domian.service.hismodel.helper.ContractHisHelper;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import org.apache.commons.lang3.time.DateUtils;

public class ContractHisModel
implements IContractHisModel {
    private static final Log logger = LogFactory.getLog(ContractHisModel.class);

    @Override
    public void hisVersionChange(DynamicObject ... signBills) {
        if (signBills == null || signBills.length == 0) {
            logger.warn("signBills is null");
            return;
        }
        GenContractService genContractService = new GenContractService();
        genContractService.init(signBills).genContract();
    }

    @Override
    public void invalidContract(Long personId, Date contractEndDate) {
        HisResponse<VersionChangeRespData> response;
        SyncStartStatusService.getInstance().deletePreWarn(personId);
        HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter statusFilter = new QFilter("contractstatus", "!=", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
        QFilter protocolTypeFilter = new QFilter("protocoltype", "!=", (Object)ProtocolTypeEnum.FS.getCombKey());
        DynamicObject[] contracts = contractHelper.loadDynamicObjectArray(new QFilter[]{personFilter, versionFilter, protocolTypeFilter, statusFilter});
        int length = contracts.length;
        if (length == 0) {
            logger.warn("personId|{} has none contract", (Object)personId);
            return;
        }
        ArrayList hisDyns = Lists.newArrayListWithExpectedSize((int)length);
        ArrayList futureContracts = Lists.newArrayListWithCapacity((int)length);
        for (DynamicObject contract : contracts) {
            if (HRStringUtils.equals((String)contract.getString("contractstatus"), (String)ContractStatusEnum.STATUS_IN_EFFECT.getCode())) {
                DynamicObject contractHis = contractHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)contract, (DynamicObject)contractHis);
                contractHis.set("bsed", (Object)HRDateTimeUtils.getNextDay((Date)contractEndDate));
                contractHis.set("actualenddate", (Object)contractEndDate);
                contractHis.set("contractstatus", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
                Date endDate = contract.getDate("enddate");
                String signStatus = Objects.nonNull(endDate) && DateUtils.isSameDay((Date)endDate, (Date)contractEndDate) ? "5" : "4";
                contractHis.set("signstatus", (Object)signStatus);
                String protocolType = contract.getString("protocoltype");
                String cancelReason = HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.CON.getCombKey()) ? ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u79bb\u804c\u5408\u540c\u5931\u6548", (String)"ContractHisModel_0", (String)"hr-hlcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u79bb\u804c\u534f\u8bae\u5931\u6548", (String)"ContractHisModel_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
                contractHis.set("cancelreason", (Object)cancelReason);
                hisDyns.add(contractHis);
                continue;
            }
            futureContracts.add(contract);
        }
        hisDyns.addAll(ContractHisHelper.getInstance().getDiscardFutureVersions(futureContracts));
        if (!hisDyns.isEmpty() && !HRStringUtils.equals((String)"200", (String)(response = ContractHisHelper.getInstance().callHisModel(hisDyns.toArray(new DynamicObject[0]))).getCode())) {
            throw new KDBizException(response.getErrorMessage());
        }
    }

    @Override
    public HisResponse<VersionChangeRespData> hisVersionSave(DynamicObject ... contracts) {
        if (Objects.isNull(contracts) || contracts.length <= 0) {
            logger.warn("contracts is null");
            return null;
        }
        for (DynamicObject contract : contracts) {
            Date startDate = HRDateTimeUtils.truncateDate((Date)contract.getDate("startdate"));
            Date endDate = HRDateTimeUtils.truncateDate((Date)contract.getDate("enddate"));
            Date actualEndDate = HRDateTimeUtils.truncateDate((Date)contract.getDate("actualenddate"));
            ContractHisHelper.getInstance().setTemplateValue(contract, contract.getLong("id"));
            ContractHisHelper.getInstance().setContractStatus(startDate, actualEndDate == null ? endDate : actualEndDate, contract);
        }
        String protocoltype = contracts[0].getString("protocoltype");
        HisResponse<VersionChangeRespData> hisResponse = ContractHisHelper.getInstance().callHisModel(contracts, protocoltype);
        return hisResponse;
    }
}

