/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hrcs.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.ERManFileRepository;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.common.enums.SignModeEnum;

public class HRCSServiceImpl
implements IHRCSService {
    private static final Log LOGGER = LogFactory.getLog(HRCSServiceImpl.class);
    private static final List<String> PRIVACY_PROPERTIES = Lists.newArrayList((Object[])new String[]{"mobile", "identity", "filePath"});

    @Override
    public DynamicObject getPromptContent(Long id) {
        LOGGER.info("invoke IHRCSService#getPromptContent id:{}", (Object)id);
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"getPromptContent", (Object[])new Object[]{id});
    }

    @Override
    public DynamicObject[] getPrompts(List<Long> ids) {
        LOGGER.info("invoke IHRCSService#getPrompts ids:{}", ids);
        return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"getPrompts", (Object[])new Object[]{ids});
    }

    @Override
    public String getContent(Long id) {
        LOGGER.info("invoke IHRCSService#getPrompts id:{}", (Object)id);
        String result = (String)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"getContent", (Object[])new Object[]{id});
        LOGGER.info("invoke IHRCSService#getContent result:{}", (Object)result);
        return result;
    }

    @Override
    public SignRespParam toSign(DynamicObject signBill, DynamicObject contractTemplate) {
        SignRespParam signRespParam;
        SignReqParam signReqParam = this.buildSignReqParam(signBill, contractTemplate);
        LOGGER.info("invoke IHRCSEContractService#toSign signReqParam:{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)signReqParam), Map.class)), PRIVACY_PROPERTIES));
        try (TXHandle notSupported = TX.notSupported();){
            if ("4".equals(signBill.getString("businesstype"))) {
                DynamicObject oldcontract = signBill.getDynamicObject("oldcontract");
                DynamicObjectCollection entryentity = oldcontract.getDynamicObjectCollection("entryentity");
                String contractNo = ((DynamicObject)entryentity.get(0)).getString("contractno");
                LOGGER.info("HRCSServiceImpl.toSign.contractNo ={}", (Object)contractNo);
                signRespParam = (SignRespParam)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"abolish", (Object[])new Object[]{contractNo, signReqParam});
            } else {
                signRespParam = (SignRespParam)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"toSign", (Object[])new Object[]{signReqParam});
            }
        }
        LOGGER.info("invoke IHRCSEContractService#toSign signRespParam:{}", (Object)signRespParam);
        return signRespParam;
    }

    @Override
    public SignRespParam getHandSignUrl(DynamicObject signBill, String contractNo) {
        SignReqParam signReqParam = this.buildSignReqParam(signBill, (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(0));
        LOGGER.info("invoke IHRCSEContractService#getHandSignUrl contractNo:{},signReqParam:{}", (Object)contractNo, (Object)LogPrivacyUtil.filterPrivacyProp((Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)signReqParam), Map.class)), PRIVACY_PROPERTIES));
        SignRespParam signRespParam = (SignRespParam)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"getHandSignUrl", (Object[])new Object[]{contractNo, signReqParam});
        LOGGER.info("invoke IHRCSEContractService#getHandSignUrl signRespParam:{}", (Object)JSON.toJSONString((Object)JSON.toJSON((Object)signRespParam)));
        return signRespParam;
    }

    @Override
    public SignRespParam sign(DynamicObject signBill, DynamicObject contractTemplate) {
        SignRespParam signRespParam;
        String contractNo = contractTemplate.getString("contractno");
        SignReqParam signReqParam = this.buildSignReqParam(signBill, contractTemplate);
        LOGGER.info("invoke IHRCSEContractService#sign signReqParam:{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)signReqParam), Map.class)), PRIVACY_PROPERTIES));
        try (TXHandle notSupported = TX.notSupported();){
            signRespParam = (SignRespParam)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"signNew", (Object[])new Object[]{signReqParam, contractNo});
        }
        LOGGER.info("invoke IHRCSEContractService#sign  signRespParam:{}", (Object)signRespParam);
        return signRespParam;
    }

    @Override
    public SignRespParam getPrevAndDown(DynamicObject signBill, String contractNo) {
        SignReqParam signReqParam = this.buildSignReqParam(signBill);
        LOGGER.info("invoke IHRCSEContractService#getPrevAndDown signReqParam:{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)signReqParam), Map.class)), PRIVACY_PROPERTIES));
        SignRespParam signRespParam = (SignRespParam)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"getPrevAndDownNew", (Object[])new Object[]{signReqParam, contractNo});
        LOGGER.info("invoke IHRCSEContractService#getPrevAndDown  signRespParam:{}", (Object)signRespParam);
        return signRespParam;
    }

    @Override
    public boolean authStatus(DynamicObject signBill, DynamicObject contractTemplate) {
        SignReqParam signReqParam = this.buildSignReqParam(signBill, contractTemplate);
        LOGGER.info("invoke IHRCSEContractService#authStatus signReqParam:{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)signReqParam), Map.class)), PRIVACY_PROPERTIES));
        boolean authStatus = (Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"authStatus", (Object[])new Object[]{signReqParam});
        LOGGER.info("invoke IHRCSEContractService#authStatus authStatus:{}", (Object)authStatus);
        return authStatus;
    }

    @Override
    public boolean signStatus(DynamicObject signBill, DynamicObject contractTemplate, String contractNo) {
        SignReqParam signReqParam = this.buildSignReqParam(signBill, contractTemplate);
        LOGGER.info("invoke IHRCSEContractService#signStatus signReqParam:{},contractNo\uff1a{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)signReqParam), Map.class)), PRIVACY_PROPERTIES), (Object)contractNo);
        boolean signStatus = (Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"signStatus", (Object[])new Object[]{signReqParam, contractNo});
        LOGGER.info("invoke IHRCSEContractService#signStatus signStatus:{}", (Object)signStatus);
        return signStatus;
    }

    @Override
    public DynamicObject selectKeywordMappingWithCondition(Long contractTemplateId) {
        String formId = "hlcm_contracttemplate";
        LOGGER.info("invoke IHRCSKeywordMappingService#selectKeywordMappingWithCondition contractTemplateId:{}", (Object)contractTemplateId);
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSKeywordMappingService", (String)"selectKeywordMappingWithCondition", (Object[])new Object[]{formId, contractTemplateId});
    }

    @Override
    public DynamicObject selectKeywordMapping(Long contractTemplateId) {
        String formId = "hlcm_contracttemplate";
        LOGGER.info("invoke IHRCSKeywordMappingService#selectKeywordMapping formId:{},contractTemplateId:{}", (Object)formId, (Object)contractTemplateId);
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSKeywordMappingService", (String)"selectKeywordMapping", (Object[])new Object[]{formId, contractTemplateId});
    }

    @Override
    @Deprecated
    public Map<String, String> getRealReplacedMap(List<DynamicObject> dyList, DynamicObjectCollection keywordMappingDyColl) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSKeywordMappingService", (String)"getRealReplacedMap", (Object[])new Object[]{dyList, keywordMappingDyColl});
    }

    @Override
    public Map<String, String> getKeyWordRepMapWithCust(List<DynamicObject> dyList, DynamicObject keywordMappingDy, String formId, Map<String, String> customizeKVs) {
        LOGGER.info("invoke IHRCSEContractService#getKeyWordRepMapWithCust start");
        Map keyWordReplacedMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSKeywordMappingService", (String)"getKeyWordRepMapWithCust", (Object[])new Object[]{dyList, keywordMappingDy, formId, customizeKVs});
        HashSet nullValueKeys = Sets.newHashSetWithExpectedSize((int)keyWordReplacedMap.size());
        HashSet notNullValueKeys = Sets.newHashSetWithExpectedSize((int)keyWordReplacedMap.size());
        keyWordReplacedMap.forEach((k, v) -> {
            if (HRStringUtils.isEmpty((String)v)) {
                nullValueKeys.add(k);
            } else {
                notNullValueKeys.add(k);
            }
        });
        LOGGER.info("invoke IHRCSEContractService#getKeyWordRepMapWithCust nullValueKeys:{},notNullValueKeys:{}", (Object)nullValueKeys, (Object)notNullValueKeys);
        return keyWordReplacedMap;
    }

    @Override
    @Deprecated
    public Map<String, String> getKeyWordReplacedMap(List<DynamicObject> dyList, DynamicObject keywordMappingDy, String formId) {
        LOGGER.info("invoke IHRCSEContractService#getKeyWordReplacedMap start");
        Map keyWordReplacedMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSKeywordMappingService", (String)"getKeyWordReplacedMap", (Object[])new Object[]{dyList, keywordMappingDy, formId});
        LOGGER.info("invoke IHRCSEContractService#getKeyWordReplacedMap success");
        return keyWordReplacedMap;
    }

    @Override
    public boolean contSubjectExists(Long fiOrg) {
        LOGGER.info("invoke IHRCSEContractService#contSubjectExists fiOrg:{}", (Object)fiOrg);
        boolean isExists = (Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"contSubjectExists", (Object[])new Object[]{fiOrg});
        LOGGER.info("invoke IHRCSEContractService#contSubjectExists isExists:{}", (Object)isExists);
        return isExists;
    }

    @Override
    public boolean contSubjectExistsNew(Long fiOrg, DynamicObject signBill) {
        LOGGER.info("invoke IHRCSEContractService#contSubjectExists fiOrg:{}", (Object)fiOrg);
        long lawentityId = 0L;
        DynamicObject signComHis = signBill.getDynamicObject("actualsigncompanyhis");
        if (signComHis != null) {
            lawentityId = signComHis.getDynamicObject("lawentity") != null ? signComHis.getLong("lawentity.id") : 0L;
        }
        SignReqParam signReqParam = new SignReqParam(fiOrg, Long.valueOf(lawentityId));
        LOGGER.info("==SignReqParam.contSubjectExistsNew:fiOrg:{},lawentityId:{}==", (Object)fiOrg, (Object)lawentityId);
        boolean isExists = (Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"contSubjectExistsNew", (Object[])new Object[]{signReqParam});
        LOGGER.info("invoke IHRCSEContractService#contSubjectExistsNew isExists:{}", (Object)isExists);
        return isExists;
    }

    @Override
    public boolean cancel(DynamicObject signBill, String contractNo) {
        SignReqParam signReqParam = this.buildSignReqParam(signBill);
        try {
            LOGGER.info("invoke IHRCSEContractService#cancel  contractNo:{}", (Object)contractNo);
            boolean result = (Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"cancelNew", (Object[])new Object[]{signReqParam, contractNo});
            LOGGER.info("invoke IHRCSEContractService#cancel result:{}", (Object)result);
            return result;
        }
        catch (Exception exp) {
            LOGGER.info("invoke IHRCSEContractService#cancel error", (Object)exp);
            return false;
        }
    }

    private Long getReOrgAdminOrgId(DynamicObject signBill) {
        Long lawEntityId = signBill.getLong("actualsigncompanyhis.lawentity.id");
        if (HRObjectUtils.isEmpty((Object)lawEntityId)) {
            return 0L;
        }
        DynamicObject lawEntity = CommonRepository.queryDynamicObjectByPk("hbss_lawentity", "adminorg", lawEntityId);
        if (HRObjectUtils.isEmpty((Object)lawEntity)) {
            return 0L;
        }
        return lawEntity.getDynamicObject("adminorg").getLong("id");
    }

    @Override
    public QFilter getCurrUserDataRuleByEntityNumberAndPermItemId(String entityNumber, String permItemId) {
        HashMap customParam = Maps.newHashMap();
        Long personId = RequestContext.get().getCurrUserId();
        LOGGER.info("invoke IHRCSEContractService#getDataRule entityNumber:{}|permItemId:{}", (Object)entityNumber, (Object)permItemId);
        QFilter dataRuleQFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{personId, "1WXBXYCLS05D", entityNumber, permItemId, customParam});
        LOGGER.info("invoke IHRCSEContractService#getDataRule:{}", (Object)dataRuleQFilter);
        return dataRuleQFilter;
    }

    @Override
    public Map<Object, Boolean> matchDataRule(String entityNumber, String permItemId, Object[] ids) {
        HashMap customParam = Maps.newHashMap();
        Long personId = RequestContext.get().getCurrUserId();
        LOGGER.info("invoke IHRCSEContractService#matchDataRule entityNumber:{},permItemId:{},ids:{}", new Object[]{entityNumber, permItemId, ids});
        Map matchDataRuleResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"matchDataRule", (Object[])new Object[]{personId, "1WXBXYCLS05D", entityNumber, permItemId, new QFilter[]{new QFilter("id", "in", (Object)ids)}, customParam});
        LOGGER.info("invoke IHRCSEContractService#matchDataRule matchDataRuleResult:{}", (Object)matchDataRuleResult);
        return matchDataRuleResult;
    }

    @Override
    public QFilter getDataRuleForBdProp(String parentEntityNumber, String propFullKey, String permItemId) {
        HashMap customParam = Maps.newHashMap();
        Long personId = RequestContext.get().getCurrUserId();
        LOGGER.info("invoke IHRCSEContractService#getDataRuleForBdProp parentEntityNumber:{},propFullKey:{},permItemId:{}", new Object[]{parentEntityNumber, propFullKey, permItemId});
        QFilter dataRuleForBdPropQf = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{personId, "1WXBXYCLS05D", parentEntityNumber, propFullKey, permItemId, customParam});
        LOGGER.info("invoke IHRCSEContractService#getDataRuleForBdProp dataRuleForBdPropQf:{}", (Object)dataRuleForBdPropQf);
        return dataRuleForBdPropQf;
    }

    public HashMap<Long, Boolean> matchDataRuleForBdProp(String entityId, String propFullKey, Set<Long> erManFiles) {
        QFilter dataRuleForBdProp = IHRCSService.getInstance().getDataRuleForBdProp(entityId, propFullKey, "47150e89000000ac");
        HashMap erManFileIsPermissionMap = Maps.newHashMapWithExpectedSize((int)erManFiles.size());
        if (dataRuleForBdProp == null) {
            erManFiles.forEach(erManFileId -> erManFileIsPermissionMap.put(erManFileId, Boolean.TRUE));
            return erManFileIsPermissionMap;
        }
        DynamicObject[] erManFileServiceIdDy = ERManFileRepository.getInstance().queryByFilterAndIds(erManFiles, dataRuleForBdProp, "id");
        Set collect = Arrays.stream(erManFileServiceIdDy).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        erManFiles.forEach(erManFileID -> {
            if (collect.contains(erManFileID)) {
                erManFileIsPermissionMap.put(erManFileID, Boolean.TRUE);
            } else {
                erManFileIsPermissionMap.put(erManFileID, Boolean.FALSE);
            }
        });
        return erManFileIsPermissionMap;
    }

    @Override
    public boolean isKDCloudSign(String contractNo) {
        LOGGER.info("param contractNo|{}", (Object)contractNo);
        boolean isKDCloud = (Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"isKDCloudSign", (Object[])new Object[]{contractNo});
        LOGGER.info("response isKDCloud|{}", (Object)isKDCloud);
        return isKDCloud;
    }

    private SignReqParam buildSignReqParam(DynamicObject signBill, DynamicObject contractTemplate) {
        Long fiOrgId = this.getReOrgAdminOrgId(signBill);
        String authFrontUrl = UrlService.getDomainContextUrl() + String.format("/mobile.html?form=%s&id=%s", "hlcm_signcontractinfo", signBill.getString("id"));
        String handSignFrontUrl = UrlService.getDomainContextUrl() + String.format("/mobile.html?form=%s&id=%s", "hlcm_signresult", signBill.getString("id"));
        String selProp = "econtemplatetype.id,econtemplate.id";
        DynamicObject eContractSignTemp = CommonRepository.queryDynamicObjectByPk("hlcm_contracttemplate", selProp, contractTemplate.getDynamicObject("contracttemplate").getLong("id"));
        SignReqParam signReqParam = new SignReqParam(fiOrgId, Long.valueOf(eContractSignTemp.getLong("econtemplate.id")), Long.valueOf(eContractSignTemp.getLong("econtemplatetype.id")), false);
        String mobile = signBill.getString("empphone");
        mobile = mobile.replace("+86", "").replace("-", "");
        try {
            signReqParam.setHandSignFrontUrl(URLEncoder.encode(handSignFrontUrl, "UTF-8"));
            signReqParam.setAuthFrontUrl(authFrontUrl);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Throwable)e);
        }
        signReqParam.setNaturalId(Long.valueOf(signBill.getDynamicObject("person").getLong("id")));
        signReqParam.setName(signBill.getString("empname"));
        signReqParam.setMobile(mobile);
        DynamicObject signComHis = signBill.getDynamicObject("actualsigncompanyhis");
        if (signComHis != null) {
            long lawentityId = signComHis.getDynamicObject("lawentity") != null ? signComHis.getLong("lawentity.id") : 0L;
            signReqParam.setLawEntityId(Long.valueOf(lawentityId));
        }
        DynamicObject cardTypeDy = signBill.getDynamicObject("cardtype");
        signReqParam.setIdentityType(String.valueOf(cardTypeDy.getLong("id")));
        signReqParam.setIdentity(signBill.getString("cardnumber"));
        signReqParam.setBusinessId(signBill.getString("id"));
        signReqParam.setAppNum("hlcm");
        signReqParam.setCloud("hr");
        String signMode = signBill.getString("signmode");
        if (HRStringUtils.equals((String)signMode, (String)SignModeEnum.BATCH_MULTASK.getValue())) {
            this.addOneFile(contractTemplate, signReqParam);
        } else {
            this.addMultiFiles(signBill, signReqParam);
        }
        return signReqParam;
    }

    private void addOneFile(DynamicObject contractTemplate, SignReqParam signReqParam) {
        FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
        String signDocUrl = contractTemplate.getString("presigndocurl");
        String filePath = attachFileServiceExt.getRealPath(signDocUrl);
        String fileName = filePath.substring(filePath.lastIndexOf(47) + 1, filePath.lastIndexOf(46));
        signReqParam.addFile(fileName, filePath);
    }

    private SignReqParam buildSignReqParam(DynamicObject signBill) {
        Long fiOrgId = this.getReOrgAdminOrgId(signBill);
        long lawentityId = 0L;
        DynamicObject signComHis = signBill.getDynamicObject("actualsigncompanyhis");
        if (signComHis != null) {
            lawentityId = signComHis.getDynamicObject("lawentity") != null ? signComHis.getLong("lawentity.id") : 0L;
        }
        return new SignReqParam(fiOrgId, Long.valueOf(lawentityId));
    }

    private void addMultiFiles(DynamicObject signBill, SignReqParam signReqParam) {
        FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
        DynamicObjectCollection entryCollection = signBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject contractTemplate : entryCollection) {
            String signDocUrl = contractTemplate.getString("presigndocurl");
            String filePath = attachFileServiceExt.getRealPath(signDocUrl);
            String fileName = filePath.substring(filePath.lastIndexOf(47) + 1, filePath.lastIndexOf(46));
            signReqParam.addFile(fileName, filePath);
        }
    }

    @Override
    public boolean isSupportBatchSign() {
        boolean isSupportBatchSign = (Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"isSupportMergeSign", (Object[])new Object[0]);
        LOGGER.info("response isSupportBatchSign|{}", (Object)isSupportBatchSign);
        return isSupportBatchSign;
    }

    @Override
    public SignRespParam getBatchSignUrl(DynamicObject signBill, List<String> contractNos) {
        Map<String, Object> params = this.buildBatchSignUrlParams(signBill, contractNos);
        LOGGER.info("getBatchSignUrl params|{}", params);
        SignRespParam signRespParam = (SignRespParam)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSEContractService", (String)"getBatchSignUrl", (Object[])new Object[]{params});
        LOGGER.info("getBatchSignUrl response signRespParam|{}", (Object)signRespParam);
        return signRespParam;
    }

    private Map<String, Object> buildBatchSignUrlParams(DynamicObject signBill, List<String> contractNos) {
        String mobile = signBill.getString("empphone");
        String accountName = mobile.replace("+86", "").replace("-", "");
        String redirectUrl = UrlService.getDomainContextUrl() + String.format("/mobile.html?form=%s&id=%s", "hlcm_signresult", signBill.getString("id"));
        SignReqParam signReqParam = this.buildSignReqParam(signBill);
        Long lawEntityId = signReqParam.getLawEntityId();
        if (lawEntityId == null || lawEntityId == 0L) {
            lawEntityId = signReqParam.getFiorg();
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)5);
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException exp) {
            LOGGER.error("URLEncoder encode", (Throwable)exp);
            throw new KDBizException(exp.getMessage());
        }
        params.put("contractNos", contractNos);
        params.put("lawEntityId", lawEntityId);
        params.put("accountName", accountName);
        params.put("redirectUrl", redirectUrl);
        params.put("signAllTasks", Boolean.TRUE);
        return params;
    }
}

