/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.inherit.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.domian.service.inherit.InheritDataService;
import kd.hr.hlcm.business.domian.service.inherit.service.InheritContractDomainDataService;
import kd.hr.hlcm.business.domian.service.inherit.service.InheritEmpProtocolDomainDataService;
import kd.hr.hlcm.business.domian.service.inherit.service.InheritOtherProtocolDomainDataService;

public class InheritDataServiceImpl
implements InheritDataService {
    private static final Log LOGGER = LogFactory.getLog(InheritDataServiceImpl.class);

    @Override
    public Map<String, Object> doInherit(List<Map<String, Object>> paramList, String type) {
        HashMap<Long, DynamicObject> targetMap = new HashMap(paramList.size());
        Map<String, Object> resultMap = new HashMap<String, Object>();
        switch (type) {
            case "1": {
                targetMap = this.convertDy(paramList, "hlcm_contract");
                InheritContractDomainDataService inheritContractDomainDataService = new InheritContractDomainDataService();
                inheritContractDomainDataService.setTargetMapForInherit(targetMap);
                resultMap = inheritContractDomainDataService.saveForInherit();
                break;
            }
            case "2": {
                targetMap = this.convertDy(paramList, "hlcm_contractfileemp");
                InheritEmpProtocolDomainDataService inheritEmpProtocolDomainDataService = new InheritEmpProtocolDomainDataService();
                inheritEmpProtocolDomainDataService.setTargetMapForInherit(targetMap);
                resultMap = inheritEmpProtocolDomainDataService.saveForInherit();
                break;
            }
            case "3": {
                targetMap = this.convertDy(paramList, "hlcm_contractfileother");
                InheritOtherProtocolDomainDataService inheritOtherProtocolDomainDataService = new InheritOtherProtocolDomainDataService();
                inheritOtherProtocolDomainDataService.setTargetMapForInherit(targetMap);
                resultMap = inheritOtherProtocolDomainDataService.saveForInherit();
                break;
            }
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> doInheritForSX(List<Map<String, Object>> paramList) {
        HashMap<Long, DynamicObject> targetMap = new HashMap(paramList.size());
        Map<Object, Object> resultMap = new HashMap<String, Boolean>();
        try (TXHandle txHandle = TX.requiresNew();){
            targetMap = this.convertDy(paramList, "hlcm_contract");
            InheritContractDomainDataService inheritContractDomainDataService = new InheritContractDomainDataService();
            inheritContractDomainDataService.setTargetMapForInherit(targetMap);
            resultMap = inheritContractDomainDataService.saveForInherit();
        }
        return resultMap;
    }

    private Map<Long, DynamicObject> convertDy(List<Map<String, Object>> paramList, String pageNumber) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(paramList.size());
        Map<String, Map<String, DynamicObject>> baseDataMap = this.getBaseDataDyByPKId(paramList);
        paramList.forEach(paramMap -> {
            List contracttemplateList;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageNumber);
            DynamicObject targetDy = serviceHelper.generateEmptyDynamicObject();
            Map jobMap = (Map)baseDataMap.get("job");
            targetDy.set("job", CollectionUtils.isEmpty((Map)jobMap) ? null : jobMap.get(String.valueOf(paramMap.get("job"))));
            Map positionMap = (Map)baseDataMap.get("position");
            targetDy.set("position", CollectionUtils.isEmpty((Map)positionMap) ? null : positionMap.get(String.valueOf(paramMap.get("position"))));
            Map stdpositionMap = (Map)baseDataMap.get("stdposition");
            targetDy.set("stdposition", CollectionUtils.isEmpty((Map)stdpositionMap) ? null : stdpositionMap.get(String.valueOf(paramMap.get("stdposition"))));
            Map departmentMap = (Map)baseDataMap.get("department");
            targetDy.set("department", CollectionUtils.isEmpty((Map)departmentMap) ? null : departmentMap.get(String.valueOf(paramMap.get("department"))));
            Map contracttypeMap = (Map)baseDataMap.get("contracttype");
            targetDy.set("contracttype", CollectionUtils.isEmpty((Map)contracttypeMap) ? null : contracttypeMap.get(String.valueOf(paramMap.get("contracttype"))));
            Map periodtypeMap = (Map)baseDataMap.get("periodtype");
            targetDy.set("periodtype", CollectionUtils.isEmpty((Map)periodtypeMap) ? null : periodtypeMap.get(String.valueOf(paramMap.get("periodtype"))));
            Map actualsigncompanyMap = (Map)baseDataMap.get("actualsigncompany");
            targetDy.set("actualsigncompany", CollectionUtils.isEmpty((Map)actualsigncompanyMap) ? null : actualsigncompanyMap.get(String.valueOf(paramMap.get("actualsigncompany"))));
            targetDy.set("id", paramMap.get("id"));
            targetDy.set("empnumber", HRObjectUtils.isEmpty(paramMap.get("empnumber")) ? null : String.valueOf(paramMap.get("empnumber")));
            targetDy.set("number", HRObjectUtils.isEmpty(paramMap.get("number")) ? null : String.valueOf(paramMap.get("number")));
            targetDy.set("period", paramMap.get("period"));
            targetDy.set("periodunit", HRObjectUtils.isEmpty(paramMap.get("periodunit")) ? null : String.valueOf(paramMap.get("periodunit")));
            targetDy.set("protocoltype", HRObjectUtils.isEmpty(paramMap.get("protocoltype")) ? null : String.valueOf(paramMap.get("protocoltype")));
            targetDy.set("enddate", HRObjectUtils.isEmpty(paramMap.get("enddate")) ? null : (Date)paramMap.get("enddate"));
            targetDy.set("actualenddate", HRObjectUtils.isEmpty(paramMap.get("actualenddate")) ? null : (Date)paramMap.get("actualenddate"));
            targetDy.set("startdate", HRObjectUtils.isEmpty(paramMap.get("startdate")) ? null : (Date)paramMap.get("startdate"));
            targetDy.set("signeddate", HRObjectUtils.isEmpty(paramMap.get("signeddate")) ? null : (Date)paramMap.get("signeddate"));
            targetDy.set("businesstype", HRObjectUtils.isEmpty(paramMap.get("businesstype")) ? null : String.valueOf(paramMap.get("businesstype")));
            targetDy.set("signstatus", HRObjectUtils.isEmpty(paramMap.get("signstatus")) ? null : String.valueOf(paramMap.get("signstatus")));
            targetDy.set("probationstartdate", HRObjectUtils.isEmpty(paramMap.get("probationstartdate")) ? null : (Date)paramMap.get("probationstartdate"));
            targetDy.set("probationenddate", HRObjectUtils.isEmpty(paramMap.get("probationenddate")) ? null : (Date)paramMap.get("probationenddate"));
            targetDy.set("probationperiod", paramMap.get("probationperiod"));
            targetDy.set("probationunit", HRObjectUtils.isEmpty(paramMap.get("probationunit")) ? null : String.valueOf(paramMap.get("probationunit")));
            if ("hlcm_contract".equals(pageNumber)) {
                targetDy.set("origincontractnumber", HRObjectUtils.isEmpty(paramMap.get("origincontractnumber")) ? null : String.valueOf(paramMap.get("origincontractnumber")));
                targetDy.set("renewcount", paramMap.get("renewcount"));
            }
            if ("hlcm_contractfileother".equals(pageNumber)) {
                targetDy.set("maincontract", HRObjectUtils.isEmpty(paramMap.get("maincontract")) ? null : String.valueOf(paramMap.get("maincontract")));
                targetDy.set("contractenddate", HRObjectUtils.isEmpty(paramMap.get("contractenddate")) ? null : (Date)paramMap.get("contractenddate"));
            }
            if (!CollectionUtils.isEmpty((Collection)(contracttemplateList = (List)paramMap.get("contracttemplate")))) {
                Map contracttemplateMap = (Map)baseDataMap.get("contracttemplate");
                DynamicObject contractTemp = (DynamicObject)contracttemplateMap.get(String.valueOf(contracttemplateList.get(0)));
                DynamicObjectCollection contractText = targetDy.getDynamicObjectCollection("entryentity");
                DynamicObject dynamicObject = contractText.addNew();
                dynamicObject.set("contracttemplate", (Object)contractTemp);
            }
            resultMap.put((Long)paramMap.get("id"), targetDy);
        });
        return resultMap;
    }

    private Map<String, Map<String, DynamicObject>> getBaseDataDyByPKId(List<Map<String, Object>> paramList) {
        HashMap<String, Map<String, DynamicObject>> resultMap = new HashMap<String, Map<String, DynamicObject>>();
        ArrayList<Object> jobList = new ArrayList<Object>(paramList.size());
        ArrayList<Object> positionList = new ArrayList<Object>(paramList.size());
        ArrayList<Object> stdpositionList = new ArrayList<Object>(paramList.size());
        ArrayList<Object> departmentList = new ArrayList<Object>(paramList.size());
        ArrayList<Object> actualSignCompanyList = new ArrayList<Object>(paramList.size());
        ArrayList<Object> periodTypeList = new ArrayList<Object>(paramList.size());
        ArrayList<Object> contractTypeList = new ArrayList<Object>(paramList.size());
        ArrayList<Object> contractTemplateList = new ArrayList<Object>();
        paramList.forEach(paramMap -> {
            Object jobId = paramMap.get("job");
            Object positionId = paramMap.get("position");
            Object stdpositionId = paramMap.get("stdposition");
            Object departmentId = paramMap.get("department");
            Object actualSignCompanyId = paramMap.get("actualsigncompany");
            Object periodTypeId = paramMap.get("periodtype");
            Object contractTypeId = paramMap.get("contracttype");
            List contractTemplateId = (List)paramMap.get("contracttemplate");
            jobList.add(jobId);
            positionList.add(positionId);
            stdpositionList.add(stdpositionId);
            departmentList.add(departmentId);
            actualSignCompanyList.add(actualSignCompanyId);
            periodTypeList.add(periodTypeId);
            contractTypeList.add(contractTypeId);
            contractTemplateList.addAll(contractTemplateId);
        });
        Map<String, DynamicObject> jobMap = this.queryByPKListHisModel(jobList, "hbjm_jobhr");
        Map<String, DynamicObject> positionMap = this.queryByPKListHisModel(positionList, "hbpm_positionhr");
        Map<String, DynamicObject> stdpositionMap = this.queryByPKListHisModel(stdpositionList, "hbpm_stposition");
        Map<String, DynamicObject> departmentMap = this.queryByPKListHisModel(departmentList, "haos_adminorghr");
        Map<String, DynamicObject> actualSignCompanyMap = this.queryByPKList(actualSignCompanyList, "hbss_signcompany");
        Map<String, DynamicObject> periodTypeMap = this.queryByPKList(periodTypeList, "hbss_timelimittype");
        Map<String, DynamicObject> contractTypeMap = this.queryByPKList(contractTypeList, "hbss_contracttypes");
        Map<String, DynamicObject> contractTemplateMap = this.queryByPKList(contractTemplateList, "hlcm_contracttemplate");
        resultMap.put("job", jobMap);
        resultMap.put("position", positionMap);
        resultMap.put("stdposition", stdpositionMap);
        resultMap.put("department", departmentMap);
        resultMap.put("actualsigncompany", actualSignCompanyMap);
        resultMap.put("periodtype", periodTypeMap);
        resultMap.put("contracttype", contractTypeMap);
        resultMap.put("contracttemplate", contractTemplateMap);
        return resultMap;
    }

    private Map<String, DynamicObject> queryByPKList(List<Object> pkList, String pageNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageNumber);
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>();
        if (!CollectionUtils.isEmpty(pkList)) {
            DynamicObject[] objects = serviceHelper.loadDynamicObjectArray(pkList.toArray());
            Arrays.stream(objects).forEach(dy -> resultMap.put(String.valueOf(dy.getLong("id")), (DynamicObject)dy));
            return resultMap;
        }
        return resultMap;
    }

    private Map<String, DynamicObject> queryByPKListHisModel(List<Object> pkList, String pageNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageNumber);
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>();
        if (!CollectionUtils.isEmpty(pkList)) {
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter idFilter = new QFilter("id", "in", pkList);
            QFilter[] paramFilters = new QFilter[]{idFilter, currentVersionFilter};
            DynamicObject[] objects = serviceHelper.loadDynamicObjectArray(paramFilters);
            Arrays.stream(objects).forEach(dy -> resultMap.put(String.valueOf(dy.getLong("id")), (DynamicObject)dy));
            return resultMap;
        }
        return resultMap;
    }
}

