/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.initdata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.hismodel.IContractHisModel;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.business.service.ContractTplService;
import kd.hr.hlcm.business.utils.HLCMImportUtils;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.common.entity.ErManQueryParam;
import kd.hr.hlcm.common.entity.ErManQueryResult;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;

public abstract class CommonInitDomainDataService
extends AbstractInitDomainDataService {
    private static final Log LOGGER = LogFactory.getLog(CommonInitDomainDataService.class);
    protected Map<Long, DynamicObject> filterdMap = new HashMap<Long, DynamicObject>();
    protected Map<Long, DynamicObject> failObjectMap = new HashMap<Long, DynamicObject>();
    protected Map<String, DynamicObject> failNumberMap = new HashMap<String, DynamicObject>();
    protected Map<Long, DynamicObject> targetMap = new HashMap<Long, DynamicObject>();
    protected Map<Long, String> validateMsgForInheritMap = new HashMap<Long, String>();
    private static final String SUCCESS_KEY = "success";
    private static final String MESSAGE_KEY = "message";
    private static final String DATA_KEY = "data";
    private static final String ERR_KEY = "errInfos";

    protected abstract String doCheckErManFile(Long var1, List<Long> var2, Long var3);

    protected abstract void difDistinct(Map<Long, DynamicObject> var1, Map<Long, String> var2);

    protected abstract void preSetFields(Map<Long, DynamicObject> var1);

    protected abstract void difBusinessValid(Map<Long, ErManQueryResult> var1, Map<Long, DynamicObject> var2, Map<Long, String> var3);

    protected abstract void businessValidByErman(Map<Long, DynamicObject> var1, Map<Long, String> var2);

    protected abstract void assembleDifFields(DynamicObject var1);

    protected void saveValid(Map<Long, DynamicObject> targetMap) {
    }

    public void validate() {
        LOGGER.info("CommonInitDomainDataService.validate.begin..");
        Map dataMap = this.getInfoWithDynamicObject();
        Map idMap = (Map)dataMap.get("idmapping");
        List dataList = (List)dataMap.get(DATA_KEY);
        LOGGER.info("CommonInitDomainDataService.validate.object.size={}", (Object)dataList.size());
        LOGGER.info("CommonInitDomainDataService.validate.mid.size={}", (Object)idMap.size());
        this.targetMap = this.transferMap(dataList, idMap);
        LOGGER.info("hlcm.CommonInitDomainDataService.preValidate.begin..");
        if (!CollectionUtils.isEmpty(this.targetMap)) {
            HashMap<Long, DynamicObject> successMap = new HashMap<Long, DynamicObject>(this.targetMap.size());
            HashMap<Long, String> failMap = new HashMap<Long, String>(this.targetMap.size());
            this.preHandle(this.targetMap, failMap);
            this.businessValidate(this.targetMap, failMap);
            this.assembleValidateResult(failMap, successMap);
            failMap.forEach((mid, esg) -> this.getInitOutParam().addErrorMsg(mid, esg));
            successMap.keySet().forEach(mid -> this.getInitOutParam().addSuccessMsg(mid, "", ""));
        }
    }

    protected void assembleValidateResult(Map<Long, String> failMap, Map<Long, DynamicObject> successMap) {
        for (Map.Entry<Long, DynamicObject> entry : this.targetMap.entrySet()) {
            Long midId = entry.getKey();
            DynamicObject dy = entry.getValue();
            if (failMap.get(midId) != null) continue;
            successMap.put(midId, dy);
        }
        LOGGER.info("assembleValidateResult.successMap.size = {},failMap.size={}", (Object)successMap.size(), (Object)failMap.size());
        this.filterdMap = successMap;
    }

    protected void preHandle(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        this.difDistinct(targetMap, failMap);
        this.preSetFields(targetMap);
    }

    public void save() {
        this.validate();
        HashMap<Long, DynamicObject> dysMap = new HashMap<Long, DynamicObject>();
        Map<Long, DynamicObject> resultMap = this.assembleDataByErmanInfo(this.filterdMap, dysMap);
        this.saveValid(resultMap);
        Set idSet = resultMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        dysMap.keySet().removeIf(key -> !idSet.contains(key));
        LOGGER.info("dysMap size|{}", (Object)dysMap.size());
        if (dysMap.isEmpty()) {
            return;
        }
        DLock dLock = DLock.create((String)String.join((CharSequence)"_", this.getInitInParam().getEntityNumber(), String.valueOf(this.getInitInParam().getExecTaskId())));
        if (!dLock.tryLock()) {
            LOGGER.info("======not trylock:{} ===", (Object)this.getInitInParam().getEntityNumber());
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u83b7\u53d6\u9501\u5931\u8d25\uff1b", (String)"CommonInitDomainDataService_24", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        try {
            DynamicObject[] dys = resultMap.values().toArray(new DynamicObject[0]);
            if (dys != null && dys.length > 0) {
                IContractHisModel.getInstance().hisVersionSave(dysMap.values().toArray(new DynamicObject[0]));
                if (!CollectionUtils.isEmpty(resultMap)) {
                    for (Map.Entry<Long, DynamicObject> entry : resultMap.entrySet()) {
                        Long midId = entry.getKey();
                        DynamicObject tmpDy = entry.getValue();
                        this.getInitOutParam().addSuccessMsg(midId, String.valueOf(tmpDy.getLong("id")), "");
                    }
                }
            }
        }
        catch (Exception exp) {
            LOGGER.error("==contract init save error==", (Throwable)exp);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u5199\u5165\u5f02\u5e38\u3002", (String)"CommonInitDomainDataService_16", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        finally {
            dLock.unlock();
        }
    }

    private Map<Long, Map> transferListToMap(String keyString, List<Map> list) {
        HashMap<Long, Map> resultMap = new HashMap<Long, Map>(list.size());
        list.forEach(map -> {
            if (HRStringUtils.isEmpty((String)keyString)) {
                Long personId = (Long)map.get("person_id");
                resultMap.put(personId, (Map)map);
                return;
            }
            Long employeeId = (Long)map.get(keyString);
            resultMap.put(employeeId, (Map)map);
        });
        return resultMap;
    }

    protected Map<Long, DynamicObject> assembleDataByErmanInfo(Map<Long, DynamicObject> filterdMap, Map<Long, DynamicObject> dysMap) {
        List<Long> ermanfiles = filterdMap.values().stream().map(dynamicObject -> dynamicObject.getLong("ermanfile")).collect(Collectors.toList());
        List<Map<String, Object>> erManFileInfos = IHSPMFileService.getInstance().getAllCardFieldByErManFileIds(ermanfiles);
        HashMap ermanidToermanInfoMap = new HashMap(erManFileInfos.size());
        HashSet personSet = new HashSet(erManFileInfos.size());
        HashSet employeeSet = new HashSet(erManFileInfos.size());
        erManFileInfos.stream().forEach(erManFileInfo -> {
            Long ermanId = (Long)erManFileInfo.get("id");
            ermanidToermanInfoMap.put(ermanId, erManFileInfo);
            Object personIDObj = erManFileInfo.get("person_id");
            if (!HRObjectUtils.isEmpty(personIDObj)) {
                Long personId = Long.valueOf(personIDObj.toString());
                personSet.add(personId);
            }
            Object employeeIdObj = erManFileInfo.get("employee_id");
            Long employeeId = Long.valueOf(String.valueOf(employeeIdObj));
            employeeSet.add(employeeId);
        });
        ArrayList personParamList = Lists.newArrayList(personSet);
        List perCreList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{personParamList, null, "hrpi_percre"});
        List perAddressDyList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{personParamList, null, "hrpi_peraddress"});
        Map<Long, Map> perCreMap = this.transferListToMap(null, perCreList);
        Iterator<Map.Entry<Long, DynamicObject>> iterator = filterdMap.entrySet().iterator();
        ArrayList<Long> departIds = new ArrayList<Long>(filterdMap.size());
        ArrayList<Long> positionIds = new ArrayList<Long>(filterdMap.size());
        ArrayList<Long> stdPositionIds = new ArrayList<Long>(filterdMap.size());
        ArrayList<Long> jobIds = new ArrayList<Long>(filterdMap.size());
        ArrayList<Long> companyIds = new ArrayList<Long>(filterdMap.size());
        while (iterator.hasNext()) {
            List<Map> collect;
            Map.Entry<Long, DynamicObject> next = iterator.next();
            Long mid = next.getKey();
            DynamicObject dy = next.getValue();
            long ermanfile = dy.getLong("ermanfile");
            Map erManFileInfo2 = (Map)ermanidToermanInfoMap.get(ermanfile);
            Date startdate = dy.getDate("startdate");
            if (CollectionUtils.isEmpty((Map)erManFileInfo2)) {
                String errMsg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8be5\u4eba\u5458\u7684\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u662f\u5426\u521d\u59cb\u5316\u5b8c\u6210\uff1b", (String)"CommonInitDomainDataService_25", (String)"hr-hlcm-business", (Object[])new Object[0]);
                this.getInitOutParam().addErrorMsg(mid, errMsg);
                iterator.remove();
                continue;
            }
            Date useStartDate = (Date)erManFileInfo2.get("startdate");
            LOGGER.info("assembleDataByErmanInfo.useStartDate={}", (Object)useStartDate);
            if (useStartDate != null && !this.checkUseStartDate(startdate, useStartDate, mid, iterator)) continue;
            dy.set("postype", erManFileInfo2.get("postype_id"));
            if ("1".equals(dy.getString("protocoltype")) && "1010".equals(String.valueOf(erManFileInfo2.get("postype_id")))) {
                dy.set("contractcategory", (Object)"1");
            }
            if ("1".equals(dy.getString("protocoltype")) && "1040".equals(String.valueOf(erManFileInfo2.get("postype_id")))) {
                dy.set("contractcategory", (Object)"2");
            }
            Long personId = HRJSONUtils.getLongValOfCustomParam(erManFileInfo2.get("person_id"));
            dy.set("person_id", (Object)personId);
            Long employeeId = HRJSONUtils.getLongValOfCustomParam(erManFileInfo2.get("employee_id"));
            dy.set("employee_id", (Object)employeeId);
            String phone = (String)erManFileInfo2.get("phone");
            dy.set("empphone", (Object)phone);
            dy.set("baselocation", erManFileInfo2.get("location_id"));
            dy.set("ermanperorg", erManFileInfo2.get("empgroup_id"));
            dy.set("org", erManFileInfo2.get("org_id"));
            dy.set("adminororg", erManFileInfo2.get("affiliateadminorg_id"));
            dy.set("signedcompany", erManFileInfo2.get("company_id"));
            dy.set("ermanorg", erManFileInfo2.get("org_id"));
            DynamicObject actualDy = dy.getDynamicObject("actualsigncompany");
            if (actualDy != null) {
                dy.set("actualsigncompanyhis", actualDy.get("vid"));
            }
            this.setHisTemplate(dy);
            Map creMap = perCreMap.get(personId);
            if (!CollectionUtils.isEmpty((Map)creMap)) {
                dy.set("cardtype", creMap.get("credentialstype_id"));
                dy.set("cardnumber", creMap.get("number"));
            }
            if (!CollectionUtils.isEmpty(collect = perAddressDyList.stream().filter(perAddr -> personId.equals(perAddr.get("person_id"))).collect(Collectors.toList()))) {
                collect.forEach(perAddress -> {
                    Long addressTypeId = (Long)perAddress.get("addresstype_id");
                    if (1020L == addressTypeId) {
                        dy.set("householdregister", perAddress.get("addressinfo"));
                    } else if (1030L == addressTypeId) {
                        dy.set("residentialaddress", perAddress.get("addressinfo"));
                    } else {
                        LOGGER.info("addressTypeId|{}", (Object)addressTypeId);
                    }
                });
            }
            this.buildIds((Long)erManFileInfo2.get("adminorg_id"), departIds, dy, "department_id");
            dy.set("curdept", erManFileInfo2.get("adminorg_id"));
            this.buildIds((Long)erManFileInfo2.get("company_id"), companyIds, dy, "signedcompany_id");
            dy.set("curcompany", erManFileInfo2.get("company_id"));
            this.buildIds((Long)erManFileInfo2.get("position_id"), positionIds, dy, "position_id");
            dy.set("curpostion", erManFileInfo2.get("position_id"));
            this.buildIds((Long)erManFileInfo2.get("stdposition_id"), stdPositionIds, dy, "stdposition_id");
            dy.set("curstdpostion", erManFileInfo2.get("stdposition_id"));
            this.buildIds((Long)erManFileInfo2.get("job_id"), jobIds, dy, "job_id");
            dy.set("curjob", erManFileInfo2.get("job_id"));
            this.assembleCommonFields(dy, erManFileInfo2);
            this.assembleDifFields(dy);
        }
        if (!CollectionUtils.isEmpty(filterdMap)) {
            DynamicObject[] dys = filterdMap.values().toArray(new DynamicObject[0]);
            if (dys != null && dys.length > 0) {
                for (DynamicObject dy : dys) {
                    Long id = dy.getLong("id");
                    dysMap.put(id, dy);
                }
            }
            ContractRepository.getInstance().findAndSetHisId(dysMap, departIds, positionIds, stdPositionIds, jobIds, companyIds);
        }
        return filterdMap;
    }

    protected boolean checkUseStartDate(Date startdate, Date useStartDate, Long mid, Iterator<Map.Entry<Long, DynamicObject>> iterator) {
        if (ProxyUtils.isInitNeedCheckUseDate() && HRDateTimeUtils.dayBefore((Date)startdate, (Date)useStartDate)) {
            String startDataStr = HRDateTimeUtils.format((Date)startdate, (String)"yyyy-MM-dd");
            String useStartDateStr = HRDateTimeUtils.format((Date)useStartDate, (String)"yyyy-MM-dd");
            String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u8be5\u5458\u5de5\u7684\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201c\uff1b", (String)"CommonInitDomainDataService_14", (String)"hr-hlcm-business", (Object[])new Object[0]), startDataStr, useStartDateStr);
            this.getInitOutParam().addErrorMsg(mid, errMsg);
            iterator.remove();
            return false;
        }
        return true;
    }

    private void buildIds(Long id, List<Long> ids, DynamicObject dy, String key) {
        if (id != null && id != 0L) {
            ids.add(id);
            dy.set(key, (Object)id);
        }
    }

    protected void assembleCommonFields(DynamicObject dy, Map<String, Object> erManFileInfo) {
        this.setHlcmDefaultValue(dy);
        dy.set("businesstype", (Object)(HRStringUtils.isEmpty((String)dy.getString("businesstype")) ? "1" : dy.getString("businesstype")));
        dy.set("name", erManFileInfo.get("name"));
        if (Lists.newArrayList((Object[])new String[]{"4", "5"}).contains(dy.getString("signstatus"))) {
            dy.set("cancelreason", (Object)dy.getString("signreason"));
            dy.set("signreason", null);
        }
    }

    protected void setHlcmDefaultValue(DynamicObject dy) {
        this.setInitDefalutValue(Lists.newArrayList((Object[])new DynamicObject[]{dy}));
    }

    private void setHisTemplate(DynamicObject dy) {
        DynamicObjectCollection templates = dy.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)templates)) {
            for (DynamicObject template : templates) {
                DynamicObject contractTemplate = template.getDynamicObject("contracttemplate");
                if (contractTemplate == null) continue;
                template.set("texthis", (Object)contractTemplate.getLong("vid"));
                template.set("opperson", (Object)RequestContext.get().getCurrUserId());
                template.set("opdate", (Object)new Date());
            }
        }
    }

    protected Map<Long, ErManQueryResult> checkErman(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        ArrayList<ErManQueryParam> erManQueryParamList = new ArrayList<ErManQueryParam>();
        targetMap.forEach((mid, dyOb) -> {
            String empnumer = dyOb.getString("empnumber");
            String departmentName = dyOb.getString("department.number");
            DynamicObject positionObject = dyOb.getDynamicObject("position");
            DynamicObject stdpositionObject = dyOb.getDynamicObject("stdposition");
            DynamicObject jobObject = dyOb.getDynamicObject("job");
            String position = null;
            String stdPosition = null;
            String job = null;
            if (!HRObjectUtils.isEmpty((Object)positionObject)) {
                position = positionObject.getString("number");
            }
            if (!HRObjectUtils.isEmpty((Object)stdpositionObject)) {
                stdPosition = stdpositionObject.getString("number");
            }
            if (!HRObjectUtils.isEmpty((Object)jobObject)) {
                job = jobObject.getString("number");
            }
            ErManQueryParam erManQueryParam = new ErManQueryParam(empnumer, departmentName, position, stdPosition, job, 0);
            erManQueryParam.setMid(mid);
            erManQueryParamList.add(erManQueryParam);
        });
        Map<ErManQueryParam, ErManQueryResult> erManQueryResultMap = HLCMImportUtils.queryInitErManFile(erManQueryParamList);
        LOGGER.info("CommonInitDomainDataService.checkErman.ErManQueryParam={}", (Object)erManQueryResultMap.keySet().toString());
        Map<Long, ErManQueryResult> midResultMap = this.changeKeyToLong(erManQueryResultMap);
        LOGGER.info("CommonInitDomainDataService.checkErman.afterTransfer={}", midResultMap.keySet());
        for (Map.Entry<Long, DynamicObject> next : targetMap.entrySet()) {
            ErManQueryResult erManQueryResult = midResultMap.get(next.getKey());
            StringBuilder msg = new StringBuilder();
            if (HRObjectUtils.isEmpty((Object)erManQueryResult)) {
                LOGGER.info("CommonInitDomainDataService.checkErman.mid={}.erManQueryResult={}", (Object)next.getKey(), (Object)erManQueryResult);
                msg.append(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8be5\u5458\u5de5\u7684\u5de5\u53f7\u3001\u6240\u5c5e\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u3001\u90e8\u95e8\u662f\u5426\u6b63\u786e\uff1b", (String)"CommonInitDomainDataService_11", (String)"hr-hlcm-business", (Object[])new Object[0]));
                this.buildErrMsgMap(failMap, msg, next.getKey());
                continue;
            }
            next.getValue().set("ermanfile", (Object)erManQueryResult.getErManFileId());
        }
        return midResultMap;
    }

    protected void businessValidate(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        this.commomBusinessValidate(targetMap, failMap);
        Map<Long, ErManQueryResult> resultMap = this.checkErman(targetMap, failMap);
        this.difBusinessValid(resultMap, targetMap, failMap);
        this.businessValidByErman(targetMap, failMap);
    }

    private void commomBusinessValidate(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        HashSet<String> nums = new HashSet<String>(targetMap.size());
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            StringBuilder msg = new StringBuilder();
            DynamicObject value = entry.getValue();
            Long key = entry.getKey();
            String contractNumber = value.getString("number");
            if (HRStringUtils.isEmpty((String)contractNumber)) {
                msg.append(ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (String)"CommonInitDomainDataService_1", (String)"hr-hlcm-business", (Object[])new Object[0]));
            } else {
                nums.add(contractNumber);
            }
            DynamicObject position = value.getDynamicObject("position");
            DynamicObject stdposition = value.getDynamicObject("stdposition");
            DynamicObject job = value.getDynamicObject("job");
            if (HRObjectUtils.isEmpty((Object)position) && HRObjectUtils.isEmpty((Object)stdposition) && HRObjectUtils.isEmpty((Object)job)) {
                msg.append(ResManager.loadKDString((String)"\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u5fc5\u987b\u586b\u5199\u4e00\u4e2a\uff1b", (String)"CommonInitDomainDataService_2", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if (!(HRObjectUtils.isEmpty((Object)position) || HRObjectUtils.isEmpty((Object)stdposition) && HRObjectUtils.isEmpty((Object)job))) {
                msg.append(ResManager.loadKDString((String)"\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\uff1b", (String)"CommonInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]));
            } else if (!(HRObjectUtils.isEmpty((Object)stdposition) || HRObjectUtils.isEmpty((Object)position) && HRObjectUtils.isEmpty((Object)job))) {
                msg.append(ResManager.loadKDString((String)"\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\uff1b", (String)"CommonInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]));
            } else {
                LOGGER.info("stdposition|{},position|{},job|{}", new Object[]{stdposition, position, job});
            }
            if (HRStringUtils.isNotEmpty((String)value.getString("periodunit")) && !Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"}).contains(value.getString("periodunit"))) {
                msg.append(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u5355\u4f4d\u53ea\u80fd\u8f93\u5165\uff1a\u5e74\u3001\u4e2a\u6708\u3001\u5468\u3001\u5929\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_19", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)value.getString("signway")) && !Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(value.getString("signway"))) {
                msg.append(ResManager.loadKDString((String)"\u7b7e\u7f72\u65b9\u5f0f\u53ea\u80fd\u586b\u5199\u7eb8\u8d28\u7b7e\u7f72\u6216\u8005\u7535\u5b50\u7b7e\u7f72\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_20", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            msg.append(this.checkContractAndTemplateType(value).trim());
            this.buildErrMsgMap(failMap, msg, key);
        }
        this.checkNumberIsExist(nums, targetMap, failMap);
    }

    protected void checkEndDate(StringBuilder msg, DynamicObject value) {
        Date signedDate;
        DynamicObject periodTypeDy = value.getDynamicObject("periodtype");
        Date endDate = HRDateTimeUtils.truncateDate((Date)value.getDate("enddate"));
        Date actualEndDate = HRDateTimeUtils.truncateDate((Date)value.getDate("actualenddate"));
        if (!HRObjectUtils.isEmpty((Object)periodTypeDy)) {
            Object periodTypeId = periodTypeDy.getPkValue();
            if (endDate == null && Objects.equals(ContractPeriodTypeEnum.FIXED.getPkId(), periodTypeId)) {
                msg.append(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u56fa\u5b9a\u671f\u9650\u201d\u65f6\uff0c\u5408\u540c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\uff1b", (String)"CommonInitDomainDataService_4", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if (endDate != null && Objects.equals(ContractPeriodTypeEnum.NONFIXED.getPkId(), periodTypeId)) {
                msg.append(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u65e0\u56fa\u5b9a\u671f\u9650\u201d\uff0c\u65e0\u9700\u586b\u5199\u5408\u540c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff1b", (String)"CommonInitDomainDataService_5", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
        }
        Date startDate = HRDateTimeUtils.truncateDate((Date)value.getDate("startdate"));
        if (endDate != null && startDate.after(endDate)) {
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_21", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)endDate), HRDateTimeUtils.formatDate((Date)startDate)));
        }
        if (actualEndDate != null && startDate.after(actualEndDate)) {
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u5b9e\u9645\u7ed3\u675f\u65e5\u671f\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_22", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)actualEndDate), HRDateTimeUtils.formatDate((Date)startDate)));
        }
        if (endDate != null && actualEndDate != null && actualEndDate.after(endDate)) {
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u5b9e\u9645\u7ed3\u675f\u65e5\u671f\u201c%1$s\u201d\u4e0d\u80fd\u665a\u4e8e\u5408\u540c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_23", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)actualEndDate), HRDateTimeUtils.formatDate((Date)endDate)));
        }
        Date date = signedDate = value.getDate("signeddate") != null ? value.getDate("signeddate") : value.getDate("signeddatetmp");
        if (signedDate != null && endDate != null && signedDate.after(endDate)) {
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u201c%1$s\u201d\u4e0d\u80fd\u665a\u4e8e\u5408\u540c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_18", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)signedDate), HRDateTimeUtils.formatDate((Date)endDate)));
        }
    }

    protected void checkNumberIsExist(Set<String> nums, Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        Map<String, Long> numMap;
        DynamicObject[] dys = ContractRepository.getInstance().findContractsByField(nums, "number");
        if (dys != null && dys.length > 0 && !CollectionUtils.isEmpty(numMap = Arrays.stream(dys).filter(dy -> !HRStringUtils.isEmpty((String)dy.getString("number"))).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (oldValue, newValue) -> newValue)))) {
            this.validNumIsExist(targetMap, failMap, numMap);
        }
    }

    private void validNumIsExist(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap, Map<String, Long> numMap) {
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            StringBuilder msg = new StringBuilder();
            DynamicObject value = entry.getValue();
            Long key = entry.getKey();
            String contractNumber = value.getString("number");
            if (HRStringUtils.isEmpty((String)contractNumber) || numMap.get(contractNumber) == null) continue;
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_13", (String)"hr-hlcm-business", (Object[])new Object[0]), contractNumber));
            this.buildErrMsgMap(failMap, msg, key);
        }
    }

    protected void buildErrMsgMap(Map<Long, String> failMap, StringBuilder msg, Long key) {
        if (!HRStringUtils.isEmpty((String)msg.toString())) {
            if (failMap.get(key) == null) {
                failMap.put(key, msg.toString());
            } else {
                String tmpMsg = failMap.get(key);
                failMap.put(key, msg.append(tmpMsg).toString());
            }
        }
    }

    protected String checkContractAndTemplateType(DynamicObject dynamicObject) {
        StringBuilder msg = new StringBuilder();
        DynamicObject groupObject = dynamicObject.getDynamicObject("contracttype");
        if (HRObjectUtils.isEmpty((Object)groupObject)) {
            msg.append(ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0d\u5b58\u5728\uff1b", (String)"CommonInitDomainDataService_10", (String)"hr-hlcm-business", (Object[])new Object[0]));
        } else {
            String contractTypeNumber = dynamicObject.getDynamicObject("contracttype").getString("number");
            Long groupId = groupObject.getLong("group.id");
            if (HRStringUtils.equals((String)dynamicObject.getString("protocoltype"), (String)"1") && !Objects.equals(ContractTypeCatEnum.CON.getPkId(), groupId)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u201c%1$s\u201d\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u52b3\u52a8\u5408\u540c\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_26", (String)"hr-hlcm-business", (Object[])new Object[0]), contractTypeNumber));
            }
            if (HRStringUtils.equals((String)dynamicObject.getString("protocoltype"), (String)"2") && !Objects.equals(ContractTypeCatEnum.EMP.getPkId(), groupId)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u201c%1$s\u201d\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u7528\u5de5\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_27", (String)"hr-hlcm-business", (Object[])new Object[0]), contractTypeNumber));
            }
            if (HRStringUtils.equals((String)dynamicObject.getString("protocoltype"), (String)"3") && !Objects.equals(ContractTypeCatEnum.OTHER.getPkId(), groupId)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u201c%1$s\u201d\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_28", (String)"hr-hlcm-business", (Object[])new Object[0]), contractTypeNumber));
            }
        }
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (entryEntity.size() > 1) {
            msg.append(ResManager.loadKDString((String)"\u540c\u4e00\u4eba\u5458\uff0c\u5408\u540c\u7684\u5c5e\u6027\u5b8c\u5168\u76f8\u540c\u65f6\uff0c\u5728\u540c\u4e00\u6279\u6b21\u4ec5\u53ef\u6dfb\u52a0\u4e00\u4efd\u5408\u540c\u6a21\u7248;", (String)"CommonInitDomainDataService_29", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        entryEntity.forEach(entity -> {
            String templateNumber = entity.getString("contracttemplate.number");
            if (entity.getDynamicObject("contracttemplate") == null || entity.getDynamicObject("contracttemplate").getDynamicObject("contracttype") == null || entity.getDynamicObject("contracttemplate").getDynamicObject("contracttype").getDynamicObject("group") == null) {
                msg.append(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u7f16\u7801\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"SignImportBasePlugin_24", (String)"hr-hlcm-business", (Object[])new Object[0]));
            } else {
                Object groupId = entity.getDynamicObject("contracttemplate").getDynamicObject("contracttype").getDynamicObject("group").getPkValue();
                long templateId = entity.getLong("contracttemplate.id");
                if (ContractTplService.checkTplIsPreData(templateId)) {
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%1$s\u201d\u4e3a\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"BeginSignTemplate_18", (String)"hr-hlcm-business", (Object[])new Object[0]), templateNumber));
                }
                if (HRStringUtils.equals((String)dynamicObject.getString("protocoltype"), (String)"1") && !Objects.equals(ContractTypeCatEnum.CON.getPkId(), groupId)) {
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%1$s\u201d\u4e2d\u7684\u5408\u540c\u7c7b\u578b\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u52b3\u52a8\u5408\u540c\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"SignImportBasePlugin_21", (String)"hr-hlcm-business", (Object[])new Object[0]), templateNumber));
                }
                if (HRStringUtils.equals((String)dynamicObject.getString("protocoltype"), (String)"2") && !Objects.equals(ContractTypeCatEnum.EMP.getPkId(), groupId)) {
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%1$s\u201d\u4e2d\u7684\u5408\u540c\u7c7b\u578b\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u7528\u5de5\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"SignImportBasePlugin_22", (String)"hr-hlcm-business", (Object[])new Object[0]), templateNumber));
                }
                if (HRStringUtils.equals((String)dynamicObject.getString("protocoltype"), (String)"3") && !Objects.equals(ContractTypeCatEnum.OTHER.getPkId(), groupId)) {
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%1$s\u201d\u4e2d\u7684\u5408\u540c\u7c7b\u578b\u6240\u5c5e\u5408\u540c\u5927\u7c7b\u4e0d\u662f\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"SignImportBasePlugin_23", (String)"hr-hlcm-business", (Object[])new Object[0]), templateNumber));
                }
            }
        });
        return msg.toString();
    }

    private Map<Long, DynamicObject> transferMap(List<DynamicObject> dataList, Map<Long, Set<Long>> idMap) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>();
        dataList.forEach(dynamicObject -> {
            Long id = dynamicObject.getLong("id");
            Set longs = (Set)idMap.get(id);
            longs.forEach(midLong -> resultMap.put((Long)midLong, (DynamicObject)dynamicObject));
        });
        return resultMap;
    }

    private Map<Long, ErManQueryResult> changeKeyToLong(Map<ErManQueryParam, ErManQueryResult> erManQueryResultMap) {
        HashMap<Long, ErManQueryResult> resultMap = new HashMap<Long, ErManQueryResult>(erManQueryResultMap.size());
        erManQueryResultMap.forEach((erParam, erResult) -> resultMap.put(erParam.getMid(), (ErManQueryResult)erResult));
        return resultMap;
    }

    protected void removeCheckedBadData(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        Iterator<Map.Entry<Long, DynamicObject>> targetIterator = targetMap.entrySet().iterator();
        while (targetIterator.hasNext()) {
            Map.Entry<Long, DynamicObject> next = targetIterator.next();
            DynamicObject value = next.getValue();
            Long midId = next.getKey();
            if (!HRStringUtils.isNotEmpty((String)failMap.get(midId))) continue;
            this.failObjectMap.put(midId, value);
            this.failNumberMap.put(value.getString("number"), value);
            targetIterator.remove();
        }
    }

    public void setTargetMapForInherit(Map<Long, DynamicObject> dynamicMap) {
        this.targetMap = dynamicMap;
    }

    protected void DefalutValueForInherit(DynamicObject dy) {
        dy.set("initstatus", (Object)"2");
        dy.set("initdatasource", null);
        dy.set("initbatch", (Object)0L);
    }

    public void validateForInherit() {
        HashMap<Long, String> failMap = new HashMap<Long, String>(this.targetMap.size());
        HashMap<Long, DynamicObject> successMap = new HashMap<Long, DynamicObject>(this.targetMap.size());
        this.preHandle(this.targetMap, failMap);
        this.businessValidate(this.targetMap, failMap);
        this.assembleValidateResult(failMap, successMap);
        this.validateMsgForInheritMap = failMap;
    }

    public Map<String, Object> saveForInherit() {
        this.validate();
        HashMap<Long, DynamicObject> dysMap = new HashMap<Long, DynamicObject>();
        Map<Long, DynamicObject> resultMap = this.assembleDataByErmanInfo(this.filterdMap, dysMap);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            DynamicObject[] dys = resultMap.values().toArray(new DynamicObject[0]);
            if (dys != null && dys.length > 0) {
                HisResponse<VersionChangeRespData> hisResponse = IContractHisModel.getInstance().hisVersionSave(dysMap.values().toArray(new DynamicObject[0]));
                returnMap.put(SUCCESS_KEY, this.targetMap.size() == resultMap.size());
                returnMap.put(MESSAGE_KEY, this.targetMap.size() == resultMap.size() ? " all data inherit success" : "some data inherit fail,please focus on the errInfos of return map");
                returnMap.put(DATA_KEY, this.parseResponse(hisResponse));
                returnMap.put(ERR_KEY, this.validateMsgForInheritMap);
                return returnMap;
            }
            returnMap.put(SUCCESS_KEY, Boolean.FALSE);
            returnMap.put(MESSAGE_KEY, "all data can not pass business check");
            returnMap.put(DATA_KEY, Maps.newHashMap());
            returnMap.put(ERR_KEY, this.validateMsgForInheritMap);
            return returnMap;
        }
        catch (Exception exp) {
            LOGGER.error("saveForInherit.error", (Throwable)exp);
            returnMap.put(SUCCESS_KEY, Boolean.FALSE);
            returnMap.put(MESSAGE_KEY, "data inherit error");
            returnMap.put(DATA_KEY, Maps.newHashMap());
            returnMap.put(ERR_KEY, Maps.newHashMap());
            return returnMap;
        }
    }

    private Map<String, Object> parseResponse(HisResponse<VersionChangeRespData> hisResponse) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!HRObjectUtils.isEmpty(hisResponse)) {
            resultMap.put("code", hisResponse.getCode());
            resultMap.put("errorMessage", hisResponse.getErrorMessage());
            resultMap.put(DATA_KEY, this.parseData((VersionChangeRespData)hisResponse.getData()));
        }
        return resultMap;
    }

    private Map<String, Object> parseData(VersionChangeRespData versionChangeRespData) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!HRObjectUtils.isEmpty((Object)versionChangeRespData)) {
            resultMap.put("eventId", versionChangeRespData.getEventId());
            resultMap.put("entityNumber", versionChangeRespData.getEntityNumber());
            resultMap.put("newDynamicObjects", versionChangeRespData.getNewDynamicObjects());
        }
        return resultMap;
    }
}

