/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.initdata.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.initdata.CommonInitDomainDataService;
import kd.hr.hlcm.common.entity.ContractEntity;
import kd.hr.hlcm.common.entity.ErManQueryResult;
import kd.hr.hlcm.common.entity.PosTypePerson;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractFileSignStatusEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.LabRelTypeEnum;
import kd.hr.hlcm.common.enums.PostypeEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class ContractInitDomainDataService
extends CommonInitDomainDataService {
    private static final Log LOGGER = LogFactory.getLog(ContractInitDomainDataService.class);

    @Override
    protected void difDistinct(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        Iterator<Map.Entry<Long, DynamicObject>> iterator = targetMap.entrySet().iterator();
        HashMap<String, Long> origNumMap = new HashMap<String, Long>(targetMap.size());
        HashSet<String> origNumSet = new HashSet<String>(targetMap.size());
        this.checkOrigNumSame(targetMap, origNumMap, origNumSet);
        while (iterator.hasNext()) {
            Map.Entry<Long, DynamicObject> next = iterator.next();
            Long key = next.getKey();
            DynamicObject dy = next.getValue();
            StringBuilder msg = new StringBuilder();
            String origincontractnumber = dy.getString("origincontractnumber");
            if (dy.getString("number").equals(origincontractnumber)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u7684\u539f\u5408\u540c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u81ea\u5df1\u7684\u5408\u540c\u7f16\u53f7\uff0c\u8bf7\u4fee\u6539\uff1a", (String)"ContractInitDomainDataService_12", (String)"hr-hlcm-business", (Object[])new Object[0]), origincontractnumber));
            }
            if (origNumSet.contains(origincontractnumber)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u591a\u4efd\u5408\u540c\u7684\u201c\u539f\u5408\u540c\u7f16\u53f7\u201d\uff08%1$s\uff09\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_5", (String)"hr-hlcm-business", (Object[])new Object[0]), origincontractnumber));
            }
            if (!HRStringUtils.isNotEmpty((String)msg.toString())) continue;
            this.buildErrMsgMap(failMap, msg, key);
            this.failObjectMap.put(key, dy);
            this.failNumberMap.put(dy.getString("number"), dy);
            iterator.remove();
        }
    }

    @Override
    protected void preSetFields(Map<Long, DynamicObject> targetMap) {
        targetMap.values().stream().forEach(dy -> {
            dy.set("protocoltype", (Object)"1");
            dy.set("signstatus", (Object)(dy.getString("signstatus") != null ? dy.getString("signstatus") : dy.getString("signstatustmp")));
            if (HRStringUtils.isEmpty((String)dy.getString("empnumber"))) {
                dy.set("empnumber", (Object)dy.getString("person.number"));
            }
        });
    }

    @Override
    protected String doCheckErManFile(Long posTypeId, List<Long> laborRelTypeClsId, Long labrelStatusPrdId) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList posTypeIds = Lists.newArrayList((Object[])new Long[]{PostypeEnum.FULL.getCombKey(), PostypeEnum.EXPATRIATE.getCombKey()});
        if (!posTypeIds.contains(posTypeId)) {
            stringBuilder.append(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u4efb\u804c\u7c7b\u578b\u4e0d\u662f\u4e3b\u4efb\u804c\u6216\u5916\u6d3e\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u5458\u5de5\u7684\u6240\u5c5e\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u6216\u90e8\u95e8\uff1b", (String)"ContractInitDomainDataService_0", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(laborRelTypeClsId) || !Lists.newArrayList((Object[])new Long[]{LabRelTypeEnum.EMPLOYMENT.getCombKey()}).contains(laborRelTypeClsId.get(0))) {
            stringBuilder.append(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u7528\u5de5\u7c7b\u578b\u5206\u7c7b\u4e0d\u662f\u96c7\u4f63\u7c7b\uff0c\u8bf7\u4fee\u6539\u5458\u5de5\u7684\u6240\u5c5e\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u6216\u90e8\u95e8\uff1b", (String)"ContractInitDomainDataService_1", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        return stringBuilder.toString().trim();
    }

    private void businessErmanValid(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        Map<String, DynamicObject> numMap;
        Iterator<Map.Entry<Long, DynamicObject>> iterator = targetMap.entrySet().iterator();
        HashSet<String> nums = new HashSet<String>(targetMap.size());
        HashMap<String, ContractEntity> contractEntityMap = new HashMap<String, ContractEntity>(targetMap.size());
        while (iterator.hasNext()) {
            ContractEntity contractEntity;
            Map.Entry<Long, DynamicObject> next = iterator.next();
            DynamicObject dy2 = next.getValue();
            String origincontractnumber = dy2.getString("origincontractnumber");
            if (HRStringUtils.isNotEmpty((String)origincontractnumber)) {
                nums.add(origincontractnumber);
                contractEntity = new ContractEntity(dy2, "0", "");
                contractEntityMap.put(dy2.getString("number"), contractEntity);
                continue;
            }
            contractEntity = new ContractEntity(dy2, "1", "");
            contractEntityMap.put(dy2.getString("number"), contractEntity);
        }
        DynamicObject[] dys = ContractRepository.getInstance().findContractsByField(nums, "number");
        if (dys != null && dys.length > 0 && !CollectionUtils.isEmpty(numMap = Arrays.stream(dys).filter(dy -> !HRStringUtils.isEmpty((String)dy.getString("number"))).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (oldValue, newValue) -> newValue)))) {
            contractEntityMap = this.validOriNumIsExist(targetMap, failMap, numMap);
        }
        if (!CollectionUtils.isEmpty(contractEntityMap)) {
            for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
                Long mid = entry.getKey();
                DynamicObject dy3 = entry.getValue();
                StringBuilder msg = new StringBuilder();
                String number = dy3.getString("number");
                if (this.checkOriIsSelf(number, contractEntityMap)) continue;
                ContractEntity contractEntity = (ContractEntity)contractEntityMap.get(number);
                msg.append(contractEntity.getMsg());
                this.buildErrMsgMap(failMap, msg, mid);
            }
        }
    }

    @Override
    protected void difBusinessValid(Map<Long, ErManQueryResult> midResultMap, Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        LOGGER.info("ContractInitDomainDataService.businessValid.begin..");
        for (Map.Entry<Long, DynamicObject> next : targetMap.entrySet()) {
            ErManQueryResult erManQueryResult;
            String probationunit;
            Long key = next.getKey();
            DynamicObject dy = next.getValue();
            StringBuilder msg = new StringBuilder();
            this.checkEndDate(msg, dy);
            if (dy.getInt("renewcount") > 100 || dy.getInt("renewcount") < 0) {
                msg.append(ResManager.loadKDString((String)"\u7eed\u7b7e\u6b21\u6570\u8bf7\u8f93\u51651\u81f3100\u7684\u6574\u6570\uff1b", (String)"CommonInitDomainDataService_9", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if ("1".equals(dy.getString("businesstype")) && HRStringUtils.isNotEmpty((String)dy.getString("origincontractnumber"))) {
                msg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u7684\u7b7e\u7f72\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u65b0\u7b7e\u201d\uff0c\u539f\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u4e3a\u7a7a\uff1b", (String)"ContractInitDomainDataService_6", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if (!Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey()}).contains(dy.getString("businesstype"))) {
                msg.append(ResManager.loadKDString((String)"\u7b7e\u7f72\u4e1a\u52a1\u7c7b\u578b\u53ea\u80fd\u8f93\u5165\uff1a\u65b0\u7b7e\u3001\u7eed\u7b7e\u3001\u6539\u7b7e\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_7", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if (!Lists.newArrayList((Object[])new String[]{ContractFileSignStatusEnum.SIGNED.getCombKey(), ContractFileSignStatusEnum.RENEW_SIGNED.getCombKey(), ContractFileSignStatusEnum.CHANGE_SIGNED.getCombKey(), ContractFileSignStatusEnum.CANCEL_SIGN.getCombKey(), ContractFileSignStatusEnum.STOP_SIGNED.getCombKey()}).contains(dy.getString("signstatus"))) {
                msg.append(ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2\u72b6\u6001\u53ea\u80fd\u8f93\u5165\uff1a\u5df2\u7b7e\u8ba2\u3001\u5df2\u7eed\u7b7e\u3001\u5df2\u6539\u7b7e\u3001\u5df2\u89e3\u9664\u3001\u5df2\u7ec8\u6b62\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_8", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if (Lists.newArrayList((Object[])new String[]{ContractFileSignStatusEnum.CHANGE_SIGNED.getCombKey(), ContractFileSignStatusEnum.CANCEL_SIGN.getCombKey(), ContractFileSignStatusEnum.STOP_SIGNED.getCombKey()}).contains(dy.getString("signstatus")) && dy.getDate("actualenddate") == null) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2\u72b6\u6001\u4e3a\u201c%1$s\u201d\u65f6\uff0c\u5408\u540c\u5b9e\u9645\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\uff1b", (String)"ContractInitDomainDataService_10", (String)"hr-hlcm-business", (Object[])new Object[0]), ContractFileSignStatusEnum.getValueByKey((String)dy.getString("signstatus"))));
            }
            Date probationstartdate = dy.getDate("probationstartdate");
            Date probationenddate = dy.getDate("probationenddate");
            if (probationstartdate != null && probationenddate != null && HRDateTimeUtils.dayBefore((Date)probationenddate, (Date)probationstartdate)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bd5\u7528\u671f\u7ed3\u675f\u65e5\u671f\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u8bd5\u7528\u671f\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"CommonInitDomainDataService_7", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)probationenddate), HRDateTimeUtils.formatDate((Date)probationstartdate)));
            }
            if (HRStringUtils.isNotEmpty((String)(probationunit = dy.getString("probationunit"))) && !Lists.newArrayList((Object[])new String[]{ProbationUnitEnum.MONTH.getCombKey(), ProbationUnitEnum.WEEK.getCombKey(), ProbationUnitEnum.DAY.getCombKey()}).contains(probationunit)) {
                msg.append(ResManager.loadKDString((String)"\u8bd5\u7528\u671f\u5355\u4f4d\u53ea\u80fd\u8f93\u5165\uff1a\u4e2a\u6708\u3001\u5468\u3001\u5929\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_9", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)(erManQueryResult = midResultMap.get(key)))) {
                msg.append(this.doCheckErManFile(erManQueryResult.getPosTypeId(), erManQueryResult.getLaborRelTypeClsId(), erManQueryResult.getLabrelStatusPrdId()));
            }
            this.buildErrMsgMap(failMap, msg, key);
        }
        this.removeCheckedBadData(targetMap, failMap);
    }

    @Override
    protected void businessValidByErman(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        this.businessErmanValid(targetMap, failMap);
    }

    @Override
    protected void assembleDifFields(DynamicObject dy) {
        Date endDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("enddate"));
        Date actualEndDate = dy.getDate("actualenddate");
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        if (endDate != null && actualEndDate == null && endDate.before(today)) {
            dy.set("actualenddate", (Object)endDate);
        }
        String signstatus = dy.getString("signstatus");
        if (Lists.newArrayList((Object[])new String[]{"4", "5"}).contains(signstatus) && actualEndDate != null && !actualEndDate.before(today)) {
            dy.set("planenddate", (Object)actualEndDate);
            dy.set("actualenddate", null);
        }
    }

    private void checkOrigNumSame(Map<Long, DynamicObject> targetMap, Map<String, Long> origNumMap, Set<String> origNumSet) {
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            Long key = entry.getKey();
            DynamicObject dy2 = entry.getValue();
            String origincontractnumber = dy2.getString("origincontractnumber");
            if (!HRStringUtils.isNotEmpty((String)origincontractnumber)) continue;
            if (origNumMap.get(origincontractnumber) == null) {
                origNumMap.put(origincontractnumber, key);
                continue;
            }
            origNumSet.add(origincontractnumber);
        }
        DynamicObject[] origDys = ContractRepository.getInstance().findContractsByField(origNumMap.keySet(), "oldcontract.number");
        if (origDys != null && origDys.length > 0) {
            Map<String, DynamicObject> origMap = Arrays.stream(origDys).filter(dy -> !HRStringUtils.isEmpty((String)dy.getString("oldcontract.number"))).collect(Collectors.toMap(dy -> dy.getString("oldcontract.number"), dy -> dy, (oldValue, newValue) -> newValue));
            this.selSameOrigNum(targetMap, origMap, origNumSet);
        }
    }

    private void selSameOrigNum(Map<Long, DynamicObject> targetMap, Map<String, DynamicObject> origMap, Set<String> origNumSet) {
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            DynamicObject dy = entry.getValue();
            String origincontractnumber = dy.getString("origincontractnumber");
            if (!HRStringUtils.isNotEmpty((String)origincontractnumber) || origMap.get(origincontractnumber) == null) continue;
            origNumSet.add(origincontractnumber);
        }
    }

    private boolean checkOriIsSelf(String number, Map<String, ContractEntity> contractEntityMap) {
        if (contractEntityMap.get(number) == null) {
            return false;
        }
        ContractEntity contractEntity = contractEntityMap.get(number);
        DynamicObject dy = contractEntity.getDy();
        String isValid = contractEntity.getIsValid();
        if ("1".equals(isValid)) {
            return true;
        }
        if ("2".equals(isValid)) {
            return false;
        }
        if (dy != null) {
            String originContractNumber = dy.getString("origincontractnumber");
            ContractEntity contractEntityOne = contractEntityMap.get(originContractNumber);
            if (contractEntityOne == null) {
                String msg = null;
                msg = !HRObjectUtils.isEmpty(this.failNumberMap.get(originContractNumber)) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u539f\u5408\u540c\u7f16\u53f7\u201c%1$s\u201d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_13", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNumber) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u539f\u5408\u540c\u7f16\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_2", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNumber);
                ContractEntity contractEntitytmp = new ContractEntity(dy, "2", msg);
                contractEntityMap.put(number, contractEntitytmp);
                return false;
            }
            if (contractEntityOne.getDy().getLong("person_id") != dy.getLong("person_id")) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u539f\u5408\u540c\u7f16\u53f7\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5458\u5de5\u7684\u5408\u540c\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNumber);
                ContractEntity contractEntitytmp = new ContractEntity(dy, "2", msg);
                contractEntityMap.put(number, contractEntitytmp);
                return false;
            }
            if (contractEntityOne.isDealing()) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u539f\u5408\u540c\u7f16\u53f7\u5b58\u5728\u76f8\u4e92\u5f15\u7528\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_4", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNumber);
                ContractEntity contractEntitytmp = new ContractEntity(dy, "2", msg);
                contractEntityMap.put(number, contractEntitytmp);
                return false;
            }
            contractEntityOne.setDealing(true);
            if (this.checkOriIsSelf(originContractNumber, contractEntityMap)) {
                String msg;
                DynamicObject dyOne = contractEntityOne.getDy();
                if (dyOne != null) {
                    dy.set("oldcontract", (Object)dyOne.getLong("id"));
                }
                ContractEntity contractEntitytmp = new ContractEntity(dy, "1", "");
                contractEntityMap.put(number, contractEntitytmp);
                if (dyOne != null && HRStringUtils.isNotEmpty((String)(msg = this.checkIsDateCross(dyOne, dy)))) {
                    contractEntitytmp.setIsValid("2");
                    contractEntitytmp.setMsg(msg);
                    return false;
                }
                return true;
            }
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u539f\u5408\u540c\u7f16\u53f7\u201c%1$s\u201d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_13", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNumber);
            ContractEntity contractEntitytmp = new ContractEntity(dy, "2", msg);
            contractEntityMap.put(number, contractEntitytmp);
            return false;
        }
        return false;
    }

    private Map<String, ContractEntity> validOriNumIsExist(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap, Map<String, DynamicObject> numMap) {
        HashMap<String, ContractEntity> contractEntityMap = new HashMap<String, ContractEntity>(targetMap.size());
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            ContractEntity contractEntity;
            DynamicObject value = entry.getValue();
            String originContractNumber = value.getString("origincontractnumber");
            String number = value.getString("number");
            long personId = value.getLong("person_id");
            if (HRStringUtils.isEmpty((String)originContractNumber)) {
                contractEntity = new ContractEntity(value, "1", "");
                contractEntityMap.put(number, contractEntity);
                continue;
            }
            contractEntity = new ContractEntity();
            if (HRStringUtils.isNotEmpty((String)originContractNumber) && numMap.get(originContractNumber) != null) {
                DynamicObject contractDy = numMap.get(originContractNumber);
                long oldPersonId = contractDy.getLong("person_id");
                if (oldPersonId != personId) {
                    contractEntity.setDy(value);
                    contractEntity.setIsValid("2");
                    contractEntity.setMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u539f\u5408\u540c\u7f16\u53f7\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5458\u5de5\u7684\u5408\u540c\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNumber));
                } else {
                    value.set("oldcontract", (Object)numMap.get(originContractNumber).getLong("id"));
                    contractEntity.setDy(value);
                    contractEntity.setIsValid("1");
                    contractEntity.setMsg("success");
                    DynamicObject dynamicObject = numMap.get(originContractNumber);
                    String msg = this.checkIsDateCross(dynamicObject, value);
                    if (HRStringUtils.isNotEmpty((String)msg)) {
                        contractEntity.setIsValid("2");
                        contractEntity.setMsg(msg);
                    }
                }
            } else {
                contractEntity.setDy(value);
                contractEntity.setIsValid("0");
                contractEntity.setMsg("");
            }
            contractEntityMap.put(number, contractEntity);
        }
        return contractEntityMap;
    }

    private String checkIsDateCross(DynamicObject oriDy, DynamicObject newDy) {
        Date oriStartDate = oriDy.getDate("startdate");
        Date actualEndDate = oriDy.getDate("actualenddate");
        Date endDate = oriDy.getDate("enddate");
        Date startDate = newDy.getDate("startdate");
        String msg = null;
        if (actualEndDate != null) {
            if (HRDateTimeUtils.dayBefore((Date)startDate, (Date)oriStartDate) || !HRDateTimeUtils.dayBefore((Date)actualEndDate, (Date)startDate)) {
                msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0e\u5408\u540c\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u5408\u540c\u5b58\u5728\u65e5\u671f\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_11", (String)"hr-hlcm-business", (Object[])new Object[0]), oriDy.getString("number"));
            }
        } else if (endDate != null && !"3".equals(oriDy.getString("signstatus")) && !HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0e\u5408\u540c\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u5408\u540c\u5b58\u5728\u65e5\u671f\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ContractInitDomainDataService_11", (String)"hr-hlcm-business", (Object[])new Object[0]), oriDy.getString("number"));
        }
        return msg;
    }

    @Override
    protected void saveValid(Map<Long, DynamicObject> targetMap) {
        super.saveValid(targetMap);
        this.businessNewValid(targetMap);
    }

    private void businessNewValid(Map<Long, DynamicObject> targetMap) {
        DynamicObject[] dbContracts;
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        Function<DynamicObject, PosTypePerson> keyFunction = dy -> new PosTypePerson(Long.valueOf(dy.getLong("postype")), Long.valueOf(dy.getLong("person_id")));
        Map<PosTypePerson, List<DynamicObject>> groupMap = targetMap.values().stream().filter(dy -> HRStringUtils.equals((String)dy.getString("businesstype"), (String)BusinessTypeEnum.NEW.getCombKey()) && HRStringUtils.equals((String)dy.getString("protocoltype"), (String)ProtocolTypeEnum.CON.getCombKey())).filter(dy -> !HRDateTimeUtils.dayAfter((Date)dy.getDate("startdate"), (Date)today)).filter(dy -> {
            Date actualEndDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("actualenddate"));
            if (actualEndDate != null) {
                return !actualEndDate.before(today);
            }
            Date endDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("enddate"));
            if (endDate != null) {
                return !endDate.before(today);
            }
            return true;
        }).collect(Collectors.groupingBy(keyFunction));
        HashSet templateKeySet = Sets.newHashSetWithExpectedSize((int)groupMap.size());
        HashSet dbKeySet = Sets.newHashSetWithExpectedSize((int)groupMap.size());
        Set<PosTypePerson> posTypePersonSet = groupMap.keySet();
        if (posTypePersonSet.isEmpty()) {
            return;
        }
        groupMap.forEach((key, list) -> {
            if (list.size() > 1) {
                templateKeySet.add(key);
            }
        });
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)groupMap.size());
        posTypePersonSet.forEach(posTypePerson -> filterList.add(new QFilter("person", "=", (Object)posTypePerson.getPersonId()).and(new QFilter("postype", "=", (Object)posTypePerson.getPosTypeId()))));
        QFilter statusFilter = new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode());
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey());
        QFilter filter = statusFilter.and(versionFilter).and(protocolTypeFilter);
        filterList.stream().reduce((f1, f2) -> f1.or(f2)).ifPresent(orFilter -> filter.and(orFilter));
        for (DynamicObject dbContract : dbContracts = HLCMCommonRepository.queryDynamicObjects("hlcm_contract", String.join((CharSequence)",", "postype", "person"), filter)) {
            dbKeySet.add(new PosTypePerson(Long.valueOf(dbContract.getLong("postype.id")), Long.valueOf(dbContract.getLong("person_id"))));
        }
        targetMap.entrySet().removeIf(entry -> {
            DynamicObject dy = (DynamicObject)entry.getValue();
            PosTypePerson posTypePerson = (PosTypePerson)keyFunction.apply(dy);
            Long mid = (Long)entry.getKey();
            if (templateKeySet.contains(posTypePerson)) {
                this.getInitOutParam().addErrorMsg(mid, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u53ef\u5b58\u5728\u591a\u4efd\u751f\u6548\u4e2d\u7684\u52b3\u52a8\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u662f\u5426\u6709\u591a\u4efd\u751f\u6548\u4e2d\u7684\u65b0\u7b7e\u6570\u636e\u3002", (String)"ContractInitDomainDataService_14", (String)"hr-hlcm-business", (Object[])new Object[0]));
                return true;
            }
            if (dbKeySet.contains(posTypePerson)) {
                this.getInitOutParam().addErrorMsg(mid, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u53ef\u5b58\u5728\u591a\u4efd\u751f\u6548\u4e2d\u7684\u52b3\u52a8\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u5728\u7cfb\u7edf\u4e2d\u662f\u5426\u5df2\u5b58\u5728\u751f\u6548\u4e2d\u7684\u5408\u540c\u3002", (String)"ContractInitDomainDataService_15", (String)"hr-hlcm-business", (Object[])new Object[0]));
                return true;
            }
            return false;
        });
    }
}

