/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.initdata.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.initdata.CommonInitDomainDataService;
import kd.hr.hlcm.common.entity.ErManQueryResult;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;

public class OtherprotocolInitDomainDataService
extends CommonInitDomainDataService {
    @Override
    protected String doCheckErManFile(Long posTypeId, List<Long> laborRelTypeClsId, Long labrelStatusPrdId) {
        return "";
    }

    @Override
    protected void preSetFields(Map<Long, DynamicObject> targetMap) {
        targetMap.values().stream().forEach(dy -> {
            dy.set("protocoltype", (Object)"3");
            dy.set("signstatus", (Object)"1");
            if (HRStringUtils.isEmpty((String)dy.getString("signway"))) {
                dy.set("signway", (Object)"2");
            }
            if (HRStringUtils.isEmpty((String)dy.getString("empnumber"))) {
                dy.set("empnumber", (Object)dy.getString("person.number"));
            }
        });
    }

    @Override
    protected void difBusinessValid(Map<Long, ErManQueryResult> midResultMap, Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        HashSet<String> originContractNums = new HashSet<String>(targetMap.size());
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            ErManQueryResult erManQueryResult;
            Date signedDate;
            DynamicObject dy = entry.getValue();
            Long mid = entry.getKey();
            StringBuilder msg = new StringBuilder();
            DynamicObject periodTypeDy = dy.getDynamicObject("periodtype");
            Date endDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("contractenddate"));
            if (!HRObjectUtils.isEmpty((Object)periodTypeDy)) {
                Object periodTypeId = periodTypeDy.getPkValue();
                if (endDate == null && Objects.equals(periodTypeId, ContractPeriodTypeEnum.FIXED.getPkId())) {
                    msg.append(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u56fa\u5b9a\u671f\u9650\u201d\u65f6\uff0c\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\uff1b", (String)"OtherprotocolInitDomainDataService_0", (String)"hr-hlcm-business", (Object[])new Object[0]));
                }
                if (endDate != null && Objects.equals(periodTypeId, ContractPeriodTypeEnum.NONFIXED.getPkId())) {
                    msg.append(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u65e0\u56fa\u5b9a\u671f\u9650\u201d\uff0c\u65e0\u9700\u586b\u5199\u5408\u540c\u7ed3\u675f\u65e5\u671f\uff1b", (String)"OtherprotocolInitDomainDataService_1", (String)"hr-hlcm-business", (Object[])new Object[0]));
                }
            }
            Date startDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("startdate"));
            if (endDate != null && startDate.after(endDate)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7ed3\u675f\u65e5\u671f\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"OtherprotocolInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)endDate), HRDateTimeUtils.formatDate((Date)startDate)));
            }
            Date date = signedDate = dy.getDate("signeddate") != null ? dy.getDate("signeddate") : dy.getDate("signeddatetmp");
            if (signedDate != null && endDate != null && signedDate.after(endDate)) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u201c%1$s\u201d\u4e0d\u80fd\u665a\u4e8e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"OtherprotocolInitDomainDataService_2", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)signedDate), HRDateTimeUtils.formatDate((Date)endDate)));
            }
            if (!HRObjectUtils.isEmpty((Object)(erManQueryResult = midResultMap.get(mid)))) {
                msg.append(this.doCheckErManFile(erManQueryResult.getPosTypeId(), erManQueryResult.getLaborRelTypeClsId(), erManQueryResult.getLabrelStatusPrdId()));
            }
            this.buildErrMsgMap(failMap, msg, mid);
            String originContractNum = dy.getString("origincontractnumbertmp");
            if (HRStringUtils.isEmpty((String)originContractNum)) continue;
            originContractNums.add(originContractNum);
        }
        this.setMainContract(targetMap, failMap, originContractNums);
    }

    @Override
    protected void businessValidByErman(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
    }

    @Override
    protected void assembleDifFields(DynamicObject dy) {
        Date endDate = dy.getDate("contractenddate");
        if (endDate != null && HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)new Date()), (Date)HRDateTimeUtils.truncateDate((Date)endDate))) {
            dy.set("actualenddate", (Object)endDate);
        }
        dy.set("enddate", (Object)endDate);
        dy.set("signeddate", (Object)dy.getDate("signeddatetmp"));
    }

    private void setMainContract(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap, Set<String> originContractNums) {
        if (!CollectionUtils.isEmpty(originContractNums)) {
            DynamicObject[] dys = ContractRepository.getInstance().findOriContractsByField(originContractNums, "othertype");
            HashMap<String, DynamicObject> numMap = new HashMap(targetMap.size());
            if (dys != null && dys.length > 0) {
                numMap = Arrays.stream(dys).filter(dy -> !HRStringUtils.isEmpty((String)dy.getString("number"))).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (oldValue, newValue) -> newValue));
            }
            for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
                StringBuilder msg = new StringBuilder();
                DynamicObject dy2 = entry.getValue();
                Long key = entry.getKey();
                String originContractNum = dy2.getString("origincontractnumbertmp");
                if (!HRStringUtils.isEmpty((String)originContractNum)) {
                    this.checkAndMainContract(numMap, msg, dy2, originContractNum);
                }
                this.buildErrMsgMap(failMap, msg, key);
            }
        }
    }

    private void checkAndMainContract(Map<String, DynamicObject> numMap, StringBuilder msg, DynamicObject dy, String originContractNum) {
        if (numMap.get(originContractNum) == null) {
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u6863\u6848\u7f16\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"OtherprotocolInitDomainDataService_4", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNum));
        } else {
            if (dy.get("ermanfile") == null || dy.getLong("ermanfile") == 0L) {
                return;
            }
            DynamicObject contractDy = numMap.get(originContractNum);
            if (contractDy.get("ermanfile") != null && contractDy.getLong("ermanfile.id") == dy.getLong("ermanfile")) {
                dy.set("maincontract", (Object)numMap.get(originContractNum).getLong("id"));
            } else {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u6863\u6848\u7f16\u53f7\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5458\u5de5\u7684\u5408\u540c\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"OtherprotocolInitDomainDataService_5", (String)"hr-hlcm-business", (Object[])new Object[0]), originContractNum));
            }
        }
    }

    @Override
    protected void difDistinct(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
    }
}

