/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.message.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.IMessageService;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.BosUserRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.message.ISendMessageService;
import kd.hr.hlcm.business.domian.service.message.MessageTemplateConstants;
import kd.hr.hlcm.business.mq.MessageTemplateParser;
import kd.hr.hlcm.business.service.PermissionService;
import kd.hr.hlcm.common.entity.MsgEntity;
import kd.hr.hlcm.common.utils.CommonUtils;

public class SendMessageServiceImpl
implements ISendMessageService {
    private static final Log LOGGER = LogFactory.getLog(SendMessageServiceImpl.class);
    private static final String BEGIN_SIGN_MESSAGE_SELECT_PROPERTIES = "empnumber,empphone";

    @Override
    public void beginSignSendMessage(Long signBillId) {
        LOGGER.info("begin sign send message start,signBillId:{}", (Object)signBillId);
        DynamicObject dynamicObject = null;
        String mobileContentUrl = null;
        List<Long> bosUserIds = null;
        try {
            dynamicObject = CommonRepository.queryDynamicObjectByPk("hlcm_contractapplybase", BEGIN_SIGN_MESSAGE_SELECT_PROPERTIES, signBillId);
            mobileContentUrl = UrlService.getDomainContextUrl() + String.format(Locale.ROOT, "/mobile.html?form=%s&id=%s", "hlcm_signinitialization", signBillId);
            String empNumber = dynamicObject.getString("empnumber");
            bosUserIds = BosUserRepository.getBosUserIds(Lists.newArrayList((Object[])new String[]{empNumber}));
        }
        catch (Exception exception) {
            LOGGER.error("begin sign send message error", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u9001\u6d88\u606f\u7684\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"SendMessageServiceImpl_0", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        this.sendMessage(signBillId, bosUserIds, null, mobileContentUrl);
        this.sendSms(signBillId, mobileContentUrl, Lists.newArrayList((Object[])new String[]{dynamicObject.getString("empphone")}), bosUserIds);
        LOGGER.info("begin sign send message end");
    }

    @Override
    public void sendMessage(Long signBillId, List<Long> userIds, String contentUrl, String mobContentUrl) {
        LOGGER.info("==SendMessageServiceImpl#sendMessage#start");
        DynamicObject template = CommonRepository.queryDynamicObjectByNumber("msg_template", String.join((CharSequence)",", "msgchannel", "msgtype", "msgentity.id"), "hlcm_empsigncontract_yzj");
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setUserIds(userIds);
        msgEntity.setSource("hlcm");
        msgEntity.setTemplateNumber("hlcm_empsigncontract_yzj");
        msgEntity.setBizDataId(signBillId);
        msgEntity.setMobContentUrl(mobContentUrl);
        msgEntity.setContentUrl(contentUrl);
        if (!HRObjectUtils.isEmpty((Object)template)) {
            msgEntity.setNotifyType(template.getString("msgchannel"));
            msgEntity.setType(template.getString("msgtype"));
            msgEntity.setEntityNumber(template.getString("msgentity.id"));
            msgEntity.setNestBillNo(template.getString("msgentity.id"));
        }
        MessageInfo messageInfo = this.buildMessageInfo(msgEntity);
        this.sendMessage(messageInfo);
        LOGGER.info("==SendMessageServiceImpl#sendMessage#END");
    }

    @Override
    @Deprecated
    public void sendSms(Long signBillId, String mobileContentUrl, List<String> phoneList) {
        LOGGER.info("SendMessageServiceImpl#sendSms#start");
        Tuple<String, String> smsMessage = MessageTemplateParser.getMessageContext("hlcm_empsigncontract_sms", signBillId);
        LOGGER.info("SendMessageServiceImpl#smsMessage={}", JSON.toJSON(smsMessage));
        String messageContext = (String)smsMessage.item2 + mobileContentUrl;
        ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
        shortMessageInfo.setMessage(messageContext);
        shortMessageInfo.setPhone(phoneList);
        try {
            ((IMessageService)ServiceFactory.getService(IMessageService.class)).sendShortMessage(shortMessageInfo);
        }
        catch (Exception e) {
            LOGGER.error("send sms error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u9001\u77ed\u4fe1\u5931\u8d25", (String)"SendMessageServiceImpl_3", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        LOGGER.info("SendMessageServiceImpl#sendSms#end");
    }

    @Override
    public void sendSms(Long signBillId, String mobileContentUrl, List<String> phoneList, List<Long> userIds) {
        LOGGER.info("==SendMessageServiceImpl#sendSms#start");
        DynamicObject template = CommonRepository.queryDynamicObjectByNumber("msg_template", String.join((CharSequence)",", "msgchannel", "msgtype", "msgentity.id"), "hlcm_empsigncontract_sms");
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setUserIds(userIds);
        msgEntity.setSource("hlcm");
        msgEntity.setTemplateNumber("hlcm_empsigncontract_sms");
        msgEntity.setBizDataId(signBillId);
        msgEntity.setMobContentUrl(mobileContentUrl);
        msgEntity.setContentUrl(null);
        if (!HRObjectUtils.isEmpty((Object)template)) {
            msgEntity.setNotifyType(template.getString("msgchannel"));
            msgEntity.setType(template.getString("msgtype"));
            msgEntity.setEntityNumber(template.getString("msgentity.id"));
            msgEntity.setNestBillNo(template.getString("msgentity.id"));
        }
        HashMap<String, List<String>> param = new HashMap<String, List<String>>(4);
        param.put("phone", phoneList);
        msgEntity.setParam(param);
        MessageInfo messageInfo = this.buildMessageInfo(msgEntity);
        this.sendMessage(messageInfo);
        LOGGER.info("==SendMessageServiceImpl#sendSms#end");
    }

    @Override
    public void sendMsgBylawEntityChg(DynamicObject dy) {
        if (dy == null) {
            return;
        }
        String tempNum = "hlcm_lawentitychg";
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        String oprsts = dy.getString("oprsts");
        if (oprsts.equals("2")) {
            tempNum = "hlcm_lawentitylogout";
        } else {
            String msg;
            DynamicObjectCollection dys = dy.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dys)) {
                LOGGER.info("lawDysHis is isEmpty");
                return;
            }
            List lawDys = dys.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("chgeffectdate"), Comparator.reverseOrder())).collect(Collectors.toList());
            List keys = CommonUtils.compareDyo((DynamicObject)dy, (DynamicObject)((DynamicObject)lawDys.get(0)), MessageTemplateConstants.mapKeys);
            if (!CollectionUtils.isEmpty((Collection)keys) && !HRStringUtils.isEmpty((String)(msg = CommonUtils.buildMsgParam((List)keys)))) {
                paramMap.put("changetext", msg);
            }
        }
        List<Long> userIds = PermissionService.getUsersByRoleID("2DDMMJ=V6E3X");
        DynamicObject template = CommonRepository.queryDynamicObjectByNumber("msg_template", String.join((CharSequence)",", "msgchannel", "msgtype", "msgentity.id"), tempNum);
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setUserIds(userIds);
        msgEntity.setParamMap(paramMap);
        msgEntity.setSource("hbss");
        msgEntity.setTemplateNumber(tempNum);
        msgEntity.setBizDataId(Long.valueOf(dy.getLong("id")));
        if (!HRObjectUtils.isEmpty((Object)template)) {
            msgEntity.setNotifyType(template.getString("msgchannel"));
            msgEntity.setType(template.getString("msgtype"));
            msgEntity.setEntityNumber(template.getString("msgentity.id"));
            msgEntity.setNestBillNo(template.getString("msgentity.id"));
        }
        MessageInfo messageInfo = this.buildMessageInfo(msgEntity);
        this.sendMessage(messageInfo);
    }

    @Override
    public void sendTerminateMsg(Long bizDataId, String templateNum) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject template = CommonRepository.queryDynamicObjectByNumber("msg_template", String.join((CharSequence)",", "msgchannel", "msgtype", "msgentity.id"), templateNum);
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setUserIds((List)Lists.newArrayList((Object[])new Long[]{currUserId}));
        msgEntity.setSource("hlcm");
        msgEntity.setTemplateNumber(templateNum);
        msgEntity.setBizDataId(bizDataId);
        if (!HRObjectUtils.isEmpty((Object)template)) {
            msgEntity.setNotifyType(template.getString("msgchannel"));
            msgEntity.setType(template.getString("msgtype"));
            msgEntity.setEntityNumber(template.getString("msgentity.id"));
            msgEntity.setNestBillNo(template.getString("msgentity.id"));
        }
        MessageInfo messageInfo = this.buildMessageInfo(msgEntity);
        this.sendMessage(messageInfo);
    }

    @Override
    public MessageInfo buildMessageInfo(MsgEntity msgEntity) {
        MessageInfo messageInfo = new MessageInfo();
        if (msgEntity == null) {
            LOGGER.info("==buildMessageInfo.msgEntity is null==");
            return messageInfo;
        }
        LOGGER.info("==buildMessageInfo.msgEntity:{}==", (Object)msgEntity.toString());
        messageInfo.setUserIds(msgEntity.getUserIds());
        messageInfo.setBizDataId(msgEntity.getBizDataId());
        messageInfo.setTemplateNumber(msgEntity.getTemplateNumber());
        messageInfo.setEntityNumber(msgEntity.getEntityNumber());
        messageInfo.setNestBillno(msgEntity.getNestBillNo());
        messageInfo.setMessageTag((ILocaleString)(msgEntity.getMsgTag() == null ? ResManager.getLocaleString((String)"\u901a\u77e5", (String)"SendMessageServiceImpl_1", (String)"hr-hlcm-business") : msgEntity.getMsgTag()));
        messageInfo.setMessageSenderName((ILocaleString)ResManager.getLocaleString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"SendMessageServiceImpl_9", (String)"hr-hlcm-business"));
        messageInfo.setNotifyType(msgEntity.getNotifyType());
        messageInfo.setType(msgEntity.getType());
        messageInfo.setEntityNumber(msgEntity.getEntityNumber());
        messageInfo.setNestBillno(msgEntity.getNestBillNo());
        Map paramMap = msgEntity.getParamMap();
        Tuple<String, String> messageContext = CollectionUtils.isEmpty((Map)paramMap) ? MessageTemplateParser.getMessageContext(msgEntity.getTemplateNumber(), msgEntity.getBizDataId()) : MessageTemplateParser.getMessageContext(msgEntity.getTemplateNumber(), msgEntity.getBizDataId(), paramMap);
        Map param = msgEntity.getParam();
        if (!CollectionUtils.isEmpty((Map)param)) {
            messageInfo.setParams(param);
        }
        if (HRStringUtils.isNotEmpty((String)msgEntity.getContentUrl())) {
            messageInfo.setContentUrl(msgEntity.getContentUrl());
        }
        if (HRStringUtils.isNotEmpty((String)msgEntity.getMobContentUrl())) {
            messageInfo.setMobContentUrl(msgEntity.getMobContentUrl());
        }
        LOGGER.info("==messageContext.tile:{}, context:{}==", messageContext.item1, messageContext.item2);
        messageInfo.setMessageTitle((ILocaleString)new LocaleString((String)messageContext.item1));
        messageInfo.setMessageContent((ILocaleString)new LocaleString((String)messageContext.item2));
        return messageInfo;
    }

    @Override
    public void sendMessage(MessageInfo messageInfo) {
        if (messageInfo == null) {
            return;
        }
        try {
            LOGGER.info("sendMessage messageInfo:{}", (Object)messageInfo);
            Map result = MessageCenterServiceHelper.batchSendMessages((List)Lists.newArrayList((Object[])new MessageInfo[]{messageInfo}));
            LOGGER.info("sendMessage result:{}", (Object)result);
        }
        catch (Exception exception) {
            LOGGER.error("sendMessage fail", (Throwable)exception);
            throw new KDBizException("send message fail");
        }
    }
}

