/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.signmgt.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginCall;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.HtmlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.FileNameUtils;
import kd.bos.util.HttpClientUtils;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.econtract.HRWordUtils;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.BosAttachmentRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractApplyEntryRepository;
import kd.hr.hlcm.business.domian.repository.ContractApplyRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.domian.service.hismodel.IContractHisModel;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.business.domian.service.message.ISendMessageService;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.business.service.PersonService;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.utils.HLCMExceptionUtils;
import kd.hr.hlcm.business.utils.OperationLogUtils;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.business.utils.SignListPermissionUtils;
import kd.hr.hlcm.common.enums.ActivityProcessStatusEnum;
import kd.hr.hlcm.common.enums.ActivityStatusEnum;
import kd.hr.hlcm.common.enums.AuditStatusEnum;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.EmpCompSignStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.SignModeEnum;
import kd.hr.hlcm.common.enums.SignStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;
import kd.hr.hlcm.common.utils.ComboUtils;
import kd.hr.hlcm.common.utils.DateUtil;
import kd.sdk.hr.hlcm.business.domain.IHLCMTemplateService;
import kd.sdk.hr.hpfs.business.config.service.IDevParamConfigService;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class SignManageServiceImpl
implements ISignManageService {
    private static final Log LOGGER = LogFactory.getLog(SignManageServiceImpl.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)(SignManageServiceImpl.class.getName() + ".batchReplaceKeywordGenContract"), (int)5, (int)20);
    private static final String GET_ACTIVITY_SELECT_PROPERTIES = "processstatus,processtime";
    private static final String MUCH_FLAG = "muchflag";
    private static final Set<ActivityStatusEnum> ABLE_BEGIN_SIGN_ACTIVITY_STATUS_SET = Sets.newHashSet((Object[])new ActivityStatusEnum[]{ActivityStatusEnum.P_TO_LAUNCH, ActivityStatusEnum.E_TO_LAUNCH, ActivityStatusEnum.E_LUNCHED, ActivityStatusEnum.E_TO_CONFIRM, ActivityStatusEnum.E_CONFIRMED, ActivityStatusEnum.E_P_TO_SIGN, ActivityStatusEnum.E_P_SIGNED});
    private static final Set<String> contractApplyTypes = Sets.newHashSet((Object[])new String[]{"hlcm_contractapplycancel", "hlcm_contractapplyend"});
    private static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)";

    @Override
    public List<HRExportHeadObject> getSignBillBaseExcelHead(String formId) {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        headObjectList.add(new HRExportHeadObject("empname", ResManager.loadKDString((String)"\u59d3\u540d", (String)"SignManageServiceImpl_2", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("empnumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"SignManageServiceImpl_3", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("actualsigncompany", ResManager.loadKDString((String)"\u5b9e\u7b7e\u5355\u4f4d", (String)"SignManageServiceImpl_4", (String)"hr-hlcm-business", (Object[])new Object[0])));
        if (contractApplyTypes.contains(formId)) {
            headObjectList.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"SignManageServiceImpl_10", (String)"hr-hlcm-business", (Object[])new Object[0])));
            headObjectList.add(new HRExportHeadObject("contractnumber", ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"SignManageServiceImpl_5", (String)"hr-hlcm-business", (Object[])new Object[0])));
        } else {
            headObjectList.add(new HRExportHeadObject("contractnumber", ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"SignManageServiceImpl_5", (String)"hr-hlcm-business", (Object[])new Object[0])));
            headObjectList.add(new HRExportHeadObject("signeddate", ResManager.loadKDString((String)"\u9884\u8ba1\u7b7e\u8ba2\u65e5\u671f", (String)"SignManageServiceImpl_6", (String)"hr-hlcm-business", (Object[])new Object[0])));
        }
        return headObjectList;
    }

    @Override
    public List<HRExportHeadObject> getMulSelectConfirmExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = this.getSignBillBaseExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("activity.name", ResManager.loadKDString((String)"\u6d3b\u52a8\u540d\u79f0", (String)"SignManageServiceImpl_7", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("taskstatus", ResManager.loadKDString((String)"\u6d3b\u52a8\u72b6\u6001", (String)"SignManageServiceImpl_8", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<Map<String, Object>> applyBillPreValidateExportData(Object[] pkValues, Map<Object, String> errorMap, String formId) {
        DynamicObject[] dynamicObjects = CommonRepository.queryByIds("hlcm_contractapplybase", null, Arrays.stream(pkValues).map(Object::toString).map(Long::parseLong).collect(Collectors.toList()));
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject signBill : dynamicObjects) {
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)8);
            if (contractApplyTypes.contains(formId)) {
                this.setExcelDataForContractCancelAndStop(exportData, signBill, errorMap.get(signBill.getLong("id")));
            } else {
                this.setSignBillBaseExcelData(exportData, signBill, errorMap.get(signBill.getLong("id")));
            }
            DynamicObject activityIns = signBill.getDynamicObject("activityins");
            if (!HRObjectUtils.isEmpty((Object)activityIns)) {
                exportData.put("activity.name", activityIns.getString("activity.name"));
                ActivityStatusEnum activityStatusEnum = ActivityStatusEnum.getActivityStatusEnum((String)signBill.getString("handlestatus"), (Long)activityIns.getLong("activity.id"), (String)activityIns.getString("taskstatus"));
                exportData.put("taskstatus", activityStatusEnum != null ? activityStatusEnum.getBridge().loadKDString() : null);
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    @Override
    public List<Map<String, Object>> activityPreValidateExportData(Object[] pkValues, Map<Object, String> errorMap) {
        DynamicObject[] activities = CommonRepository.queryByIds("hlcm_activity", String.join((CharSequence)",", "activity", "activityins", "signapply", "processstatus"), Arrays.stream(pkValues).map(Object::toString).map(Long::parseLong).collect(Collectors.toList()));
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)pkValues.length);
        for (DynamicObject activity : activities) {
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)8);
            DynamicObject signBill = activity.getDynamicObject("signapply");
            this.setSignBillBaseExcelData(exportData, signBill, errorMap.get(activity.getLong("id")));
            DynamicObject activityIns = activity.getDynamicObject("activityins");
            if (!HRObjectUtils.isEmpty((Object)activityIns)) {
                exportData.put("activity.name", activityIns.getString("activity.name"));
                exportData.put("taskstatus", Optional.ofNullable(this.getActivityProcessStatusEnum(activity)).map(ActivityProcessStatusEnum::getDesc).map(MultiLangEnumBridge::loadKDString).orElse(null));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    @Override
    public Map<Long, String> batchBeginSign(List<Long> ids) {
        LOGGER.info("batch begin sign ids:{}", ids);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids);
        Map<DynamicObject, DynamicObject> nextActivityMap = ISignActivity.getInstance().getNextActivityMap(signBills);
        nextActivityMap.forEach((signBill, nextActivity) -> {
            String result = this.beginSignHandler((DynamicObject)signBill, (DynamicObject)nextActivity);
            if (HRStringUtils.isNotEmpty((String)result)) {
                resultMap.put(signBill.getLong("id"), result);
            }
        });
        LOGGER.info("batch begin sign end");
        return resultMap;
    }

    @Override
    public Map<Long, String> batchCompleteSign(List<Long> ids) {
        LOGGER.info("batch complete sign ids:{}", ids);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids);
        Map<DynamicObject, DynamicObject> nextActivityMap = ISignActivity.getInstance().getNextActivityMap(signBills);
        nextActivityMap.forEach((signBill, nextActivity) -> {
            String result = this.completeSignHandler((DynamicObject)signBill, (DynamicObject)nextActivity);
            if (HRStringUtils.isNotEmpty((String)result)) {
                resultMap.put(signBill.getLong("id"), result);
            }
        });
        LOGGER.info("batch complete sign end");
        return resultMap;
    }

    @Override
    public Map<Long, String> batchConfirmArchive(List<Long> ids) {
        DynamicObject[] signBills;
        LOGGER.info("batch conform archive ids:{}", ids);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        for (DynamicObject signBill : signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids)) {
            String result = this.confirmArchiveHandler(signBill);
            if (!HRStringUtils.isNotEmpty((String)result)) continue;
            resultMap.put(signBill.getLong("id"), result);
        }
        LOGGER.info("batch confirm archive end");
        return resultMap;
    }

    @Override
    public Map<Long, ActivityStatusEnum> getActivityStatusEnumMap(DynamicObject[] signBills) {
        return Arrays.stream(signBills).filter(signBill -> this.getActivityStatusEnum((DynamicObject)signBill) != null).collect(Collectors.toMap(signBill -> signBill.getLong("id"), this::getActivityStatusEnum));
    }

    @Override
    public ActivityStatusEnum getActivityStatusEnum(DynamicObject signBill) {
        DynamicObject activityIns = signBill.getDynamicObject("activityins");
        Long activityId = !HRObjectUtils.isEmpty((Object)activityIns) ? Long.valueOf(activityIns.getLong("activity.id")) : null;
        String taskStatus = !HRObjectUtils.isEmpty((Object)activityIns) ? activityIns.getString("taskstatus") : null;
        LOGGER.info("SignManageServiceImpl.getActivityStatusEnum : activityId = {}, taskStatus = {}", (Object)activityId, (Object)taskStatus);
        return ActivityStatusEnum.getActivityStatusEnum((String)signBill.getString("handlestatus"), (Long)activityId, (String)taskStatus);
    }

    @Override
    public Map<Long, ActivityProcessStatusEnum> getActivityProcessStatusEnumMap(DynamicObject[] activities) {
        return Arrays.stream(activities).collect(Collectors.toMap(activity -> activity.getLong("signapply.id"), this::getActivityProcessStatusEnum));
    }

    @Override
    public ActivityProcessStatusEnum getActivityProcessStatusEnum(DynamicObject activity) {
        Long activityId = activity.getLong("activity.id");
        return ActivityProcessStatusEnum.getValueByKey((Long)activityId, (String)activity.getString("processstatus"));
    }

    @Override
    public Map<Long, String> batchCompanySign(List<Long> ids) {
        LOGGER.info("batch company sign ids:{}", ids);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids);
        Arrays.stream(signBills).forEach(signBill -> {
            String result = this.companySignHandler((DynamicObject)signBill);
            if (HRStringUtils.isNotEmpty((String)result)) {
                resultMap.put(signBill.getLong("id"), result);
            }
        });
        LOGGER.info("batch company sign end");
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String companySignNotify(String contractNo) {
        LOGGER.info("company sign notify contractNo:{}", (Object)contractNo);
        DynamicObject signBill = ContractApplyRepository.getInstance().queryByContractNo(contractNo);
        if (HRStringUtils.equals((String)signBill.getString("businesstype"), (String)BusinessTypeEnum.CANCEL.getCombKey())) {
            LOGGER.info("businessType is cancel need not companySignNotify");
            return null;
        }
        long activityInsId = this.getCurActivityInsId(signBill, SignTabEnum.E_CSIGN.getSourceListFormId());
        LOGGER.info("companySignNotify activityInsId|{}", (Object)activityInsId);
        try (TXHandle txHandle = TX.required();){
            DynamicObjectCollection entryEntityCollection = signBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryEntityDy : entryEntityCollection) {
                entryEntityDy.set("entrycompsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
            }
            SignRespParam signRespParam = IHRCSService.getInstance().getPrevAndDown(signBill, contractNo);
            this.updateSignDocUrl(signBill, signRespParam.getSealInfo().getDownloadUrlList(), "companysignnotify", false);
            this.completeCompanySign(signBill, activityInsId);
        }
        LOGGER.info("company sign notify end");
        return null;
    }

    private void completeCompanySign(DynamicObject signBill, long activityInsId) {
        signBill.set("actualsigndate", (Object)new Date());
        this.updateCurrentActivityProcessStatus(activityInsId, ProcessStatusEnum.PROCESSED);
        boolean existECheckActivity = ISignActivity.getInstance().isExistActivity(signBill.getLong("id"), SignTabEnum.E_CHECK.getSourceListFormId());
        boolean isArchive = HRStringUtils.equals((String)signBill.getString("handlestatus"), (String)HandleStatusEnum.ARCHIVE.getCombKey());
        boolean isCSignActivity = HRStringUtils.equals((String)BusinessStatusEnum.CSIGN.getCombKey(), (String)signBill.getString("businessstatus"));
        LOGGER.info("existECheckActivity |{}, isArchive|{}, isCSignActivity|{}", new Object[]{existECheckActivity, isArchive, isCSignActivity});
        if (!isArchive) {
            if (!existECheckActivity) {
                this.archiveUpdateSignBill(signBill);
                ISignManageService.getInstance().archiveAfterTransaction(signBill);
            } else if (isCSignActivity) {
                signBill.set("signstatus", (Object)SignStatusEnum.C_SIGNED.getCombKey());
                signBill.set("billstatus", (Object)BillStatusEnum.STATUS_APPROVED.getCode());
                signBill.set("compsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
                CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            }
        }
        ISignActivity.getInstance().assignAndConsentTask((Long)activityInsId, SignTabEnum.E_CSIGN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String companySignNotifyMulTaskMode(DynamicObject signBill, String contractNo) {
        long signBillId = signBill.getLong("id");
        LOGGER.info("MulTaskMode company sign notify contractNo:{}, signBillId:{}", (Object)contractNo, (Object)signBillId);
        if (HRStringUtils.equals((String)signBill.getString("businesstype"), (String)BusinessTypeEnum.CANCEL.getCombKey())) {
            LOGGER.info("businessType is cancel need not companySignNotify");
            return null;
        }
        try (TXHandle txHandleOne = TX.required();){
            DynamicObject entryEntityDy = this.getEntryEntityDyByConstractNo(signBill, contractNo);
            entryEntityDy.set("entrycompsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
            SignRespParam signRespParam = IHRCSService.getInstance().getPrevAndDown(signBill, contractNo);
            List downloadUrlList = signRespParam.getSealInfo().getDownloadUrlList();
            this.updateOneSignDocUrl(signBill, (String)downloadUrlList.get(0), "companysignnotify", entryEntityDy, false);
            CommonRepository.updateOne("hlcm_contractapplyentry", entryEntityDy);
            if (HRStringUtils.equals((String)signBill.getString("signtasknumber"), (String)contractNo)) {
                signBill.set("compsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
                CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            }
        }
        if (this.checkExistUnsuccessful(signBillId, "entrycompsignstatus")) {
            return "";
        }
        long activityInsId = this.getCurActivityInsId(signBill, SignTabEnum.E_CSIGN.getSourceListFormId());
        LOGGER.info("companySignNotify activityInsId|{}", (Object)activityInsId);
        try (TXHandle txHandleSecond = TX.required();){
            this.completeCompanySign(signBill, activityInsId);
        }
        LOGGER.info("company sign notify end");
        return null;
    }

    private DynamicObject getEntryEntityDyByConstractNo(DynamicObject signBill, String contractNo) {
        DynamicObjectCollection entryEntityCollection = signBill.getDynamicObjectCollection("entryentity");
        long entryid = 0L;
        for (DynamicObject entryEntityDy : entryEntityCollection) {
            if (!HRStringUtils.equals((String)entryEntityDy.getString("contractno"), (String)contractNo)) continue;
            entryid = entryEntityDy.getLong("id");
        }
        return ContractApplyEntryRepository.getInstance().queryByContractEntryId(entryid);
    }

    private boolean checkExistUnsuccessful(long signBillId, String empCompSignStatusKey) {
        DynamicObject[] billAllEntry;
        for (DynamicObject entry : billAllEntry = ContractApplyEntryRepository.getInstance().queryAllEntryByApplyId(signBillId)) {
            if (HRStringUtils.equals((String)entry.getString(empCompSignStatusKey), (String)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public DynamicObject loadCurUserSignBill(String id) {
        if (HRStringUtils.isEmpty((String)id)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"SignManageServiceImpl_13", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        Long userId = RequestContext.get().getCurrUserId();
        Long personId = PersonService.getInstance().getPersonIdByUserId(userId);
        if (personId == null || personId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u540c\u5355\u636e\u3002", (String)"SignManageServiceImpl_12", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(id)), new QFilter("person", "=", (Object)personId)};
        DynamicObject signBill = CommonRepository.queryOne("hlcm_contractapplybase", null, filters);
        if (HRObjectUtils.isEmpty((Object)signBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u540c\u5355\u636e\u3002", (String)"SignManageServiceImpl_12", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        return signBill;
    }

    @Override
    public void empInfoConfirm(String id, DynamicObject dataEntity) {
        TXHandle txHandle = TX.required();
        LOGGER.info("empInfoConfirm#id:{},dataEntity:{}", (Object)id, (Object)dataEntity);
        DynamicObject signBill = this.loadCurUserSignBill(id);
        try {
            signBill.set("cardtype", dataEntity.get("cardtype"));
            signBill.set("cardnumber", dataEntity.get("cardnumber"));
            signBill.set("residentialaddress", (Object)dataEntity.getString("residentialaddress"));
            String empPhone = dataEntity.getString("empphone");
            if (empPhone.startsWith("+86") && !empPhone.startsWith("+86-")) {
                empPhone = empPhone.replace("+86", "+86-");
            }
            signBill.set("empphone", (Object)empPhone);
            signBill.set("signstatus", (Object)SignStatusEnum.TO_SIGN.getCombKey());
            signBill.set("billstatus", (Object)BillStatusEnum.STATUS_APPROVED.getCode());
            CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            this.batchReplaceKeywordGenContract(new DynamicObject[]{signBill}, true);
            CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            this.updateCurrentActivityProcessStatus(signBill, ProcessStatusEnum.PROCESSED);
            ISignActivity.getInstance().assignAndConsentTask((Long)signBill.getLong("activityins.id"), SignTabEnum.E_CONFIRM);
        }
        catch (KDBizException e) {
            LOGGER.error("emp info confirm error", (Throwable)e);
            txHandle.markRollback();
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("emp info confirm error", (Throwable)e);
            txHandle.markRollback();
            throw new KDBizException(ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\u786e\u8ba4\u5931\u8d25\u3002", (String)"SignManageServiceImpl_9", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        finally {
            txHandle.close();
        }
    }

    @Override
    public void batchReplaceKeywordGenContract(DynamicObject[] signBills, boolean isToPdf) {
        HashMap<DynamicObject, DynamicObject> contractTemplateEntryMap = new HashMap<DynamicObject, DynamicObject>(signBills.length);
        Arrays.stream(signBills).forEach(signBill -> {
            DynamicObjectCollection dynamicObjectCollection = signBill.getDynamicObjectCollection("entryentity");
            dynamicObjectCollection.stream().filter(contractTemplateEntry -> HRStringUtils.isEmpty((String)contractTemplateEntry.getString("presigndocurl"))).forEach(contractTemplateEntry -> contractTemplateEntryMap.put((DynamicObject)contractTemplateEntry, (DynamicObject)signBill));
        });
        int size = contractTemplateEntryMap.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            Map.Entry entry = contractTemplateEntryMap.entrySet().iterator().next();
            DynamicObject contractTemplateEntry2 = (DynamicObject)entry.getKey();
            String replacedFilePath = this.replaceKeywordGenContract((DynamicObject)entry.getValue(), contractTemplateEntry2, true, isToPdf);
            if (!HRStringUtils.isEmpty((String)replacedFilePath)) {
                contractTemplateEntry2.set("presigndocurl", (Object)replacedFilePath);
            }
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(size);
            AtomicInteger atomicSuccessCount = new AtomicInteger(0);
            contractTemplateEntryMap.forEach((contractTemplateEntry, signBill) -> THREAD_POOL.execute(() -> {
                try {
                    String replacedFilePath = this.replaceKeywordGenContract((DynamicObject)signBill, (DynamicObject)contractTemplateEntry, true, isToPdf);
                    if (!HRStringUtils.isEmpty((String)replacedFilePath)) {
                        contractTemplateEntry.set("presigndocurl", (Object)replacedFilePath);
                    }
                    atomicSuccessCount.incrementAndGet();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            }));
            try {
                if (!countDownLatch.await(180L, TimeUnit.SECONDS)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u66ff\u6362\u5173\u952e\u5b57\u751f\u6210\u5408\u540c\u5931\u8d25\u3002", (String)"SignManageServiceImpl_16", (String)"hr-hlcm-business", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (size != atomicSuccessCount.get()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u66ff\u6362\u5173\u952e\u5b57\u751f\u6210\u5408\u540c\u5931\u8d25\u3002", (String)"SignManageServiceImpl_16", (String)"hr-hlcm-business", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public Map<String, String> replaceKeywordGenFile(DynamicObject signBill, DynamicObject contractTemplateEntry, boolean isAlterFileName, boolean isToPdf) {
        String fileId = this.replaceKeywordGenContract(signBill, contractTemplateEntry, isAlterFileName, isToPdf);
        FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
        String realPath = attachFileServiceExt.getRealPath(fileId);
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)2);
        result.put("fileId", fileId);
        result.put("realPath", realPath);
        return result;
    }

    @Override
    public String replaceKeywordGenContract(DynamicObject signBill, DynamicObject contractTemplateEntry, boolean isAlterFileName, boolean isToPdf) {
        try {
            RequestContext requestContext;
            String pathParam;
            if (contractTemplateEntry.getDynamicObject("texthis") == null) {
                return "";
            }
            DynamicObject contractTemplateHis = CommonRepository.queryById("hlcm_contracttemplatehis", null, contractTemplateEntry.getDynamicObject("texthis").getLong("id"));
            Map<String, String> keyWordMap = this.getKeyWordMap(signBill, contractTemplateHis, contractTemplateEntry);
            DynamicObject[] attachments = BosAttachmentRepository.getInstance().queryByInterId(contractTemplateHis.getString("id"), "hlcm_contracttemplatehis", "ffileid");
            if (attachments == null || attachments.length == 0) {
                return null;
            }
            String fileId = attachments[0].getString("ffileid");
            FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
            String wordFilePath = attachFileServiceExt.getRealPath(fileId);
            String wordFileName = wordFilePath.substring(wordFilePath.lastIndexOf(47) + 1);
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            if (fileService.exists(pathParam = FileNameUtils.getAttachmentFileName((String)(requestContext = RequestContext.get()).getTenantId(), (String)requestContext.getAccountId(), (String)"hlcm", (String)"hlcm_contractapplybase", (Object)contractTemplateEntry.getString("id"), (String)wordFileName))) {
                fileService.delete(pathParam);
                LOGGER.info("delete pathParam:{}", (Object)pathParam);
            }
            if (isAlterFileName) {
                String contractNumber = contractTemplateEntry.getString("entrycontractnumber");
                if (HRStringUtils.isEmpty((String)contractNumber)) {
                    contractNumber = signBill.getString("contractnumber");
                }
                if (HRStringUtils.isEmpty((String)contractNumber)) {
                    contractNumber = signBill.getDynamicObject("oldcontract").getString("number");
                }
                wordFileName = String.format("%s-%s-%s.docx", signBill.getString("empname"), contractNumber, contractTemplateEntry.getDynamicObject("contracttemplate").getString("name"));
            }
            LOGGER.info("replaceWordKeyword fileId:{},wordFilePath:{},wordFileName:{}", new Object[]{fileId, wordFilePath, wordFileName});
            String keyWordDouble = contractTemplateHis.getDynamicObject("econtemplate") != null ? contractTemplateHis.getDynamicObject("econtemplate").getString("keyworddouble") : "";
            String replacedFilePath = HRWordUtils.replaceWordKeyword((String)wordFilePath, (String)wordFileName, (String)"hlcm_contractapplybase", keyWordMap, (boolean)isToPdf, (String)keyWordDouble, (String)"hlcm", (Object)contractTemplateEntry.getLong("id"));
            LOGGER.info("replaceWordKeyword replacedFilePath:{}", (Object)replacedFilePath);
            Assert.hasText((String)replacedFilePath, (String)"replaceWordKeyword file path is incorrect");
            return replacedFilePath;
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u66ff\u6362\u5173\u952e\u5b57\u751f\u6210\u5408\u540c\u5931\u8d25\u3002", (String)"SignManageServiceImpl_16", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
    }

    private Map<String, String> getKeyWordMap(DynamicObject signBill, DynamicObject contractTemplateHis, DynamicObject contractTemplateEntry) {
        DynamicObject keywordMappingDy = IHRCSService.getInstance().selectKeywordMappingWithCondition(contractTemplateHis.getLong("id"));
        Map<String, String> keywordMap = new HashMap<String, String>();
        if (!HRObjectUtils.isEmpty((Object)keywordMappingDy)) {
            Map<String, String> syspresetCustomizeKVsMap = this.getSyspresetCustomizeKVs(keywordMappingDy, signBill, contractTemplateEntry);
            Map<String, String> customizeKVs = ProxyUtils.getKeyWordRepMapWithCust((PluginCall<IHLCMTemplateService, Map<String, String>>)((PluginCall)hlcmTemService -> hlcmTemService.getKeyWordRepMapWithCust(signBill, contractTemplateHis)));
            customizeKVs.putAll(syspresetCustomizeKVsMap);
            keywordMap = IHRCSService.getInstance().getKeyWordRepMapWithCust(Lists.newArrayList((Object[])new DynamicObject[]{signBill}), keywordMappingDy, "hlcm_contractapplybase", customizeKVs);
            String muchFlag = keywordMap.get(MUCH_FLAG);
            if (HRStringUtils.isNotEmpty((String)muchFlag)) {
                String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5408\u540c\u7b7e\u7f72\u6a21\u677f\u201c%1$s\u201d\u4e2d\u914d\u7f6e\u7684\u53d8\u91cf\u5b57\u6bb5\u201c%2$s\u201d\u65e0\u6cd5\u5339\u914d\u5230\u552f\u4e00\u7684\u5b57\u6bb5\u503c\uff0c\u8bf7\u8054\u7cfb\u5408\u540c\u6a21\u677f\u7ba1\u7406\u5458\u91cd\u65b0\u914d\u7f6e\u6a21\u677f\u5b57\u6bb5\u3002", (String)"SignManageServiceImpl_20", (String)"hr-hlcm-business", (Object[])new Object[0]), contractTemplateHis.getString("name"), muchFlag);
                throw new KDBizException(errMsg);
            }
        }
        return keywordMap;
    }

    private Map<String, String> getSyspresetCustomizeKVs(DynamicObject keywordMappingDy, DynamicObject signBill, DynamicObject contractTemplateEntry) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (contractTemplateEntry == null) {
            return resultMap;
        }
        DynamicObjectCollection customizeCol = keywordMappingDy.getDynamicObjectCollection("entryentity");
        if (customizeCol == null || customizeCol.size() == 0) {
            return resultMap;
        }
        ArrayList customizeKeyList = new ArrayList(customizeCol.size());
        customizeCol.forEach(customizeDyn -> {
            String customizeKey;
            if (HRStringUtils.equals((String)"1", (String)customizeDyn.getString("iscustomize")) && HRStringUtils.isNotEmpty((String)(customizeKey = customizeDyn.getString("customizekey")))) {
                customizeKeyList.add(customizeDyn.getString("customizekey"));
            }
        });
        if (customizeKeyList.size() == 0) {
            return resultMap;
        }
        Map<String, String> valueMap = this.getValueFromContractTemplateEntry(signBill, contractTemplateEntry);
        customizeKeyList.forEach(customizeKey -> resultMap.put(customizeKey, valueMap.get(customizeKey)));
        return resultMap;
    }

    private Map<String, String> getValueFromContractTemplateEntry(DynamicObject signBill, DynamicObject contractTemplateEntry) {
        String contractNumber = contractTemplateEntry.getString("entrycontractnumber");
        DynamicObject contractType = contractTemplateEntry.getDynamicObject("entrycontracttype");
        DynamicObject periodtype = contractTemplateEntry.getDynamicObject("entryperiodtype");
        String period = contractTemplateEntry.getString("entryperiod");
        Date startDate = contractTemplateEntry.getDate("entrystartdate");
        Date endDate = contractTemplateEntry.getDate("entryenddate");
        LocaleString periodunitLocaleString = HRStringUtils.equals((String)contractTemplateEntry.getString("entryperiodunit"), (String)"0") ? null : ComboUtils.getComboOptionName((DynamicObject)contractTemplateEntry, (String)"entryperiodunit");
        period = period.substring(0, period.indexOf(".") > 0 ? period.indexOf(".") + 2 : period.length()).replace(".0", "");
        Map maskMap = DateUtil.getTimeMask((String)signBill.getDataEntityType().getName(), Arrays.asList("entrystartdate", "entryenddate"));
        String startDateStr = DateUtil.formatDateByMask((Date)startDate, (String)((String)maskMap.get("entrystartdate")));
        String endDateStr = DateUtil.formatDateByMask((Date)endDate, (String)((String)maskMap.get("entryenddate")));
        String contractType_CN = this.getNameLocalStringValue(contractType, "zh_CN");
        String contractType_US = this.getNameLocalStringValue(contractType, "en_US");
        String periodtype_CN = this.getNameLocalStringValue(periodtype, "zh_CN");
        String periodtype_US = this.getNameLocalStringValue(periodtype, "en_US");
        String periodunit_CN = this.getLocalStringValue((ILocaleString)periodunitLocaleString, "zh_CN");
        String periodunit_US = this.getLocalStringValue((ILocaleString)periodunitLocaleString, "en_US");
        if (periodtype != null && Objects.equals(periodtype.getLong("id"), ContractPeriodTypeEnum.NONFIXED.getPkId())) {
            period = "";
            periodunit_CN = "";
            periodunit_US = "";
            endDateStr = "";
        }
        HashMap<String, String> valueMap = new HashMap<String, String>(16);
        valueMap.put("entry_contractno", contractNumber);
        valueMap.put("entry_contracttype_cn", contractType_CN);
        valueMap.put("entry_contracttype_us", contractType_US);
        valueMap.put("entry_periodtype_cn", periodtype_CN);
        valueMap.put("entry_periodtype_us", periodtype_US);
        valueMap.put("entry_startdate", startDateStr);
        valueMap.put("entry_enddate", endDateStr);
        valueMap.put("entry_period_periodunit_cn", period + periodunit_CN);
        valueMap.put("entry_period_periodunit_us", period + periodunit_US);
        return valueMap;
    }

    private String getNameLocalStringValue(DynamicObject dyn, String ormLocaleValue) {
        if (dyn != null) {
            ILocaleString localeString = dyn.getLocaleString("name");
            return this.getLocalStringValue(localeString, ormLocaleValue);
        }
        return "";
    }

    private String getLocalStringValue(ILocaleString localeString, String ormLocaleValue) {
        String value;
        if (localeString != null && HRStringUtils.isNotEmpty((String)(value = (String)localeString.getItem(ormLocaleValue)))) {
            return value;
        }
        return "";
    }

    @Override
    public void validateMuchValue(DynamicObject signBill) {
        DynamicObjectCollection collection = signBill.getDynamicObjectCollection("entryentity");
        Set textHisIds = collection.stream().map(contractTemplateEntry -> contractTemplateEntry.getDynamicObject("texthis")).filter(contractTemplate -> !HRObjectUtils.isEmpty((Object)contractTemplate)).map(contractTemplate -> contractTemplate.getLong("id")).map(String::valueOf).collect(Collectors.toSet());
        QFilter filter = new QFilter("finterid", "in", textHisIds).and("fbilltype", "=", (Object)"hlcm_contracttemplatehis").and("fattachmentpanel", "=", (Object)"attachmentpanelap");
        DynamicObject[] attachmentDys = HLCMCommonRepository.queryDynamicObjects("bos_attachment", "finterid", filter);
        Set existAttachmentIds = Stream.of(attachmentDys).map(attachment -> attachment.getString("finterid")).collect(Collectors.toSet());
        for (DynamicObject contractTemplateEntry2 : collection) {
            long textHisId;
            DynamicObject contractTemplate2 = contractTemplateEntry2.getDynamicObject("texthis");
            if (HRObjectUtils.isEmpty((Object)contractTemplate2) || !existAttachmentIds.contains(String.valueOf(textHisId = contractTemplate2.getLong("id")))) continue;
            DynamicObject contractTemplateHis = CommonRepository.queryById("hlcm_contracttemplatehis", null, textHisId);
            this.getKeyWordMap(signBill, contractTemplateHis, null);
        }
    }

    @Override
    public void empSignComplete(DynamicObject signBill) {
        long signBillId = signBill.getLong("id");
        long activityInsId = this.getCurActivityInsId(signBill, SignTabEnum.E_ESIGN.getSourceListFormId());
        LOGGER.info("emp sign complete id:{},activityInsId:{}", (Object)signBill.getLong("id"), (Object)activityInsId);
        try (TXHandle txHandle = TX.required();){
            DynamicObjectCollection entryEntityCollection = signBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryEntityDy : entryEntityCollection) {
                boolean isDone = entryEntityDy.getBoolean("isdone");
                if (isDone) {
                    LOGGER.warn("emp sign repeat signBillId|{}", (Object)signBillId);
                    return;
                }
                entryEntityDy.set("isdone", (Object)Boolean.TRUE);
                entryEntityDy.set("signdate", (Object)new Date());
                entryEntityDy.set("entryempsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
            }
            DynamicObject contract = (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(0);
            String contractNo = contract.getString("contractno");
            SignRespParam signRespParam = IHRCSService.getInstance().getPrevAndDown(signBill, contractNo);
            List downloadUrlList = signRespParam.getSealInfo().getDownloadUrlList();
            this.updateSignDocUrl(signBill, downloadUrlList, "empsignnotify", false);
            this.completeEmpSign(signBill, activityInsId, contractNo);
        }
    }

    private void completeEmpSign(DynamicObject signBill, long activityInsId, String contractNo) {
        if (HRStringUtils.equals((String)signBill.getString("businesstype"), (String)BusinessTypeEnum.CANCEL.getCombKey()) && !HRStringUtils.equals((String)signBill.getString("handlestatus"), (String)HandleStatusEnum.ARCHIVE.getCombKey())) {
            signBill.set("actualsigndate", (Object)new Date());
            this.archiveUpdateSignBill(signBill);
            this.updateCurrentActivityProcessStatus(activityInsId, ProcessStatusEnum.PROCESSED);
            ISignManageService.getInstance().archiveAfterTransaction(signBill);
        } else {
            signBill.set("billstatus", (Object)BillStatusEnum.STATUS_APPROVED.getCode());
            signBill.set("signstatus", (Object)SignStatusEnum.P_SIGNED.getCombKey());
            signBill.set("empsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
            CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            this.updateCurrentActivityProcessStatus(activityInsId, ProcessStatusEnum.PROCESSED);
        }
        LOGGER.info("assignAndConsentTask activityInsId:{} contractNo:{}", (Object)activityInsId, (Object)contractNo);
        ISignActivity.getInstance().assignAndConsentTask((Long)activityInsId, SignTabEnum.E_ESIGN);
    }

    @Override
    public void empSignCompleteMulTaskMode(DynamicObject signBill, String contractNo) {
        long signBillId = signBill.getLong("id");
        long activityInsId = this.getCurActivityInsId(signBill, SignTabEnum.E_ESIGN.getSourceListFormId());
        LOGGER.info("MulTaskMode emp sign complete id:{},activityInsId:{},contractNo:{}", new Object[]{signBillId, activityInsId, contractNo});
        try (TXHandle txHandleOne = TX.required();){
            DynamicObject entryEntityDy = this.getEntryEntityDyByConstractNo(signBill, contractNo);
            boolean isDone = entryEntityDy.getBoolean("isdone");
            if (!isDone) {
                entryEntityDy.set("isdone", (Object)Boolean.TRUE);
                entryEntityDy.set("signdate", (Object)new Date());
                entryEntityDy.set("entryempsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
                SignRespParam signRespParam = IHRCSService.getInstance().getPrevAndDown(signBill, contractNo);
                List downloadUrlList = signRespParam.getSealInfo().getDownloadUrlList();
                this.updateOneSignDocUrl(signBill, (String)downloadUrlList.get(0), "empsignnotify", entryEntityDy, false);
                CommonRepository.updateOne("hlcm_contractapplyentry", entryEntityDy);
                if (HRStringUtils.equals((String)signBill.getString("signtasknumber"), (String)contractNo)) {
                    signBill.set("empsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
                    CommonRepository.updateOne("hlcm_contractapplybase", signBill);
                }
            }
        }
        if (!HRStringUtils.equals((String)signBill.getString("signstatus"), (String)SignStatusEnum.TO_SIGN.getCombKey())) {
            return;
        }
        if (this.checkExistUnsuccessful(signBillId, "entryempsignstatus")) {
            LOGGER.info("check Exist Unsuccessful signBillId|{}", (Object)signBillId);
            return;
        }
        LOGGER.info("signBillId|{} has been callback success", (Object)signBillId);
        try (TXHandle txHandleSecond = TX.required();){
            this.completeEmpSign(signBill, activityInsId, contractNo);
        }
    }

    @Override
    public void viewContract(IFormView formView) {
        DynamicObject signBill = ISignManageService.getInstance().loadCurUserSignBill((String)formView.getFormShowParameter().getCustomParam("id"));
        DynamicObject contract = (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(0);
        String contractNo = contract.getString("contractno");
        if (HRStringUtils.isEmpty((String)contractNo)) {
            return;
        }
        if (!contract.getBoolean("isdone")) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7535\u5b50\u5408\u540c\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SignManageServiceImpl_18", (String)"hr-hlcm-business", (Object[])new Object[0]));
            return;
        }
        try {
            SignRespParam signRespParam = IHRCSService.getInstance().getPrevAndDown(signBill, contractNo);
            formView.openUrl(signRespParam.getSealInfo().getPreviewOfMobileUrl());
        }
        catch (Exception exp) {
            LOGGER.error("getPrevAndDown error.", (Throwable)exp);
            formView.showTipNotification(HLCMExceptionUtils.handleException(exp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String beginSignHandler(DynamicObject signBill, DynamicObject nextActivity) {
        try (TXHandle txHandle = TX.required();){
            ActivityStatusEnum activityStatusEnum = this.getActivityStatusEnum(signBill);
            String signWay = signBill.getString("signway");
            if (activityStatusEnum == ActivityStatusEnum.E_TO_LAUNCH || activityStatusEnum == ActivityStatusEnum.P_TO_LAUNCH) {
                signBill.set("billstatus", (Object)BillStatusEnum.STATUS_APPROVED.getCode());
                this.refreshPersonInfo(signBill);
                DynamicObject reloadSignBill = CommonRepository.reload(signBill);
                if (HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey())) {
                    String formId = nextActivity.getString("activity.bizobj.number");
                    if (!HRStringUtils.equals((String)formId, (String)SignTabEnum.E_CONFIRM.getSourceListFormId())) {
                        this.batchReplaceKeywordGenContract(new DynamicObject[]{reloadSignBill}, true);
                        reloadSignBill.set("signstatus", (Object)SignStatusEnum.TO_SIGN.getCombKey());
                    }
                    this.initSignStatus(reloadSignBill);
                } else {
                    this.batchReplaceKeywordGenContract(new DynamicObject[]{reloadSignBill}, false);
                }
                CommonRepository.updateOne("hlcm_contractapplybase", reloadSignBill);
                this.updateCurrentActivityProcessStatus(reloadSignBill, ProcessStatusEnum.PROCESSED);
            }
            if (HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey())) {
                ISendMessageService.getInstance().beginSignSendMessage(signBill.getLong("id"));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void empSign(IFormView formView, DynamicObject signBill, DynamicObject contractTemplate) {
        LOGGER.info("===SignManageServiceImpl.empSign begin===");
        try (TXHandle txHandle = TX.required();){
            SignRespParam signRespParam = IHRCSService.getInstance().toSign(signBill, contractTemplate);
            this.updateCurrentActivityProcessStatus(signBill, ProcessStatusEnum.PROCESSING);
            DynamicObjectCollection signTextCollection = signBill.getDynamicObjectCollection("entryentity");
            if (!this.isMultiTask(signBill)) {
                signTextCollection.forEach(signTextDy -> signTextDy.set("contractno", (Object)signRespParam.getContractNo()));
            }
            CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            String authUrl = signRespParam.getAuthUrl();
            String jumpUrl = HRStringUtils.isEmpty((String)authUrl) ? signRespParam.getHandSignUrl() : authUrl;
            formView.openUrl(jumpUrl);
        }
        LOGGER.info("===SignManageServiceImpl.empSign end===");
    }

    @Override
    public void empBatchSign(IFormView formView, DynamicObject signBill) {
        DynamicObjectCollection entryEntity = signBill.getDynamicObjectCollection("entryentity");
        DynamicObject firstContractTemplate = (DynamicObject)entryEntity.get(0);
        int count = entryEntity.size();
        ArrayList contractNos = Lists.newArrayListWithCapacity((int)count);
        if (this.isMultiTask(signBill)) {
            for (DynamicObject contractTemplate : entryEntity) {
                String contractNo = contractTemplate.getString("contractno");
                String empSignStatus = contractTemplate.getString("entryempsignstatus");
                if (HRStringUtils.isEmpty((String)contractNo)) {
                    SignRespParam signRespParam = IHRCSService.getInstance().toSign(signBill, contractTemplate);
                    if (HRStringUtils.isNotEmpty((String)signRespParam.getAuthUrl())) {
                        formView.openUrl(signRespParam.getAuthUrl());
                        return;
                    }
                    String contractNewNo = signRespParam.getContractNo();
                    contractTemplate.set("contractno", (Object)contractNewNo);
                    contractNos.add(contractNewNo);
                    continue;
                }
                if (HRStringUtils.equals((String)empSignStatus, (String)EmpCompSignStatusEnum.TO_SIGN.getValue()) || HRStringUtils.isEmpty((String)empSignStatus)) {
                    contractNos.add(contractNo);
                    continue;
                }
                LOGGER.info("contractNo|{} has been signed or signing", (Object)contractNo);
            }
            CommonRepository.updateOne("hlcm_contractapplybase", signBill);
        }
        if (contractNos.size() > 1) {
            SignRespParam batchSignUrlResp = IHRCSService.getInstance().getBatchSignUrl(signBill, contractNos);
            formView.openUrl(batchSignUrlResp.getHandSignUrl());
        } else {
            this.empSign(formView, signBill, firstContractTemplate);
        }
    }

    @Override
    public String companySignHandler(DynamicObject signBill) {
        try (TXHandle ignored = TX.notSupported();){
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("hlcm");
            String value = String.valueOf(RequestContext.get().getCurrUserId());
            long pkValue = signBill.getLong("id");
            String key = String.format("%s_%d", "COMPANY_SIGN", pkValue);
            cache.put(key, (Object)value, 1, TimeUnit.DAYS);
            LOGGER.info("put key|{} value|{} into cache", (Object)key, (Object)value);
            DynamicObjectCollection entryEntityCollection = signBill.getDynamicObjectCollection("entryentity");
            if (this.isMultiTask(signBill)) {
                for (DynamicObject contractTemplate : entryEntityCollection) {
                    String compSignStatus = contractTemplate.getString("entrycompsignstatus");
                    if (!Lists.newArrayList((Object[])new String[]{EmpCompSignStatusEnum.TO_SIGN.getValue(), EmpCompSignStatusEnum.SIGN_FAILED.getValue()}).contains(compSignStatus) && !HRStringUtils.isEmpty((String)compSignStatus)) continue;
                    IHRCSService.getInstance().sign(signBill, contractTemplate);
                }
            } else {
                IHRCSService.getInstance().sign(signBill, (DynamicObject)entryEntityCollection.get(0));
            }
            this.updateCurrentActivityProcessStatus(signBill, ProcessStatusEnum.PROCESSING);
        }
        catch (Exception exp) {
            LOGGER.error("company sign error", (Throwable)exp);
            return HLCMExceptionUtils.handleException(exp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String completeSignHandler(DynamicObject signBill, DynamicObject nextActivity) {
        String formId = HRObjectUtils.isEmpty((Object)nextActivity) ? null : nextActivity.getString("activity.bizobj.number");
        try (TXHandle txHandle = TX.required();){
            Date signDate = signBill.getDate("signeddate");
            Date actualSignDate = signBill.getDate("actualsigndate");
            if (null == actualSignDate) {
                signBill.set("actualsigndate", (Object)signDate);
            }
            this.updateCurrentActivityProcessStatus(signBill, ProcessStatusEnum.PROCESSED);
            if (!HRStringUtils.equals((String)formId, (String)SignTabEnum.P_CHECK.getSourceListFormId())) {
                this.archiveUpdateSignBill(signBill);
            } else {
                signBill.set("signstatus", (Object)SignStatusEnum.COMPLETE_SIGN.getCombKey());
                signBill.set("billstatus", (Object)BillStatusEnum.STATUS_APPROVED.getCode());
                CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            }
        }
        return null;
    }

    @Override
    public void signFailNotifyHandler(DynamicObject signBill) {
        boolean isCSignActivity = HRStringUtils.equals((String)BusinessStatusEnum.CSIGN.getCombKey(), (String)signBill.getString("businessstatus"));
        String empCompSignStatusKey = isCSignActivity ? "entrycompsignstatus" : "entryempsignstatus";
        String billEmpCompSignStatusKey = isCSignActivity ? "compsignstatus" : "empsignstatus";
        DynamicObjectCollection entryEntityCollection = signBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntityDy : entryEntityCollection) {
            entryEntityDy.set(empCompSignStatusKey, (Object)EmpCompSignStatusEnum.SIGN_FAILED.getValue());
        }
        signBill.set(billEmpCompSignStatusKey, (Object)EmpCompSignStatusEnum.SIGN_FAILED.getValue());
        CommonRepository.updateOne("hlcm_contractapplybase", signBill);
        this.updateCurrentActivityProcessStatus(signBill, ProcessStatusEnum.PROCESSING_FAIL);
    }

    @Override
    public void signFailNotifyHandlerMulTaskMode(DynamicObject signBill, String contractNo, String businessType) {
        boolean isCSignActivity = HRStringUtils.equals((String)BusinessStatusEnum.CSIGN.getCombKey(), (String)businessType);
        String empCompSignStatusKey = isCSignActivity ? "entrycompsignstatus" : "entryempsignstatus";
        String billEmpCompSignStatusKey = isCSignActivity ? "compsignstatus" : "empsignstatus";
        DynamicObject entryEntityDy = this.getEntryEntityDyByConstractNo(signBill, contractNo);
        entryEntityDy.set(empCompSignStatusKey, (Object)EmpCompSignStatusEnum.SIGN_FAILED.getValue());
        CommonRepository.updateOne("hlcm_contractapplyentry", entryEntityDy);
        if (HRStringUtils.equals((String)signBill.getString("signtasknumber"), (String)contractNo)) {
            signBill.set(billEmpCompSignStatusKey, (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
            CommonRepository.updateOne("hlcm_contractapplybase", signBill);
        }
        this.updateCurrentActivityProcessStatus(signBill, ProcessStatusEnum.PROCESSING_FAIL);
    }

    @Override
    public void cancel(DynamicObject applyBill) {
        ArrayList selectProperties = Lists.newArrayList((Object[])new String[]{"signway", String.format(Locale.ROOT, "%s.%s", "entryentity", "contractno"), "actualsigncompanyhis"});
        DynamicObject signBill = HLCMCommonRepository.queryDynamicObjectByPk("hlcm_contractapplybase", String.join((CharSequence)",", selectProperties), applyBill.getPkValue());
        if (HRStringUtils.equals((String)signBill.getString("signway"), (String)SignWayEnum.ELECTRONIC.getCombKey())) {
            signBill.getDynamicObjectCollection("entryentity").stream().findFirst().map(contract -> contract.getString("contractno")).ifPresent(contractNo -> IHRCSService.getInstance().cancel(signBill, (String)contractNo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String confirmArchiveHandler(DynamicObject signBill) {
        try (TXHandle txHandle = TX.required();){
            LOGGER.info("confirmArchiveHandler start");
            this.updateCurrentActivityProcessStatus(signBill, ProcessStatusEnum.PROCESSED);
            this.archiveUpdateSignBill(signBill);
            LOGGER.info("confirmArchiveHandler end");
        }
        return null;
    }

    @Override
    public boolean isAbleBeginSign(ActivityStatusEnum activityStatusEnum) {
        return ABLE_BEGIN_SIGN_ACTIVITY_STATUS_SET.contains(activityStatusEnum);
    }

    @Override
    public String permissionValidate(IFormView formView, String operateKey, String operateName) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String formId = formShowParameter.getFormId();
        SignTabEnum signTabEnum = SignTabEnum.getSignEnum((String)formId);
        String formName = signTabEnum.getFormName().loadKDString();
        String listFormId = signTabEnum.getListFormId();
        DynamicObject activity = CommonRepository.queryOne("hlcm_activity", "id", new QFilter[]{new QFilter("signapply.id", "=", formView.getModel().getDataEntity().getPkValue())});
        Object activityId = HRObjectUtils.isEmpty((Object)activity) ? null : activity.get("id");
        boolean permissionResult = true;
        boolean dataRuleResult = true;
        switch (operateKey) {
            case "refresh": {
                if (SignTabEnum.E_ALL.getListFormId().equals(listFormId)) break;
                permissionResult = SignListPermissionUtils.checkRefreshPermission(listFormId);
                dataRuleResult = SignListPermissionUtils.checkRefreshDataRulePermission(listFormId, activityId);
                break;
            }
            case "stopsign": {
                permissionResult = SignListPermissionUtils.checkStopSignPermission(listFormId);
                dataRuleResult = SignListPermissionUtils.checkStopSignDataRulePermission(listFormId, activityId);
                break;
            }
            case "beginsign": {
                permissionResult = SignListPermissionUtils.checkBeginSignPermission(listFormId);
                dataRuleResult = SignListPermissionUtils.checkBeginSignDataRulePermission(listFormId, activityId);
                break;
            }
            case "compsign": {
                permissionResult = SignListPermissionUtils.checkCompSignPermission(listFormId);
                dataRuleResult = SignListPermissionUtils.checkCompSignDataRulePermission(listFormId, activityId);
                break;
            }
            case "companysign": {
                permissionResult = SignListPermissionUtils.checkCSignSignPermission(listFormId);
                dataRuleResult = SignListPermissionUtils.checkCSignSignDataRulePermission(listFormId, activityId);
                break;
            }
            case "archive": 
            case "confirmarchive": {
                permissionResult = SignListPermissionUtils.checkArchiveSignPermission(listFormId);
                dataRuleResult = SignListPermissionUtils.checkArchiveSignDataRulePermission(listFormId, activityId);
                break;
            }
        }
        String errorInfo = null;
        if (!permissionResult) {
            errorInfo = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignManageServiceImpl_14", (String)"hr-hlcm-business", (Object[])new Object[0]), formName, operateName);
            OperationLogUtils.writeLog(formShowParameter, operateKey, operateName, new kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee\uff1a%s\u3002", "SignManageServiceImpl_15", "hr-hlcm-business"), errorInfo);
        } else if (!dataRuleResult) {
            errorInfo = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%1$s\u201d\u201c%2$s\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignManageServiceImpl_17", (String)"hr-hlcm-business", (Object[])new Object[0]), operateName, formName);
            OperationLogUtils.writeLog(formShowParameter, operateKey, operateName, new kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge("\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%1$s\u201d\u201c%2$s\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", "SignManageServiceImpl_17", "hr-hlcm-business"), operateName, formName);
        } else {
            LOGGER.info("permissionResult is true,dataRuleResult is true");
        }
        return errorInfo;
    }

    @Override
    public void initPrompt(IFormView formView, Long promptId, String htmlApKey) {
        String content = IHRCSService.getInstance().getContent(promptId);
        HtmlAp htmlAp = new HtmlAp();
        htmlAp.setKey(htmlApKey);
        htmlAp.setHtmlContent(content);
        htmlAp.setDirection("column");
        formView.updateControlMetadata(htmlApKey, htmlAp.createControl());
    }

    private void updateCurrentActivityProcessStatus(DynamicObject signBill, ProcessStatusEnum processStatusEnum) {
        DynamicObject activityIns = signBill.getDynamicObject("activityins");
        if (HRObjectUtils.isEmpty((Object)activityIns)) {
            LOGGER.info("activityIns is empty");
            return;
        }
        long activityInsId = activityIns.getLong("id");
        this.updateCurrentActivityProcessStatus(activityInsId, processStatusEnum);
    }

    private void updateCurrentActivityProcessStatus(long activityInsId, ProcessStatusEnum processStatusEnum) {
        DynamicObject activity = CommonRepository.queryOne("hlcm_activity", GET_ACTIVITY_SELECT_PROPERTIES, new QFilter[]{new QFilter("activityins.id", "=", (Object)activityInsId)});
        if (HRObjectUtils.isEmpty((Object)activity)) {
            LOGGER.warn("can not find activity activityInsId|{}", (Object)activityInsId);
            return;
        }
        activity.set("processstatus", (Object)processStatusEnum.getValue());
        activity.set("processtime", (Object)new Date());
        CommonRepository.updateOne("hlcm_activity", activity);
    }

    private void archiveUpdateSignBill(DynamicObject signBill) {
        signBill.set("businessstatus", (Object)BusinessStatusEnum.ARCHIVE.getCombKey());
        signBill.set("handlestatus", (Object)HandleStatusEnum.ARCHIVE.getCombKey());
        signBill.set("signstatus", (Object)SignStatusEnum.COMPLETE_SIGN.getCombKey());
        signBill.set("billstatus", (Object)BillStatusEnum.STATUS_PASS.getCode());
        signBill.set("auditstatus", (Object)AuditStatusEnum.STATUS_AUDITED.getCode());
        signBill.set("deadline", null);
        signBill.set("activityins", null);
        signBill.set("empsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
        signBill.set("compsignstatus", (Object)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue());
        CommonRepository.updateOne("hlcm_contractapplybase", signBill);
    }

    private void setSignBillBaseExcelData(Map<String, Object> exportData, DynamicObject dynamicObject, String errorInfo) {
        exportData.put("id", dynamicObject.getLong("id"));
        exportData.put("empname", dynamicObject.getString("empname"));
        exportData.put("empnumber", dynamicObject.getString("empnumber"));
        DynamicObject actualSignCompany = dynamicObject.getDynamicObject("actualsigncompany");
        if (!HRObjectUtils.isEmpty((Object)actualSignCompany)) {
            exportData.put("actualsigncompany", actualSignCompany.getString("name"));
        }
        exportData.put("contractnumber", dynamicObject.getString("contractnumber"));
        Date signedDate = dynamicObject.getDate("signeddate");
        if (signedDate != null) {
            exportData.put("signeddate", HRDateTimeUtils.formatDate((Date)signedDate));
        }
        String billStatusName = BillStatusEnum.getValueByKey((String)dynamicObject.getString("billstatus"));
        exportData.put("billstatus", billStatusName);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            exportData.put("islegal", this.getValidateIsLegalFieldValue(false));
            exportData.put("reason", errorInfo);
        } else {
            exportData.put("islegal", this.getValidateIsLegalFieldValue(true));
        }
    }

    private void setExcelDataForContractCancelAndStop(Map<String, Object> exportData, DynamicObject dynamicObject, String errorInfo) {
        exportData.put("id", dynamicObject.getLong("id"));
        exportData.put("empname", dynamicObject.getString("empname"));
        exportData.put("empnumber", dynamicObject.getString("empnumber"));
        DynamicObject actualSignCompany = dynamicObject.getDynamicObject("actualsigncompany");
        if (!HRObjectUtils.isEmpty((Object)actualSignCompany)) {
            exportData.put("actualsigncompany", actualSignCompany.getString("name"));
        }
        exportData.put("billno", dynamicObject.getString("billno"));
        exportData.put("contractnumber", dynamicObject.getString("contractnumber"));
        String billStatusName = BillStatusEnum.getValueByKey((String)dynamicObject.getString("billstatus"));
        exportData.put("billstatus", billStatusName);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            exportData.put("islegal", this.getValidateIsLegalFieldValue(false));
            exportData.put("reason", errorInfo);
        } else {
            exportData.put("islegal", this.getValidateIsLegalFieldValue(true));
        }
    }

    private String getValidateIsLegalFieldValue(boolean isLegal) {
        return isLegal ? ResManager.loadKDString((String)"\u662f", (String)"SignManageServiceImpl_0", (String)"hr-hlcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SignManageServiceImpl_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public void refreshPersonInfo(DynamicObject signBill) {
        if (!ProxyUtils.isFreshPersonInfo(signBill)) {
            return;
        }
        Long erManFileId = signBill.getDynamicObject("ermanfile").getLong("id");
        Map<String, Object> personInfo = ContractSignUtils.getPersonInfoByErManFile(erManFileId);
        signBill.set("empname", personInfo.get("empname"));
        signBill.set("empnumber", personInfo.get("empnumber"));
        signBill.set("postype", personInfo.get("postype"));
        signBill.set("usestartdate", personInfo.get("startdate"));
        Long personId = (Long)personInfo.get("person_id");
        signBill.set("person", (Object)personId);
        signBill.set("baselocation", personInfo.get("location_id"));
        signBill.set("nation", personInfo.get("nationality_id"));
        Integer probationPeriod = (Integer)personInfo.get("probationperiod");
        Date preRegularDate = (Date)personInfo.get("probationenddate");
        if (!Objects.isNull(probationPeriod) && probationPeriod != 0 && !Objects.isNull(preRegularDate)) {
            signBill.set("probationstartdate", personInfo.get("probationstartdate"));
            signBill.set("probationenddate", (Object)HRDateTimeUtils.getBeforeDay((Date)preRegularDate));
            signBill.set("probationperiod", personInfo.get("probationperiod"));
            signBill.set("probationunit", personInfo.get("probationperiodunit"));
            signBill.set("probationperiodunit", (Object)(personInfo.get("probationperiod") + ProbationUnitEnum.getValueByKey((String)((String)personInfo.get("probationperiodunit")))));
        }
        signBill.set("householdregister", personInfo.get("householdregister"));
        signBill.set("residentialaddress", personInfo.get("residentialaddress"));
        Long companyId = (Long)personInfo.get("signedcompany");
        IHbpmService instance = IHbpmService.getInstance();
        signBill.set("signedcompanyhis", (Object)instance.getAdminOrgHis(companyId));
        signBill.set("curcompany", (Object)companyId);
        Long departmentId = (Long)personInfo.get("department");
        signBill.set("departmenthis", (Object)instance.getAdminOrgHis(departmentId));
        signBill.set("curdept", (Object)departmentId);
        Long positionId = (Long)personInfo.get("position");
        signBill.set("postionhis", (Object)instance.getPosHis(positionId));
        signBill.set("curpostion", (Object)positionId);
        Long stdPositionId = (Long)personInfo.get("stdposition");
        signBill.set("stdpostionhis", (Object)instance.getStdPosHis(stdPositionId));
        signBill.set("curstdpostion", (Object)stdPositionId);
        Long jobId = (Long)personInfo.get("job");
        signBill.set("job", (Object)instance.getJobHis(jobId));
        signBill.set("curjob", (Object)jobId);
        Long orgId = (Long)personInfo.get("org_id");
        signBill.set("ermanorg", (Object)orgId);
        Long affiliateAdminOrgId = (Long)personInfo.get("affiliateadminorg_id");
        signBill.set("adminororg", (Object)affiliateAdminOrgId);
        Long empGroupId = (Long)personInfo.get("empgroup_id");
        signBill.set("ermanperorg", (Object)empGroupId);
        CommonRepository.updateOne("hlcm_contractapplybase", signBill);
    }

    @Override
    public void updateSignDocUrl(DynamicObject signBill, List<String> downloadUrlList, String attachmentKey) {
        this.updateSignDocUrl(signBill, downloadUrlList, attachmentKey, true);
    }

    private void updateSignDocUrl(DynamicObject signBill, List<String> downloadUrlList, String attachmentKey, boolean update) {
        LOGGER.info("downloadUrlList:{}", downloadUrlList);
        DynamicObjectCollection entryCollection = signBill.getDynamicObjectCollection("entryentity");
        AtomicInteger increment = new AtomicInteger();
        for (DynamicObject contract : entryCollection) {
            int index = increment.getAndIncrement();
            if (index >= downloadUrlList.size()) {
                LOGGER.error("entryCollection size|{} downloadUrlList size|{}", (Object)entryCollection.size(), (Object)downloadUrlList.size());
                break;
            }
            String downloadUrl = downloadUrlList.get(index);
            this.updateOneSignDocUrl(signBill, downloadUrl, attachmentKey, contract, update);
        }
    }

    private void updateOneSignDocUrl(DynamicObject signBill, String downloadUrl, String attachmentKey, DynamicObject contract, boolean updateBill) {
        InputStream inputStream = null;
        try {
            HttpClient httpClient = HttpClientUtils.wrapperHttpClient((int)3000, (int)60000);
            URL url = new URL(downloadUrl);
            HttpGet httpGet = new HttpGet(url.toURI());
            httpGet.setHeader("User-Agent", USER_AGENT);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(3000).setSocketTimeout(60000).setRedirectsEnabled(true).build();
            httpGet.setConfig(requestConfig);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            inputStream = response.getEntity().getContent();
            LOGGER.info("SignManageServiceImpl#updateSignDocUrl#response={}", (Object)response);
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String contractNumber = contract.getString("entrycontractnumber");
            if (HRStringUtils.isEmpty((String)contractNumber)) {
                contractNumber = signBill.getString("contractnumber");
            }
            if (HRStringUtils.isEmpty((String)contractNumber)) {
                contractNumber = signBill.getDynamicObject("oldcontract").getString("number");
            }
            String fileName = signBill.getString("empname") + "-" + contractNumber + "-" + contract.getDynamicObject("contracttemplate").getString("name") + ".pdf";
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)"hlcm", (String)"hlcm_contractapplybase", (Object)contract.getString("id"), (String)fileName);
            FileItem item = new FileItem(fileName, pathParam, inputStream);
            item.setAppId("hlcm");
            item.setFId(signBill.getString("id"));
            String oldSignDocUrl = contract.getString("presigndocurl");
            String newSignDocUrl = fileService.upload(item);
            if (HRStringUtils.isEmpty((String)newSignDocUrl)) {
                throw new KDBizException("pdf file path is incorrect");
            }
            contract.set("presigndocurl", (Object)newSignDocUrl);
            if (HRStringUtils.equals((String)signBill.getString("signtasknumber"), (String)contract.getString("contractno"))) {
                signBill.set("signfile", (Object)newSignDocUrl);
            }
            if (updateBill) {
                CommonRepository.updateOne("hlcm_contractapplybase", signBill);
            }
            this.writeAttachment(newSignDocUrl, attachmentKey, signBill.getPkValue(), fileName, new Date());
            LOGGER.info("upload pathParam:{},oldSignDocUrl:{},newSignDocUrl:{}", new Object[]{pathParam, oldSignDocUrl, newSignDocUrl});
            FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
            String decodeOldSignDocUrl = attachFileServiceExt.getRealPath(oldSignDocUrl);
            String decodeNewSignDocUrl = attachFileServiceExt.getRealPath(newSignDocUrl);
            LOGGER.info("upload pathParam:{},decodeOldSignDocUrl:{},decodeNewSignDocUrl:{}", new Object[]{pathParam, decodeOldSignDocUrl, decodeNewSignDocUrl});
            if (!HRStringUtils.equals((String)decodeOldSignDocUrl, (String)decodeNewSignDocUrl)) {
                fileService.delete(oldSignDocUrl);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"SignManageServiceImpl_19", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void archiveAfterTransaction(DynamicObject ... signBills) {
        if (signBills.length == 0) {
            return;
        }
        LOGGER.info("archiveAfterTransaction begin");
        DynamicObject[] dynamicObjects = CommonRepository.queryByIds("hlcm_contractapplybase", null, Arrays.stream(signBills).map(signBill -> signBill.getLong("id")).collect(Collectors.toList()));
        IContractHisModel.getInstance().hisVersionChange(dynamicObjects);
        AttachmentUtils.signAttachmentToContract(dynamicObjects);
        SyncStartStatusService.getInstance().syncSignBillHandleStatusToPreWarn(dynamicObjects);
        SyncStartStatusService.getInstance().syncHirePersonStartStatus(dynamicObjects);
        DynamicObject[] contracts = ContractRepository.getInstance().loadBySignBills(dynamicObjects, String.join((CharSequence)",", "contractstatus", "person.id", "ermanorg.id", "protocoltype", "actualsigncompanyhis.lawentity.id", "startdate"));
        PersonService.getInstance().updateLaborRelRecord(contracts);
        LOGGER.info("archiveAfterTransaction end");
    }

    @Override
    public void abandonSignProcess(List<Long> personIds, List<String> protocolTypes, Long terminateCauseId) {
        QFilter[] filters = new QFilter[]{new QFilter("person", "in", personIds), new QFilter("protocoltype", "in", protocolTypes), new QFilter("handlestatus", "=", (Object)HandleStatusEnum.PROCESSIN.getCombKey())};
        DynamicObject[] signBills = HLCMCommonRepository.queryDynamicObjects("hlcm_contractapplyhandle", String.join((CharSequence)",", "id", "businesstype", "person.id", "employee"), filters);
        if (signBills.length == 0) {
            return;
        }
        this.executeTermOperate(signBills, terminateCauseId);
    }

    @Override
    public boolean isSupportMulPartFileSign() {
        return !IHRCSService.getInstance().isKDCloudSign(null);
    }

    @Override
    public boolean isSupportCancelSign(DynamicObject signBill) {
        DynamicObject oldContractDy = signBill.getDynamicObject("oldcontract");
        if (HRObjectUtils.isEmpty((Object)oldContractDy)) {
            return false;
        }
        DynamicObjectCollection entryEntities = (oldContractDy = HLCMCommonRepository.queryDynamicObjectByPk("hlcm_contract", "entryentity.contractno", oldContractDy.getPkValue())).getDynamicObjectCollection("entryentity");
        String contractNo = entryEntities.stream().map(dy -> dy.getString("contractno")).filter(HRStringUtils::isNotEmpty).findFirst().orElse(null);
        if (HRStringUtils.isEmpty((String)contractNo)) {
            return false;
        }
        return !IHRCSService.getInstance().isKDCloudSign(contractNo);
    }

    private void executeTermOperate(DynamicObject[] signBills, Long terminateCauseId) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("terminateReason", String.valueOf(terminateCauseId));
        Object[] signBillIds = (Long[])Stream.of(signBills).map(signBill -> signBill.getLong("id")).toArray(Long[]::new);
        OperationResult terminateResult = OperationServiceHelper.executeOperate((String)"terminate", (String)"hlcm_contractapplyhandle", (Object[])signBillIds, (OperateOption)operateOption);
        if (terminateResult.isSuccess()) {
            SyncStartStatusService.getInstance().syncHirePersonStartStatus(signBills);
        }
    }

    private void writeAttachment(String signDocUrl, String attachmentKey, Object pkId, String fileName, Date signDate) {
        String pkIdString = pkId.toString();
        LOGGER.info("start writeAttachment url|{},panelAttachment|{},pkId|{}", new Object[]{signDocUrl, attachmentKey, pkIdString});
        AttachmentUtils.writeAttachment(attachmentKey, "hlcm_signattachment", pkIdString, signDocUrl, fileName, signDate);
        LOGGER.info("writeAttachment success");
    }

    private long getCurActivityInsId(DynamicObject signBill, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("activity.bizobj.number", "=", (Object)formId), new QFilter("signapply", "=", (Object)signBill.getLong("id"))};
        DynamicObject activityInsDy = HLCMCommonRepository.queryDynamicObject("hlcm_activity", "activityins.id", filters);
        long signBillActivityInsId = signBill.getLong("activityins.id");
        if (HRObjectUtils.isEmpty((Object)activityInsDy)) {
            LOGGER.info("getCurActivityInsId from signBill activityInsId|{}", (Object)signBillActivityInsId);
            return signBillActivityInsId;
        }
        long activityInsId = activityInsDy.getLong("activityins.id");
        if (0L == activityInsId) {
            LOGGER.info("getCurActivityInsId from signBill activityInsId|{}", (Object)signBillActivityInsId);
            return signBillActivityInsId;
        }
        LOGGER.info("getCurActivityInsId from Activity activityInsId|{}", (Object)activityInsId);
        return activityInsId;
    }

    private String handleException(Exception exp) {
        String message = exp.getMessage();
        return HRStringUtils.isEmpty((String)message) ? "System error" : message;
    }

    private void initSignStatus(DynamicObject signBill) {
        DynamicObjectCollection entryCollection = signBill.getDynamicObjectCollection("entryentity");
        entryCollection.forEach(entry -> {
            entry.set("entryempsignstatus", (Object)EmpCompSignStatusEnum.TO_SIGN.getValue());
            entry.set("entrycompsignstatus", (Object)EmpCompSignStatusEnum.TO_SIGN.getValue());
        });
        signBill.set("empsignstatus", (Object)EmpCompSignStatusEnum.TO_SIGN.getValue());
        signBill.set("compsignstatus", (Object)EmpCompSignStatusEnum.TO_SIGN.getValue());
        signBill.set("signmode", (Object)this.getSignMode());
    }

    private String getSignMode() {
        if (IHRCSService.getInstance().isSupportBatchSign()) {
            String signModeVal = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hlcm_sign_mode");
            if (HRStringUtils.equals((String)(signModeVal = HRStringUtils.trim((String)signModeVal)), (String)"merge_task")) {
                return SignModeEnum.BATCH_MULTASK.getValue();
            }
            if (HRStringUtils.equals((String)signModeVal, (String)"single_task")) {
                return SignModeEnum.BATCH_ONETASK.getValue();
            }
        }
        return SignModeEnum.NO_BATCH.getValue();
    }

    @Override
    public boolean isMultiTask(DynamicObject signBill) {
        String signMode = signBill.getString("signmode");
        DynamicObjectCollection entryEntity = signBill.getDynamicObjectCollection("entryentity");
        return HRStringUtils.equals((String)signMode, (String)SignModeEnum.BATCH_MULTASK.getValue()) && entryEntity.size() > 1;
    }
}

