/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.sync.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.domian.service.hismodel.helper.ContractHisHelper;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.business.domian.service.sync.ISyncPersonInfoService;
import kd.hr.hlcm.common.entity.FiveHisFieldsVO;
import kd.hr.hlcm.common.entity.SyncPersonInfoVO;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import org.apache.commons.collections.CollectionUtils;

public class SyncPersonInfoServiceImpl
implements ISyncPersonInfoService {
    private static final Log LOGGER = LogFactory.getLog(SyncPersonInfoServiceImpl.class);
    private static final int BATCH = 1000;

    @Override
    public void syncPersonInfo(Long employeeId) {
        LOGGER.info("employeeId|{} start sync", (Object)employeeId);
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        this.syncPersonInfoByFilter(employeeFilter);
        LOGGER.info("employeeId|{} end sync", (Object)employeeId);
    }

    @Override
    public void syncPersonInfoByFilter(QFilter filter) {
        this.syncBillField(filter);
        this.syncContractField(filter);
        this.syncHiredperson(filter);
    }

    private Map<Long, SyncPersonInfoVO> mapPersonInfoVO(List<Long> employeeIds, Boolean isSignBill) {
        Map<Long, Long> empErmanMap = IHSPMFileService.getInstance().getNewestErmanByEmployee(employeeIds, Boolean.FALSE);
        Collection<Long> values = empErmanMap.values();
        ArrayList ermanIds = Lists.newArrayList(values);
        List<Map<String, Object>> erManFileInfos = IHSPMFileService.getInstance().getAllCardFieldByErManFileIds(ermanIds);
        if (CollectionUtils.isEmpty(erManFileInfos)) {
            return Maps.newHashMap();
        }
        LinkedHashMap employeeInfoMap = Maps.newLinkedHashMapWithExpectedSize((int)employeeIds.size());
        DynamicObject[] ermanDys = IHSPMFileService.getInstance().getEmpposrelByErmanId(ermanIds);
        Map<Long, DynamicObject> erManFileMap = Arrays.stream(ermanDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k2));
        erManFileInfos.forEach(erManFileInfo -> {
            Long employeeId = (Long)erManFileInfo.get("employee_id");
            Long erManFileId = (Long)erManFileInfo.get("id");
            DynamicObject erManFileDy = (DynamicObject)erManFileMap.get(erManFileId);
            SyncPersonInfoVO personInfoVO = new SyncPersonInfoVO();
            personInfoVO.setCompanyId((Long)erManFileInfo.get("company_id"));
            personInfoVO.setDeptId((Long)erManFileInfo.get("adminorg_id"));
            personInfoVO.setPositionId((Long)erManFileInfo.get("position_id"));
            personInfoVO.setStdPositionId((Long)erManFileInfo.get("stdposition_id"));
            personInfoVO.setJobId((Long)erManFileInfo.get("job_id"));
            personInfoVO.setEmployeeId(employeeId);
            personInfoVO.setEmpEntRelId(Long.valueOf(erManFileDy.getLong("empentrel.id")));
            personInfoVO.setEmpPosRelId(Long.valueOf(erManFileDy.getLong("empposrel.id")));
            personInfoVO.setAdminOrgId((Long)erManFileInfo.get("org_id"));
            personInfoVO.setAttachmentOrgId((Long)erManFileInfo.get("affiliateadminorg_id"));
            personInfoVO.setGroupOrgId((Long)erManFileInfo.get("empgroup_id"));
            personInfoVO.setErManFileId((Long)erManFileInfo.get("id"));
            employeeInfoMap.put(employeeId, personInfoVO);
        });
        if (isSignBill.booleanValue()) {
            this.setHisFieldsForBill(erManFileInfos, employeeInfoMap);
        }
        if (employeeIds.size() == 1) {
            LOGGER.info("employeeInfoMap|{}", (Object)JSON.toJSONString((Object)employeeInfoMap));
        }
        return employeeInfoMap;
    }

    private void setHisFieldsForBill(List<Map<String, Object>> erManFileInfos, Map<Long, SyncPersonInfoVO> employeeInfoMap) {
        int size = erManFileInfos.size();
        HashSet companyIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet adminOrgIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet stdPositionIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet positionIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet jobIdSet = Sets.newHashSetWithExpectedSize((int)size);
        for (Map<String, Object> erManFileInfo : erManFileInfos) {
            companyIdSet.add((Long)erManFileInfo.get("company_id"));
            adminOrgIdSet.add((Long)erManFileInfo.get("adminorg_id"));
            positionIdSet.add((Long)erManFileInfo.get("position_id"));
            stdPositionIdSet.add((Long)erManFileInfo.get("stdposition_id"));
            jobIdSet.add((Long)erManFileInfo.get("job_id"));
        }
        IHbpmService instance = IHbpmService.getInstance();
        Map<Long, Long> companyIdMap = instance.getAdminOrgHis(Lists.newArrayList((Iterable)companyIdSet));
        Map<Long, Long> adminOrgIdMap = instance.getAdminOrgHis(Lists.newArrayList((Iterable)adminOrgIdSet));
        Map<Long, Long> stdPositionIdMap = instance.getStdPosHis(Lists.newArrayList((Iterable)stdPositionIdSet));
        Map<Long, Long> positionIdMap = instance.getPosHis(Lists.newArrayList((Iterable)positionIdSet));
        Map<Long, Long> jobIdMap = instance.getJobHis(Lists.newArrayList((Iterable)jobIdSet));
        for (Map<String, Object> erManFileInfo : erManFileInfos) {
            Long employeeId = (Long)erManFileInfo.get("employee_id");
            SyncPersonInfoVO syncPersonInfoVO = employeeInfoMap.get(employeeId);
            if (HRObjectUtils.isEmpty((Object)syncPersonInfoVO)) continue;
            FiveHisFieldsVO fiveHisFieldsVO = new FiveHisFieldsVO();
            Long companyId = (Long)erManFileInfo.get("company_id");
            fiveHisFieldsVO.setCompanyVid(companyIdMap.get(companyId));
            Long adminOrgId = (Long)erManFileInfo.get("adminorg_id");
            fiveHisFieldsVO.setDeptVid(adminOrgIdMap.get(adminOrgId));
            Long positionId = (Long)erManFileInfo.get("position_id");
            fiveHisFieldsVO.setPositionVid(positionIdMap.get(positionId));
            Long stdPositionId = (Long)erManFileInfo.get("stdposition_id");
            fiveHisFieldsVO.setStdPositionVid(stdPositionIdMap.get(stdPositionId));
            Long jobId = (Long)erManFileInfo.get("job_id");
            fiveHisFieldsVO.setJobVid(jobIdMap.get(jobId));
            syncPersonInfoVO.setHisFieldsVO(fiveHisFieldsVO);
        }
    }

    private void syncBillField(QFilter filter) {
        boolean isLast = false;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        long start = 0L;
        while (!isLast) {
            DynamicObject[] activityDys;
            DynamicObject[] queryResult;
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            if (Objects.nonNull(filter)) {
                idFilter.and(filter);
                idFilter.and(new QFilter("postype", "=", (Object)1010L));
                idFilter.and(new QFilter("businessstatus", "in", (Object)new String[]{" ", BusinessStatusEnum.BEGIN.getCombKey()}));
            }
            if ((queryResult = serviceHelper.query("signedcompanyhis.id,departmenthis.id,postionhis.id,stdpostionhis,job.id,employee.id,person.id,postype.id,curcompany.id,curdept.id,curpostion.id,curstdpostion.id,curjob.id,ermanfile.id,org.id,ermanorg.id,adminororg.id,ermanperorg.id", new QFilter[]{idFilter}, "id", 1000)).length == 0) {
                return;
            }
            if (queryResult.length < 1000) {
                isLast = true;
            }
            start = queryResult[queryResult.length - 1].getLong("id");
            List<Long> employeeIds = Stream.of(queryResult).map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
            Map<Long, SyncPersonInfoVO> personInfoMap = this.mapPersonInfoVO(employeeIds, Boolean.TRUE);
            HashMap signBillIdMap = Maps.newHashMapWithExpectedSize((int)queryResult.length);
            for (DynamicObject dy2 : queryResult) {
                Long empId = dy2.getLong("employee.id");
                SyncPersonInfoVO personInfoVO = personInfoMap.get(empId);
                if (null == personInfoVO) {
                    LOGGER.warn("can not find personInfoVO employeeId:{}", (Object)empId);
                    continue;
                }
                dy2.set("org", (Object)personInfoVO.getAdminOrgId());
                dy2.set("ermanorg", (Object)personInfoVO.getAdminOrgId());
                dy2.set("adminororg", (Object)personInfoVO.getAttachmentOrgId());
                dy2.set("ermanperorg", (Object)personInfoVO.getGroupOrgId());
                dy2.set("ermanfile", (Object)personInfoVO.getErManFileId());
                dy2.set("curcompany", (Object)personInfoVO.getCompanyId());
                dy2.set("curdept", (Object)personInfoVO.getDeptId());
                dy2.set("curpostion", (Object)personInfoVO.getPositionId());
                dy2.set("curstdpostion", (Object)personInfoVO.getStdPositionId());
                dy2.set("curjob", (Object)personInfoVO.getJobId());
                FiveHisFieldsVO hisFieldsVO = personInfoVO.getHisFieldsVO();
                if (!HRObjectUtils.isEmpty((Object)hisFieldsVO)) {
                    dy2.set("signedcompanyhis", (Object)hisFieldsVO.getCompanyVid());
                    dy2.set("departmenthis", (Object)hisFieldsVO.getDeptVid());
                    dy2.set("postionhis", (Object)hisFieldsVO.getPositionVid());
                    dy2.set("stdpostionhis", (Object)hisFieldsVO.getStdPositionVid());
                    dy2.set("job", (Object)hisFieldsVO.getJobVid());
                }
                signBillIdMap.put(dy2.getLong("id"), personInfoVO);
            }
            serviceHelper.save(queryResult);
            Set signBillIdSet = signBillIdMap.keySet();
            for (DynamicObject activityDy : activityDys = HLCMCommonRepository.queryDynamicObjects("hlcm_activity", "org.id,adminororg.id,ermanperorg.id,signapply.id", new QFilter("signapply", "in", signBillIdSet))) {
                long signBillId = activityDy.getLong("signapply.id");
                SyncPersonInfoVO syncPersonInfoVO = (SyncPersonInfoVO)signBillIdMap.get(signBillId);
                activityDy.set("org", (Object)syncPersonInfoVO.getAdminOrgId());
                activityDy.set("adminororg", (Object)syncPersonInfoVO.getAttachmentOrgId());
                activityDy.set("ermanperorg", (Object)syncPersonInfoVO.getGroupOrgId());
            }
            HLCMCommonRepository.updateDynamicObjects("hlcm_activity", activityDys);
        }
    }

    private void syncContractField(QFilter filter) {
        boolean isLast = false;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contractsource");
        long start = 0L;
        while (!isLast) {
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            if (Objects.nonNull(filter)) {
                idFilter.and(filter);
                idFilter.and(new QFilter("postype", "=", (Object)1010L));
            }
            QFilter versionFilter = new QFilter("iscurrentversion", "!=", (Object)"1");
            QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1"});
            DynamicObject[] queryIDResult = serviceHelper.query("id", new QFilter[]{idFilter, versionFilter, dataStatusFilter}, "id", 1000);
            List idList = Stream.of(queryIDResult).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            QFilter idListFilter = new QFilter("id", "in", idList);
            DynamicObject[] queryResult = serviceHelper.loadDynamicObjectArray(new QFilter[]{idListFilter, versionFilter, dataStatusFilter});
            if (queryIDResult.length == 0) {
                return;
            }
            if (queryIDResult.length < 1000) {
                isLast = true;
            }
            start = queryResult[queryIDResult.length - 1].getLong("id");
            List<Long> employeeIds = Stream.of(queryResult).map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
            Map<Long, SyncPersonInfoVO> personInfoMap = this.mapPersonInfoVO(employeeIds, Boolean.FALSE);
            for (DynamicObject dy2 : queryResult) {
                Long empId = dy2.getLong("employee.id");
                SyncPersonInfoVO personInfoVO = personInfoMap.get(empId);
                if (null == personInfoVO) {
                    LOGGER.warn("can not find personInfoVO employee:{}", (Object)empId);
                    continue;
                }
                this.setLongValue(personInfoVO.getAdminOrgId(), "ermanorg", dy2);
                this.setLongValue(personInfoVO.getAttachmentOrgId(), "adminororg", dy2);
                this.setLongValue(personInfoVO.getGroupOrgId(), "ermanperorg", dy2);
                this.setLongValue(personInfoVO.getErManFileId(), "ermanfile", dy2);
                this.setLongValue(personInfoVO.getCompanyId(), "curcompany", dy2);
                this.setLongValue(personInfoVO.getDeptId(), "curdept", dy2);
                this.setLongValue(personInfoVO.getPositionId(), "curpostion", dy2);
                this.setLongValue(personInfoVO.getStdPositionId(), "curstdpostion", dy2);
                this.setLongValue(personInfoVO.getJobId(), "curjob", dy2);
            }
            DynamicObject[] reviseDirties = (DynamicObject[])Stream.of(queryResult).filter(dy -> dy.getDataEntityState().getDataEntityDirty()).toArray(DynamicObject[]::new);
            if (reviseDirties.length == 0) continue;
            ContractHisHelper.getInstance().reviseVersion("hlcm_contractsource", reviseDirties);
        }
    }

    private void syncHiredperson(QFilter filter) {
        boolean isLast = false;
        long start = 0L;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_hiredperson");
        while (!isLast) {
            DynamicObject[] queryResult;
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            if (Objects.nonNull(filter)) {
                idFilter.and(filter);
            }
            if ((queryResult = serviceHelper.query("employee.id, empnumber, empentrel.id, empposrel.id,ermanorg.id, adminororg.id, ermanperorg.id, ermanfile.id, person.id", new QFilter[]{idFilter}, "id", 1000)).length == 0) {
                return;
            }
            if (queryResult.length < 1000) {
                isLast = true;
            }
            start = queryResult[queryResult.length - 1].getLong("id");
            List<Long> employeeIds = Stream.of(queryResult).map(dy -> dy.getLong("employee.id")).distinct().collect(Collectors.toList());
            Map<Long, SyncPersonInfoVO> employeeInfoMap = this.mapPersonInfoVO(employeeIds, Boolean.FALSE);
            for (DynamicObject dy2 : queryResult) {
                long employeeId = dy2.getLong("employee.id");
                SyncPersonInfoVO personInfoVO = employeeInfoMap.get(employeeId);
                if (null == personInfoVO) {
                    LOGGER.warn("can not find person number|{},employeeId|{}", (Object)dy2.getString("empnumber"), (Object)employeeId);
                    continue;
                }
                this.setLongValue(personInfoVO.getAdminOrgId(), "ermanorg", dy2);
                this.setLongValue(personInfoVO.getAttachmentOrgId(), "adminororg", dy2);
                this.setLongValue(personInfoVO.getGroupOrgId(), "ermanperorg", dy2);
                this.setLongValue(personInfoVO.getErManFileId(), "ermanfile", dy2);
                this.setLongValue(personInfoVO.getEmpPosRelId(), "empposrel", dy2);
                this.setLongValue(personInfoVO.getEmpEntRelId(), "empentrel", dy2);
            }
            DynamicObject[] reviseDirties = (DynamicObject[])Stream.of(queryResult).filter(dy -> dy.getDataEntityState().getDataEntityDirty()).toArray(DynamicObject[]::new);
            serviceHelper.save(reviseDirties);
        }
    }

    private void setLongValue(Long value, String propertyName, DynamicObject dy) {
        Long longValue = Optional.ofNullable(value).orElse(0L);
        if (!Objects.equals(dy.getLong(propertyName + "_id"), longValue)) {
            dy.set(propertyName, (Object)longValue);
        }
    }
}

