/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.sharecenter.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.TerminateRepository;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmEnum;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.business.domian.sharecenter.ShowFormService;
import kd.hr.hlcm.business.utils.SignListPermissionUtils;
import kd.hr.hlcm.business.utils.SignUploadUtil;
import kd.hr.hlcm.business.utils.TerminateUtils;
import kd.hr.hlcm.common.enums.SignTabEnum;

public class ShowFormServiceImpl
implements ShowFormService {
    private static final Log LOGGER = LogFactory.getLog(ShowFormServiceImpl.class);
    private static final String SHARE_BIZ_APP_ID = "40A+670S4LST";
    private static final Map<String, String> OPERATE_KEY_PERMISSION_MAP = Maps.newHashMapWithExpectedSize((int)4);

    @Override
    public Map<String, Object> preValidate(Map<String, Object> validateInfo) {
        LOGGER.info("ShowFormServiceImpl.preValidate.begin.and.param={}", validateInfo);
        try {
            String operateKey = String.valueOf(validateInfo.get("operateKey"));
            String formId = String.valueOf(validateInfo.get("billFormId"));
            List pkValues = (List)validateInfo.get("selectedKeys");
            if (operateKey.equals("terminate")) {
                if (pkValues.size() > 1) {
                    String tip = ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u7ec8\u6b62\u4e00\u4e2a\u6d41\u7a0b\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u7ec8\u6b62\u6d41\u7a0b\u7684\u5355\u636e\u3002", (String)"ContractFormTipUtils_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    return this.resultMap(tip, "11", null, null, Boolean.TRUE);
                }
                if (pkValues.size() == 0) {
                    String tip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u7ec8\u6b62\u6d41\u7a0b\u7684\u5355\u636e\u3002", (String)"ContractFormTipUtils_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    return this.resultMap(tip, "11", null, null, Boolean.TRUE);
                }
                String tip = ResManager.loadKDString((String)"\u7ec8\u6b62\u6d41\u7a0b\u540e\u4eba\u5458\u7684\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u679c\u786e\u8ba4\u7ec8\u6b62\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff1a", (String)"ContractSignListPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                DynamicObject activity = CommonRepository.queryById("hlcm_activity", "signapply", (Long)pkValues.get(0));
                DynamicObject signBill = HLCMCommonRepository.queryDynamicObjectByPk("hlcm_contractapplybase", String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"handlestatus", "activityins"})), activity.getLong("signapply.id"));
                Optional<String> optionalResult = TerminateRepository.getInstance().validateStatus(signBill);
                if (optionalResult.isPresent()) {
                    return this.resultMap(optionalResult.get(), "12", null, null, Boolean.TRUE);
                }
                FormShowParameter formShowParameter = TerminateUtils.getInstance().returnOperationPage(tip, signBill.getPkValue(), activity.getLong("id"), formId);
                return this.resultMap(tip, "20", formShowParameter, pkValues, Boolean.TRUE);
            }
            MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate(operateKey);
            if (template == null) {
                return this.resultMap("do not need preValid", "11", null, null, Boolean.TRUE);
            }
            if (pkValues.size() == 0) {
                return this.resultMap(template.getEmptySelectMessage(), "11", null, null, Boolean.TRUE);
            }
            if (pkValues.size() == 1) {
                if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
                    return this.resultMap("single submit need not valid", "13", null, pkValues, Boolean.TRUE);
                }
                String errorInfo = this.invokeSingleOperation(formId, "pre" + operateKey, pkValues.toArray());
                if (HRStringUtils.isEmpty((String)errorInfo)) {
                    DynamicObject activity = CommonRepository.queryById("hlcm_activity", "signapply", (Long)pkValues.get(0));
                    String msg = this.singleOperateTips(operateKey, activity, formId);
                    if ("compsign".equals(operateKey) && !HRObjectUtils.isEmpty((Object)validateInfo.get("sourcesscdetail")) && ((Boolean)validateInfo.get("sourcesscdetail")).booleanValue()) {
                        DynamicObject dataEntity = activity.getDynamicObject("signapply");
                        FormShowParameter formShowParameter = new FormShowParameter();
                        formShowParameter.setFormId("hlcm_papersign_attach");
                        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                        formShowParameter.setCloseCallBack(new CloseCallBack("kd.hr.hlcm.formplugin.common.ConfirmCommonFormPlugin", "upload"));
                        formShowParameter.setCustomParam("id", dataEntity.getPkValue());
                        formShowParameter.setCustomParam("enddate", (Object)dataEntity.getDate("enddate"));
                        formShowParameter.setCustomParam("signeddate", (Object)dataEntity.getDate("signeddate"));
                        SignUploadUtil.setHeight(formShowParameter, dataEntity);
                        return this.resultMap(msg, "20", formShowParameter, pkValues, Boolean.TRUE);
                    }
                    return this.resultMap(msg, "30", null, pkValues, Boolean.TRUE);
                }
                return this.resultMap(errorInfo, "12", null, null, Boolean.TRUE);
            }
            HashMap<Object, String> preErrorInfoMap = new HashMap<Object, String>(pkValues.size());
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)("pre" + operateKey), (String)formId, (Object[])pkValues.toArray(), (OperateOption)this.shareOperateOption());
            ArrayList<Object> preValidateSuccessPkValues = new ArrayList<Object>(pkValues.size());
            if (preOpResult.isSuccess()) {
                if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
                    Map<Object, String> errorInfoMap = this.batchInvokeOperation(formId, operateKey, pkValues.toArray());
                    FormShowParameter formShowParameter = this.showConfirmResultPage(formId, errorInfoMap, template, pkValues.toArray());
                    return this.resultMap(null, "30", formShowParameter, pkValues, Boolean.TRUE);
                }
                String msg = this.multOperateTips(operateKey, formId);
                return this.resultMap(msg, "30", null, pkValues, Boolean.TRUE);
            }
            Set<String> errorSet = this.assembleValidResult(preValidateSuccessPkValues, preErrorInfoMap, preOpResult);
            if (preErrorInfoMap.size() == pkValues.size() && errorSet.size() == 1) {
                return this.resultMap(errorSet.iterator().next(), "12", null, null, Boolean.TRUE);
            }
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("sumlabel", pkValues.size());
            params.put("incongruentlabel", preErrorInfoMap.size());
            params.put("coincidentlabel", pkValues.size() - preErrorInfoMap.size());
            params.put("filename", template.getFileName());
            params.put("headDataList", template.getMulSelectConfirmExcelHead(formId));
            params.put("exportDataList", template.getMulSelectConfirmExportData(pkValues.toArray(), preErrorInfoMap, formId));
            params.put("donothing_confirm", operateKey);
            params.put("isShowCommentFlag", template.isShowComment());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hlcm_mulselectconfirm");
            showParameter.setCaption(template.getName());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(params);
            return this.resultMap("", "20", showParameter, preValidateSuccessPkValues, Boolean.TRUE);
        }
        catch (Exception exe) {
            LOGGER.error("sharecenter.impl.ShowFormServiceImpl.preValidate", (Throwable)exe);
            return this.resultMap("hlcm.prevalid.fail", "12", null, null, Boolean.FALSE);
        }
    }

    @Override
    public Map<String, Object> validCallBack(Map<String, Object> executeInfo) {
        LOGGER.info("ShowFormServiceImpl.validCallBack.begin.and.param={}", executeInfo);
        try {
            Object[] pkValues;
            String operateKey = String.valueOf(executeInfo.get("operateKey"));
            String billFormId = String.valueOf(executeInfo.get("billFormId"));
            String formName = SignTabEnum.getTableNameByListFormId((String)billFormId);
            MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate(operateKey);
            if (!SignListPermissionUtils.checkPermission(SHARE_BIZ_APP_ID, billFormId, OPERATE_KEY_PERMISSION_MAP.get(operateKey))) {
                String errorInfo = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignManageServiceImpl_14", (String)"hr-hlcm-business", (Object[])new Object[0]), formName, template.getName());
                return this.resultMap(errorInfo, "12", null, null, Boolean.TRUE);
            }
            Object pkValueObj = executeInfo.get("passValidateKeys");
            ArrayList<Object> pkList = new ArrayList();
            if (pkValueObj instanceof List) {
                pkList = (List)pkValueObj;
            }
            if ((pkValues = pkList.toArray()).length == 1) {
                String errorInfo = this.invokeSingleOperation(billFormId, operateKey, pkValues);
                if (HRStringUtils.isEmpty((String)errorInfo)) {
                    return this.resultMap(template.getSingleOkSuccessMessage(), "10", null, null, Boolean.TRUE);
                }
                return this.resultMap(errorInfo, "12", null, null, Boolean.TRUE);
            }
            Map<Object, String> errorInfoMap = this.batchInvokeOperation(billFormId, operateKey, pkValues);
            FormShowParameter formShowParameter = this.showConfirmResultPage(billFormId, errorInfoMap, template, pkValues);
            return this.resultMap("", "20", formShowParameter, pkList, Boolean.TRUE);
        }
        catch (Exception exe) {
            LOGGER.error("sharecenter.impl.ShowFormServiceImpl.validCallBack", (Throwable)exe);
            return this.resultMap("hlcm.rpc.fail", "12", null, null, Boolean.FALSE);
        }
    }

    private Set<String> assembleValidResult(List<Object> successPkValues, Map<Object, String> preErrorInfoMap, OperationResult preOpResult) {
        successPkValues.addAll(preOpResult.getSuccessPkIds());
        preErrorInfoMap.putAll(preOpResult.getAllErrorOrValidateInfo().stream().collect(Collectors.toMap(IOperateInfo::getPkValue, IOperateInfo::getMessage, (v1, v2) -> v1 + " " + v2)));
        Set<String> errorSet = preErrorInfoMap.values().stream().map(value -> value.substring(value.indexOf(65306) + 1)).collect(Collectors.toSet());
        return errorSet;
    }

    private String invokeSingleOperation(String formId, String operateKey, Object[] pkValues) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", "hstc");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operateKey, (String)formId, (Object[])pkValues, (OperateOption)operateOption);
        String errorInfo = "";
        if (operationResult != null && !operationResult.isSuccess()) {
            List validateErrors = operationResult.getAllErrorOrValidateInfo();
            errorInfo = validateErrors.size() > 0 ? ((IOperateInfo)validateErrors.get(0)).getMessage() : operationResult.getMessage();
        }
        return errorInfo;
    }

    private FormShowParameter showConfirmResultPage(String formId, Map<Object, String> errorInfoMap, MulSelectConfirmTemplate template, Object[] pkValues) {
        HashMap<String, Object> params = new HashMap<String, Object>(9);
        params.put("hasoperation", Boolean.FALSE);
        params.put("successperson", String.valueOf(pkValues.length - errorInfoMap.size()));
        params.put("successoperation", this.getSuccessOperation());
        params.put("failperson", String.valueOf(errorInfoMap.size()));
        params.put("failoperation", this.getFailOperation());
        params.put("excelname", template.getFileName());
        params.put("headdatalist", template.getConfirmResultExcelHead(formId));
        params.put("exportdatalist", template.getConfirmResultExportData(pkValues, errorInfoMap, formId));
        params.put("isShowCommentFlag", template.isShowComment());
        FormShowParameter formShow = new FormShowParameter();
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setFormId("hlcm_result");
        formShow.setCustomParams(params);
        formShow.setCaption(template.getName());
        return formShow;
    }

    public Map<Object, String> batchInvokeOperation(String billFormId, String operationKey, Object[] pkValues) {
        Map<Object, Object> errorMap = Maps.newHashMapWithExpectedSize((int)pkValues.length);
        try {
            LOGGER.info("invoke operation billFormId:{},operationKey:{},pkValues:{}", new Object[]{billFormId, operationKey, pkValues});
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)billFormId, (Object[])pkValues, (OperateOption)this.shareOperateOption());
            if (operationResult != null && !operationResult.isSuccess()) {
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                String wfAssignPersonsMsg = ResManager.loadKDString((String)"\u5728\u9700\u8981\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba\u7684\u60c5\u51b5\u4e0b\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"WfAssignPersonsFacade_0", (String)"bos-wf-facade", (Object[])new Object[0]);
                if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                    List notNullPkValue = allErrorOrValidateInfo.stream().map(IOperateInfo::getPkValue).filter(Objects::nonNull).collect(Collectors.toList());
                    if (notNullPkValue.isEmpty()) {
                        HashMap wfAssignPersonsErrorMap = Maps.newHashMapWithExpectedSize((int)pkValues.length);
                        allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).filter(msg -> HRStringUtils.equals((String)msg, (String)wfAssignPersonsMsg)).findFirst().ifPresent(msg -> wfAssignPersonsErrorMap.putAll(Arrays.stream(pkValues).collect(Collectors.toMap(id -> id, id -> msg))));
                        errorMap.putAll(wfAssignPersonsErrorMap);
                    } else {
                        Map<Object, List<IOperateInfo>> operationInfoMap = allErrorOrValidateInfo.stream().collect(Collectors.groupingBy(IOperateInfo::getPkValue));
                        errorMap = operationInfoMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> {
                            List operateInfos = (List)operationInfoMap.get(key);
                            return ((IOperateInfo)operateInfos.get(operateInfos.size() - 1)).getMessage();
                        }, (v1, v2) -> v1 + " " + v2));
                        String unKnowErrorMsg = ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef", (String)"AbstractMulSelectConfirmTemplate_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
                        Set<Object> failIds = errorMap.keySet();
                        List successPkIds = operationResult.getSuccessPkIds();
                        HashMap unKnowErrorMap = Maps.newHashMapWithExpectedSize((int)pkValues.length);
                        Arrays.stream(pkValues).filter(pkValue -> !failIds.contains(pkValue)).filter(pkValue -> !successPkIds.contains(pkValue)).forEach(failId -> unKnowErrorMap.put(failId, unKnowErrorMsg));
                        errorMap.putAll(unKnowErrorMap);
                    }
                } else {
                    errorMap = Arrays.stream(pkValues).collect(Collectors.toMap(id -> id, id -> pkValues.length == 1 && operationResult.isNeedWfAssignPersons() ? wfAssignPersonsMsg : operationResult.getMessage()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("invoke operation error", (Throwable)e);
            String message = e.getMessage();
            errorMap = Arrays.stream(pkValues).collect(Collectors.toMap(pkValue -> pkValue, pkValue -> message));
        }
        return errorMap;
    }

    public String getSuccessOperation() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AbstractMulSelectConfirmTemplate_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    public String getFailOperation() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractMulSelectConfirmTemplate_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    private Map<String, Object> resultMap(String msg, String showType, FormShowParameter formShowParameter, List<Object> passValidKeys, Boolean isSuccess) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        resultMap.put("msg", msg);
        resultMap.put("showParameter", formShowParameter);
        resultMap.put("showType", showType);
        resultMap.put("passValidateKeys", passValidKeys);
        resultMap.put("success", isSuccess);
        return resultMap;
    }

    private String singleOperateTips(String operateKey, DynamicObject activity, String formId) {
        String msg = "";
        String empName = activity.getDynamicObject("signapply").getString("empname");
        switch (operateKey) {
            case "beginsign": {
                msg = HRStringUtils.equals((String)formId, (String)SignTabEnum.P_BEGIN.getListFormId()) ? ResManager.loadKDString((String)"\u5c06\u4e3a%s\u53d1\u8d77\u7b7e\u7f72\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"BeginSignTemplate_6", (String)"hr-hlcm-business", (Object[])new Object[]{empName}) : ResManager.loadKDString((String)"\u5c06\u4e3a%s\u53d1\u9001\u7b7e\u7f72\u901a\u77e5\u6d88\u606f\uff0c\u662f\u5426\u786e\u8ba4\u53d1\u9001\uff1f", (String)"BeginSignTemplate_5", (String)"hr-hlcm-business", (Object[])new Object[]{empName});
                break;
            }
            case "compsign": {
                msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5c06\u66f4\u65b0%s\u5408\u540c\u7684\u7b7e\u7f72\u72b6\u6001\u4e3a\u201c\u5df2\u5b8c\u6210\u7b7e\u7f72\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CompleteSignTemplate_5", (String)"hr-hlcm-business", (Object[])new Object[]{empName});
                break;
            }
            case "archive": {
                msg = ResManager.loadKDString((String)"\u786e\u8ba4\u5f52\u6863\u540e\uff0c%s\u7b7e\u7f72\u7684\u7b7e\u7f72\u7684\u5408\u540c\u5c06\u81ea\u52a8\u5f52\u6863\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"ConfirmArchiveTemplate_1", (String)"hr-hlcm-business", (Object[])new Object[]{empName});
                break;
            }
            case "companysign": {
                msg = ResManager.loadKDString((String)"\u5c06\u4e3a%s\u7684\u5408\u540c\u53d1\u8d77\u4f01\u4e1a\u7b7e\u7f72\uff0c\u53d1\u8d77\u6210\u529f\u540e\u53ef\u5237\u65b0\u9875\u9762\u67e5\u770b\u7b7e\u7f72\u7ed3\u679c\u3002\u82e5\u7b7e\u7f72\u6210\u529f\u3002\u6d3b\u52a8\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u201c\u5df2\u7b7e\u7f72\u201d\u4e14\u65e0\u6cd5\u64a4\u9500\uff1b\u82e5\u7b7e\u7f72\u5931\u8d25\u53ef\u91cd\u65b0\u53d1\u8d77\u7b7e\u7f72\u3002\u8bf7\u52a1\u5fc5\u4ed4\u7ec6\u6838\u5bf9\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"CompanySignTemplate_5", (String)"hr-hlcm-business", (Object[])new Object[]{empName});
                break;
            }
        }
        return msg;
    }

    private String multOperateTips(String operateKey, String formId) {
        String msg = "";
        switch (operateKey) {
            case "beginsign": {
                msg = HRStringUtils.equals((String)formId, (String)SignTabEnum.P_BEGIN.getListFormId()) ? ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u5458\u5de5\u53d1\u8d77\u7b7e\u7f72\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"BeginSignTemplate_9", (String)"hr-hlcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u5458\u5de5\u53d1\u9001\u7b7e\u7f72\u901a\u77e5\u6d88\u606f\uff0c\u786e\u8ba4\u5168\u90e8\u53d1\u9001\uff1f", (String)"BeginSignTemplate_3", (String)"hr-hlcm-business", (Object[])new Object[0]);
                break;
            }
            case "compsign": {
                msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5c06\u66f4\u65b0\u6240\u9009\u5458\u5de5\u5408\u540c\u7684\u7b7e\u7f72\u72b6\u6001\u4e3a\u201c\u5df2\u5b8c\u6210\u7b7e\u7f72\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CompleteSignTemplate_3", (String)"hr-hlcm-business", (Object[])new Object[0]);
                break;
            }
            case "archive": {
                msg = ResManager.loadKDString((String)"\u786e\u8ba4\u5f52\u6863\u540e\uff0c\u6240\u9009\u5458\u5de5\u7b7e\u7f72\u7684\u5408\u540c\u5c06\u81ea\u52a8\u5f52\u6863\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"ArchiveTemplate_8", (String)"hr-hlcm-business", (Object[])new Object[0]);
                break;
            }
            case "companysign": {
                msg = ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u5458\u5de5\u7684\u5408\u540c\u53d1\u8d77\u4f01\u4e1a\u7b7e\u7f72\uff0c\u53d1\u8d77\u6210\u529f\u540e\u53ef\u5237\u65b0\u9875\u9762\u67e5\u770b\u7b7e\u7f72\u7ed3\u679c\u3002\u82e5\u7b7e\u7f72\u6210\u529f\uff0c\u6d3b\u52a8\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u201c\u5df2\u7b7e\u7f72\u201d\u4e14\u65e0\u6cd5\u64a4\u9500\uff1b\u82e5\u7b7e\u7f72\u5931\u8d25\u53ef\u91cd\u65b0\u53d1\u8d77\u3002\u8bf7\u52a1\u5fc5\u4ed4\u7ec6\u6838\u5bf9\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"CompanySignTemplate_3", (String)"hr-hlcm-business", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    private OperateOption shareOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", "hstc");
        return operateOption;
    }

    static {
        OPERATE_KEY_PERMISSION_MAP.put("beginsign", "2BEGOC9WTO6A");
        OPERATE_KEY_PERMISSION_MAP.put("compsign", "2BEGPA0K7+N/");
        OPERATE_KEY_PERMISSION_MAP.put("archive", "2BEGNF7Y+24F");
        OPERATE_KEY_PERMISSION_MAP.put("companysign", "2BEGQLHRN9JX");
        OPERATE_KEY_PERMISSION_MAP.put("terminate", "2BEGMIB+UGLX");
    }
}

