/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.message;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.BosUserRepository;
import kd.hr.hlcm.business.mq.MessageTemplateParser;

public class SendMessageUtils {
    private static final Log LOGGER = LogFactory.getLog(SendMessageUtils.class);
    public static final String TEMP_MSG_TERMINATE_APP = "hlcm_contractterminate_app";
    public static final String TEMP_MSG_TERMINATE_YG = "hlcm_contractterminate_new";
    public static final String TEMP_MSG_TERMINATE_STOP = "hlcm_contractterminate_stop";
    public static final String TEMP_MSG_TERMINATE_JC = "hlcm_contractterminate_jc";

    public static void sendMsgNoParam(List<String> personNumbers, String templateNumber) {
        Tuple<String, String> messageContext = MessageTemplateParser.getMessageContextNoParam(templateNumber);
        SendMessageUtils.sendMessageExecute((String)messageContext.item1, (String)messageContext.item2, personNumbers);
    }

    public static void sendMsgBatch(DynamicObject[] dys, List<String> personNumbers, String templateNumber) {
        for (DynamicObject dy : dys) {
            Tuple<String, String> messageContext = MessageTemplateParser.getMessageContext(templateNumber, dy.getLong("id"));
            SendMessageUtils.sendMessageExecute((String)messageContext.item1, (String)messageContext.item2, personNumbers);
        }
    }

    private static void sendMessageExecute(String title, String content, List<String> personNumberList) {
        MessageInfo message = new MessageInfo();
        message.setType("message");
        message.setMessageTitle((ILocaleString)new LocaleString(title));
        message.setMessageContent((ILocaleString)new LocaleString(content));
        long currUserId = RequestContext.get().getCurrUserId();
        message.setUserIds((List)Lists.newArrayList((Object[])new Long[]{currUserId}));
        message.setSendTime(new Date(System.currentTimeMillis()));
        message.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u901a\u77e5", (String)"SendMessageUtil_0", (String)"hr-hlcm-business"));
        MessageCenterServiceHelper.batchSendMessages((List)Lists.newArrayList((Object[])new MessageInfo[]{message}));
    }

    public static List<Long> getBosUserIds(List<String> personNumberList) {
        QFilter numberFilter = new QFilter("number", "in", personNumberList);
        QFilter enabelFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] bosUsers = BosUserRepository.getInstance().query("id", new QFilter[]{numberFilter, enabelFilter});
        ArrayList<Long> bosUserIdList = new ArrayList<Long>(bosUsers.length);
        for (DynamicObject bosUser : bosUsers) {
            bosUserIdList.add(bosUser.getLong("id"));
        }
        bosUserIdList.add(RequestContext.get().getCurrUserId());
        return bosUserIdList;
    }

    public static String getTempNumTerminate(String entityID) {
        String temNum = "";
        if (HRStringUtils.isNotEmpty((String)entityID)) {
            switch (entityID) {
                case "hlcm_otheragreements": {
                    temNum = TEMP_MSG_TERMINATE_APP;
                    break;
                }
                case "hlcm_empprotocolnew": {
                    temNum = TEMP_MSG_TERMINATE_YG;
                    break;
                }
                case "hlcm_empprotocolrelieve": {
                    temNum = TEMP_MSG_TERMINATE_JC;
                    break;
                }
                case "hlcm_empprotocolterminate": {
                    temNum = TEMP_MSG_TERMINATE_STOP;
                    break;
                }
            }
        }
        return temNum;
    }
}

