/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.prewarn.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hlcm.business.prewarn.abs.PreWarnBaseService;
import kd.hr.hlcm.common.enums.PreWarnTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class PreWarn3Service
extends PreWarnBaseService {
    private static final String VID = "vid";
    private static final String IS_CHANGECON = "ischangecon";
    private static final String CONTRACT_ACTUAL_SIGN_COMPANY = "contract.actualsigncompany";
    private Object[] eventIds;
    private QFilter[] filters;

    public PreWarn3Service(Object[] eventIds) {
        super(PreWarnTypeEnum.SIGN_COMPANY_CHANGE);
        this.eventIds = eventIds;
        this.filters = eventIds == null || eventIds.length == 0 ? new QFilter[0] : new QFilter[]{new QFilter(VID, "in", (Object)eventIds)};
    }

    public PreWarn3Service() {
        this(new Object[0]);
    }

    @Override
    protected QFilter[] getDelFilters() {
        QFilter[] delFilters = super.getDelFilters();
        if (this.eventIds == null || this.eventIds.length == 0) {
            return delFilters;
        }
        int length = delFilters.length;
        QFilter[] result = Arrays.copyOf(delFilters, length + 1);
        result[length] = new QFilter(CONTRACT_ACTUAL_SIGN_COMPANY, "in", (Object)this.eventIds);
        return result;
    }

    @Override
    protected DynamicObject[] getPreWarns() {
        HRBaseServiceHelper signCompanyHisHelper = new HRBaseServiceHelper("hbss_signcompanyhis");
        DynamicObject[] signCompanyVids = signCompanyHisHelper.loadDynamicObjectArray(this.filters);
        HashMap<Long, Boolean> vidIsChangeMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Long> vidIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject row : signCompanyVids) {
            Long pkValue = Long.parseLong(row.getPkValue().toString());
            vidIsChangeMap.put(pkValue, row.getBoolean(IS_CHANGECON));
            vidIdMap.put(pkValue, row.getLong(VID));
        }
        HashMap vidGroupById = new HashMap();
        vidIdMap.forEach((vid, id) -> {
            ArrayList<Long> vidList = (ArrayList<Long>)vidGroupById.get(id);
            if (Objects.isNull(vidList)) {
                vidList = new ArrayList<Long>();
                vidList.add((Long)vid);
                vidGroupById.put(id, vidList);
            } else {
                vidList.add((Long)vid);
            }
        });
        Set vids = vidIdMap.keySet().stream().filter(vid -> this.isNeedChange((Map<Long, Long>)vidIdMap, (Map<Long, Boolean>)vidIsChangeMap, vidGroupById, (Long)vid)).collect(Collectors.toSet());
        if (vids.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter statusFilter = new QFilter("contractstatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter protocolTypeFilter = new QFilter("protocoltype", "not in", (Object)ProtocolTypeEnum.FS.getCombKey());
        QFilter vidFilter = new QFilter("actualsigncompanyhis", "in", vids);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.contractHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, vidFilter, versionFilter, protocolTypeFilter, initStatusFilter});
    }

    private boolean isNeedChange(Map<Long, Long> vidIdMap, Map<Long, Boolean> vidIsChangeMap, Map<Long, List<Long>> vidGroupById, Long vid) {
        Long id = vidIdMap.get(vid);
        for (Long curVid : vidGroupById.get(id)) {
            if (curVid <= vid || !vidIsChangeMap.get(curVid).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<String> excludeSignStatus() {
        ArrayList<String> signStatus = new ArrayList<String>();
        signStatus.add("2");
        signStatus.add("3");
        signStatus.add("4");
        return signStatus;
    }
}

